/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.OffsetOrderVisitor;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

public class ConstraintDefinitionNode
extends TableElementNode {
    private TableName constraintName;
    protected int constraintType;
    protected Properties properties;
    ProviderList apl;
    UUIDFactory uuidFactory;
    String backingIndexName;
    UUID backingIndexUUID;
    ResultColumnList columnList;
    String constraintText;
    ValueNode checkCondition;
    private int behavior;
    private int verifyType;
    public static final boolean DEFERRABLE_DEFAULT = false;
    public static final boolean INITIALLY_DEFERRED_DEFAULT = false;
    public static final boolean ENFORCED_DEFAULT = true;
    private boolean[] characteristics;

    ConstraintDefinitionNode(TableName constraintName, int constraintType, ResultColumnList rcl, Properties properties, ValueNode checkCondition, String constraintText, int behavior, int verifyType, ContextManager cm) {
        super(null, cm);
        this.constraintName = constraintName;
        if (this.constraintName != null) {
            this.name = this.constraintName.getTableName();
        }
        this.constraintType = constraintType;
        this.properties = properties;
        this.columnList = rcl;
        this.checkCondition = checkCondition;
        this.constraintText = constraintText;
        this.behavior = behavior;
        this.verifyType = verifyType;
    }

    void setCharacteristics(boolean[] cc) {
        this.characteristics = (boolean[])cc.clone();
    }

    boolean[] getCharacteristics() {
        if (this.characteristics == null) {
            this.characteristics = new boolean[]{false, false, true};
        }
        return (boolean[])this.characteristics.clone();
    }

    @Override
    public String toString() {
        return "constraintName: " + (this.constraintName != null ? this.constraintName.toString() : "null") + "\n" + "constraintType: " + this.constraintType + "\n" + "properties: " + (this.properties != null ? this.properties.toString() : "null") + "\n" + super.toString();
    }

    void bind(DDLStatementNode ddlNode, DataDictionary dd) throws StandardException {
        if (this.constraintType == 5) {
            return;
        }
        if (this.constraintName != null) {
            String constraintSchema = this.constraintName.getSchemaName();
            if (constraintSchema != null) {
                TableName tableName = ddlNode.getObjectName();
                String tableSchema = tableName.getSchemaName();
                if (tableSchema == null) {
                    tableSchema = this.getSchemaDescriptor(null).getSchemaName();
                    tableName.setSchemaName(tableSchema);
                }
                if (!constraintSchema.equals(tableSchema)) {
                    throw StandardException.newException("42X85", this.constraintName, tableName);
                }
            }
        } else {
            this.name = this.getBackingIndexName(dd);
        }
    }

    String getConstraintMoniker() {
        return this.name;
    }

    String getDropSchemaName() {
        if (this.constraintName != null) {
            return this.constraintName.getSchemaName();
        }
        return null;
    }

    UUID getBackingIndexUUID() {
        if (this.backingIndexUUID == null) {
            this.backingIndexUUID = this.getUUIDFactory().createUUID();
        }
        return this.backingIndexUUID;
    }

    String getBackingIndexName(DataDictionary dd) {
        if (this.backingIndexName == null) {
            this.backingIndexName = dd.getSystemSQLName();
        }
        return this.backingIndexName;
    }

    void setAuxiliaryProviderList(ProviderList apl) {
        this.apl = apl;
    }

    ProviderList getAuxiliaryProviderList() {
        return this.apl;
    }

    @Override
    boolean hasPrimaryKeyConstraint() {
        return this.constraintType == 2;
    }

    @Override
    boolean hasUniqueKeyConstraint() {
        return this.constraintType == 3;
    }

    @Override
    boolean hasForeignKeyConstraint() {
        return this.constraintType == 6;
    }

    @Override
    boolean hasCheckConstraint() {
        return this.constraintType == 4;
    }

    @Override
    boolean hasConstraint() {
        return true;
    }

    boolean requiresBackingIndex() {
        switch (this.constraintType) {
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    boolean requiresUniqueIndex() {
        switch (this.constraintType) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    int getConstraintType() {
        return this.constraintType;
    }

    void setProperties(Properties properties) {
        this.properties = properties;
    }

    Properties getProperties() {
        return this.properties;
    }

    boolean isReferenced() {
        return false;
    }

    int getReferenceCount() {
        return 0;
    }

    boolean isEnabled() {
        return true;
    }

    ResultColumnList getColumnList() {
        return this.columnList;
    }

    void setColumnList(ResultColumnList columnList) {
        this.columnList = columnList;
    }

    ValueNode getCheckCondition() {
        return this.checkCondition;
    }

    void setCheckCondition(ValueNode checkCondition) {
        this.checkCondition = checkCondition;
    }

    String getConstraintText() {
        return this.constraintText;
    }

    int getDropBehavior() {
        return this.behavior;
    }

    int getVerifyType() {
        return this.verifyType;
    }

    private UUIDFactory getUUIDFactory() {
        if (this.uuidFactory == null) {
            this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.constraintName != null) {
            this.constraintName = (TableName)this.constraintName.accept(v);
        }
    }

    void qualifyNames() throws StandardException {
        OffsetOrderVisitor<TableName> visitor = new OffsetOrderVisitor<TableName>(TableName.class, this.checkCondition.getBeginOffset(), this.checkCondition.getEndOffset() + 1);
        this.checkCondition.accept(visitor);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int offset = this.checkCondition.getBeginOffset();
        for (TableName tableName : visitor.getNodes()) {
            sb.append(this.constraintText, pos, tableName.getBeginOffset() - offset);
            sb.append(tableName.getFullSQLName());
            pos = tableName.getEndOffset() + 1 - offset;
        }
        sb.append(this.constraintText, pos, this.constraintText.length());
        this.constraintText = sb.toString();
    }
}

