/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

class ModifyColumnNode
extends ColumnDefinitionNode {
    int columnPosition = -1;
    UUID oldDefaultUUID;
    static final int K_MODIFY_COLUMN_TYPE = 0;
    static final int K_MODIFY_COLUMN_DEFAULT = 1;
    static final int K_MODIFY_COLUMN_CONSTRAINT = 2;
    static final int K_MODIFY_COLUMN_CONSTRAINT_NOT_NULL = 3;
    static final int K_DROP_COLUMN = 4;
    final int kind;

    ModifyColumnNode(int kind, String name, ValueNode defaultNode, DataTypeDescriptor dataTypeServices, long[] autoIncrementInfo, ContextManager cm) throws StandardException {
        super(name, defaultNode, dataTypeServices, autoIncrementInfo, cm);
        this.kind = kind;
    }

    @Override
    UUID getOldDefaultUUID() {
        return this.oldDefaultUUID;
    }

    int getColumnPosition() {
        SanityManager.ASSERT(this.columnPosition > 0, "columnPosition expected to be > 0");
        return this.columnPosition;
    }

    @Override
    void checkUserType(TableDescriptor td) throws StandardException {
        if (this.kind != 0) {
            return;
        }
        ColumnDescriptor cd = td.getColumnDescriptor(this.name);
        if (cd == null) {
            throw StandardException.newException("42X14", this.name, td.getName());
        }
        DataTypeDescriptor oldType = cd.getType();
        this.setNullability(oldType.isNullable());
        if (!oldType.getTypeId().equals(this.getType().getTypeId())) {
            throw StandardException.newException("42Z15", this.name);
        }
        String typeName = this.getType().getTypeName();
        if (!(typeName.equals("VARCHAR") || typeName.equals("VARCHAR () FOR BIT DATA") || typeName.equals("BLOB") || typeName.equals("CLOB"))) {
            throw StandardException.newException("42Z16", new Object[0]);
        }
        if (this.getType().getMaximumWidth() < oldType.getMaximumWidth()) {
            throw StandardException.newException("42Z17", this.name);
        }
    }

    void checkExistingConstraints(TableDescriptor td) throws StandardException {
        if (this.kind != 0 && this.kind != 2 && this.kind != 3) {
            return;
        }
        DataDictionary dd = this.getDataDictionary();
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(td);
        int[] intArray = new int[]{this.columnPosition};
        for (int index = 0; index < cdl.size(); ++index) {
            ConstraintDescriptor existingConstraint = cdl.elementAt(index);
            if (!(existingConstraint instanceof KeyConstraintDescriptor) || !existingConstraint.columnIntersects(intArray)) continue;
            int constraintType = existingConstraint.getConstraintType();
            if (constraintType == 6 && this.kind == 0) {
                throw StandardException.newException("42Z18", this.name, existingConstraint.getConstraintName());
            }
            if (!dd.checkVersion(160, null) && this.kind == 2 && existingConstraint.getConstraintType() == 3) {
                throw StandardException.newException("42Z20", this.name);
            }
            if (this.kind == 2 && existingConstraint.getConstraintType() == 2) {
                String errorState = this.getLanguageConnectionContext().getDataDictionary().checkVersion(160, null) ? "42Z20.S.1" : "42Z20";
                throw StandardException.newException(errorState, this.name);
            }
            ConstraintDescriptorList refcdl = dd.getForeignKeys(existingConstraint.getUUID());
            if (refcdl.size() > 0) {
                throw StandardException.newException("42Z19", this.name, refcdl.elementAt(0).getConstraintName());
            }
            this.getCompilerContext().createDependency(existingConstraint);
        }
    }

    void useExistingCollation(TableDescriptor td) throws StandardException {
        ColumnDescriptor cd = td.getColumnDescriptor(this.name);
        if (cd == null) {
            throw StandardException.newException("42X14", this.name, td.getName());
        }
        if (this.getType() != null && this.getType().getTypeId().isStringTypeId()) {
            this.setCollationType(cd.getType().getCollationType());
        }
    }

    @Override
    int getAction() {
        switch (this.kind) {
            case 1: {
                if (this.autoinc_create_or_modify_Start_Increment == 1L) {
                    return 5;
                }
                if (this.autoinc_create_or_modify_Start_Increment == 2L) {
                    return 6;
                }
                return 7;
            }
            case 0: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 1;
            }
        }
        SanityManager.THROWASSERT("Unexpected type = " + this.kind);
        return 0;
    }

    @Override
    void bindAndValidateDefault(DataDictionary dd, TableDescriptor td) throws StandardException {
        ColumnDescriptor cd = td.getColumnDescriptor(this.name);
        if (cd == null) {
            throw StandardException.newException("42X14", this.name, td.getName());
        }
        DefaultDescriptor defaultDescriptor = cd.getDefaultDescriptor(dd);
        this.oldDefaultUUID = defaultDescriptor == null ? null : defaultDescriptor.getUUID();
        this.columnPosition = cd.getPosition();
        if (this.kind != 1) {
            return;
        }
        if (this.keepCurrentDefault) {
            this.defaultInfo = (DefaultInfoImpl)cd.getDefaultInfo();
        } else if (cd.hasGenerationClause() || cd.isAutoincrement()) {
            throw StandardException.newException("42XA7", cd.getColumnName());
        }
        if (this.autoinc_create_or_modify_Start_Increment == 1L) {
            this.autoincrementIncrement = cd.getAutoincInc();
        }
        if (this.autoinc_create_or_modify_Start_Increment == 2L) {
            this.autoincrementStart = cd.getAutoincStart();
        }
        this.type = cd.getType();
        this.validateDefault(dd, td);
    }

    private ColumnDescriptor getLocalColumnDescriptor(String name, TableDescriptor td) throws StandardException {
        ColumnDescriptor cd = td.getColumnDescriptor(name);
        if (cd == null) {
            throw StandardException.newException("42X14", name, td.getName());
        }
        return cd;
    }

    @Override
    void validateAutoincrement(DataDictionary dd, TableDescriptor td, int tableType) throws StandardException {
        ColumnDescriptor cd;
        if (this.kind == 2 && (cd = this.getLocalColumnDescriptor(this.name, td)).isAutoincrement()) {
            throw StandardException.newException("42Z26", this.getColumnName());
        }
        if (this.autoincrementVerify && !(cd = this.getLocalColumnDescriptor(this.name, td)).isAutoincrement()) {
            throw StandardException.newException("42837", td.getQualifiedName(), this.name);
        }
        if (!this.isAutoincrement) {
            return;
        }
        super.validateAutoincrement(dd, td, tableType);
        if (this.getType().isNullable()) {
            throw StandardException.newException("42Z27", this.getColumnName());
        }
    }
}

