/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import org.apache.derby.iapi.db.OptimizerTrace;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.impl.sql.compile.DefaultOptTrace;
import org.apache.derby.impl.sql.compile.XMLOptTrace;

public class OptimizerTracer
implements OptionalTool {
    @Override
    public void loadTool(String ... configurationParameters) throws SQLException {
        OptTrace tracer;
        if (configurationParameters == null || configurationParameters.length == 0) {
            tracer = new DefaultOptTrace();
        } else if ("xml".equals(configurationParameters[0])) {
            try {
                tracer = new XMLOptTrace();
            }
            catch (Throwable t) {
                throw this.wrap(t);
            }
        } else if ("custom".equals(configurationParameters[0])) {
            if (configurationParameters.length != 2) {
                throw this.wrap(MessageService.getTextMessage("X0Y89.S", new Object[0]));
            }
            String customOptTraceName = configurationParameters[1];
            try {
                ClassFactoryContext cfc = (ClassFactoryContext)ContextService.getContext("ClassFactoryContext");
                ClassFactory classFactory = cfc.getClassFactory();
                tracer = (OptTrace)classFactory.loadApplicationClass(customOptTraceName).newInstance();
            }
            catch (InstantiationException cnfe) {
                throw this.cantInstantiate(customOptTraceName);
            }
            catch (ClassNotFoundException cnfe) {
                throw this.cantInstantiate(customOptTraceName);
            }
            catch (IllegalAccessException cnfe) {
                throw this.cantInstantiate(customOptTraceName);
            }
            catch (Throwable t) {
                throw this.wrap(t);
            }
        } else {
            throw this.wrap(MessageService.getTextMessage("X0Y89.S", new Object[0]));
        }
        OptimizerTrace.setOptimizerTracer(tracer);
    }

    private SQLException cantInstantiate(String className) {
        return this.wrap(MessageService.getTextMessage("X0Y90.S", className));
    }

    @Override
    public void unloadTool(final String ... configurationParameters) throws SQLException {
        try {
            PrintWriter pw;
            OptTrace tracer = OptimizerTrace.getOptimizerTracer();
            boolean needsClosing = false;
            if (configurationParameters != null && configurationParameters.length > 0) {
                pw = AccessController.doPrivileged(new PrivilegedAction<PrintWriter>(){

                    @Override
                    public PrintWriter run() {
                        try {
                            return new PrintWriter(configurationParameters[0]);
                        }
                        catch (IOException ioe) {
                            throw new IllegalArgumentException(ioe.getMessage(), ioe);
                        }
                    }
                });
                needsClosing = true;
            } else {
                pw = new PrintWriter(System.out);
            }
            if (tracer != null) {
                tracer.printToWriter(pw);
                pw.flush();
            }
            if (needsClosing) {
                pw.close();
            }
        }
        catch (Exception e) {
            throw this.wrap(e);
        }
        finally {
            OptimizerTrace.setOptimizerTracer(null);
        }
    }

    private SQLException wrap(Throwable t) {
        return new SQLException(t.getMessage(), t);
    }

    private SQLException wrap(String errorMessage) {
        String sqlState = "XJ001.U".substring(0, 5);
        return new SQLException(errorMessage, sqlState);
    }
}

