/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.OptimizerPlan;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.types.XML;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AggregateWindowFunctionNode;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.AlterTableNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BetweenOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryArithmeticOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CachedValueNode;
import org.apache.derby.impl.sql.compile.CallStatementNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.CharStream;
import org.apache.derby.impl.sql.compile.CoalesceFunctionNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CompilerContextImpl;
import org.apache.derby.impl.sql.compile.ConcatenationOperatorNode;
import org.apache.derby.impl.sql.compile.ConditionalNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.CountAggregateDefinition;
import org.apache.derby.impl.sql.compile.CreateAliasNode;
import org.apache.derby.impl.sql.compile.CreateIndexNode;
import org.apache.derby.impl.sql.compile.CreateRoleNode;
import org.apache.derby.impl.sql.compile.CreateSchemaNode;
import org.apache.derby.impl.sql.compile.CreateSequenceNode;
import org.apache.derby.impl.sql.compile.CreateTableNode;
import org.apache.derby.impl.sql.compile.CreateTriggerNode;
import org.apache.derby.impl.sql.compile.CreateViewNode;
import org.apache.derby.impl.sql.compile.CurrentDatetimeOperatorNode;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DB2LengthOperatorNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.DeleteNode;
import org.apache.derby.impl.sql.compile.DropAliasNode;
import org.apache.derby.impl.sql.compile.DropIndexNode;
import org.apache.derby.impl.sql.compile.DropRoleNode;
import org.apache.derby.impl.sql.compile.DropSchemaNode;
import org.apache.derby.impl.sql.compile.DropSequenceNode;
import org.apache.derby.impl.sql.compile.DropTableNode;
import org.apache.derby.impl.sql.compile.DropTriggerNode;
import org.apache.derby.impl.sql.compile.DropViewNode;
import org.apache.derby.impl.sql.compile.ExecSPSNode;
import org.apache.derby.impl.sql.compile.ExtractOperatorNode;
import org.apache.derby.impl.sql.compile.FKConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GenerationClauseNode;
import org.apache.derby.impl.sql.compile.GetCurrentConnectionNode;
import org.apache.derby.impl.sql.compile.GrantNode;
import org.apache.derby.impl.sql.compile.GrantRoleNode;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HalfOuterJoinNode;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.HashJoinStrategy;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.IntersectOrExceptNode;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.LengthOperatorNode;
import org.apache.derby.impl.sql.compile.LikeEscapeOperatorNode;
import org.apache.derby.impl.sql.compile.LockTableNode;
import org.apache.derby.impl.sql.compile.MatchingClauseNode;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.MergeNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.ModifyColumnNode;
import org.apache.derby.impl.sql.compile.NOPStatementNode;
import org.apache.derby.impl.sql.compile.NestedLoopJoinStrategy;
import org.apache.derby.impl.sql.compile.NewInvocationNode;
import org.apache.derby.impl.sql.compile.NextSequenceNode;
import org.apache.derby.impl.sql.compile.NonStaticMethodCallNode;
import org.apache.derby.impl.sql.compile.NotNode;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.ParseException;
import org.apache.derby.impl.sql.compile.PrivilegeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.RenameNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RevokeNode;
import org.apache.derby.impl.sql.compile.RevokeRoleNode;
import org.apache.derby.impl.sql.compile.RoutineDesignator;
import org.apache.derby.impl.sql.compile.RowNumberFunctionNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SQLParserConstants;
import org.apache.derby.impl.sql.compile.SQLParserTokenManager;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SavepointNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SetConstraintsNode;
import org.apache.derby.impl.sql.compile.SetRoleNode;
import org.apache.derby.impl.sql.compile.SetSchemaNode;
import org.apache.derby.impl.sql.compile.SetTransactionIsolationNode;
import org.apache.derby.impl.sql.compile.SimpleStringOperatorNode;
import org.apache.derby.impl.sql.compile.SpecialFunctionNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.StaticClassFieldReferenceNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.SumAvgAggregateDefinition;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.TablePrivilegesNode;
import org.apache.derby.impl.sql.compile.TernaryOperatorNode;
import org.apache.derby.impl.sql.compile.TimestampOperatorNode;
import org.apache.derby.impl.sql.compile.Token;
import org.apache.derby.impl.sql.compile.TransactionStatementNode;
import org.apache.derby.impl.sql.compile.TriggerReferencingStruct;
import org.apache.derby.impl.sql.compile.UnaryArithmeticOperatorNode;
import org.apache.derby.impl.sql.compile.UnaryDateTimestampOperatorNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.UserTypeConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;
import org.apache.derby.impl.sql.compile.VarbitConstantNode;
import org.apache.derby.impl.sql.compile.WindowDefinitionNode;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.impl.sql.compile.WindowNode;
import org.apache.derby.impl.sql.compile.WindowReferenceNode;
import org.apache.derby.shared.common.sanity.SanityManager;

class SQLParser
implements SQLParserConstants {
    private static final String[] SAVEPOINT_CLAUSE_NAMES = new String[]{"UNIQUE", "ON ROLLBACK RETAIN LOCKS", "ON ROLLBACK RETAIN CURSORS"};
    private static final String[] ROUTINE_CLAUSE_NAMES = new String[]{null, "SPECIFIC", "RESULT SET", "LANGUAGE", "EXTERNAL NAME", "PARAMETER STYLE", "SQL", "DETERMINISTIC", "ON NULL INPUT", "RETURN TYPE", "EXTERNAL SECURITY", null};
    private static final int[] JAVA_ROUTINE_CLAUSES = new int[]{3, 4, 5};
    private static final String[] TEMPORARY_TABLE_CLAUSE_NAMES = new String[]{"NOT LOGGED", "ON COMMIT", "ON ROLLBACK"};
    private static final int DEFAULT_STRING_COLUMN_LENGTH = 1;
    private static final int ON_OR_USING_CLAUSE_SIZE = 2;
    private static final int ON_CLAUSE = 0;
    private static final int USING_CLAUSE = 1;
    private static final int OPTIONAL_TABLE_CLAUSES_SIZE = 3;
    private static final int OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES = 0;
    private static final int OPTIONAL_TABLE_CLAUSES_DERIVED_RCL = 1;
    private static final int OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME = 2;
    private static final int MAX_UTF8_LENGTH = 65535;
    private static final int NO_SET_OP = 0;
    private static final int UNION_OP = 1;
    private static final int UNION_ALL_OP = 2;
    private static final int EXCEPT_OP = 3;
    private static final int EXCEPT_ALL_OP = 4;
    private static final int INTERSECT_OP = 5;
    private static final int INTERSECT_ALL_OP = 6;
    private static final int IDX_DATA_TYPE = 0;
    private static final int IDX_START_WITH_OPTION = 1;
    private static final int IDX_INCREMENT_BY_OPTION = 2;
    private static final int IDX_MAX_VALUE_OPTION = 3;
    private static final int IDX_MIN_VALUE_OPTION = 4;
    private static final int IDX_CYCLE_OPTION = 5;
    private static final int IDX_OPTION_COUNT = 6;
    private static final int OFFSET_CLAUSE = 0;
    private static final int FETCH_FIRST_CLAUSE = 1;
    private static final int OFFSET_CLAUSE_COUNT = 2;
    private Object[] paramDefaults;
    private String statementSQLText;
    private OptimizerFactory optimizerFactory;
    private ContextManager cm;
    private CompilerContext compilerContext;
    private int parameterNumber;
    private ArrayList<ParameterNode> parameterList;
    private boolean lastTokenDelimitedIdentifier = false;
    private boolean nextToLastTokenDelimitedIdentifier = false;
    private Token lastIdentifierToken;
    private Token nextToLastIdentifierToken;
    private Token thirdToLastIdentifierToken;
    static final String SINGLEQUOTES = "''";
    static final String DOUBLEQUOTES = "\"\"";
    static final String DEFAULT_INDEX_TYPE = "BTREE";
    private static final String[] ESCAPED_SYSFUN_FUNCTIONS = new String[]{"ACOS", "ASIN", "ATAN", "ATAN2", "COS", "SIN", "TAN", "PI", "DEGREES", "RADIANS", "EXP", "LOG", "LOG10", "CEILING", "FLOOR", "SIGN", "RAND", "COT"};
    public SQLParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[379];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private static int[] jj_la1_7;
    private static int[] jj_la1_8;
    private static int[] jj_la1_9;
    private static int[] jj_la1_10;
    private static int[] jj_la1_11;
    private static int[] jj_la1_12;
    private static int[] jj_la1_13;
    private static int[] jj_la1_14;
    private static int[] jj_la1_15;
    private final JJCalls[] jj_2_rtns = new JJCalls[94];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector<int[]> jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    final void setCompilerContext(CompilerContext cc) {
        this.compilerContext = cc;
        this.cm = cc.getContextManager();
    }

    private final OptimizerFactory getOptimizerFactory() throws StandardException {
        if (this.optimizerFactory == null) {
            this.optimizerFactory = this.getCompilerContext().getOptimizerFactory();
        }
        return this.optimizerFactory;
    }

    private final CompilerContext getCompilerContext() {
        return this.compilerContext;
    }

    private DataTypeDescriptor getDataTypeServices(int type, int precision, int scale, int length) throws StandardException {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(type), precision, scale, true, length);
    }

    private DataTypeDescriptor getJavaClassDataTypeDescriptor(TableName typeName) throws StandardException {
        return new DataTypeDescriptor(TypeId.getUserDefinedTypeId(typeName.getSchemaName(), typeName.getTableName(), null), true);
    }

    private LanguageConnectionContext getLanguageConnectionContext() {
        return (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
    }

    private boolean checkVersion(int version, String feature) throws StandardException {
        return this.getLanguageConnectionContext().getDataDictionary().checkVersion(version, feature);
    }

    private void checkSqlStandardAccess(String command) throws StandardException {
        if (this.getLanguageConnectionContext().usesSqlAuthorization()) {
            return;
        }
        throw StandardException.newException("42Z60", command, "derby.database.sqlAuthorization", "TRUE");
    }

    private void forbidNextValueFor() {
        CompilerContext cc = this.getCompilerContext();
        cc.setReliability(cc.getReliability() | 0x4000);
    }

    private void checkInternalFeature(String feature) throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        if ((cc.getReliability() & 0x400) != 0) {
            throw StandardException.newException("42X01", feature);
        }
    }

    private void checkTypeLimits(int type, int length) throws StandardException {
        boolean valid = true;
        switch (type) {
            case -2: 
            case 1: {
                if (length <= 254) break;
                valid = false;
                break;
            }
            case -3: 
            case 12: {
                if (length <= 32672) break;
                valid = false;
                break;
            }
        }
        if (!valid) {
            DataTypeDescriptor charDTD = DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);
            throw StandardException.newException("42611", charDTD.getSQLstring());
        }
    }

    private final ContextManager getContextManager() {
        return this.cm;
    }

    private static void verifyImageLength(String image) throws StandardException {
        if (image.length() > 65535) {
            throw StandardException.newException("42Z99", new Object[0]);
        }
    }

    private static String normalizeDelimitedID(String str) {
        str = StringUtil.compressQuotes(str, DOUBLEQUOTES);
        return str;
    }

    private static boolean isDATETIME(int val) {
        return val == 285 || val == 350 || val == 351;
    }

    ValueNode multOp(ValueNode leftOperand, ValueNode rightOperand, int multiplicativeOperator) throws StandardException {
        if (leftOperand == null) {
            return rightOperand;
        }
        switch (multiplicativeOperator) {
            case 3: {
                return new BinaryArithmeticOperatorNode(3, leftOperand, rightOperand, this.getContextManager());
            }
            case 4: {
                return new BinaryArithmeticOperatorNode(0, leftOperand, rightOperand, this.getContextManager());
            }
            case 5: {
                return new ConcatenationOperatorNode(leftOperand, rightOperand, this.getContextManager());
            }
        }
        SanityManager.THROWASSERT("Unexpected multiplicative operator " + multiplicativeOperator);
        return null;
    }

    private void setUpAndLinkParameters() throws StandardException {
        CompilerContextImpl cc = (CompilerContextImpl)this.getCompilerContext();
        cc.setParameterList(this.parameterList);
        DataTypeDescriptor[] descriptors = cc.getParameterTypes();
        int paramCount = -1;
        int plSize = this.parameterList.size();
        for (int index = 0; index < plSize; ++index) {
            ++paramCount;
            ParameterNode newNode = this.parameterList.get(index);
            newNode.setDescriptors(descriptors);
        }
    }

    void initUnnamedParameterList() {
        this.parameterList = new ArrayList();
    }

    ParameterNode makeParameterNode() throws StandardException {
        DataValueDescriptor sdv = null;
        if (this.paramDefaults != null && this.parameterNumber < this.paramDefaults.length) {
            sdv = (DataValueDescriptor)this.paramDefaults[this.parameterNumber];
        }
        ParameterNode parm = new ParameterNode(this.parameterNumber, sdv, this.getContextManager());
        ++this.parameterNumber;
        this.parameterList.add(parm);
        return parm;
    }

    NumericConstantNode getNumericNode(String num, boolean intsOnly) throws StandardException {
        ContextManager cm = this.getContextManager();
        try {
            return new NumericConstantNode(TypeId.getBuiltInTypeId(4), Integer.valueOf(num), cm);
        }
        catch (NumberFormatException nfe) {
            try {
                return new NumericConstantNode(TypeId.getBuiltInTypeId(-5), Long.valueOf(num), cm);
            }
            catch (NumberFormatException nfe2) {
                if (intsOnly) {
                    throw nfe2;
                }
                return new NumericConstantNode(TypeId.getBuiltInTypeId(3), new BigDecimal(num), cm);
            }
        }
    }

    private boolean isBuiltInAlias() {
        boolean retval = false;
        switch (this.token.kind) {
            case 271: 
            case 272: 
            case 311: 
            case 376: 
            case 403: 
            case 404: 
            case 438: 
            case 444: {
                retval = true;
                break;
            }
            default: {
                retval = false;
            }
        }
        return retval;
    }

    boolean commonDatatypeName(boolean checkFollowingToken) {
        return this.commonDatatypeName(1, checkFollowingToken);
    }

    boolean dataTypeCheck(int start) {
        if (this.commonDatatypeName(start, false)) {
            return true;
        }
        boolean retval = true;
        switch (this.getToken((int)start).kind) {
            case 453: 
            case 454: 
            case 458: {
                retval = false;
            }
        }
        return retval;
    }

    boolean commonDatatypeName(int start, boolean checkFollowingToken) {
        boolean retval = false;
        switch (this.getToken((int)start).kind) {
            case 80: 
            case 81: 
            case 88: 
            case 89: 
            case 116: 
            case 117: 
            case 128: 
            case 143: 
            case 167: 
            case 168: 
            case 187: 
            case 193: 
            case 214: 
            case 228: 
            case 261: 
            case 275: 
            case 278: 
            case 285: 
            case 318: 
            case 350: 
            case 351: 
            case 360: 
            case 368: 
            case 377: 
            case 411: {
                retval = true;
                break;
            }
            case 369: {
                if (checkFollowingToken) {
                    switch (this.getToken((int)(start + 1)).kind) {
                        case 80: 
                        case 81: 
                        case 260: 
                        case 261: 
                        case 411: {
                            retval = true;
                        }
                    }
                    break;
                }
                retval = true;
                break;
            }
            case 185: {
                if (checkFollowingToken) {
                    switch (this.getToken((int)(start + 1)).kind) {
                        case 88: 
                        case 89: {
                            retval = true;
                        }
                    }
                    break;
                }
                retval = true;
            }
        }
        return retval;
    }

    private StatementNode getDeleteNode(FromTable fromTable, TableName tableName, ValueNode whereClause) throws StandardException {
        FromList fromList = new FromList(this.getContextManager());
        fromList.addFromTable(fromTable);
        SelectNode resultSet = new SelectNode(null, fromList, whereClause, null, null, null, null, this.getContextManager());
        DeleteNode retval = new DeleteNode(tableName, resultSet, null, this.getContextManager());
        this.setUpAndLinkParameters();
        return retval;
    }

    private StatementNode getUpdateNode(FromTable fromTable, TableName tableName, ResultColumnList setClause, ValueNode whereClause) throws StandardException {
        FromList fromList = new FromList(this.getContextManager());
        fromList.addFromTable(fromTable);
        SelectNode resultSet = new SelectNode(setClause, fromList, whereClause, null, null, null, null, this.getContextManager());
        UpdateNode retval = new UpdateNode(tableName, resultSet, null, this.getContextManager());
        this.setUpAndLinkParameters();
        return retval;
    }

    private ValueNode getTrimOperatorNode(Integer trimSpec, ValueNode trimChar, ValueNode trimSource, ContextManager cm) throws StandardException {
        if (trimChar == null) {
            trimChar = new CharConstantNode(" ", this.getContextManager());
        }
        return new TernaryOperatorNode(trimSource, trimChar, null, 0, trimSpec, cm == null ? this.getContextManager() : cm);
    }

    private boolean ansiTrimSpecFollows() {
        return this.getToken((int)2).kind == 176 || this.getToken((int)2).kind == 247 || this.getToken((int)2).kind == 82;
    }

    private boolean remainingPredicateFollows() {
        boolean retval = false;
        switch (this.getToken((int)1).kind) {
            case 79: 
            case 160: 
            case 171: 
            case 178: 
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 470: 
            case 471: {
                retval = true;
                break;
            }
            case 190: {
                switch (this.getToken((int)2).kind) {
                    case 79: 
                    case 160: 
                    case 178: {
                        retval = true;
                    }
                }
            }
        }
        return retval;
    }

    private boolean dropFollows() {
        return this.getToken((int)1).kind == 129;
    }

    private boolean escapedValueFunctionFollows() {
        if (this.getToken((int)1).kind != 451) {
            return false;
        }
        return this.getToken((int)2).kind == 399;
    }

    private String getEscapedSYSFUN(String name) {
        name = StringUtil.SQLToUpperCase(name);
        for (int i = 0; i < ESCAPED_SYSFUN_FUNCTIONS.length; ++i) {
            if (!ESCAPED_SYSFUN_FUNCTIONS[i].equals(name)) continue;
            return name;
        }
        return null;
    }

    private boolean columnMethodInvocationFollows() {
        int tokKind = this.getToken((int)1).kind;
        if (tokKind == 0) {
            return false;
        }
        if (this.getToken((int)1).image.charAt(0) == '?') {
            return false;
        }
        if (tokKind == 109 || tokKind == 110 || tokKind == 111 || tokKind == 108 && SQLParser.isDATETIME(this.getToken((int)2).kind)) {
            return false;
        }
        if (this.getToken((int)2).kind != 460) {
            return false;
        }
        tokKind = this.getToken((int)4).kind;
        if (tokKind == 453) {
            return true;
        }
        if (tokKind != 460) {
            return false;
        }
        tokKind = this.getToken((int)6).kind;
        if (tokKind == 453) {
            return true;
        }
        if (tokKind != 460) {
            return false;
        }
        tokKind = this.getToken((int)8).kind;
        return tokKind == 453;
    }

    private boolean aggregateFollows() {
        boolean retval = false;
        switch (this.getToken((int)1).kind) {
            case 77: 
            case 181: 
            case 182: 
            case 236: {
                retval = true;
                break;
            }
            case 105: {
                if (this.getToken((int)2).kind == 453) {
                    retval = true;
                }
            }
            default: {
                if (this.getToken((int)2).kind != 453 || this.getToken((int)3).kind != 127) break;
                retval = true;
            }
        }
        return retval;
    }

    private boolean builtinAggregateFollows() {
        switch (this.getToken((int)1).kind) {
            case 77: 
            case 105: 
            case 181: 
            case 182: 
            case 236: {
                return true;
            }
        }
        return false;
    }

    private boolean distinctUDAFollows() {
        if (this.builtinAggregateFollows()) {
            return false;
        }
        if (this.getToken((int)2).kind == 453 && this.getToken((int)3).kind == 127) {
            return true;
        }
        return this.getToken((int)2).kind == 460 && this.getToken((int)4).kind == 453 && this.getToken((int)5).kind == 127;
    }

    private boolean windowOrAggregateFunctionFollows() {
        if (this.distinctUDAFollows()) {
            return false;
        }
        boolean retval = false;
        switch (this.getToken((int)1).kind) {
            case 374: {
                retval = true;
                break;
            }
            default: {
                retval = this.aggregateFollows();
            }
        }
        return retval;
    }

    private boolean miscBuiltinFollows() {
        boolean retval = false;
        int tokKind = this.getToken((int)1).kind;
        if (this.getToken((int)0).kind == 361) {
            retval = true;
        }
        switch (tokKind) {
            case 109: 
            case 110: 
            case 111: 
            case 366: {
                retval = true;
                break;
            }
            case 108: {
                if (!SQLParser.isDATETIME(this.getToken((int)2).kind)) break;
                retval = true;
                break;
            }
            case 87: 
            case 453: {
                retval = false;
                break;
            }
            default: {
                if (this.getToken((int)2).kind != 453) break;
                retval = true;
            }
        }
        return retval;
    }

    private boolean subqueryFollows() {
        boolean retval = false;
        int i = 1;
        while (true) {
            int tokKind;
            if ((tokKind = this.getToken((int)i).kind) != 453) {
                if (tokKind != 225 && tokKind != 259) break;
                retval = true;
                break;
            }
            ++i;
        }
        return retval;
    }

    private boolean seeingOffsetClause() {
        boolean nesting = false;
        int i = 2;
        int tokKind = this.getToken((int)i).kind;
        if (tokKind == 457 || tokKind == 459 ? (tokKind = this.getToken((int)(++i)).kind) == 487 : tokKind == 487 || tokKind == 472) {
            tokKind = this.getToken((int)(++i)).kind;
            return tokKind == 332 || tokKind == 221;
        }
        return false;
    }

    private boolean rowValueConstructorListFollows() {
        boolean retval = false;
        if (this.getToken((int)1).kind == 453) {
            int nesting = 1;
            int i = 2;
            while (true) {
                int tokKind = this.getToken((int)i).kind;
                if (i == 2 && (tokKind == 191 || tokKind == 119)) {
                    retval = true;
                    break;
                }
                if (nesting == 1 && tokKind == 458) {
                    retval = true;
                    break;
                }
                if (tokKind == 0) break;
                if (tokKind == 453) {
                    ++nesting;
                } else if (tokKind == 454) {
                    --nesting;
                }
                if (nesting == 0) break;
                ++i;
            }
        }
        return retval;
    }

    private boolean derbyPropertiesListFollows() {
        return this.getToken((int)1).kind == 59;
    }

    private boolean newInvocationFollows(int startToken) {
        boolean retval = false;
        if (this.getToken((int)startToken).kind == 409) {
            int i = 2 + startToken;
            while (true) {
                int tokKind;
                if ((tokKind = this.getToken((int)i).kind) == 453) {
                    retval = true;
                    break;
                }
                if (tokKind != 460) break;
                i += 2;
            }
        }
        return retval;
    }

    boolean javaClassFollows() {
        boolean retval = false;
        int i = 2;
        while (true) {
            int tokKind;
            if ((tokKind = this.getToken((int)i).kind) == 463) {
                retval = true;
                break;
            }
            if (tokKind != 460) break;
            i += 2;
        }
        return retval;
    }

    private boolean fromNewInvocationFollows() {
        boolean retval = false;
        return this.getToken((int)1).kind == 147 && this.newInvocationFollows(2);
    }

    private boolean joinedTableExpressionFollows() {
        boolean retval = false;
        int tokKind1 = this.getToken((int)1).kind;
        int tokKind2 = this.getToken((int)2).kind;
        if (tokKind1 == 173) {
            retval = true;
        } else if (tokKind1 == 163 && tokKind2 == 173) {
            retval = true;
        } else if (tokKind1 == 107 && tokKind2 == 173) {
            retval = true;
        } else if (tokKind1 == 186) {
            retval = true;
        } else if ((tokKind1 == 177 || tokKind1 == 219) && tokKind2 == 201) {
            if (this.getToken((int)3).kind == 173) {
                retval = true;
            }
        } else if ((tokKind1 == 177 || tokKind1 == 219) && tokKind2 == 173) {
            retval = true;
        }
        return retval;
    }

    private static String aggName(Token token) {
        String retval = null;
        switch (token.kind) {
            case 181: {
                retval = "MAX";
                break;
            }
            case 77: {
                retval = "AVG";
                break;
            }
            case 182: {
                retval = "MIN";
                break;
            }
            case 236: {
                retval = "SUM";
                break;
            }
            case 105: {
                retval = "COUNT";
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected token type in aggName: " + token.kind);
            }
        }
        return retval;
    }

    private static Class aggClass(Token token) {
        Class retval = null;
        switch (token.kind) {
            case 181: 
            case 182: {
                retval = MaxMinAggregateDefinition.class;
                break;
            }
            case 77: 
            case 236: {
                retval = SumAvgAggregateDefinition.class;
                break;
            }
            case 105: {
                retval = CountAggregateDefinition.class;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected token type in aggClass: " + token.kind);
            }
        }
        return retval;
    }

    private boolean anotherPropertyFollows() {
        boolean retval = false;
        if (this.getToken((int)1).kind == 458) {
            int tokKind;
            int i = 3;
            do {
                if ((tokKind = this.getToken((int)i).kind) == 467) {
                    retval = true;
                    break;
                }
                i += 2;
            } while (tokKind == 460);
        }
        return retval;
    }

    StatementNode getCreateAliasNode(TableName aliasName, Object targetName, Object aliasSpecificInfo, char aliasType) throws StandardException {
        String methodName = null;
        if (aliasType != 'S' && aliasType != 'A' && aliasType != 'G') {
            String fullStaticMethodName = (String)targetName;
            int paren = fullStaticMethodName.indexOf(40);
            int lastPeriod = paren == -1 ? fullStaticMethodName.lastIndexOf(46) : fullStaticMethodName.substring(0, paren).lastIndexOf(46);
            if (lastPeriod == -1 || lastPeriod == fullStaticMethodName.length() - 1) {
                throw StandardException.newException("42Y04", fullStaticMethodName);
            }
            String javaClassName = fullStaticMethodName.substring(0, lastPeriod);
            methodName = fullStaticMethodName.substring(lastPeriod + 1);
            targetName = javaClassName;
        }
        return new CreateAliasNode(aliasName, targetName, methodName, aliasSpecificInfo, aliasType, this.cm);
    }

    StatementNode dropAliasNode(TableName aliasName, char type) throws StandardException {
        return new DropAliasNode(aliasName, type, this.getContextManager());
    }

    ValueNode getSubstringNode(ValueNode stringValue, ValueNode startPosition, ValueNode length) throws StandardException {
        return new TernaryOperatorNode(stringValue, startPosition, length, 2, -1, this.getContextManager());
    }

    private void initStatement(String statementSQLText, Object[] paramDefaults) throws StandardException {
        this.parameterNumber = 0;
        this.statementSQLText = statementSQLText;
        this.paramDefaults = paramDefaults;
        this.optimizerFactory = this.getOptimizerFactory();
        this.initUnnamedParameterList();
    }

    private ValueNode getJdbcIntervalNode(int intervalType) throws StandardException {
        return new NumericConstantNode(TypeId.getBuiltInTypeId(4), ReuseFactory.getInteger(intervalType), this.getContextManager());
    }

    void checkRequiredRoutineClause(int[] required, Object[] clauses) throws StandardException {
        for (int i = 0; i < required.length; ++i) {
            int re = required[i];
            if (clauses[re] != null) continue;
            throw StandardException.newException("42X01", ROUTINE_CLAUSE_NAMES[re]);
        }
    }

    boolean isPrivilegeKeywordExceptTrigger(int tokenKind) {
        return tokenKind == 225 || tokenKind == 122 || tokenKind == 166 || tokenKind == 254 || tokenKind == 215 || tokenKind == 137 || tokenKind == 357 || tokenKind == 66;
    }

    TableElementNode wrapAlterColumnDefaultValue(ValueNode defaultNode, String columnName, long[] autoIncrementInfo) throws StandardException {
        if (autoIncrementInfo[2] == 0L) {
            autoIncrementInfo = null;
        }
        return new ModifyColumnNode(1, columnName, defaultNode, null, autoIncrementInfo, this.getContextManager());
    }

    private boolean isTableValueConstructor(ResultSetNode expression) throws StandardException {
        return expression instanceof RowResultSetNode || expression instanceof UnionNode && ((UnionNode)expression).tableConstructor();
    }

    private JoinNode newJoinNode(ResultSetNode leftRSN, ResultSetNode rightRSN, ValueNode onClause, ResultColumnList usingClause, int joinType) throws StandardException {
        switch (joinType) {
            case 1: {
                return new JoinNode(leftRSN, rightRSN, onClause, usingClause, null, null, null, this.getContextManager());
            }
            case 3: {
                return new HalfOuterJoinNode(leftRSN, rightRSN, onClause, usingClause, false, null, this.getContextManager());
            }
            case 4: {
                return new HalfOuterJoinNode(leftRSN, rightRSN, onClause, usingClause, true, null, this.getContextManager());
            }
        }
        SanityManager.THROWASSERT("Unexpected joinType: " + joinType);
        return null;
    }

    private static boolean hasQueryExpressionSuffix(OrderByList orderBy, ValueNode[] offsetClauses) {
        return orderBy != null || offsetClauses[0] != null || offsetClauses[1] != null;
    }

    public final StatementNode Statement(String statementSQLText, Object[] paramDefaults) throws ParseException, StandardException {
        this.initStatement(statementSQLText, paramDefaults);
        StatementNode statementNode = this.StatementPart(null);
        this.jj_consume_token(0);
        statementNode.setBeginOffset(0);
        statementNode.setEndOffset(statementSQLText.length() - 1);
        return statementNode;
    }

    public final ValueNode SearchCondition(String sqlFragment) throws ParseException, StandardException {
        this.initStatement(sqlFragment, null);
        ValueNode valueNode = this.valueExpression();
        this.jj_consume_token(0);
        valueNode.setBeginOffset(0);
        valueNode.setEndOffset(sqlFragment.length() - 1);
        return valueNode;
    }

    public final StatementNode proceduralStatement(Token[] tokenHolder) throws ParseException, StandardException {
        StatementNode statementNode;
        tokenHolder[0] = this.getToken(1);
        switch (this.jj_nt.kind) {
            case 166: {
                statementNode = this.insertStatement();
                break;
            }
            case 254: {
                statementNode = this.preparableUpdateStatement();
                break;
            }
            case 122: {
                statementNode = this.preparableDeleteStatement();
                break;
            }
            case 225: 
            case 259: 
            case 453: {
                statementNode = this.preparableSelectStatement(true);
                break;
            }
            case 309: {
                statementNode = this.mergeStatement();
                break;
            }
            case 361: 
            case 451: 
            case 472: {
                statementNode = this.callStatement();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode StatementPart(Token[] tokenHolder) throws ParseException, StandardException {
        if (tokenHolder != null) {
            tokenHolder[0] = this.getToken(1);
        }
        switch (this.jj_nt.kind) {
            case 405: 
            case 424: {
                StatementNode statementNode;
                switch (this.jj_nt.kind) {
                    case 424: {
                        statementNode = this.spsRenameStatement();
                        break;
                    }
                    case 405: {
                        statementNode = this.lockStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return statementNode;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        if (this.jj_2_4(1)) {
            StatementNode statementNode;
            block7 : switch (this.jj_nt.kind) {
                case 106: {
                    statementNode = this.createStatements();
                    break;
                }
                case 129: {
                    statementNode = this.dropStatements();
                    break;
                }
                case 68: {
                    statementNode = this.spsAlterStatement();
                    break;
                }
                case 118: {
                    statementNode = this.globalTemporaryTableDeclaration();
                    break;
                }
                case 122: 
                case 166: 
                case 220: 
                case 225: 
                case 254: 
                case 259: 
                case 309: 
                case 327: 
                case 333: 
                case 361: 
                case 451: 
                case 453: 
                case 472: {
                    statementNode = this.preparableSQLDataStatement();
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    if (this.jj_2_1(1)) {
                        statementNode = this.spsSetStatement();
                        break;
                    }
                    switch (this.jj_nt.kind) {
                        case 354: {
                            statementNode = this.truncateTableStatement();
                            break block7;
                        }
                    }
                    this.jj_la1[3] = this.jj_gen;
                    if (this.jj_2_2(1)) {
                        statementNode = this.grantStatement();
                        break;
                    }
                    if (this.jj_2_3(1)) {
                        statementNode = this.revokeStatement();
                        break;
                    }
                    switch (this.jj_nt.kind) {
                        case 137: {
                            statementNode = this.execStatement();
                            break block7;
                        }
                    }
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode createStatements() throws ParseException, StandardException {
        StatementNode statementNode;
        Token beginToken = this.jj_consume_token(106);
        block0 : switch (this.jj_nt.kind) {
            case 222: 
            case 263: 
            case 348: 
            case 373: 
            case 432: 
            case 442: {
                switch (this.jj_nt.kind) {
                    case 222: {
                        statementNode = this.schemaDefinition();
                        break block0;
                    }
                    case 263: {
                        statementNode = this.viewDefinition(beginToken);
                        break block0;
                    }
                    case 442: {
                        statementNode = this.triggerDefinition();
                        break block0;
                    }
                    case 348: {
                        statementNode = this.synonymDefinition();
                        break block0;
                    }
                    case 373: {
                        statementNode = this.roleDefinition();
                        break block0;
                    }
                    case 432: {
                        statementNode = this.sequenceDefinition();
                        break block0;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 239: {
                statementNode = this.tableDefinition();
                break;
            }
            case 211: {
                statementNode = this.procedureDefinition();
                break;
            }
            case 149: {
                statementNode = this.functionDefinition();
                break;
            }
            case 391: {
                statementNode = this.aggregateDefinition();
                break;
            }
            case 355: {
                statementNode = this.udtDefinition();
                break;
            }
            case 252: 
            case 400: {
                statementNode = this.indexDefinition();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode dropStatements() throws ParseException, StandardException {
        StatementNode statementNode;
        this.jj_consume_token(129);
        switch (this.jj_nt.kind) {
            case 222: {
                statementNode = this.dropSchemaStatement();
                break;
            }
            case 239: {
                statementNode = this.dropTableStatement();
                break;
            }
            case 400: {
                statementNode = this.dropIndexStatement();
                break;
            }
            case 149: 
            case 211: 
            case 348: 
            case 355: 
            case 391: {
                statementNode = this.dropAliasStatement();
                break;
            }
            case 263: {
                statementNode = this.dropViewStatement();
                break;
            }
            case 442: {
                statementNode = this.dropTriggerStatement();
                break;
            }
            case 373: {
                statementNode = this.dropRoleStatement();
                break;
            }
            case 432: {
                statementNode = this.dropSequenceStatement();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode spsAlterStatement() throws ParseException, StandardException {
        this.jj_consume_token(68);
        StatementNode statementNode = this.alterTableStatement();
        return statementNode;
    }

    public final StatementNode spsSetStatement() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 227 && this.getToken((int)2).kind != 108) {
            StatementNode statementNode;
            this.jj_consume_token(227);
            if (this.jj_2_5(1)) {
                statementNode = this.setIsolationStatement();
            } else if (this.jj_2_6(1)) {
                statementNode = this.setSchemaStatement();
            } else {
                switch (this.jj_nt.kind) {
                    case 406: {
                        statementNode = this.setMessageLocaleStatement();
                        break;
                    }
                    case 373: {
                        statementNode = this.setRoleStatement();
                        break;
                    }
                    case 101: {
                        statementNode = this.setConstraintsStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            return statementNode;
        }
        if (this.getToken((int)1).kind == 227 && this.getToken((int)2).kind == 108) {
            StatementNode statementNode;
            this.jj_consume_token(227);
            if (this.jj_2_7(1)) {
                statementNode = this.setSchemaStatement();
            } else if (this.jj_2_8(1)) {
                statementNode = this.setIsolationStatement();
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void constraintsReference(List<TableName> constraints) throws ParseException, StandardException {
        TableName constraint = this.qualifiedName(128);
        constraints.add(constraint);
    }

    public final StatementNode setConstraintsStatement() throws ParseException, StandardException {
        boolean initiallyDeferred;
        ArrayList<TableName> constraints;
        block12: {
            constraints = new ArrayList<TableName>();
            this.jj_consume_token(101);
            if (this.jj_2_9(1)) {
                this.constraintsReference(constraints);
                while (true) {
                    switch (this.jj_nt.kind) {
                        case 458: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block12;
                        }
                    }
                    this.jj_consume_token(458);
                    this.constraintsReference(constraints);
                }
            }
            switch (this.jj_nt.kind) {
                case 66: {
                    this.jj_consume_token(66);
                    constraints = null;
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        switch (this.jj_nt.kind) {
            case 121: {
                this.jj_consume_token(121);
                initiallyDeferred = true;
                break;
            }
            case 159: {
                this.jj_consume_token(159);
                initiallyDeferred = false;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.checkVersion(230, "DEFERRED CONSTRAINTS");
        return new SetConstraintsNode(constraints, initiallyDeferred, this.cm);
    }

    public final StatementNode preparableSQLDataStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 122: {
                StatementNode dmlStatement = this.preparableDeleteStatement();
                return dmlStatement;
            }
            case 225: 
            case 259: 
            case 453: {
                CursorNode dmlStatement = this.preparableSelectStatement(true);
                return dmlStatement;
            }
            case 166: {
                StatementNode dmlStatement = this.insertStatement();
                return dmlStatement;
            }
            case 309: {
                StatementNode dmlStatement = this.mergeStatement();
                return dmlStatement;
            }
            case 254: {
                StatementNode dmlStatement = this.preparableUpdateStatement();
                return dmlStatement;
            }
            case 361: 
            case 451: 
            case 472: {
                StatementNode dmlStatement = this.callStatement();
                return dmlStatement;
            }
            case 220: 
            case 327: 
            case 333: {
                StatementNode dmlStatement = this.savepointStatement();
                return dmlStatement;
            }
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableDeleteStatement() throws ParseException, StandardException {
        this.jj_consume_token(122);
        StatementNode qtn = this.deleteBody();
        return qtn;
    }

    public final StatementNode deleteBody() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLNode = null;
        String correlationName = null;
        TableName tableName = null;
        ValueNode whereClause = null;
        FromTable fromTable = null;
        Properties targetProperties = null;
        Token whereToken = null;
        if (this.fromNewInvocationFollows()) {
            this.jj_consume_token(147);
            javaToSQLNode = this.newInvocation();
            switch (this.jj_nt.kind) {
                case 265: {
                    whereToken = this.jj_consume_token(265);
                    whereClause = this.whereClause(whereToken);
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                }
            }
            fromTable = new FromVTI((MethodCallNode)javaToSQLNode.getJavaValueNode(), null, null, null, this.getContextManager());
            return this.getDeleteNode(fromTable, tableName, whereClause);
        }
        switch (this.jj_nt.kind) {
            case 147: {
                this.jj_consume_token(147);
                tableName = this.qualifiedName(128);
                if (this.getToken((int)1).kind != 0 && this.getToken((int)1).kind != 265 && !this.derbyPropertiesListFollows()) {
                    switch (this.jj_nt.kind) {
                        case 72: {
                            this.jj_consume_token(72);
                            break;
                        }
                        default: {
                            this.jj_la1[15] = this.jj_gen;
                        }
                    }
                    correlationName = this.identifier(128, true);
                }
                switch (this.jj_nt.kind) {
                    case 59: {
                        targetProperties = this.propertyList(false);
                        this.jj_consume_token(64);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 265: {
                        whereToken = this.jj_consume_token(265);
                        if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 194) {
                            fromTable = this.currentOfClause(correlationName);
                            break;
                        }
                        if (this.jj_2_10(1)) {
                            whereClause = this.whereClause(whereToken);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                    }
                }
                if (fromTable == null) {
                    fromTable = new FromBaseTable(tableName, correlationName, 2, null, this.getContextManager());
                }
                if (targetProperties != null) {
                    if (((FromBaseTable)fromTable).getProperties() != null) {
                        SanityManager.THROWASSERT("Overwriting existing properties");
                    }
                    ((FromBaseTable)fromTable).setTableProperties(targetProperties);
                }
                return this.getDeleteNode(fromTable, tableName, whereClause);
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final FromTable currentOfClause(String correlationName) throws ParseException, StandardException {
        String cursorName = null;
        this.jj_consume_token(108);
        this.jj_consume_token(194);
        cursorName = this.identifier(128, true);
        return new CurrentOfNode(correlationName, cursorName, null, this.getContextManager());
    }

    public final CursorNode preparableSelectStatement(boolean checkParams) throws ParseException, StandardException {
        ArrayList<String> updateColumns = new ArrayList<String>();
        int forUpdateState = 0;
        int isolationLevel = 0;
        OrderByList orderCols = null;
        ValueNode[] offsetClauses = new ValueNode[2];
        boolean hasJDBClimitClause = false;
        ResultSetNode queryExpression = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 200: {
                orderCols = this.orderByClause(queryExpression);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        hasJDBClimitClause = this.offsetFetchFirstClause(offsetClauses);
        switch (this.jj_nt.kind) {
            case 144: {
                this.jj_consume_token(144);
                forUpdateState = this.forUpdateClause(updateColumns);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 267: {
                isolationLevel = this.atIsolationLevel();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        CursorNode retval = new CursorNode("SELECT", queryExpression, null, orderCols, offsetClauses[0], offsetClauses[1], hasJDBClimitClause, forUpdateState, forUpdateState == 1 ? null : updateColumns.toArray(new String[updateColumns.size()]), false, this.getContextManager());
        if (checkParams) {
            this.setUpAndLinkParameters();
        }
        if (isolationLevel != 0) {
            this.getCompilerContext().setScanIsolationLevel(isolationLevel);
        }
        return retval;
    }

    public final StatementNode insertStatement() throws ParseException, StandardException {
        this.jj_consume_token(166);
        this.jj_consume_token(170);
        QueryTreeNode targetTable = this.targetTable();
        StatementNode insertNode = this.insertColumnsAndSource(targetTable);
        this.setUpAndLinkParameters();
        return insertNode;
    }

    public final QueryTreeNode targetTable() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLNode = null;
        String correlationName = null;
        if (this.newInvocationFollows(1)) {
            javaToSQLNode = this.newInvocation();
            return new FromVTI((MethodCallNode)javaToSQLNode.getJavaValueNode(), correlationName, null, null, this.getContextManager());
        }
        if (this.jj_2_11(1)) {
            TableName tableName = this.qualifiedName(128);
            return tableName;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableUpdateStatement() throws ParseException, StandardException {
        this.jj_consume_token(254);
        StatementNode qtn = this.updateBody();
        return qtn;
    }

    public final boolean tableOrIndex() throws ParseException {
        switch (this.jj_nt.kind) {
            case 239: {
                this.jj_consume_token(239);
                return true;
            }
            case 400: {
                this.jj_consume_token(400);
                return false;
            }
        }
        this.jj_la1[22] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode updateBody() throws ParseException, StandardException {
        String correlationName = null;
        JavaToSQLValueNode javaToSQLNode = null;
        TableName tableName = null;
        ValueNode whereClause = null;
        FromTable fromTable = null;
        Properties targetProperties = null;
        Token whereToken = null;
        if (this.newInvocationFollows(1)) {
            javaToSQLNode = this.newInvocation();
            this.jj_consume_token(227);
            ResultColumnList columnList = this.setClauseList();
            switch (this.jj_nt.kind) {
                case 265: {
                    whereToken = this.jj_consume_token(265);
                    whereClause = this.whereClause(whereToken);
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                }
            }
            fromTable = new FromVTI((MethodCallNode)javaToSQLNode.getJavaValueNode(), null, null, null, this.getContextManager());
            return this.getUpdateNode(fromTable, tableName, columnList, whereClause);
        }
        if (this.jj_2_13(1)) {
            tableName = this.qualifiedName(128);
            if (this.getToken((int)1).kind != 227 && !this.derbyPropertiesListFollows()) {
                switch (this.jj_nt.kind) {
                    case 72: {
                        this.jj_consume_token(72);
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                    }
                }
                correlationName = this.identifier(128, true);
            }
            switch (this.jj_nt.kind) {
                case 59: {
                    targetProperties = this.propertyList(false);
                    this.jj_consume_token(64);
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                }
            }
            this.jj_consume_token(227);
            ResultColumnList columnList = this.setClauseList();
            block9 : switch (this.jj_nt.kind) {
                case 265: {
                    whereToken = this.jj_consume_token(265);
                    if (this.jj_2_12(1)) {
                        whereClause = this.whereClause(whereToken);
                        break;
                    }
                    switch (this.jj_nt.kind) {
                        case 108: {
                            fromTable = this.currentOfClause(correlationName);
                            break block9;
                        }
                    }
                    this.jj_la1[26] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                }
            }
            if (fromTable == null) {
                fromTable = new FromBaseTable(tableName, correlationName, 1, null, this.getContextManager());
            }
            if (targetProperties != null) {
                if (((FromBaseTable)fromTable).getProperties() != null) {
                    SanityManager.THROWASSERT("Overwriting existing properties");
                }
                ((FromBaseTable)fromTable).setTableProperties(targetProperties);
            }
            return this.getUpdateNode(fromTable, tableName, columnList, whereClause);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode callStatement() throws ParseException, StandardException {
        StatementNode retval;
        switch (this.jj_nt.kind) {
            case 361: 
            case 472: {
                retval = this.bareCallStatement();
                break;
            }
            case 451: {
                this.jj_consume_token(451);
                retval = this.bareCallStatement();
                this.jj_consume_token(452);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return retval;
    }

    public final StatementNode bareCallStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 361: {
                this.jj_consume_token(361);
                ValueNode value = this.primaryExpression();
                if (!(value instanceof JavaToSQLValueNode) || !(((JavaToSQLValueNode)value).getJavaValueNode() instanceof MethodCallNode)) {
                    throw StandardException.newException("42X74", new Object[0]);
                }
                CallStatementNode callStatement = new CallStatementNode((JavaToSQLValueNode)value, this.getContextManager());
                this.setUpAndLinkParameters();
                return callStatement;
            }
            case 472: {
                ParameterNode returnParam = this.dynamicParameterSpecification();
                this.getCompilerContext().setReturnParameterFlag();
                this.jj_consume_token(467);
                this.jj_consume_token(361);
                ResultSetNode resultSetNode = this.rowValueConstructor(null);
                ResultColumnList rcl = resultSetNode.getResultColumns();
                if (rcl == null || rcl.size() > 1) {
                    throw StandardException.newException("42X74", new Object[0]);
                }
                ValueNode value = ((ResultColumn)rcl.elementAt(0)).getExpression();
                if (!(value instanceof JavaToSQLValueNode) || !(((JavaToSQLValueNode)value).getJavaValueNode() instanceof MethodCallNode)) {
                    throw StandardException.newException("42X74", new Object[0]);
                }
                CursorNode cursorNode = new CursorNode("SELECT", resultSetNode, null, null, null, null, false, 1, null, false, this.getContextManager());
                returnParam.setReturnOutputParam(value);
                this.setUpAndLinkParameters();
                return cursorNode;
            }
        }
        this.jj_la1[29] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode mergeStatement() throws ParseException, StandardException {
        this.jj_consume_token(309);
        this.jj_consume_token(170);
        FromTable targetTable = this.tableFactor();
        this.jj_consume_token(257);
        FromTable sourceTable = this.tableFactor();
        ValueNode searchCondition = this.joinCondition();
        ArrayList<MatchingClauseNode> matchingClauses = this.matchingClauseList();
        this.checkVersion(230, "MERGE");
        this.setUpAndLinkParameters();
        return new MergeNode(targetTable, sourceTable, searchCondition, matchingClauses, this.getContextManager());
    }

    public final ArrayList<MatchingClauseNode> matchingClauseList() throws ParseException, StandardException {
        ArrayList<MatchingClauseNode> matchingClauses = new ArrayList<MatchingClauseNode>();
        this.matchingClause(matchingClauses);
        while (this.jj_2_14(1)) {
            this.matchingClause(matchingClauses);
        }
        return matchingClauses;
    }

    public final void matchingClause(ArrayList<MatchingClauseNode> matchingClauses) throws ParseException, StandardException {
        ValueNode matchingRefinement = null;
        ResultColumnList updateColumns = null;
        ResultColumnList insertColumns = null;
        ResultColumnList insertValues = new ResultColumnList(this.getContextManager());
        if (this.getToken((int)1).kind == 358 && this.getToken((int)2).kind != 190) {
            this.jj_consume_token(358);
            this.jj_consume_token(307);
            switch (this.jj_nt.kind) {
                case 69: {
                    this.jj_consume_token(69);
                    matchingRefinement = this.valueExpression();
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                }
            }
            this.jj_consume_token(349);
            switch (this.jj_nt.kind) {
                case 122: {
                    this.jj_consume_token(122);
                    break;
                }
                case 254: {
                    this.jj_consume_token(254);
                    this.jj_consume_token(227);
                    updateColumns = this.setClauseList();
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            MatchingClauseNode matchingClause = updateColumns != null ? MatchingClauseNode.makeUpdateClause(matchingRefinement, updateColumns, this.getContextManager()) : MatchingClauseNode.makeDeleteClause(matchingRefinement, this.getContextManager());
            matchingClauses.add(matchingClause);
        } else if (this.getToken((int)1).kind == 358 && this.getToken((int)2).kind == 190) {
            this.jj_consume_token(358);
            this.jj_consume_token(190);
            this.jj_consume_token(307);
            switch (this.jj_nt.kind) {
                case 69: {
                    this.jj_consume_token(69);
                    matchingRefinement = this.valueExpression();
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                }
            }
            this.jj_consume_token(349);
            this.jj_consume_token(166);
            switch (this.jj_nt.kind) {
                case 453: {
                    this.jj_consume_token(453);
                    insertColumns = this.insertColumnList();
                    this.jj_consume_token(454);
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                }
            }
            this.jj_consume_token(259);
            this.jj_consume_token(453);
            this.rowValueConstructorList(insertValues);
            this.jj_consume_token(454);
            MatchingClauseNode matchingClause = MatchingClauseNode.makeInsertClause(matchingRefinement, insertColumns, insertValues, this.getContextManager());
            matchingClauses.add(matchingClause);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final ValueNode primaryExpression() throws ParseException, StandardException {
        ValueNode value = null;
        if (this.getToken((int)2).kind == 460 && this.getToken((int)4).kind == 453) {
            value = this.routineInvocation();
            return value;
        }
        if (this.jj_2_15(1)) {
            value = this.primaryExpressionXX();
            return value;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode savepointStatement() throws ParseException, StandardException {
        int savepointStatementType;
        String savepointName = null;
        Object[] savepointStatementClauses = new Object[3];
        switch (this.jj_nt.kind) {
            case 333: {
                this.jj_consume_token(333);
                savepointName = this.identifier(128, true);
                block14: while (true) {
                    this.savepointStatementClause(savepointStatementClauses);
                    switch (this.jj_nt.kind) {
                        case 195: 
                        case 252: {
                            continue block14;
                        }
                    }
                    break;
                }
                this.jj_la1[34] = this.jj_gen;
                if (savepointStatementClauses[2] == null) {
                    throw StandardException.newException("42X01", "MISSING ON ROLLBACK RETAIN CURSORS");
                }
                savepointStatementType = 1;
                break;
            }
            case 220: {
                this.jj_consume_token(220);
                switch (this.jj_nt.kind) {
                    case 268: {
                        this.jj_consume_token(268);
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                    }
                }
                this.jj_consume_token(243);
                this.jj_consume_token(333);
                if (this.jj_2_16(1)) {
                    savepointName = this.identifier(128, true);
                }
                savepointStatementType = 2;
                break;
            }
            case 327: {
                this.jj_consume_token(327);
                switch (this.jj_nt.kind) {
                    case 243: {
                        this.jj_consume_token(243);
                        break;
                    }
                    default: {
                        this.jj_la1[36] = this.jj_gen;
                    }
                }
                this.jj_consume_token(333);
                savepointName = this.identifier(128, true);
                savepointStatementType = 3;
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SavepointNode(savepointName, savepointStatementType, this.getContextManager());
    }

    public final void savepointStatementClause(Object[] savepointStatementClauses) throws ParseException, StandardException {
        int clausePosition = -1;
        switch (this.jj_nt.kind) {
            case 252: {
                this.jj_consume_token(252);
                clausePosition = 0;
                break;
            }
            case 195: {
                this.jj_consume_token(195);
                this.jj_consume_token(220);
                this.jj_consume_token(427);
                clausePosition = this.LocksOrCursors();
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (clausePosition != -1) {
            if (savepointStatementClauses[clausePosition] != null) {
                String which = SAVEPOINT_CLAUSE_NAMES[clausePosition];
                throw StandardException.newException("42613", which);
            }
            savepointStatementClauses[clausePosition] = Boolean.TRUE;
        }
    }

    public final int LocksOrCursors() throws ParseException {
        switch (this.jj_nt.kind) {
            case 304: {
                this.jj_consume_token(304);
                return 1;
            }
            case 389: {
                this.jj_consume_token(389);
                return 2;
            }
        }
        this.jj_la1[39] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode globalTemporaryTableDeclaration() throws ParseException, StandardException {
        Object[] declareTableClauses = new Object[3];
        this.jj_consume_token(118);
        this.jj_consume_token(151);
        this.jj_consume_token(240);
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        TableElementList tableElementList = this.tableElementList();
        do {
            this.declareTableClause(declareTableClauses);
        } while (this.jj_2_17(1));
        if (declareTableClauses[0] == null) {
            throw StandardException.newException("42X01", "MISSING NOT LOGGED");
        }
        if (declareTableClauses[1] == null) {
            declareTableClauses[1] = Boolean.TRUE;
        }
        if (declareTableClauses[2] == null) {
            declareTableClauses[2] = Boolean.TRUE;
        }
        return new CreateTableNode(tableName, tableElementList, null, (Boolean)declareTableClauses[1], (Boolean)declareTableClauses[2], this.getContextManager());
    }

    public final void declareTableClause(Object[] declareTableClauses) throws ParseException, StandardException {
        int clausePosition = -1;
        Boolean clauseValue = null;
        switch (this.jj_nt.kind) {
            case 190: {
                this.jj_consume_token(190);
                this.jj_consume_token(306);
                clauseValue = Boolean.TRUE;
                clausePosition = 0;
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                if (this.getToken((int)1).kind == 195 && this.getToken((int)2).kind == 97) {
                    this.jj_consume_token(195);
                    this.jj_consume_token(97);
                    clauseValue = this.onCommit();
                    this.jj_consume_token(221);
                    clausePosition = 1;
                    break;
                }
                if (this.getToken((int)1).kind == 195 && this.getToken((int)2).kind == 220) {
                    this.jj_consume_token(195);
                    this.jj_consume_token(220);
                    this.jj_consume_token(122);
                    this.jj_consume_token(221);
                    clauseValue = Boolean.TRUE;
                    clausePosition = 2;
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (clausePosition != -1) {
            if (declareTableClauses[clausePosition] != null) {
                String which = TEMPORARY_TABLE_CLAUSE_NAMES[clausePosition];
                throw StandardException.newException("42613", which);
            }
            declareTableClauses[clausePosition] = clauseValue;
        }
    }

    public final Boolean onCommit() throws ParseException {
        switch (this.jj_nt.kind) {
            case 207: {
                this.jj_consume_token(207);
                return Boolean.FALSE;
            }
            case 122: {
                this.jj_consume_token(122);
                return Boolean.TRUE;
            }
        }
        this.jj_la1[41] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementList tableElementList() throws ParseException, StandardException {
        TableElementList tableElementList = new TableElementList(this.getContextManager());
        this.jj_consume_token(453);
        this.tableElement(tableElementList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.tableElement(tableElementList);
        }
        this.jj_consume_token(454);
        return tableElementList;
    }

    public final void tableElement(TableElementList tableElementList) throws ParseException, StandardException {
        if (this.jj_2_18(1)) {
            TableElementNode tableElement = this.columnDefinition(tableElementList);
            tableElementList.addTableElement(tableElement);
        } else {
            switch (this.jj_nt.kind) {
                case 91: 
                case 100: 
                case 145: 
                case 208: 
                case 252: {
                    TableElementNode tableElement = this.tableConstraintDefinition();
                    tableElementList.addTableElement(tableElement);
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final TableElementNode columnDefinition(TableElementList tableElementList) throws ParseException, StandardException {
        DataTypeDescriptor[] typeDescriptor = new DataTypeDescriptor[1];
        ValueNode defaultNode = null;
        long[] autoIncrementInfo = new long[4];
        String columnName = this.identifier(128, true);
        if (this.jj_2_19(1)) {
            typeDescriptor[0] = this.dataTypeDDL();
        }
        switch (this.jj_nt.kind) {
            case 91: 
            case 100: 
            case 119: 
            case 190: 
            case 208: 
            case 215: 
            case 252: 
            case 267: 
            case 292: {
                defaultNode = this.defaultAndConstraints(typeDescriptor, tableElementList, columnName, autoIncrementInfo);
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        if (autoIncrementInfo[2] == 0L) {
            autoIncrementInfo = null;
        }
        return new ColumnDefinitionNode(columnName, defaultNode, typeDescriptor[0], autoIncrementInfo, this.getContextManager());
    }

    public final ValueNode defaultAndConstraints(DataTypeDescriptor[] typeDescriptor, TableElementList tableElementList, String columnName, long[] autoIncrementInfo) throws ParseException, StandardException {
        ValueNode defaultNode = null;
        switch (this.jj_nt.kind) {
            case 91: 
            case 100: 
            case 190: 
            case 208: 
            case 215: 
            case 252: {
                this.columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
                block16: while (true) {
                    switch (this.jj_nt.kind) {
                        case 91: 
                        case 100: 
                        case 190: 
                        case 208: 
                        case 215: 
                        case 252: {
                            break;
                        }
                        default: {
                            this.jj_la1[45] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
                }
                block7 : switch (this.jj_nt.kind) {
                    case 119: 
                    case 267: 
                    case 292: {
                        defaultNode = this.defaultClause(autoIncrementInfo, columnName);
                        while (true) {
                            switch (this.jj_nt.kind) {
                                case 91: 
                                case 100: 
                                case 190: 
                                case 208: 
                                case 215: 
                                case 252: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[46] = this.jj_gen;
                                    break block7;
                                }
                            }
                            this.columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
                        }
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                    }
                }
                return defaultNode;
            }
            case 119: 
            case 267: 
            case 292: {
                defaultNode = this.defaultClause(autoIncrementInfo, columnName);
                block18: while (true) {
                    switch (this.jj_nt.kind) {
                        case 91: 
                        case 100: 
                        case 190: 
                        case 208: 
                        case 215: 
                        case 252: {
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            break block18;
                        }
                    }
                    this.columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
                }
                return defaultNode;
            }
        }
        this.jj_la1[49] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor dataTypeDDL() throws ParseException, StandardException {
        if (this.commonDatatypeName(false)) {
            DataTypeDescriptor typeDescriptor = this.dataTypeCommon();
            return typeDescriptor;
        }
        if (this.getToken((int)1).kind != 292) {
            DataTypeDescriptor typeDescriptor = this.javaType(new TableName[1]);
            return typeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TypeDescriptor catalogType() throws ParseException, StandardException {
        DataTypeDescriptor typeDescriptor = this.dataTypeDDL();
        return typeDescriptor.getCatalogType();
    }

    public final DataTypeDescriptor dataTypeCast(TableName[] udtName) throws ParseException, StandardException {
        if (this.commonDatatypeName(true)) {
            DataTypeDescriptor typeDescriptor = this.dataTypeCommon();
            return typeDescriptor;
        }
        if (this.jj_2_20(1)) {
            DataTypeDescriptor typeDescriptor = this.javaType(udtName);
            return typeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor dataTypeCommon() throws ParseException, StandardException {
        DataTypeDescriptor typeDescriptor;
        boolean checkCS = false;
        if (this.jj_2_21(1)) {
            if (this.getToken((int)2).kind == 300) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            typeDescriptor = this.characterStringType();
        } else if (this.jj_2_22(1)) {
            if (this.getToken((int)3).kind == 300) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            typeDescriptor = this.nationalCharacterStringType();
        } else if (this.jj_2_23(1)) {
            typeDescriptor = this.numericType();
        } else {
            switch (this.jj_nt.kind) {
                case 285: 
                case 350: 
                case 351: {
                    typeDescriptor = this.datetimeType();
                    break;
                }
                case 360: {
                    this.jj_consume_token(360);
                    if ((this.getCompilerContext().getReliability() & 0x400) != 0) {
                        this.checkVersion(190, "BOOLEAN");
                    }
                    typeDescriptor = new DataTypeDescriptor(TypeId.BOOLEAN_ID, true);
                    break;
                }
                case 369: {
                    typeDescriptor = this.longType();
                    break;
                }
                case 80: 
                case 88: 
                case 89: 
                case 185: 
                case 275: 
                case 278: 
                case 318: {
                    typeDescriptor = this.LOBType();
                    break;
                }
                case 377: {
                    typeDescriptor = this.XMLType();
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return typeDescriptor;
    }

    public final DataTypeDescriptor characterStringType() throws ParseException, StandardException {
        int type;
        int length = 1;
        Token varyingToken = null;
        switch (this.jj_nt.kind) {
            case 261: {
                this.jj_consume_token(261);
                length = this.charLength();
                type = 12;
                break;
            }
            case 88: 
            case 89: {
                this.charOrCharacter();
                block4 : switch (this.jj_nt.kind) {
                    case 262: {
                        varyingToken = this.jj_consume_token(262);
                        length = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 453: {
                                length = this.charLength();
                                break block4;
                            }
                        }
                        this.jj_la1[51] = this.jj_gen;
                    }
                }
                type = varyingToken == null ? 1 : 12;
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_nt.kind) {
            case 144: {
                type = this.forBitData(type);
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        this.checkTypeLimits(type, length);
        DataTypeDescriptor charDTD = DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);
        return charDTD;
    }

    public final void charOrCharacter() throws ParseException {
        switch (this.jj_nt.kind) {
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int charLength() throws ParseException, StandardException {
        this.jj_consume_token(453);
        int length = this.length();
        this.jj_consume_token(454);
        return length;
    }

    public final int forBitData(int charType) throws ParseException {
        this.jj_consume_token(144);
        this.jj_consume_token(81);
        this.jj_consume_token(284);
        if (charType == 1) {
            charType = -2;
        } else if (charType == 12) {
            charType = -3;
        } else if (charType == -1) {
            charType = -4;
        }
        return charType;
    }

    public final DataTypeDescriptor nationalCharacterStringType() throws ParseException, StandardException {
        int length = 1;
        String type = null;
        Token varyingToken = null;
        switch (this.jj_nt.kind) {
            case 185: {
                this.jj_consume_token(185);
                this.charOrCharacter();
                block5 : switch (this.jj_nt.kind) {
                    case 262: {
                        varyingToken = this.jj_consume_token(262);
                        length = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 453: {
                                length = this.charLength();
                                break block5;
                            }
                        }
                        this.jj_la1[56] = this.jj_gen;
                    }
                }
                type = varyingToken == null ? "NATIONAL CHAR" : "NATIONAL CHAR VARYING";
                break;
            }
            case 187: {
                this.jj_consume_token(187);
                block11 : switch (this.jj_nt.kind) {
                    case 262: {
                        varyingToken = this.jj_consume_token(262);
                        length = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[59] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 453: {
                                length = this.charLength();
                                break block11;
                            }
                        }
                        this.jj_la1[58] = this.jj_gen;
                    }
                }
                type = varyingToken == null ? "NATIONAL CHAR" : "NATIONAL CHAR VARYING";
                break;
            }
            case 411: {
                this.jj_consume_token(411);
                length = this.charLength();
                type = "NATIONAL CHAR VARYING";
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw StandardException.newException("0A000.S", type);
    }

    public final DataTypeDescriptor LOBType() throws ParseException, StandardException {
        String type;
        int length = Integer.MAX_VALUE;
        switch (this.jj_nt.kind) {
            case 275: {
                this.jj_consume_token(275);
                switch (this.jj_nt.kind) {
                    case 453: {
                        length = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[61] = this.jj_gen;
                    }
                }
                type = "BLOB";
                break;
            }
            case 278: {
                this.jj_consume_token(278);
                switch (this.jj_nt.kind) {
                    case 453: {
                        length = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[62] = this.jj_gen;
                    }
                }
                type = "CLOB";
                break;
            }
            case 318: {
                this.jj_consume_token(318);
                length = this.lengthAndModifier();
                String type2 = "NCLOB";
                throw StandardException.newException("0A000.S", type2);
            }
            case 80: {
                this.jj_consume_token(80);
                this.jj_consume_token(300);
                this.jj_consume_token(322);
                switch (this.jj_nt.kind) {
                    case 453: {
                        length = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[63] = this.jj_gen;
                    }
                }
                type = "BLOB";
                break;
            }
            case 88: 
            case 89: {
                this.charOrCharacter();
                this.jj_consume_token(300);
                this.jj_consume_token(322);
                switch (this.jj_nt.kind) {
                    case 453: {
                        length = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                    }
                }
                type = "CLOB";
                break;
            }
            case 185: {
                this.jj_consume_token(185);
                this.jj_consume_token(89);
                this.jj_consume_token(300);
                this.jj_consume_token(322);
                length = this.lengthAndModifier();
                String type3 = "NCLOB";
                throw StandardException.newException("0A000.S", type3);
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);
        return dtd;
    }

    public final DataTypeDescriptor numericType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 116: 
            case 117: 
            case 167: 
            case 168: 
            case 193: 
            case 228: 
            case 368: {
                DataTypeDescriptor typeDescriptor = this.exactNumericType();
                return typeDescriptor;
            }
        }
        this.jj_la1[66] = this.jj_gen;
        if (this.jj_2_24(1)) {
            DataTypeDescriptor typeDescriptor = this.approximateNumericType();
            return typeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor exactNumericType() throws ParseException, StandardException {
        int precision = 5;
        int scale = 0;
        int type = 3;
        String typeStr = "DECIMAL";
        DataTypeDescriptor dtd = null;
        switch (this.jj_nt.kind) {
            case 116: 
            case 117: 
            case 193: {
                switch (this.jj_nt.kind) {
                    case 193: {
                        this.jj_consume_token(193);
                        type = 2;
                        typeStr = "NUMERIC";
                        break;
                    }
                    case 117: {
                        this.jj_consume_token(117);
                        break;
                    }
                    case 116: {
                        this.jj_consume_token(116);
                        break;
                    }
                    default: {
                        this.jj_la1[67] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_nt.kind) {
                    case 453: {
                        this.jj_consume_token(453);
                        precision = this.precision();
                        switch (this.jj_nt.kind) {
                            case 458: {
                                this.jj_consume_token(458);
                                scale = this.scale();
                                break;
                            }
                            default: {
                                this.jj_la1[68] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(454);
                        break;
                    }
                    default: {
                        this.jj_la1[69] = this.jj_gen;
                    }
                }
                if (precision <= 0 || precision > 31) {
                    throw StandardException.newException("42X48", typeStr, String.valueOf(precision));
                }
                if (scale < 0 || scale > 31) {
                    throw StandardException.newException("42Y42", typeStr, String.valueOf(scale));
                }
                if (scale > precision) {
                    throw StandardException.newException("42Y43", String.valueOf(scale), String.valueOf(precision));
                }
                int maxWidth = DataTypeUtilities.computeMaxWidth(precision, scale);
                return this.getDataTypeServices(type, precision, scale, maxWidth);
            }
            case 167: 
            case 168: 
            case 228: 
            case 368: {
                dtd = this.exactIntegerType();
                return dtd;
            }
        }
        this.jj_la1[70] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor exactIntegerType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 167: 
            case 168: {
                switch (this.jj_nt.kind) {
                    case 168: {
                        this.jj_consume_token(168);
                        break;
                    }
                    case 167: {
                        this.jj_consume_token(167);
                        break;
                    }
                    default: {
                        this.jj_la1[71] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(4);
            }
            case 228: {
                this.jj_consume_token(228);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(5);
            }
            case 368: {
                this.jj_consume_token(368);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5);
            }
        }
        this.jj_la1[72] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor approximateNumericType() throws ParseException, StandardException {
        int type = 0;
        int scale = 0;
        int width = 0;
        int prec = -1;
        DataTypeDescriptor dts = null;
        switch (this.jj_nt.kind) {
            case 143: {
                this.jj_consume_token(143);
                switch (this.jj_nt.kind) {
                    case 453: {
                        this.jj_consume_token(453);
                        prec = this.precision();
                        this.jj_consume_token(454);
                        break;
                    }
                    default: {
                        this.jj_la1[73] = this.jj_gen;
                    }
                }
                if (prec == -1) {
                    prec = 52;
                }
                if (prec > 0 && prec <= 23) {
                    type = 7;
                    prec = 23;
                    scale = 0;
                    width = 4;
                } else if (prec > 23 && prec <= 52) {
                    type = 8;
                    prec = 52;
                    scale = 0;
                    width = 8;
                } else {
                    throw StandardException.newException("42X48", "FLOAT", String.valueOf(prec));
                }
                return this.getDataTypeServices(type, prec, scale, width);
            }
            case 214: {
                this.jj_consume_token(214);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(7);
            }
        }
        this.jj_la1[74] = this.jj_gen;
        if (this.jj_2_25(1)) {
            dts = this.doubleType();
            return dts;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor doubleType() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 326) {
            this.jj_consume_token(128);
            this.jj_consume_token(326);
        } else {
            switch (this.jj_nt.kind) {
                case 128: {
                    this.jj_consume_token(128);
                    break;
                }
                default: {
                    this.jj_la1[75] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(8);
    }

    public final DataTypeDescriptor longType() throws ParseException, StandardException {
        this.jj_consume_token(369);
        DataTypeDescriptor dataTypeDescriptor = this.longSubType();
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor longSubType() throws ParseException, StandardException {
        int lvcType = -1;
        switch (this.jj_nt.kind) {
            case 261: {
                this.jj_consume_token(261);
                switch (this.jj_nt.kind) {
                    case 144: {
                        lvcType = this.forBitData(lvcType);
                        break;
                    }
                    default: {
                        this.jj_la1[76] = this.jj_gen;
                    }
                }
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(lvcType);
            }
            case 411: {
                this.jj_consume_token(411);
                throw StandardException.newException("0A000.S", "LONG NVARCHAR");
            }
        }
        this.jj_la1[77] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor XMLType() throws ParseException, StandardException {
        this.jj_consume_token(377);
        this.checkVersion(130, "XML");
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(2009);
    }

    public final void xmlDocOrContent() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 395 && this.getToken((int)1).kind != 387) {
            throw StandardException.newException("42Z72", "DOCUMENT", ReuseFactory.getInteger(this.getToken((int)1).beginLine), ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        if (this.getToken((int)1).kind == 387) {
            this.jj_consume_token(387);
            throw StandardException.newException("42Z74", "CONTENT");
        }
        if (this.getToken((int)1).kind == 395) {
            this.jj_consume_token(395);
            return;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor javaType(TableName[] udtName) throws ParseException, StandardException {
        TableName typeName;
        udtName[0] = typeName = this.qualifiedName(128);
        return this.getJavaClassDataTypeDescriptor(typeName);
    }

    public final String javaDSL() throws ParseException {
        String dotSeparatedList = this.caseSensitiveIdentifierPlusReservedWords();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 460: {
                    break;
                }
                default: {
                    this.jj_la1[78] = this.jj_gen;
                    break block3;
                }
            }
            dotSeparatedList = this.javaDSLNameExtender(dotSeparatedList);
        }
        return dotSeparatedList;
    }

    public final String javaClassName() throws ParseException {
        String javaClassName = this.javaDSL();
        return javaClassName;
    }

    public final String javaDSLNameExtender(String dotSeparatedList) throws ParseException {
        this.jj_consume_token(460);
        String extender = this.caseSensitiveIdentifierPlusReservedWords();
        return dotSeparatedList + "." + extender;
    }

    public final int lengthAndModifier() throws ParseException, StandardException {
        Token tok;
        Token tokmod = null;
        this.jj_consume_token(453);
        block1 : switch (this.jj_nt.kind) {
            case 489: {
                tok = this.jj_consume_token(489);
                break;
            }
            case 487: {
                tok = this.jj_consume_token(487);
                switch (this.jj_nt.kind) {
                    case 480: {
                        tokmod = this.jj_consume_token(480);
                        break block1;
                    }
                }
                this.jj_la1[79] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(454);
        String s = tok.image + (tokmod == null ? "" : tokmod.image);
        try {
            long mul;
            char modifier = s.charAt(s.length() - 1);
            String number = s.substring(0, s.length() - 1);
            switch (modifier) {
                case 'G': 
                case 'g': {
                    mul = 0x40000000L;
                    break;
                }
                case 'M': 
                case 'm': {
                    mul = 0x100000L;
                    break;
                }
                case 'K': 
                case 'k': {
                    mul = 1024L;
                    break;
                }
                default: {
                    mul = 1L;
                    number = s;
                }
            }
            long specifiedLength = Long.parseLong(number) * mul;
            if (specifiedLength > 0L && specifiedLength <= Integer.MAX_VALUE) {
                return (int)specifiedLength;
            }
            if (mul != 1L && specifiedLength == 0x80000000L) {
                return Integer.MAX_VALUE;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        throw StandardException.newException("42X44", s);
    }

    public final int length() throws ParseException, StandardException {
        Token tok = this.jj_consume_token(487);
        try {
            int retval = Integer.parseInt(tok.image);
            if (retval > 0) {
                return retval;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw StandardException.newException("42X44", tok.image);
    }

    public final long exactNumber() throws ParseException, StandardException {
        String sign = "";
        switch (this.jj_nt.kind) {
            case 457: 
            case 459: {
                sign = this.sign();
                break;
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
            }
        }
        Token longToken = this.jj_consume_token(487);
        try {
            if (sign.equals("-")) {
                return Long.parseLong("-" + longToken.image);
            }
            return Long.parseLong(longToken.image);
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("42X49", longToken.image);
        }
    }

    public final int precision() throws ParseException, StandardException {
        int uintValue = this.uint_value();
        return uintValue;
    }

    public final int uint_value() throws ParseException, StandardException {
        Token uintToken = this.jj_consume_token(487);
        try {
            return Integer.parseInt(uintToken.image);
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("42X49", uintToken.image);
        }
    }

    public final int scale() throws ParseException, StandardException {
        int uintValue = this.uint_value();
        return uintValue;
    }

    public final DataTypeDescriptor datetimeType() throws ParseException, StandardException {
        Object tzTok = null;
        int prec = -1;
        switch (this.jj_nt.kind) {
            case 285: {
                this.jj_consume_token(285);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(91);
            }
            case 350: {
                this.jj_consume_token(350);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(92);
            }
            case 351: {
                this.jj_consume_token(351);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(93);
            }
        }
        this.jj_la1[82] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableName qualifiedName(int id_length_limit) throws ParseException, StandardException {
        String qualifiedId;
        String schemaName = null;
        String firstName = null;
        String secondName = null;
        Token firstNameToken = null;
        firstName = this.identifier(128, false);
        if (this.getToken((int)1).kind == 460 && this.getToken((int)2).kind != 455) {
            this.jj_consume_token(460);
            secondName = this.identifier(128, false);
        }
        if (secondName == null) {
            qualifiedId = firstName;
            firstNameToken = this.lastIdentifierToken;
        } else {
            schemaName = firstName;
            qualifiedId = secondName;
            firstNameToken = this.nextToLastIdentifierToken;
        }
        IdUtil.checkIdentifierLengthLimit(qualifiedId, id_length_limit);
        if (schemaName != null) {
            IdUtil.checkIdentifierLengthLimit(schemaName, 128);
        }
        return new TableName(schemaName, qualifiedId, firstNameToken.beginOffset, this.lastIdentifierToken.endOffset, this.getContextManager());
    }

    public final ResultSetNode queryExpression(ResultSetNode leftSide, int operatorType) throws ParseException, StandardException {
        ResultSetNode term = this.nonJoinQueryTerm(leftSide, operatorType);
        switch (this.jj_nt.kind) {
            case 134: 
            case 251: {
                term = this.unionOrExcept(term);
                break;
            }
            default: {
                this.jj_la1[83] = this.jj_gen;
            }
        }
        return term;
    }

    public final ResultSetNode unionOrExcept(ResultSetNode term) throws ParseException, StandardException {
        Token tok = null;
        switch (this.jj_nt.kind) {
            case 251: {
                this.jj_consume_token(251);
                block4 : switch (this.jj_nt.kind) {
                    case 66: 
                    case 127: {
                        switch (this.jj_nt.kind) {
                            case 66: {
                                tok = this.jj_consume_token(66);
                                break block4;
                            }
                            case 127: {
                                this.jj_consume_token(127);
                                break block4;
                            }
                        }
                        this.jj_la1[84] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[85] = this.jj_gen;
                    }
                }
                ResultSetNode expression = this.queryExpression(term, tok != null ? 2 : 1);
                if (tok != null && tok.kind == 127) {
                    this.forbidNextValueFor();
                }
                return expression;
            }
            case 134: {
                this.jj_consume_token(134);
                block11 : switch (this.jj_nt.kind) {
                    case 66: 
                    case 127: {
                        switch (this.jj_nt.kind) {
                            case 66: {
                                tok = this.jj_consume_token(66);
                                break block11;
                            }
                            case 127: {
                                this.jj_consume_token(127);
                                break block11;
                            }
                        }
                        this.jj_la1[86] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[87] = this.jj_gen;
                    }
                }
                ResultSetNode expression = this.queryExpression(term, tok != null ? 4 : 3);
                if (tok != null && tok.kind == 127) {
                    this.forbidNextValueFor();
                }
                return expression;
            }
        }
        this.jj_la1[88] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode nonJoinQueryTerm(ResultSetNode leftSide, int operatorType) throws ParseException, StandardException {
        ResultSetNode term = this.nonJoinQueryPrimary();
        switch (this.jj_nt.kind) {
            case 169: {
                term = this.intersect(term);
                break;
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
            }
        }
        switch (operatorType) {
            case 0: {
                return term;
            }
            case 1: {
                return new UnionNode(leftSide, term, false, false, null, this.getContextManager());
            }
            case 2: {
                return new UnionNode(leftSide, term, true, false, null, this.getContextManager());
            }
            case 3: {
                return new IntersectOrExceptNode(2, leftSide, term, false, null, this.getContextManager());
            }
            case 4: {
                return new IntersectOrExceptNode(2, leftSide, term, true, null, this.getContextManager());
            }
            case 5: {
                return new IntersectOrExceptNode(1, leftSide, term, false, null, this.getContextManager());
            }
            case 6: {
                return new IntersectOrExceptNode(1, leftSide, term, true, null, this.getContextManager());
            }
        }
        SanityManager.THROWASSERT("Invalid set operator type: " + operatorType);
        return null;
    }

    public final ResultSetNode intersect(ResultSetNode term) throws ParseException, StandardException {
        Token tok = null;
        this.jj_consume_token(169);
        block0 : switch (this.jj_nt.kind) {
            case 66: 
            case 127: {
                switch (this.jj_nt.kind) {
                    case 66: {
                        tok = this.jj_consume_token(66);
                        break block0;
                    }
                    case 127: {
                        this.jj_consume_token(127);
                        break block0;
                    }
                }
                this.jj_la1[90] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[91] = this.jj_gen;
            }
        }
        ResultSetNode expression = this.nonJoinQueryTerm(term, tok != null ? 6 : 5);
        if (tok != null && tok.kind == 127) {
            this.forbidNextValueFor();
        }
        return expression;
    }

    public final ResultSetNode nonJoinQueryPrimary() throws ParseException, StandardException {
        boolean hasJDBClimitClause = false;
        OrderByList orderCols = null;
        ValueNode[] offsetClauses = new ValueNode[2];
        switch (this.jj_nt.kind) {
            case 225: 
            case 259: {
                ResultSetNode primary = this.simpleTable();
                return primary;
            }
            case 453: {
                this.jj_consume_token(453);
                ResultSetNode primary = this.queryExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 200: {
                        orderCols = this.orderByClause(primary);
                        break;
                    }
                    default: {
                        this.jj_la1[92] = this.jj_gen;
                    }
                }
                hasJDBClimitClause = this.offsetFetchFirstClause(offsetClauses);
                this.jj_consume_token(454);
                if (SQLParser.hasQueryExpressionSuffix(orderCols, offsetClauses)) {
                    if (primary instanceof SelectNode || primary instanceof UnionNode || primary instanceof RowResultSetNode) {
                        primary.pushQueryExpressionSuffix();
                        primary.pushOrderByList(orderCols);
                        primary.pushOffsetFetchFirst(offsetClauses[0], offsetClauses[1], hasJDBClimitClause);
                    } else {
                        String tokenName = orderCols != null ? "ORDER BY" : (hasJDBClimitClause ? "LIMIT" : (offsetClauses[0] != null ? "OFFSET" : "FETCH"));
                        throw StandardException.newException("42X01", tokenName);
                    }
                }
                return primary;
            }
        }
        this.jj_la1[93] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode simpleTable() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 225: {
                ResultSetNode resultSetNode = this.querySpecification();
                return resultSetNode;
            }
            case 259: {
                ResultSetNode resultSetNode = this.tableValueConstructor();
                return resultSetNode;
            }
        }
        this.jj_la1[94] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode querySpecification() throws ParseException, StandardException {
        boolean isDistinct = false;
        this.jj_consume_token(225);
        if (this.jj_2_26(1)) {
            isDistinct = this.setQuantifier();
        }
        ResultColumnList selectList = this.selectList();
        SelectNode selectNode = this.tableExpression(selectList);
        if (isDistinct) {
            selectNode.makeDistinct();
        }
        return selectNode;
    }

    public final boolean setQuantifier() throws ParseException {
        if (this.getToken((int)1).kind == 127 && this.getToken((int)2).kind != 460 && this.getToken((int)2).kind != 463) {
            this.jj_consume_token(127);
            this.forbidNextValueFor();
            return true;
        }
        if (this.getToken((int)1).kind == 66 && this.getToken((int)2).kind != 460 && this.getToken((int)2).kind != 463) {
            this.jj_consume_token(66);
            return false;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList selectList() throws ParseException, StandardException {
        ResultColumnList resultColumns = new ResultColumnList(this.getContextManager());
        switch (this.jj_nt.kind) {
            case 455: {
                this.jj_consume_token(455);
                AllResultColumn allResultColumn = new AllResultColumn(null, this.getContextManager());
                resultColumns.addResultColumn(allResultColumn);
                return resultColumns;
            }
        }
        this.jj_la1[95] = this.jj_gen;
        if (this.jj_2_27(1)) {
            this.selectColumnList(resultColumns);
            return resultColumns;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void selectColumnList(ResultColumnList resultColumns) throws ParseException, StandardException {
        this.selectSublist(resultColumns);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[96] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.selectSublist(resultColumns);
        }
    }

    public final void selectSublist(ResultColumnList resultColumns) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 460 && (this.getToken((int)3).kind == 455 || this.getToken((int)4).kind == 460 && this.getToken((int)5).kind == 455)) {
            TableName tableName = this.qualifiedName(128);
            this.jj_consume_token(460);
            this.jj_consume_token(455);
            AllResultColumn allResultColumn = new AllResultColumn(tableName, this.getContextManager());
            resultColumns.addResultColumn(allResultColumn);
        } else if (this.jj_2_28(1)) {
            ResultColumn resultColumn = this.derivedColumn(resultColumns);
            resultColumns.addResultColumn(resultColumn);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final ResultColumn derivedColumn(ResultColumnList resultColumns) throws ParseException, StandardException {
        String columnName = null;
        ValueNode columnExpression = this.valueExpression();
        if (this.jj_2_29(1)) {
            columnName = this.asClause();
        }
        if (columnName == null && columnExpression instanceof ColumnReference) {
            columnName = ((ColumnReference)columnExpression).getColumnName();
        }
        return new ResultColumn(columnName, columnExpression, this.getContextManager());
    }

    public final String asClause() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
            }
        }
        String columnName = this.identifier(128, true);
        return columnName;
    }

    public final ValueNode valueExpression() throws ParseException, StandardException {
        ValueNode leftOperand = this.orExpression(null);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 199: {
                    break;
                }
                default: {
                    this.jj_la1[98] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(199);
            leftOperand = this.orExpression(leftOperand);
        }
        return leftOperand;
    }

    public final ValueNode orExpression(ValueNode farLeftOperand) throws ParseException, StandardException {
        ValueNode leftOperand = this.andExpression(null);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 69: {
                    break;
                }
                default: {
                    this.jj_la1[99] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(69);
            leftOperand = this.andExpression(leftOperand);
        }
        if (farLeftOperand == null) {
            return leftOperand;
        }
        return new OrNode(farLeftOperand, leftOperand, this.getContextManager());
    }

    public final ValueNode andExpression(ValueNode farLeftOperand) throws ParseException, StandardException {
        Token tok = null;
        if (this.getToken((int)1).kind == 190 && this.getToken((int)2).kind != 460 && this.getToken((int)2).kind != 463) {
            tok = this.jj_consume_token(190);
        }
        ValueNode test = this.isSearchCondition();
        if (tok != null) {
            test = new NotNode(test, this.getContextManager());
        }
        if (farLeftOperand != null) {
            test = new AndNode(farLeftOperand, test, this.getContextManager());
        }
        return test;
    }

    public final ValueNode isSearchCondition() throws ParseException, StandardException {
        ValueNode booleanPrimary = this.booleanPrimary();
        return booleanPrimary;
    }

    public final ValueNode booleanPrimary() throws ParseException, StandardException {
        ValueNode primary = this.predicate();
        return primary;
    }

    public final ValueNode predicate() throws ParseException, StandardException {
        ValueNode value;
        if (this.jj_2_30(1)) {
            value = this.additiveExpression(null, 0);
        } else {
            switch (this.jj_nt.kind) {
                case 138: {
                    value = this.existsExpression();
                    break;
                }
                default: {
                    this.jj_la1[100] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        while (this.remainingPredicateFollows()) {
            value = this.remainingPredicate(value);
        }
        return value;
    }

    public final ValueNode remainingPredicate(ValueNode value) throws ParseException, StandardException {
        Token tok = null;
        switch (this.jj_nt.kind) {
            case 465: 
            case 466: 
            case 467: 
            case 468: 
            case 469: 
            case 470: 
            case 471: {
                value = this.remainingNonNegatablePredicate(value);
                return value;
            }
            case 79: 
            case 160: 
            case 171: 
            case 178: 
            case 190: {
                switch (this.jj_nt.kind) {
                    case 190: {
                        tok = this.jj_consume_token(190);
                        break;
                    }
                    default: {
                        this.jj_la1[101] = this.jj_gen;
                    }
                }
                value = this.remainingNegatablePredicate(value);
                if (tok != null) {
                    value = new NotNode(value, this.getContextManager());
                }
                return value;
            }
        }
        this.jj_la1[102] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode remainingNonNegatablePredicate(ValueNode leftOperand) throws ParseException, StandardException {
        Object tok = null;
        Object tree = null;
        int operator = this.compOp();
        if ((this.getToken((int)1).kind == 66 || this.getToken((int)1).kind == 70 || this.getToken((int)1).kind == 229) && this.getToken((int)2).kind == 453) {
            operator = this.quantifier(operator);
            this.jj_consume_token(453);
            leftOperand = this.tableSubquery(operator, leftOperand);
            this.jj_consume_token(454);
        } else if (this.jj_2_31(1)) {
            leftOperand = this.additiveExpression(leftOperand, operator);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return leftOperand;
    }

    public final ValueNode remainingNegatablePredicate(ValueNode leftOperand) throws ParseException, StandardException {
        ValueNode tree = null;
        ValueNode escapeValue = null;
        Token notToken = null;
        switch (this.jj_nt.kind) {
            case 160: {
                this.jj_consume_token(160);
                tree = this.inPredicateValue(leftOperand);
                return tree;
            }
            case 171: {
                this.jj_consume_token(171);
                switch (this.jj_nt.kind) {
                    case 190: {
                        notToken = this.jj_consume_token(190);
                        break;
                    }
                    default: {
                        this.jj_la1[103] = this.jj_gen;
                    }
                }
                this.jj_consume_token(191);
                return new IsNullNode(leftOperand, notToken != null, this.getContextManager());
            }
            case 178: {
                this.jj_consume_token(178);
                ValueNode likePattern = this.additiveExpression(null, 0);
                if (this.jj_2_32(1)) {
                    switch (this.jj_nt.kind) {
                        case 133: {
                            this.jj_consume_token(133);
                            escapeValue = this.additiveExpression(null, 0);
                            break;
                        }
                        default: {
                            this.jj_la1[104] = this.jj_gen;
                            if (this.getToken((int)1).kind == 451 && this.getToken((int)2).kind != 303) {
                                this.jj_consume_token(451);
                                this.jj_consume_token(133);
                                escapeValue = this.additiveExpression(null, 0);
                                this.jj_consume_token(452);
                                break;
                            }
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                tree = new LikeEscapeOperatorNode(leftOperand, likePattern, escapeValue, this.getContextManager());
                return tree;
            }
            case 79: {
                this.jj_consume_token(79);
                ValueNode betweenLeft = this.additiveExpression(null, 0);
                this.jj_consume_token(69);
                ValueNode betweenRight = this.additiveExpression(null, 0);
                ValueNodeList betweenList = new ValueNodeList(this.getContextManager());
                betweenList.addElement(betweenLeft);
                betweenList.addElement(betweenRight);
                tree = new BetweenOperatorNode(leftOperand, betweenList, this.getContextManager());
                return tree;
            }
        }
        this.jj_la1[105] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int compOp() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 467: {
                this.jj_consume_token(467);
                return 6;
            }
            case 468: {
                this.jj_consume_token(468);
                return 7;
            }
            case 469: {
                this.jj_consume_token(469);
                return 7;
            }
            case 465: {
                this.jj_consume_token(465);
                return 10;
            }
            case 470: {
                this.jj_consume_token(470);
                return 8;
            }
            case 466: {
                this.jj_consume_token(466);
                return 11;
            }
            case 471: {
                this.jj_consume_token(471);
                return 9;
            }
        }
        this.jj_la1[106] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode additiveExpression(ValueNode farLeftOperand, int compOp) throws ParseException, StandardException {
        int kind;
        ValueNode leftOperand = this.multiplicativeExpression(null, 0);
        block11: while (true) {
            switch (this.jj_nt.kind) {
                case 457: 
                case 459: {
                    break;
                }
                default: {
                    this.jj_la1[107] = this.jj_gen;
                    break block11;
                }
            }
            int operator = this.additiveOperator();
            leftOperand = this.multiplicativeExpression(leftOperand, operator);
        }
        if (farLeftOperand == null) {
            return leftOperand;
        }
        switch (compOp) {
            case 6: {
                kind = 0;
                break;
            }
            case 7: {
                kind = 5;
                break;
            }
            case 10: {
                kind = 4;
                break;
            }
            case 8: {
                kind = 2;
                break;
            }
            case 11: {
                kind = 3;
                break;
            }
            case 9: {
                kind = 1;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unknown comparison operator " + compOp);
                kind = -1;
            }
        }
        return new BinaryRelationalOperatorNode(kind, farLeftOperand, leftOperand, false, this.getContextManager());
    }

    public final int additiveOperator() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 457: {
                Token tok = this.jj_consume_token(457);
                return 1;
            }
            case 459: {
                Token tok = this.jj_consume_token(459);
                return 2;
            }
        }
        this.jj_la1[108] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode multiplicativeExpression(ValueNode farLeftOperand, int additiveOperator) throws ParseException, StandardException {
        ValueNode leftOperand = this.unaryExpression(null, 0);
        block7: while (true) {
            switch (this.jj_nt.kind) {
                case 455: 
                case 461: 
                case 477: {
                    break;
                }
                default: {
                    this.jj_la1[109] = this.jj_gen;
                    break block7;
                }
            }
            int multOp = this.multiplicativeOperator();
            leftOperand = this.unaryExpression(leftOperand, multOp);
        }
        if (farLeftOperand == null) {
            return leftOperand;
        }
        switch (additiveOperator) {
            case 1: {
                return new BinaryArithmeticOperatorNode(2, farLeftOperand, leftOperand, this.getContextManager());
            }
            case 2: {
                return new BinaryArithmeticOperatorNode(1, farLeftOperand, leftOperand, this.getContextManager());
            }
        }
        SanityManager.THROWASSERT("Unexpected operator value of " + additiveOperator);
        return null;
    }

    public final int multiplicativeOperator() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 455: {
                this.jj_consume_token(455);
                return 3;
            }
            case 461: {
                this.jj_consume_token(461);
                return 4;
            }
            case 477: {
                this.jj_consume_token(477);
                return 5;
            }
        }
        this.jj_la1[110] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode unaryExpression(ValueNode farLeftOperand, int multiplicativeOperator) throws ParseException, StandardException {
        int tokKind2;
        String sign = null;
        int tokKind1 = this.getToken((int)1).kind;
        if ((tokKind1 == 457 || tokKind1 == 459) && (tokKind2 = this.getToken((int)2).kind) != 487 && tokKind2 != 492) {
            sign = this.sign();
        }
        ValueNode value = this.primaryExpression();
        if ("-".equals(sign)) {
            value = new UnaryArithmeticOperatorNode(value, 1, this.getContextManager());
        } else if ("+".equals(sign)) {
            value = new UnaryArithmeticOperatorNode(value, 0, this.getContextManager());
        } else if (sign != null) {
            SanityManager.THROWASSERT("Unknown unary operator '" + sign + "'");
        }
        return this.multOp(farLeftOperand, value, multiplicativeOperator);
    }

    public final String sign() throws ParseException {
        switch (this.jj_nt.kind) {
            case 457: {
                Token s = this.jj_consume_token(457);
                return s.image;
            }
            case 459: {
                Token s = this.jj_consume_token(459);
                return s.image;
            }
        }
        this.jj_la1[111] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode primaryExpressionXX() throws ParseException, StandardException {
        ValueNode value = this.primary();
        while (this.jj_2_33(1)) {
            value = this.nonStaticMethodCallOrFieldAccess(value);
        }
        return value;
    }

    public final ValueNode nonStaticMethodCallOrFieldAccess(ValueNode receiver) throws ParseException, StandardException {
        ValueNode value = this.nonStaticMethodInvocation(receiver);
        return value;
    }

    public final ValueNode nonStaticMethodInvocation(ValueNode receiver) throws ParseException, StandardException {
        ArrayList<ValueNode> parameterList = new ArrayList<ValueNode>();
        if (this.getToken((int)3).kind == 453) {
            switch (this.jj_nt.kind) {
                case 478: {
                    this.jj_consume_token(478);
                    break;
                }
                case 460: {
                    this.jj_consume_token(460);
                    break;
                }
                default: {
                    this.jj_la1[112] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            MethodCallNode methodNode = this.methodName(receiver);
            this.methodCallParameterList(parameterList);
            if (receiver instanceof ParameterNode) {
                throw StandardException.newException("42X54", methodNode.getMethodName());
            }
            methodNode.addParms(parameterList);
            return new JavaToSQLValueNode(methodNode, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 460: {
                this.jj_consume_token(460);
                MethodCallNode methodNode = this.methodName(receiver);
                if (receiver instanceof ParameterNode) {
                    throw StandardException.newException("42X54", methodNode.getMethodName());
                }
                methodNode.addParms(parameterList);
                return new JavaToSQLValueNode(methodNode, this.getContextManager());
            }
        }
        this.jj_la1[113] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final MethodCallNode methodName(ValueNode receiver) throws ParseException, StandardException {
        String methodName = this.caseSensitiveIdentifierPlusReservedWords();
        return new NonStaticMethodCallNode(methodName, receiver, this.getContextManager());
    }

    public final MethodCallNode staticMethodName(String javaClassName) throws ParseException, StandardException {
        String methodName = this.caseSensitiveIdentifierPlusReservedWords();
        return new StaticMethodCallNode(methodName, javaClassName, this.getContextManager());
    }

    public final void methodParameter(List<ValueNode> parameterList) throws ParseException, StandardException {
        if (this.jj_2_34(1)) {
            ValueNode parameter = this.valueExpression();
            parameterList.add(parameter);
        } else {
            switch (this.jj_nt.kind) {
                case 191: {
                    ValueNode parameter = this.nullSpecification();
                    parameterList.add(parameter);
                    break;
                }
                default: {
                    this.jj_la1[114] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final ValueNode primary() throws ParseException, StandardException {
        if (this.javaClassFollows()) {
            ValueNode value = this.staticClassReference();
            return value;
        }
        if (this.jj_2_35(1)) {
            ValueNode value = this.valueExpressionPrimary();
            return value;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode staticClassReference() throws ParseException, StandardException {
        String javaClassName = this.javaClass();
        this.jj_consume_token(463);
        ValueNode value = this.staticClassReferenceType(javaClassName);
        return value;
    }

    public final ValueNode staticClassReferenceType(String javaClassName) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 453) {
            ValueNode value = this.staticMethodInvocation(javaClassName);
            return value;
        }
        if (this.jj_2_36(1)) {
            ValueNode value = this.staticClassFieldReference(javaClassName);
            return value;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode staticClassFieldReference(String javaClassName) throws ParseException, StandardException {
        String fieldName = null;
        fieldName = this.caseSensitiveIdentifierPlusReservedWords();
        return new JavaToSQLValueNode(new StaticClassFieldReferenceNode(javaClassName, fieldName, this.nextToLastTokenDelimitedIdentifier, this.getContextManager()), this.getContextManager());
    }

    public final int nonSecondDatetimeField() throws ParseException {
        switch (this.jj_nt.kind) {
            case 270: {
                this.jj_consume_token(270);
                return 0;
            }
            case 314: {
                this.jj_consume_token(314);
                return 1;
            }
            case 286: {
                this.jj_consume_token(286);
                return 2;
            }
            case 157: {
                this.jj_consume_token(157);
                return 3;
            }
            case 183: {
                this.jj_consume_token(183);
                return 4;
            }
        }
        this.jj_la1[115] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode escapedValueFunction() throws ParseException, StandardException {
        ValueNode length = null;
        if (this.jj_2_37(1)) {
            ValueNode value = this.miscBuiltinsCore(true);
            return value;
        }
        switch (this.jj_nt.kind) {
            case 235: {
                this.jj_consume_token(235);
                this.jj_consume_token(453);
                ValueNode value = this.additiveExpression(null, 0);
                this.jj_consume_token(458);
                ValueNode startPosition = this.additiveExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 458: {
                        this.jj_consume_token(458);
                        length = this.additiveExpression(null, 0);
                        break;
                    }
                    default: {
                        this.jj_la1[116] = this.jj_gen;
                    }
                }
                this.jj_consume_token(454);
                return this.getSubstringNode(value, startPosition, length);
            }
            case 362: {
                this.jj_consume_token(362);
                this.jj_consume_token(453);
                this.jj_consume_token(454);
                return new CurrentDatetimeOperatorNode(0, this.getContextManager());
            }
            case 364: {
                this.jj_consume_token(364);
                this.jj_consume_token(453);
                this.jj_consume_token(454);
                return new CurrentDatetimeOperatorNode(1, this.getContextManager());
            }
            case 281: {
                this.jj_consume_token(281);
                this.jj_consume_token(453);
                ValueNode str1 = this.additiveExpression(null, 0);
                this.jj_consume_token(458);
                ValueNode str2 = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new ConcatenationOperatorNode(str1, str2, this.getContextManager());
            }
            case 112: 
            case 226: 
            case 256: {
                ValueNode value = this.userNode();
                this.jj_consume_token(453);
                this.jj_consume_token(454);
                return value;
            }
            case 352: 
            case 353: {
                ValueNode value = this.timestampArithmeticFuncion();
                return value;
            }
        }
        this.jj_la1[117] = this.jj_gen;
        if (this.getEscapedSYSFUN(this.getToken((int)1).image) != null) {
            ValueNode value = this.escapedSYSFUNFunction();
            return value;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode escapedSYSFUNFunction() throws ParseException, StandardException {
        ArrayList<ValueNode> parameterList = new ArrayList<ValueNode>();
        Token tok = this.jj_consume_token(480);
        this.methodCallParameterList(parameterList);
        String sysFunName = this.getEscapedSYSFUN(tok.image);
        TableName functionName = new TableName("SYSFUN", sysFunName, this.getContextManager());
        StaticMethodCallNode methodNode = new StaticMethodCallNode(functionName, null, this.getContextManager());
        methodNode.addParms(parameterList);
        return new JavaToSQLValueNode(methodNode, this.getContextManager());
    }

    public final ValueNode timestampArithmeticFuncion() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 352: {
                this.jj_consume_token(352);
                this.jj_consume_token(453);
                ValueNode intervalType = this.jdbcIntervalType();
                this.jj_consume_token(458);
                ValueNode count = this.additiveExpression(null, 0);
                this.jj_consume_token(458);
                ValueNode tstamp1 = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new TernaryOperatorNode(tstamp1, intervalType, count, 4, -1, this.getContextManager());
            }
            case 353: {
                this.jj_consume_token(353);
                this.jj_consume_token(453);
                ValueNode intervalType = this.jdbcIntervalType();
                this.jj_consume_token(458);
                ValueNode tstamp1 = this.additiveExpression(null, 0);
                this.jj_consume_token(458);
                ValueNode tstamp2 = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new TernaryOperatorNode(tstamp2, intervalType, tstamp1, 5, -1, this.getContextManager());
            }
        }
        this.jj_la1[118] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode jdbcIntervalType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 337: {
                this.jj_consume_token(337);
                return this.getJdbcIntervalNode(0);
            }
            case 338: {
                this.jj_consume_token(338);
                return this.getJdbcIntervalNode(1);
            }
            case 339: {
                this.jj_consume_token(339);
                return this.getJdbcIntervalNode(2);
            }
            case 340: {
                this.jj_consume_token(340);
                return this.getJdbcIntervalNode(3);
            }
            case 341: {
                this.jj_consume_token(341);
                return this.getJdbcIntervalNode(4);
            }
            case 342: {
                this.jj_consume_token(342);
                return this.getJdbcIntervalNode(5);
            }
            case 343: {
                this.jj_consume_token(343);
                return this.getJdbcIntervalNode(6);
            }
            case 344: {
                this.jj_consume_token(344);
                return this.getJdbcIntervalNode(7);
            }
            case 345: {
                this.jj_consume_token(345);
                return this.getJdbcIntervalNode(8);
            }
        }
        this.jj_la1[119] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode numericValueFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 271: {
                this.jj_consume_token(271);
                ValueNode value = this.absFunction();
                return value;
            }
            case 272: {
                this.jj_consume_token(272);
                ValueNode value = this.absFunction();
                return value;
            }
            case 438: {
                this.jj_consume_token(438);
                this.jj_consume_token(453);
                ValueNode value = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new UnaryArithmeticOperatorNode(value, 2, this.getContextManager());
            }
            case 311: {
                this.jj_consume_token(311);
                ValueNode value = this.modFunction();
                return value;
            }
            case 293: {
                this.jj_consume_token(293);
                this.jj_consume_token(453);
                this.jj_consume_token(454);
                return new SpecialFunctionNode(0, this.getContextManager());
            }
        }
        this.jj_la1[120] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode coalesceFunction(String coalesceOrValue) throws ParseException, StandardException {
        ValueNodeList expressionList = new ValueNodeList(this.getContextManager());
        this.jj_consume_token(453);
        this.coalesceExpression(expressionList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[121] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.coalesceExpression(expressionList);
        }
        this.jj_consume_token(454);
        return new CoalesceFunctionNode(coalesceOrValue, expressionList, this.getContextManager());
    }

    public final void coalesceExpression(ValueNodeList expressionList) throws ParseException, StandardException {
        ValueNode expression = this.additiveExpression(null, 0);
        expressionList.addElement(expression);
    }

    public final ValueNode absFunction() throws ParseException, StandardException {
        this.jj_consume_token(453);
        ValueNode value = this.additiveExpression(null, 0);
        this.jj_consume_token(454);
        return new UnaryArithmeticOperatorNode(value, 3, this.getContextManager());
    }

    public final ValueNode modFunction() throws ParseException, StandardException {
        this.jj_consume_token(453);
        ValueNode int1 = this.additiveExpression(null, 0);
        this.jj_consume_token(458);
        ValueNode int2 = this.additiveExpression(null, 0);
        this.jj_consume_token(454);
        return new BinaryArithmeticOperatorNode(4, int1, int2, this.getContextManager());
    }

    public final int datetimeField() throws ParseException {
        switch (this.jj_nt.kind) {
            case 157: 
            case 183: 
            case 270: 
            case 286: 
            case 314: {
                int field = this.nonSecondDatetimeField();
                return field;
            }
            case 224: {
                this.jj_consume_token(224);
                return 5;
            }
        }
        this.jj_la1[122] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode characterValueFunction() throws ParseException, StandardException {
        ValueNode value = null;
        Token upperTok = null;
        Token lowerTok = null;
        ValueNode length = null;
        switch (this.jj_nt.kind) {
            case 376: {
                this.jj_consume_token(376);
                this.jj_consume_token(453);
                value = this.additiveExpression(null, 0);
                this.jj_consume_token(458);
                ValueNode startPosition = this.additiveExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 458: {
                        this.jj_consume_token(458);
                        length = this.additiveExpression(null, 0);
                        break;
                    }
                    default: {
                        this.jj_la1[123] = this.jj_gen;
                    }
                }
                this.jj_consume_token(454);
                return this.getSubstringNode(value, startPosition, length);
            }
            case 179: 
            case 255: {
                switch (this.jj_nt.kind) {
                    case 255: {
                        upperTok = this.jj_consume_token(255);
                        break;
                    }
                    case 179: {
                        lowerTok = this.jj_consume_token(179);
                        break;
                    }
                    default: {
                        this.jj_la1[124] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(453);
                value = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new SimpleStringOperatorNode(value, upperTok != null ? "upper" : "lower", this.getContextManager());
            }
            case 403: 
            case 444: {
                switch (this.jj_nt.kind) {
                    case 444: {
                        upperTok = this.jj_consume_token(444);
                        break;
                    }
                    case 403: {
                        lowerTok = this.jj_consume_token(403);
                        break;
                    }
                    default: {
                        this.jj_la1[125] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(453);
                value = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new SimpleStringOperatorNode(value, upperTok != null ? "upper" : "lower", this.getContextManager());
            }
            case 248: 
            case 370: 
            case 375: {
                value = this.trimFunction();
                return value;
            }
            case 404: {
                this.jj_consume_token(404);
                this.jj_consume_token(453);
                ValueNode str1 = this.additiveExpression(null, 0);
                this.jj_consume_token(458);
                ValueNode str2 = this.additiveExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 458: {
                        this.jj_consume_token(458);
                        value = this.additiveExpression(null, 0);
                        break;
                    }
                    default: {
                        this.jj_la1[126] = this.jj_gen;
                    }
                }
                this.jj_consume_token(454);
                return new TernaryOperatorNode(str1, str2, value == null ? new NumericConstantNode(TypeId.getBuiltInTypeId(4), ReuseFactory.getInteger(1), this.getContextManager()) : value, 1, -1, this.getContextManager());
            }
        }
        this.jj_la1[127] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode trimFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 370: 
            case 375: {
                Integer trimType = this.trimType();
                this.jj_consume_token(453);
                ValueNode source = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return this.getTrimOperatorNode(trimType, null, source, null);
            }
            case 248: {
                this.jj_consume_token(248);
                ValueNode ansiTrimNode = this.ansiTrim();
                return ansiTrimNode;
            }
        }
        this.jj_la1[128] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode ansiTrim() throws ParseException, StandardException {
        Integer trimSpec = ReuseFactory.getInteger(0);
        ValueNode trimChar = null;
        ValueNode trimSource = null;
        if (this.ansiTrimSpecFollows()) {
            this.jj_consume_token(453);
            trimSpec = this.ansiTrimSpec();
            if (this.jj_2_38(Integer.MAX_VALUE)) {
                this.jj_consume_token(147);
                trimSource = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return this.getTrimOperatorNode(trimSpec, trimChar, trimSource, null);
            }
            if (this.jj_2_39(1)) {
                trimChar = this.additiveExpression(null, 0);
                this.jj_consume_token(147);
                trimSource = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return this.getTrimOperatorNode(trimSpec, trimChar, trimSource, null);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (!this.ansiTrimSpecFollows()) {
            this.jj_consume_token(453);
            trimChar = this.additiveExpression(null, 0);
            switch (this.jj_nt.kind) {
                case 147: {
                    this.jj_consume_token(147);
                    trimSource = this.additiveExpression(null, 0);
                    this.jj_consume_token(454);
                    return this.getTrimOperatorNode(trimSpec, trimChar, trimSource, null);
                }
                case 454: {
                    this.jj_consume_token(454);
                    return this.getTrimOperatorNode(trimSpec, null, trimChar, null);
                }
            }
            this.jj_la1[129] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Integer ansiTrimSpec() throws ParseException {
        switch (this.jj_nt.kind) {
            case 247: {
                this.jj_consume_token(247);
                return ReuseFactory.getInteger(1);
            }
            case 176: {
                this.jj_consume_token(176);
                return ReuseFactory.getInteger(2);
            }
            case 82: {
                this.jj_consume_token(82);
                return ReuseFactory.getInteger(0);
            }
        }
        this.jj_la1[130] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Integer trimType() throws ParseException {
        switch (this.jj_nt.kind) {
            case 375: {
                this.jj_consume_token(375);
                return ReuseFactory.getInteger(1);
            }
            case 370: {
                this.jj_consume_token(370);
                return ReuseFactory.getInteger(2);
            }
        }
        this.jj_la1[131] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode valueExpressionPrimary() throws ParseException, StandardException {
        if (this.escapedValueFunctionFollows()) {
            this.jj_consume_token(451);
            this.jj_consume_token(399);
            ValueNode value = this.escapedValueFunction();
            this.jj_consume_token(452);
            return value;
        }
        if (this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 436) {
            this.jj_consume_token(108);
            switch (this.jj_nt.kind) {
                case 222: {
                    this.jj_consume_token(222);
                    break;
                }
                case 436: {
                    this.jj_consume_token(436);
                    break;
                }
                default: {
                    this.jj_la1[132] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return new SpecialFunctionNode(2, this.getContextManager());
        }
        if (this.getToken((int)2).kind == 172) {
            this.jj_consume_token(108);
            this.jj_consume_token(172);
            return new SpecialFunctionNode(1, this.getContextManager());
        }
        if (this.jj_2_41(1)) {
            ValueNode value = this.valueSpecification();
            return value;
        }
        if (this.newInvocationFollows(1)) {
            JavaToSQLValueNode value = this.newInvocation();
            return value;
        }
        if (this.windowOrAggregateFunctionFollows()) {
            ValueNode value = this.windowOrAggregateFunctionNode();
            return value;
        }
        if (this.miscBuiltinFollows()) {
            ValueNode value = this.miscBuiltins();
            return value;
        }
        if (this.jj_2_42(1)) {
            ColumnReference value = this.columnReference();
            return value;
        }
        switch (this.jj_nt.kind) {
            case 453: {
                ValueNode value;
                this.jj_consume_token(453);
                if (this.getToken((int)1).kind == 225 || this.getToken((int)1).kind == 259) {
                    value = this.subquery(17, null);
                } else if (this.jj_2_40(1)) {
                    value = this.valueExpression();
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(454);
                return value;
            }
            case 87: {
                ValueNode value = this.castSpecification();
                return value;
            }
            case 188: {
                ValueNode value = this.nextValueExpression();
                return value;
            }
        }
        this.jj_la1[133] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode miscBuiltins() throws ParseException, StandardException {
        if ((this.getToken((int)1).kind == 366 || this.getToken((int)1).kind == 271 || this.getToken((int)1).kind == 272 || this.getToken((int)1).kind == 438 || this.getToken((int)1).kind == 311 || this.getToken((int)1).kind == 93 || this.getToken((int)1).kind == 258 || this.getToken((int)1).kind == 293 || this.getToken((int)1).kind == 235 || this.getToken((int)1).kind == 376 || this.getToken((int)1).kind == 255 || this.getToken((int)1).kind == 179 || this.getToken((int)1).kind == 444 || this.getToken((int)1).kind == 403 || this.getToken((int)1).kind == 370 || this.getToken((int)1).kind == 375 || this.getToken((int)1).kind == 248 || this.getToken((int)1).kind == 285 || this.getToken((int)1).kind == 350 || this.getToken((int)1).kind == 351 || this.getToken((int)1).kind == 128 || this.getToken((int)1).kind == 88 || this.getToken((int)1).kind == 261 || this.getToken((int)1).kind == 168 || this.getToken((int)1).kind == 167 || this.getToken((int)1).kind == 228 || this.getToken((int)1).kind == 368 || this.getToken((int)1).kind == 270 || this.getToken((int)1).kind == 314 || this.getToken((int)1).kind == 286 || this.getToken((int)1).kind == 157 || this.getToken((int)1).kind == 183 || this.getToken((int)1).kind == 224 || this.getToken((int)1).kind == 301 || this.getToken((int)1).kind == 404 || this.getToken((int)1).kind == 379 || this.getToken((int)1).kind == 381 || this.getToken((int)1).kind == 378 || this.getToken((int)1).kind == 380) && this.getToken((int)2).kind == 453) {
            ValueNode value = this.miscBuiltinsCore(false);
            return value;
        }
        if (this.jj_2_43(1)) {
            ValueNode value = this.datetimeValueFunction();
            return value;
        }
        if (this.jj_2_44(1)) {
            ValueNode value = this.routineInvocation();
            return value;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode miscBuiltinsCore(boolean isJDBCEscape) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 366: {
                this.jj_consume_token(366);
                this.jj_consume_token(453);
                this.jj_consume_token(454);
                ContextManager cm = this.getContextManager();
                this.checkInternalFeature("GETCURRENTCONNECTION()");
                return new JavaToSQLValueNode(new GetCurrentConnectionNode(cm), cm);
            }
            case 271: 
            case 272: 
            case 293: 
            case 311: 
            case 438: {
                ValueNode value = this.numericValueFunction();
                return value;
            }
            case 179: 
            case 248: 
            case 255: 
            case 370: 
            case 375: 
            case 376: 
            case 403: 
            case 404: 
            case 444: {
                ValueNode value = this.characterValueFunction();
                return value;
            }
        }
        this.jj_la1[134] = this.jj_gen;
        if (this.jj_2_45(1)) {
            ValueNode value = this.dataTypeScalarFunction();
            return value;
        }
        switch (this.jj_nt.kind) {
            case 93: {
                this.jj_consume_token(93);
                ValueNode value = this.coalesceFunction("COALESCE");
                return value;
            }
            case 258: {
                this.jj_consume_token(258);
                ValueNode value = this.coalesceFunction("VALUE");
                return value;
            }
            case 301: {
                this.jj_consume_token(301);
                this.jj_consume_token(453);
                ValueNode value = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                ContextManager localCM = this.getContextManager();
                if (isJDBCEscape) {
                    return new LengthOperatorNode(this.getTrimOperatorNode(ReuseFactory.getInteger(1), null, value, localCM), localCM);
                }
                return new DB2LengthOperatorNode(value, localCM);
            }
            case 378: 
            case 379: 
            case 380: 
            case 381: {
                ValueNode value = this.xmlFunction();
                return value;
            }
        }
        this.jj_la1[135] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dataTypeScalarFunction() throws ParseException, StandardException {
        int length = -1;
        switch (this.jj_nt.kind) {
            case 157: 
            case 183: 
            case 224: 
            case 270: 
            case 285: 
            case 286: 
            case 314: 
            case 350: 
            case 351: {
                ValueNode value = this.dateTimeScalarFunction();
                return value;
            }
        }
        this.jj_la1[137] = this.jj_gen;
        if (this.jj_2_46(1)) {
            DataTypeDescriptor dts = this.numericFunctionType();
            this.jj_consume_token(453);
            ValueNode operand = this.additiveExpression(null, 0);
            this.jj_consume_token(454);
            CastNode value = new CastNode(operand, dts, this.getContextManager());
            value.setForDataTypeFunction(true);
            value.setForExternallyGeneratedCASTnode();
            return value;
        }
        switch (this.jj_nt.kind) {
            case 88: 
            case 261: {
                int charType = this.charOrVarchar();
                this.jj_consume_token(453);
                ValueNode operand = this.additiveExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 458: {
                        this.jj_consume_token(458);
                        length = this.length();
                        break;
                    }
                    default: {
                        this.jj_la1[136] = this.jj_gen;
                    }
                }
                this.jj_consume_token(454);
                this.checkTypeLimits(charType, length);
                CastNode value = new CastNode(operand, charType, length, this.getContextManager());
                value.setForDataTypeFunction(true);
                value.setForExternallyGeneratedCASTnode();
                return value;
            }
        }
        this.jj_la1[138] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlFunction() throws ParseException, StandardException {
        this.checkVersion(130, "XML");
        XML.checkXMLRequirements();
        switch (this.jj_nt.kind) {
            case 379: {
                this.jj_consume_token(379);
                this.jj_consume_token(453);
                this.xmlDocOrContent();
                ValueNode value = this.xmlParseValue();
                this.jj_consume_token(454);
                return value;
            }
            case 381: {
                this.jj_consume_token(381);
                this.jj_consume_token(453);
                ValueNode value = this.xmlSerializeValue();
                this.jj_consume_token(454);
                return value;
            }
            case 378: {
                this.jj_consume_token(378);
                this.jj_consume_token(453);
                ValueNode value = this.xmlQueryValue(true);
                this.jj_consume_token(454);
                return value;
            }
            case 380: {
                this.jj_consume_token(380);
                this.jj_consume_token(453);
                ValueNode value = this.xmlQueryValue(false);
                this.jj_consume_token(454);
                return value;
            }
        }
        this.jj_la1[139] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlParseValue() throws ParseException, StandardException {
        ValueNode value = this.additiveExpression(null, 0);
        boolean wsOption = this.xmlPreserveWhitespace();
        return new UnaryOperatorNode(value, 0, null, wsOption, this.getContextManager());
    }

    public final boolean xmlPreserveWhitespace() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 440 && this.getToken((int)1).kind != 207) {
            throw StandardException.newException("42Z72", "PRESERVE WHITESPACE", ReuseFactory.getInteger(this.getToken((int)1).beginLine), ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        switch (this.jj_nt.kind) {
            case 440: {
                this.jj_consume_token(440);
                this.jj_consume_token(446);
                throw StandardException.newException("42Z74", "STRIP WHITESPACE");
            }
            case 207: {
                this.jj_consume_token(207);
                this.jj_consume_token(446);
                return true;
            }
        }
        this.jj_la1[140] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlSerializeValue() throws ParseException, StandardException {
        ValueNode value = this.additiveExpression(null, 0);
        DataTypeDescriptor targetType = this.xmlSerializeTargetType();
        return new UnaryOperatorNode(value, 1, targetType, false, this.getContextManager());
    }

    public final DataTypeDescriptor xmlSerializeTargetType() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 72) {
            throw StandardException.newException("42Z72", "AS", ReuseFactory.getInteger(this.getToken((int)1).beginLine), ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        switch (this.jj_nt.kind) {
            case 72: {
                this.jj_consume_token(72);
                DataTypeDescriptor targetType = this.dataTypeDDL();
                return targetType;
            }
        }
        this.jj_la1[141] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlQueryValue(boolean existsOnly) throws ParseException, StandardException {
        ValueNode xqueryExpr = null;
        ValueNode xmlValue = null;
        int defaultPassingMech = -1;
        xqueryExpr = this.additiveExpression(null, 0);
        this.jj_consume_token(418);
        defaultPassingMech = this.xmlPassingMechanism();
        xmlValue = this.xqVarList();
        if (!existsOnly) {
            if (this.jj_2_48(1)) {
                this.xqReturningClause();
                if (this.jj_2_47(1)) {
                    this.xmlPassingMechanism();
                }
            }
            this.xqEmptyHandlingClause();
        } else if (!existsOnly) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        BinaryOperatorNode vNode = new BinaryOperatorNode(xqueryExpr, xmlValue, existsOnly ? 0 : 1, this.getContextManager());
        return vNode;
    }

    public final ValueNode xqVarList() throws ParseException, StandardException {
        ValueNode[] xmlValue = new ValueNode[]{null};
        this.xqVariable(xmlValue);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[142] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.xqVariable(xmlValue);
        }
        return xmlValue[0];
    }

    public final void xqVariable(ValueNode[] xmlVal) throws ParseException, StandardException {
        String varName = null;
        int passingMech = -1;
        ValueNode curVal = this.additiveExpression(null, 0);
        if (this.getToken((int)1).kind == 72) {
            this.jj_consume_token(72);
            varName = this.identifier(128, true);
            throw StandardException.newException("42Z74", "PASSING ... AS");
        }
        if (this.jj_2_49(1)) {
            passingMech = this.xmlPassingMechanism();
        }
        if (varName == null) {
            if (xmlVal[0] != null) {
                throw StandardException.newException("42Z76", new Object[0]);
            }
            xmlVal[0] = curVal;
        }
    }

    public final short xmlPassingMechanism() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 422) {
            this.jj_consume_token(83);
            this.jj_consume_token(422);
            return 1;
        }
        switch (this.jj_nt.kind) {
            case 83: {
                this.jj_consume_token(83);
                this.jj_consume_token(258);
                throw StandardException.newException("42Z74", "BY VALUE");
            }
        }
        this.jj_la1[143] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final short xqReturningClause() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 432) {
            this.jj_consume_token(428);
            this.jj_consume_token(432);
            return 3;
        }
        switch (this.jj_nt.kind) {
            case 428: {
                this.jj_consume_token(428);
                this.jj_consume_token(387);
                throw StandardException.newException("42Z74", "RETURNING CONTENT");
            }
        }
        this.jj_la1[144] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final short xqEmptyHandlingClause() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 397) {
            this.jj_consume_token(397);
            this.jj_consume_token(195);
            this.jj_consume_token(397);
            return 5;
        }
        switch (this.jj_nt.kind) {
            case 191: {
                this.jj_consume_token(191);
                this.jj_consume_token(195);
                this.jj_consume_token(397);
                throw StandardException.newException("42Z74", "NULL ON EMPTY");
            }
        }
        this.jj_la1[145] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor numericFunctionType() throws ParseException, StandardException {
        if (this.jj_2_50(1)) {
            DataTypeDescriptor dts = this.doubleType();
            return dts;
        }
        switch (this.jj_nt.kind) {
            case 167: 
            case 168: 
            case 228: 
            case 368: {
                DataTypeDescriptor dts = this.exactIntegerType();
                return dts;
            }
        }
        this.jj_la1[146] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dateTimeScalarFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 350: {
                this.jj_consume_token(350);
                this.jj_consume_token(453);
                ValueNode value = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                CastNode castValue = new CastNode(value, DataTypeDescriptor.getBuiltInDataTypeDescriptor(92), this.getContextManager());
                castValue.setForExternallyGeneratedCASTnode();
                return castValue;
            }
            case 285: {
                this.jj_consume_token(285);
                this.jj_consume_token(453);
                ValueNode value = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new UnaryDateTimestampOperatorNode(value, 0, this.getContextManager());
            }
            case 351: {
                this.jj_consume_token(351);
                this.jj_consume_token(453);
                ValueNode value = this.additiveExpression(null, 0);
                ValueNode timestampNode = this.timestampFunctionCompletion(value);
                return timestampNode;
            }
            case 157: 
            case 183: 
            case 224: 
            case 270: 
            case 286: 
            case 314: {
                int field = this.datetimeField();
                this.jj_consume_token(453);
                ValueNode value = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new ExtractOperatorNode(ReuseFactory.getInteger(field), value, this.getContextManager());
            }
        }
        this.jj_la1[147] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode timestampFunctionCompletion(ValueNode firstArg) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 454: {
                this.jj_consume_token(454);
                return new UnaryDateTimestampOperatorNode(firstArg, 1, this.getContextManager());
            }
            case 458: {
                this.jj_consume_token(458);
                ValueNode timeValue = this.additiveExpression(null, 0);
                this.jj_consume_token(454);
                return new TimestampOperatorNode(firstArg, timeValue, this.getContextManager());
            }
        }
        this.jj_la1[148] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token booleanLiteral() throws ParseException {
        switch (this.jj_nt.kind) {
            case 249: {
                Token tok = this.jj_consume_token(249);
                return tok;
            }
            case 140: {
                Token tok = this.jj_consume_token(140);
                return tok;
            }
        }
        this.jj_la1[149] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode generalValueSpecification() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 472: {
                ParameterNode parm = this.dynamicParameterSpecification();
                return parm;
            }
            case 112: 
            case 226: 
            case 256: {
                ValueNode parm = this.userNode();
                return parm;
            }
            case 363: {
                ValueNode parm = this.currentRoleNode();
                return parm;
            }
        }
        this.jj_la1[150] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode userNode() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 256: {
                this.jj_consume_token(256);
                return new SpecialFunctionNode(3, this.getContextManager());
            }
            case 112: {
                this.jj_consume_token(112);
                return new SpecialFunctionNode(4, this.getContextManager());
            }
            case 226: {
                this.jj_consume_token(226);
                return new SpecialFunctionNode(5, this.getContextManager());
            }
        }
        this.jj_la1[151] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode currentRoleNode() throws ParseException, StandardException {
        this.jj_consume_token(363);
        this.checkVersion(170, "ROLES");
        this.checkSqlStandardAccess("CURRENT_ROLE");
        return new SpecialFunctionNode(7, this.getContextManager());
    }

    public final JavaToSQLValueNode newInvocation() throws ParseException, StandardException {
        ArrayList<ValueNode> parameterList = new ArrayList<ValueNode>();
        this.jj_consume_token(409);
        String javaClassName = this.javaClassName();
        this.methodCallParameterList(parameterList);
        if (!(javaClassName.startsWith("org.apache.derby.diag.") || javaClassName.startsWith("org.apache.derby.catalog.") || javaClassName.startsWith("com.ibm.db2j."))) {
            this.checkInternalFeature(javaClassName);
        }
        NewInvocationNode newNode = new NewInvocationNode(javaClassName, parameterList, this.lastTokenDelimitedIdentifier, this.getContextManager());
        return new JavaToSQLValueNode(newNode, this.getContextManager());
    }

    public final JavaToSQLValueNode vtiTableConstruct() throws ParseException, StandardException {
        NewInvocationNode newNode = null;
        MethodCallNode invocationNode = null;
        ArrayList<ValueNode> parameterList = new ArrayList<ValueNode>();
        TableName vtiTableName = null;
        this.jj_consume_token(239);
        this.jj_consume_token(453);
        vtiTableName = this.qualifiedName(128);
        this.methodCallParameterList(parameterList);
        this.jj_consume_token(454);
        newNode = new NewInvocationNode(vtiTableName, null, parameterList, this.lastTokenDelimitedIdentifier, this.getContextManager());
        if (newNode.isBuiltinVTI()) {
            invocationNode = newNode;
        } else {
            StaticMethodCallNode methodNode = new StaticMethodCallNode(vtiTableName, null, this.getContextManager());
            methodNode.addParms(parameterList);
            invocationNode = methodNode;
        }
        return new JavaToSQLValueNode(invocationNode, this.getContextManager());
    }

    public final ValueNode staticMethodInvocation(String javaClassName) throws ParseException, StandardException {
        ArrayList<ValueNode> parameterList = new ArrayList<ValueNode>();
        MethodCallNode methodNode = this.staticMethodName(javaClassName);
        this.methodCallParameterList(parameterList);
        methodNode.addParms(parameterList);
        return new JavaToSQLValueNode(methodNode, this.getContextManager());
    }

    public final void methodCallParameterList(List<ValueNode> parameterList) throws ParseException, StandardException {
        this.jj_consume_token(453);
        if (this.jj_2_51(1)) {
            this.methodParameter(parameterList);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 458: {
                        break;
                    }
                    default: {
                        this.jj_la1[152] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(458);
                this.methodParameter(parameterList);
            }
        }
        this.jj_consume_token(454);
    }

    public final ValueNode routineInvocation() throws ParseException, StandardException {
        if (!this.distinctUDAFollows()) {
            ValueNode valueNode = this.routineExpression();
            return valueNode;
        }
        if (this.distinctUDAFollows()) {
            ValueNode valueNode = this.distinctUDA();
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode routineExpression() throws ParseException, StandardException {
        ArrayList<ValueNode> parameterList = new ArrayList<ValueNode>();
        TableName routineName = this.qualifiedName(128);
        this.methodCallParameterList(parameterList);
        StaticMethodCallNode methodNode = new StaticMethodCallNode(routineName, null, this.getContextManager());
        methodNode.addParms(parameterList);
        return new JavaToSQLValueNode(methodNode, this.getContextManager());
    }

    public final ValueNode distinctUDA() throws ParseException, StandardException {
        TableName aggName = this.qualifiedName(128);
        this.jj_consume_token(453);
        this.jj_consume_token(127);
        ValueNode value = this.additiveExpression(null, 0);
        this.jj_consume_token(454);
        return new AggregateNode(value, aggName, true, "", this.getContextManager());
    }

    public final String javaClass() throws ParseException, StandardException {
        String javaClassName = this.javaClassName();
        return javaClassName;
    }

    public final ValueNode columnMethodInvocation() throws ParseException, StandardException {
        ValueNode columnReference = this.columnNameForInvocation();
        ValueNode methodNode = this.nonStaticMethodInvocation(columnReference);
        return methodNode;
    }

    public final ValueNode columnNameForInvocation() throws ParseException, StandardException {
        String secondName = null;
        String thirdName = null;
        String columnName = null;
        String tableName = null;
        String schemaName = null;
        TableName tabName = null;
        String firstName = this.identifier(128, true);
        if (this.getToken((int)1).kind == 460 && this.getToken((int)3).kind == 460) {
            this.jj_consume_token(460);
            secondName = this.identifier(128, true);
            if (this.getToken((int)1).kind == 460 && this.getToken((int)3).kind == 460) {
                this.jj_consume_token(460);
                thirdName = this.identifier(128, true);
            }
        }
        if (thirdName == null) {
            if (secondName == null) {
                columnName = firstName;
            } else {
                tableName = firstName;
                columnName = secondName;
            }
        } else {
            schemaName = firstName;
            tableName = secondName;
            columnName = thirdName;
        }
        if (tableName != null) {
            tabName = new TableName(schemaName, tableName, (thirdName == null ? this.nextToLastIdentifierToken : this.thirdToLastIdentifierToken).beginOffset, this.nextToLastIdentifierToken.endOffset, this.getContextManager());
        }
        ColumnReference retval = new ColumnReference(columnName, tabName, this.lastIdentifierToken.beginOffset, this.lastIdentifierToken.endOffset, this.getContextManager());
        return retval;
    }

    public final ColumnReference columnReference() throws ParseException, StandardException {
        String secondName = null;
        String thirdName = null;
        String columnName = null;
        String tableName = null;
        String schemaName = null;
        TableName tabName = null;
        String firstName = this.identifier(128, false);
        if (this.getToken((int)1).kind == 460 && this.getToken((int)3).kind != 453) {
            this.jj_consume_token(460);
            secondName = this.identifier(128, false);
            if (this.getToken((int)1).kind == 460 && this.getToken((int)3).kind != 453) {
                this.jj_consume_token(460);
                thirdName = this.identifier(128, false);
            }
        }
        if (thirdName == null) {
            if (secondName == null) {
                columnName = firstName;
            } else {
                tableName = firstName;
                columnName = secondName;
            }
        } else {
            schemaName = firstName;
            tableName = secondName;
            columnName = thirdName;
        }
        IdUtil.checkIdentifierLengthLimit(columnName, 128);
        if (schemaName != null) {
            IdUtil.checkIdentifierLengthLimit(schemaName, 128);
        }
        if (tableName != null) {
            IdUtil.checkIdentifierLengthLimit(tableName, 128);
        }
        if (tableName != null) {
            tabName = new TableName(schemaName, tableName, (thirdName == null ? this.nextToLastIdentifierToken : this.thirdToLastIdentifierToken).beginOffset, this.nextToLastIdentifierToken.endOffset, this.getContextManager());
        }
        return new ColumnReference(columnName, tabName, this.lastIdentifierToken.beginOffset, this.lastIdentifierToken.endOffset, this.getContextManager());
    }

    public final OrderByList orderByClause(ResultSetNode rs) throws ParseException, StandardException {
        this.jj_consume_token(200);
        this.jj_consume_token(83);
        OrderByList orderCols = this.sortSpecificationList(rs);
        this.forbidNextValueFor();
        return orderCols;
    }

    public final int atIsolationLevel() throws ParseException, StandardException {
        this.jj_consume_token(267);
        int isolationLevel = this.isolationLevelDB2Abbrev();
        return isolationLevel;
    }

    public final OrderByList sortSpecificationList(ResultSetNode rs) throws ParseException, StandardException {
        OrderByList orderCols = new OrderByList(rs, this.getContextManager());
        this.sortSpecification(orderCols);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[153] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.sortSpecification(orderCols);
        }
        return orderCols;
    }

    public final void sortSpecification(OrderByList orderCols) throws ParseException, StandardException {
        OrderByColumn orderCol = this.sortKey();
        switch (this.jj_nt.kind) {
            case 73: 
            case 123: {
                this.orderingSpecification(orderCol);
                break;
            }
            default: {
                this.jj_la1[154] = this.jj_gen;
            }
        }
        if (this.jj_2_52(1)) {
            this.nullOrdering(orderCol);
        }
        orderCols.addOrderByColumn(orderCol);
    }

    public final OrderByColumn sortKey() throws ParseException, StandardException {
        ValueNode columnExpression = this.additiveExpression(null, 0);
        return new OrderByColumn(columnExpression, this.getContextManager());
    }

    public final void orderingSpecification(OrderByColumn orderCol) throws ParseException {
        switch (this.jj_nt.kind) {
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                orderCol.setDescending();
                break;
            }
            default: {
                this.jj_la1[155] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void nullOrdering(OrderByColumn orderCol) throws ParseException {
        if (this.getToken((int)2).kind == 175) {
            this.jj_consume_token(320);
            this.jj_consume_token(175);
            if (!orderCol.isAscending()) {
                orderCol.setNullsOrderedLow();
            }
        } else {
            switch (this.jj_nt.kind) {
                case 320: {
                    this.jj_consume_token(320);
                    this.jj_consume_token(142);
                    if (!orderCol.isAscending()) break;
                    orderCol.setNullsOrderedLow();
                    break;
                }
                default: {
                    this.jj_la1[156] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final boolean offsetFetchFirstClause(ValueNode[] clauses) throws ParseException, StandardException {
        boolean result = false;
        if (this.getToken((int)1).kind == 323 || this.getToken((int)1).kind == 141) {
            this.sqlStandardOffsetFetchFirst(clauses);
            return false;
        }
        if (this.getToken((int)1).kind == 451) {
            this.jdbcLimitOffset(clauses);
            result = true;
        }
        return result;
    }

    public final void sqlStandardOffsetFetchFirst(ValueNode[] clauses) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 323: {
                clauses[0] = this.offsetClause();
                break;
            }
            default: {
                this.jj_la1[157] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 141: {
                clauses[1] = this.fetchFirstClause();
                break;
            }
            default: {
                this.jj_la1[158] = this.jj_gen;
            }
        }
    }

    public final void jdbcLimitOffset(ValueNode[] clauses) throws ParseException, StandardException {
        ValueNode rowCount = null;
        ValueNode startRow = null;
        this.jj_consume_token(451);
        this.jj_consume_token(303);
        switch (this.jj_nt.kind) {
            case 457: 
            case 459: 
            case 487: {
                rowCount = this.intLiteral();
                break;
            }
            case 472: {
                rowCount = this.dynamicParameterSpecification();
                break;
            }
            default: {
                this.jj_la1[159] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block4 : switch (this.jj_nt.kind) {
            case 323: {
                this.jj_consume_token(323);
                switch (this.jj_nt.kind) {
                    case 457: 
                    case 459: 
                    case 487: {
                        startRow = this.intLiteral();
                        break block4;
                    }
                    case 472: {
                        startRow = this.dynamicParameterSpecification();
                        break block4;
                    }
                }
                this.jj_la1[160] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[161] = this.jj_gen;
            }
        }
        this.jj_consume_token(452);
        if (rowCount instanceof NumericConstantNode && ((ConstantNode)rowCount).getValue().getInt() == 0) {
            rowCount = null;
        }
        if (startRow == null) {
            startRow = this.getNumericNode("0", true);
        }
        clauses[1] = rowCount;
        clauses[0] = startRow;
    }

    public final ValueNode offsetClause() throws ParseException, StandardException {
        ValueNode result = null;
        this.jj_consume_token(323);
        switch (this.jj_nt.kind) {
            case 457: 
            case 459: 
            case 487: {
                result = this.intLiteral();
                break;
            }
            case 472: {
                result = this.dynamicParameterSpecification();
                break;
            }
            default: {
                this.jj_la1[162] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_nt.kind) {
            case 332: {
                this.jj_consume_token(332);
                break;
            }
            case 221: {
                this.jj_consume_token(221);
                break;
            }
            default: {
                this.jj_la1[163] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final ValueNode fetchFirstClause() throws ParseException, StandardException {
        ValueNode result = this.getNumericNode("1", true);
        this.jj_consume_token(141);
        switch (this.jj_nt.kind) {
            case 142: {
                this.jj_consume_token(142);
                break;
            }
            case 188: {
                this.jj_consume_token(188);
                break;
            }
            default: {
                this.jj_la1[164] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block4 : switch (this.jj_nt.kind) {
            case 457: 
            case 459: 
            case 472: 
            case 487: {
                switch (this.jj_nt.kind) {
                    case 457: 
                    case 459: 
                    case 487: {
                        result = this.intLiteral();
                        break block4;
                    }
                    case 472: {
                        result = this.dynamicParameterSpecification();
                        break block4;
                    }
                }
                this.jj_la1[165] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[166] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 332: {
                this.jj_consume_token(332);
                break;
            }
            case 221: {
                this.jj_consume_token(221);
                break;
            }
            default: {
                this.jj_la1[167] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(196);
        return result;
    }

    public final int forUpdateClause(List<String> columnList) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 254: {
                this.jj_consume_token(254);
                switch (this.jj_nt.kind) {
                    case 194: {
                        this.jj_consume_token(194);
                        this.forUpdateColumnList(columnList);
                        break;
                    }
                    default: {
                        this.jj_la1[168] = this.jj_gen;
                    }
                }
                return 2;
            }
            case 213: {
                this.jj_consume_token(213);
                this.jj_consume_token(196);
                return 1;
            }
            case 141: {
                this.jj_consume_token(141);
                this.jj_consume_token(196);
                return 1;
            }
        }
        this.jj_la1[169] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void forUpdateColumnList(List<String> columnList) throws ParseException, StandardException {
        this.forUpdateColumn(columnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[170] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.forUpdateColumn(columnList);
        }
    }

    public final void forUpdateColumn(List<String> columnList) throws ParseException, StandardException {
        String columnName = this.identifier(128, true);
        columnList.add(columnName);
    }

    public final ResultColumnList setClauseList() throws ParseException, StandardException {
        ResultColumnList columnList = new ResultColumnList(this.getContextManager());
        this.setClause(columnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[171] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.setClause(columnList);
        }
        return columnList;
    }

    public final void setClause(ResultColumnList columnList) throws ParseException, StandardException {
        ColumnReference columnName = this.columnReference();
        this.jj_consume_token(467);
        ValueNode valueNode = this.updateSource(columnName.getColumnName());
        ResultColumn resultColumn = new ResultColumn(columnName, valueNode, this.getContextManager());
        columnList.addResultColumn(resultColumn);
    }

    public final ValueNode updateSource(String columnName) throws ParseException, StandardException {
        if (this.jj_2_53(1)) {
            ValueNode valueNode = this.valueExpression();
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 191: {
                ValueNode valueNode = this.nullSpecification();
                return valueNode;
            }
            case 119: {
                this.jj_consume_token(119);
                return new DefaultNode(columnName, this.getContextManager());
            }
        }
        this.jj_la1[172] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode nullSpecification() throws ParseException, StandardException {
        this.jj_consume_token(191);
        return new UntypedNullConstantNode(this.getContextManager());
    }

    public final StatementNode insertColumnsAndSource(QueryTreeNode targetTable) throws ParseException, StandardException {
        Properties targetProperties = null;
        ResultColumnList columnList = null;
        OrderByList orderCols = null;
        ValueNode[] offsetClauses = new ValueNode[2];
        boolean hasJDBClimitClause = false;
        if (this.getToken((int)1).kind == 453 && !this.subqueryFollows()) {
            this.jj_consume_token(453);
            columnList = this.insertColumnList();
            this.jj_consume_token(454);
        }
        switch (this.jj_nt.kind) {
            case 59: {
                targetProperties = this.propertyList(false);
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[173] = this.jj_gen;
            }
        }
        ResultSetNode queryExpression = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 200: {
                orderCols = this.orderByClause(queryExpression);
                break;
            }
            default: {
                this.jj_la1[174] = this.jj_gen;
            }
        }
        hasJDBClimitClause = this.offsetFetchFirstClause(offsetClauses);
        if (orderCols != null && this.isTableValueConstructor(queryExpression)) {
            throw StandardException.newException("42X01", "ORDER BY");
        }
        if ((offsetClauses[0] != null || offsetClauses[1] != null) && this.isTableValueConstructor(queryExpression)) {
            String tokenName = hasJDBClimitClause ? "LIMIT" : (offsetClauses[0] != null ? "OFFSET" : "FETCH");
            throw StandardException.newException("42X01", tokenName);
        }
        return new InsertNode(targetTable, columnList, queryExpression, null, targetProperties, orderCols, offsetClauses[0], offsetClauses[1], hasJDBClimitClause, this.getContextManager());
    }

    public final ResultColumnList insertColumnList() throws ParseException, StandardException {
        ResultColumnList columnList = new ResultColumnList(this.getContextManager());
        this.columnQualifiedNameList(columnList);
        return columnList;
    }

    public final void columnQualifiedNameList(ResultColumnList columnList) throws ParseException, StandardException {
        this.columnQualifiedNameItem(columnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[175] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.columnQualifiedNameItem(columnList);
        }
    }

    public final void columnQualifiedNameItem(ResultColumnList columnList) throws ParseException, StandardException {
        ColumnReference columnRef = this.columnReference();
        ResultColumn resultColumn = new ResultColumn(columnRef, null, this.getContextManager());
        columnList.addResultColumn(resultColumn);
    }

    public final ResultSetNode rowValueConstructor(ResultSetNode leftRSN) throws ParseException, StandardException {
        ResultColumnList resultColumns = new ResultColumnList(this.getContextManager());
        if (this.rowValueConstructorListFollows()) {
            this.jj_consume_token(453);
            this.rowValueConstructorList(resultColumns);
            this.jj_consume_token(454);
            FromTable newRSN = new RowResultSetNode(resultColumns, null, this.getContextManager());
            if (leftRSN != null) {
                if (leftRSN.getResultColumns().size() != newRSN.getResultColumns().size()) {
                    throw StandardException.newException("42X59", new Object[0]);
                }
                newRSN = new UnionNode(leftRSN, newRSN, true, true, null, this.getContextManager());
            }
            return newRSN;
        }
        this.rowValueConstructorElement(resultColumns);
        FromTable newRSN = new RowResultSetNode(resultColumns, null, this.getContextManager());
        if (leftRSN != null) {
            if (leftRSN.getResultColumns().size() != newRSN.getResultColumns().size()) {
                throw StandardException.newException("42X59", new Object[0]);
            }
            newRSN = new UnionNode(leftRSN, newRSN, true, true, null, this.getContextManager());
        }
        return newRSN;
    }

    public final void rowValueConstructorElement(ResultColumnList resultColumns) throws ParseException, StandardException {
        if (this.jj_2_54(1)) {
            ValueNode value = this.valueExpression();
            resultColumns.addResultColumn(new ResultColumn((String)null, value, this.getContextManager()));
        } else {
            switch (this.jj_nt.kind) {
                case 191: {
                    ValueNode value = this.nullSpecification();
                    resultColumns.addResultColumn(new ResultColumn((String)null, value, this.getContextManager()));
                    break;
                }
                case 119: {
                    this.jj_consume_token(119);
                    resultColumns.addResultColumn(new ResultColumn((String)null, (ValueNode)new DefaultNode(null, this.getContextManager()), this.getContextManager()));
                    break;
                }
                default: {
                    this.jj_la1[176] = this.jj_gen;
                    throw StandardException.newException("42X80", new Object[0]);
                }
            }
        }
    }

    public final void rowValueConstructorList(ResultColumnList resultColumns) throws ParseException, StandardException {
        this.rowValueConstructorElement(resultColumns);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[177] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.rowValueConstructorElement(resultColumns);
        }
    }

    public final SubqueryNode tableSubquery(int subqueryType, ValueNode leftOperand) throws ParseException, StandardException {
        SubqueryNode subqueryNode = this.subquery(subqueryType, leftOperand);
        return subqueryNode;
    }

    public final SubqueryNode subquery(int subqueryType, ValueNode leftOperand) throws ParseException, StandardException {
        OrderByList orderCols = null;
        ValueNode[] offsetClauses = new ValueNode[2];
        boolean hasJDBClimitClause = false;
        ResultSetNode queryExpression = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 200: {
                orderCols = this.orderByClause(queryExpression);
                break;
            }
            default: {
                this.jj_la1[178] = this.jj_gen;
            }
        }
        hasJDBClimitClause = this.offsetFetchFirstClause(offsetClauses);
        SubqueryNode subqueryNode = new SubqueryNode(queryExpression, subqueryType, leftOperand, orderCols, offsetClauses[0], offsetClauses[1], hasJDBClimitClause, this.getContextManager());
        return subqueryNode;
    }

    public final ValueNode inPredicateValue(ValueNode leftOperand) throws ParseException, StandardException {
        ValueNode retval;
        this.jj_consume_token(453);
        if (this.subqueryFollows()) {
            retval = this.tableSubquery(1, leftOperand);
        } else if (this.jj_2_55(1)) {
            retval = this.inValueList(leftOperand);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(454);
        return retval;
    }

    public final ValueNode inValueList(ValueNode leftOperand) throws ParseException, StandardException {
        ValueNodeList inList = new ValueNodeList(this.getContextManager());
        this.inElement(inList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[179] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.inElement(inList);
        }
        return new InListOperatorNode(leftOperand, inList, this.getContextManager());
    }

    public final void inElement(ValueNodeList inList) throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        inList.addElement(valueNode);
    }

    public final int quantifier(int opType) throws ParseException, StandardException {
        int retval = 0;
        switch (this.jj_nt.kind) {
            case 66: {
                this.jj_consume_token(66);
                switch (opType) {
                    case 6: {
                        retval = 4;
                        break;
                    }
                    case 7: {
                        retval = 6;
                        break;
                    }
                    case 11: {
                        retval = 14;
                        break;
                    }
                    case 10: {
                        retval = 12;
                        break;
                    }
                    case 9: {
                        retval = 10;
                        break;
                    }
                    case 8: {
                        retval = 8;
                        break;
                    }
                    default: {
                        SanityManager.THROWASSERT("Invalid value for opType (" + opType + ") passed to quantifier()");
                    }
                }
                return retval;
            }
            case 70: 
            case 229: {
                this.some();
                switch (opType) {
                    case 6: {
                        retval = 3;
                        break;
                    }
                    case 7: {
                        retval = 5;
                        break;
                    }
                    case 11: {
                        retval = 13;
                        break;
                    }
                    case 10: {
                        retval = 11;
                        break;
                    }
                    case 9: {
                        retval = 9;
                        break;
                    }
                    case 8: {
                        retval = 7;
                        break;
                    }
                    default: {
                        SanityManager.THROWASSERT("Invalid value for opType (" + opType + ") passed to quantifier()");
                    }
                }
                return retval;
            }
        }
        this.jj_la1[180] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void some() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 229: {
                this.jj_consume_token(229);
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                break;
            }
            default: {
                this.jj_la1[181] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final SubqueryNode existsExpression() throws ParseException, StandardException {
        this.jj_consume_token(138);
        this.jj_consume_token(453);
        SubqueryNode subqueryNode = this.tableSubquery(15, null);
        this.jj_consume_token(454);
        return subqueryNode;
    }

    public final SelectNode tableExpression(ResultColumnList selectList) throws ParseException, StandardException {
        ValueNode whereClause = null;
        GroupByList groupByList = null;
        ValueNode havingClause = null;
        WindowList windows = null;
        OptimizerPlan optimizerOverridePlan = null;
        FromList fromList = this.fromClause();
        switch (this.jj_nt.kind) {
            case 265: {
                Token whereToken = this.jj_consume_token(265);
                whereClause = this.whereClause(whereToken);
                break;
            }
            default: {
                this.jj_la1[182] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 155: {
                groupByList = this.groupByClause();
                break;
            }
            default: {
                this.jj_la1[183] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 156: {
                havingClause = this.havingClause();
                break;
            }
            default: {
                this.jj_la1[184] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 266: {
                windows = this.windowClause();
                break;
            }
            default: {
                this.jj_la1[185] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 359: {
                optimizerOverridePlan = this.optimizerOverridePlan();
                break;
            }
            default: {
                this.jj_la1[186] = this.jj_gen;
            }
        }
        if (havingClause != null && groupByList == null) {
            AggregateNode n = new AggregateNode(null, CountAggregateDefinition.class, false, "COUNT(*)", this.getContextManager());
            n.replaceAggregatesWithColumnReferences(selectList, 0);
        }
        SelectNode selectNode = new SelectNode(selectList, fromList, whereClause, groupByList, havingClause, windows, optimizerOverridePlan, this.getContextManager());
        return selectNode;
    }

    public final FromList fromClause() throws ParseException, StandardException {
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        this.jj_consume_token(147);
        Token beginToken = this.getToken(1);
        switch (this.jj_nt.kind) {
            case 59: {
                this.fromListProperties(fromList);
                break;
            }
            default: {
                this.jj_la1[187] = this.jj_gen;
            }
        }
        this.dummyTableReferenceRule(fromList);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[188] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(458);
            this.dummyTableReferenceRule(fromList);
        }
        Token endToken = this.getToken(0);
        fromList.setBeginOffset(beginToken.beginOffset);
        fromList.setEndOffset(endToken.endOffset);
        return fromList;
    }

    public final void fromListProperties(FromList fromList) throws ParseException, StandardException {
        Properties properties = this.propertyList(true);
        this.jj_consume_token(64);
        fromList.setProperties(properties);
    }

    public final void dummyTableReferenceRule(FromList fromList) throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 239 && this.getToken((int)2).kind == 453 && (this.getToken((int)3).kind == 225 || this.getToken((int)3).kind == 259)) {
            this.jj_consume_token(239);
            FromTable tableReference = this.tableReferenceTypes(false);
            fromList.addFromTable(tableReference);
        } else if (this.jj_2_56(1)) {
            FromTable tableReference = this.tableReferenceTypes(false);
            fromList.addFromTable(tableReference);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final FromTable tableReferenceTypes(boolean nestedInParens) throws ParseException, StandardException {
        if (this.jj_2_57(1)) {
            FromTable tableReference = this.tableReference(nestedInParens);
            return tableReference;
        }
        switch (this.jj_nt.kind) {
            case 451: {
                this.jj_consume_token(451);
                this.jj_consume_token(412);
                FromTable tableReference = this.tableReference(nestedInParens);
                this.jj_consume_token(452);
                return tableReference;
            }
        }
        this.jj_la1[189] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] optionalTableClauses() throws ParseException, StandardException {
        Object[] otc = null;
        Properties tableProperties = null;
        ResultColumnList derivedRCL = null;
        String correlationName = null;
        switch (this.jj_nt.kind) {
            case 59: {
                otc = this.optionalTableProperties();
                otc[1] = derivedRCL;
                otc[2] = correlationName;
                return otc;
            }
        }
        this.jj_la1[193] = this.jj_gen;
        if (this.jj_2_58(1)) {
            switch (this.jj_nt.kind) {
                case 72: {
                    this.jj_consume_token(72);
                    break;
                }
                default: {
                    this.jj_la1[190] = this.jj_gen;
                }
            }
            correlationName = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 453: {
                    this.jj_consume_token(453);
                    derivedRCL = this.derivedColumnList();
                    this.jj_consume_token(454);
                    break;
                }
                default: {
                    this.jj_la1[191] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 59: {
                    tableProperties = this.propertyList(true);
                    this.jj_consume_token(64);
                    break;
                }
                default: {
                    this.jj_la1[192] = this.jj_gen;
                }
            }
        }
        otc = new Object[]{tableProperties, derivedRCL, correlationName};
        return otc;
    }

    public final Object[] optionalTableProperties() throws ParseException, StandardException {
        Object[] otc = null;
        Properties tableProperties = null;
        tableProperties = this.propertyList(true);
        this.jj_consume_token(64);
        otc = new Object[3];
        otc[0] = tableProperties;
        return otc;
    }

    public final FromTable tableReference(boolean nestedInParens) throws ParseException, StandardException {
        TableOperatorNode joinTable = null;
        FromTable fromTable = this.tableFactor();
        while (this.joinedTableExpressionFollows()) {
            joinTable = this.joinedTableExpression(joinTable == null ? fromTable : joinTable, nestedInParens);
        }
        return joinTable == null ? fromTable : joinTable;
    }

    public final FromTable tableFactor() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLNode = null;
        String correlationName = null;
        ResultColumnList derivedRCL = null;
        Object[] optionalTableClauses = new Object[3];
        Object tableProperties = null;
        if (this.jj_2_59(1)) {
            if (this.newInvocationFollows(1)) {
                javaToSQLNode = this.newInvocation();
            } else {
                switch (this.jj_nt.kind) {
                    case 239: {
                        javaToSQLNode = this.vtiTableConstruct();
                        break;
                    }
                    default: {
                        this.jj_la1[194] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            switch (this.jj_nt.kind) {
                case 72: {
                    this.jj_consume_token(72);
                    break;
                }
                default: {
                    this.jj_la1[195] = this.jj_gen;
                }
            }
            correlationName = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 453: {
                    this.jj_consume_token(453);
                    derivedRCL = this.derivedColumnList();
                    this.jj_consume_token(454);
                    break;
                }
                default: {
                    this.jj_la1[196] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 59: {
                    optionalTableClauses = this.optionalTableProperties();
                    break;
                }
                default: {
                    this.jj_la1[197] = this.jj_gen;
                }
            }
            FromVTI fromTable = new FromVTI((MethodCallNode)javaToSQLNode.getJavaValueNode(), correlationName, derivedRCL, optionalTableClauses != null ? (Properties)optionalTableClauses[0] : (Properties)null, this.getContextManager());
            return fromTable;
        }
        if (this.jj_2_60(1)) {
            TableName tableName = this.qualifiedName(128);
            optionalTableClauses = this.optionalTableClauses();
            FromBaseTable fromTable = new FromBaseTable(tableName, (String)optionalTableClauses[2], (ResultColumnList)optionalTableClauses[1], (Properties)optionalTableClauses[0], this.getContextManager());
            return fromTable;
        }
        if (this.getToken((int)1).kind == 453 && (this.getToken((int)2).kind == 225 || this.getToken((int)2).kind == 259)) {
            SubqueryNode derivedTable = this.derivedTable();
            switch (this.jj_nt.kind) {
                case 72: {
                    this.jj_consume_token(72);
                    break;
                }
                default: {
                    this.jj_la1[198] = this.jj_gen;
                }
            }
            correlationName = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 453: {
                    this.jj_consume_token(453);
                    derivedRCL = this.derivedColumnList();
                    this.jj_consume_token(454);
                    break;
                }
                default: {
                    this.jj_la1[199] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 59: {
                    optionalTableClauses = this.optionalTableProperties();
                    break;
                }
                default: {
                    this.jj_la1[200] = this.jj_gen;
                }
            }
            FromSubquery fromTable = new FromSubquery(derivedTable.getResultSet(), derivedTable.getOrderByList(), derivedTable.getOffset(), derivedTable.getFetchFirst(), derivedTable.hasJDBClimitClause(), correlationName, derivedRCL, optionalTableClauses != null ? (Properties)optionalTableClauses[0] : (Properties)null, this.getContextManager());
            return fromTable;
        }
        switch (this.jj_nt.kind) {
            case 453: {
                this.jj_consume_token(453);
                FromTable tableReference = this.tableReferenceTypes(true);
                this.jj_consume_token(454);
                FromTable fromTable = tableReference;
                return fromTable;
            }
        }
        this.jj_la1[201] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList derivedColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumns = new ResultColumnList(this.getContextManager());
        this.columnNameList(resultColumns);
        return resultColumns;
    }

    public final void columnNameList(ResultColumnList columnList) throws ParseException, StandardException {
        this.columnNameItem(columnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[202] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.columnNameItem(columnList);
        }
    }

    public final void columnNameItem(ResultColumnList columnList) throws ParseException, StandardException {
        String columnName = this.identifier(128, true);
        ResultColumn resultColumn = new ResultColumn(columnName, null, this.getContextManager());
        columnList.addResultColumn(resultColumn);
    }

    public final void indexColumnList(List<String> columnList) throws ParseException, StandardException {
        this.indexColumnItem(columnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[203] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.indexColumnItem(columnList);
        }
    }

    public final void indexColumnItem(List<String> columnList) throws ParseException, StandardException {
        String columnName = this.identifier(128, true);
        block0 : switch (this.jj_nt.kind) {
            case 73: 
            case 123: {
                switch (this.jj_nt.kind) {
                    case 73: {
                        this.jj_consume_token(73);
                        break block0;
                    }
                    case 123: {
                        this.jj_consume_token(123);
                        columnName = columnName + ' ';
                        break block0;
                    }
                }
                this.jj_la1[204] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[205] = this.jj_gen;
            }
        }
        columnList.add(columnName);
    }

    public final SubqueryNode derivedTable() throws ParseException, StandardException {
        this.jj_consume_token(453);
        SubqueryNode tableSubquery = this.tableSubquery(0, null);
        this.jj_consume_token(454);
        return tableSubquery;
    }

    public final TableOperatorNode joinedTableExpression(ResultSetNode leftRSN, boolean nestedInParens) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 107: {
                TableOperatorNode joinNode = this.crossJoin(leftRSN, nestedInParens);
                return joinNode;
            }
            case 163: 
            case 173: 
            case 177: 
            case 219: {
                TableOperatorNode joinNode = this.qualifiedJoin(leftRSN, nestedInParens);
                return joinNode;
            }
            case 186: {
                TableOperatorNode joinNode = this.naturalJoin(leftRSN, nestedInParens);
                return joinNode;
            }
        }
        this.jj_la1[206] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableOperatorNode crossJoin(ResultSetNode leftRSN, boolean nestedInParens) throws ParseException, StandardException {
        this.jj_consume_token(107);
        this.jj_consume_token(173);
        FromTable rightRSN = this.tableFactor();
        JoinNode ton = this.newJoinNode(leftRSN, rightRSN, null, null, 1);
        ton.setNestedInParens(nestedInParens);
        return ton;
    }

    public final TableOperatorNode qualifiedJoin(ResultSetNode leftRSN, boolean nestedInParens) throws ParseException, StandardException {
        int joinType = 1;
        JoinNode ton = null;
        Object[] onOrUsingClause = null;
        ResultColumnList usingClause = null;
        switch (this.jj_nt.kind) {
            case 163: 
            case 177: 
            case 219: {
                joinType = this.joinType();
                break;
            }
            default: {
                this.jj_la1[207] = this.jj_gen;
            }
        }
        this.jj_consume_token(173);
        FromTable rightRSN = this.tableReferenceTypes(nestedInParens);
        onOrUsingClause = this.joinSpecification(leftRSN, rightRSN);
        ValueNode onClause = (ValueNode)onOrUsingClause[0];
        usingClause = (ResultColumnList)onOrUsingClause[1];
        if (onClause == null && usingClause == null) {
            throw StandardException.newException("42Y11", JoinNode.joinTypeToString(joinType));
        }
        ton = this.newJoinNode(leftRSN, rightRSN, onClause, usingClause, joinType);
        ton.setNestedInParens(nestedInParens);
        return ton;
    }

    public final TableOperatorNode naturalJoin(ResultSetNode leftRSN, boolean nestedInParens) throws ParseException, StandardException {
        int joinType = 1;
        this.jj_consume_token(186);
        switch (this.jj_nt.kind) {
            case 163: 
            case 177: 
            case 219: {
                joinType = this.joinType();
                break;
            }
            default: {
                this.jj_la1[208] = this.jj_gen;
            }
        }
        this.jj_consume_token(173);
        FromTable rightRSN = this.tableFactor();
        JoinNode node = this.newJoinNode(leftRSN, rightRSN, null, null, joinType);
        node.setNestedInParens(nestedInParens);
        node.setNaturalJoin();
        return node;
    }

    public final int joinType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 163: {
                this.jj_consume_token(163);
                return 1;
            }
            case 177: 
            case 219: {
                int joinType = this.outerJoinType();
                switch (this.jj_nt.kind) {
                    case 201: {
                        this.jj_consume_token(201);
                        break;
                    }
                    default: {
                        this.jj_la1[209] = this.jj_gen;
                    }
                }
                return joinType;
            }
        }
        this.jj_la1[210] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int outerJoinType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 177: {
                this.jj_consume_token(177);
                return 3;
            }
            case 219: {
                this.jj_consume_token(219);
                return 4;
            }
        }
        this.jj_la1[211] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] joinSpecification(ResultSetNode leftRSN, ResultSetNode rightRSN) throws ParseException, StandardException {
        Object[] onOrUsingClause = new Object[2];
        ResultColumnList usingClause = null;
        ValueNode joinClause = null;
        switch (this.jj_nt.kind) {
            case 195: {
                joinClause = this.joinCondition();
                onOrUsingClause[0] = joinClause;
                onOrUsingClause[1] = usingClause;
                return onOrUsingClause;
            }
            case 257: {
                usingClause = this.namedColumnsJoin();
                onOrUsingClause[0] = joinClause;
                onOrUsingClause[1] = usingClause;
                return onOrUsingClause;
            }
        }
        this.jj_la1[212] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode joinCondition() throws ParseException, StandardException {
        this.jj_consume_token(195);
        ValueNode joinClause = this.valueExpression();
        return joinClause;
    }

    public final ResultColumnList namedColumnsJoin() throws ParseException, StandardException {
        ResultColumnList usingClause = new ResultColumnList(this.getContextManager());
        this.jj_consume_token(257);
        this.jj_consume_token(453);
        this.columnNameList(usingClause);
        this.jj_consume_token(454);
        return usingClause;
    }

    public final ResultSetNode tableValueConstructor() throws ParseException, StandardException {
        this.jj_consume_token(259);
        ResultSetNode resultSetNode = this.tableValueConstructorList();
        return resultSetNode;
    }

    public final ResultSetNode tableValueConstructorList() throws ParseException, StandardException {
        ResultSetNode resultSetNode = this.rowValueConstructor(null);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[213] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            resultSetNode = this.rowValueConstructor(resultSetNode);
        }
        if (resultSetNode instanceof UnionNode) {
            ((UnionNode)resultSetNode).markTopTableConstructor();
        }
        return resultSetNode;
    }

    public final ValueNode datetimeValueFunction() throws ParseException, StandardException {
        int prec = -1;
        if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 285) {
            this.jj_consume_token(108);
            this.jj_consume_token(285);
            return new CurrentDatetimeOperatorNode(0, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 109: {
                this.jj_consume_token(109);
                return new CurrentDatetimeOperatorNode(0, this.getContextManager());
            }
        }
        this.jj_la1[214] = this.jj_gen;
        if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 350) {
            this.jj_consume_token(108);
            this.jj_consume_token(350);
            return new CurrentDatetimeOperatorNode(1, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 110: {
                this.jj_consume_token(110);
                return new CurrentDatetimeOperatorNode(1, this.getContextManager());
            }
        }
        this.jj_la1[215] = this.jj_gen;
        if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 351) {
            this.jj_consume_token(108);
            this.jj_consume_token(351);
            return new CurrentDatetimeOperatorNode(2, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 111: {
                this.jj_consume_token(111);
                return new CurrentDatetimeOperatorNode(2, this.getContextManager());
            }
        }
        this.jj_la1[216] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode windowOrAggregateFunctionNode() throws ParseException, StandardException {
        WindowNode window = null;
        AggregateNode agg = null;
        switch (this.jj_nt.kind) {
            case 105: {
                this.jj_consume_token(105);
                this.jj_consume_token(453);
                switch (this.jj_nt.kind) {
                    case 455: {
                        this.jj_consume_token(455);
                        agg = new AggregateNode(null, CountAggregateDefinition.class, false, "COUNT(*)", this.getContextManager());
                        break;
                    }
                    default: {
                        this.jj_la1[217] = this.jj_gen;
                        if (this.jj_2_61(1)) {
                            agg = this.aggregateExpression("COUNT", CountAggregateDefinition.class);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(454);
                if (this.jj_2_62(1)) {
                    window = this.overClause();
                }
                if (window != null) {
                    return new AggregateWindowFunctionNode(window, agg, this.getContextManager());
                }
                return agg;
            }
            case 77: 
            case 181: 
            case 182: 
            case 236: {
                agg = this.generalAggregate();
                if (this.jj_2_63(1)) {
                    window = this.overClause();
                }
                if (window != null) {
                    return new AggregateWindowFunctionNode(window, agg, this.getContextManager());
                }
                return agg;
            }
            case 374: {
                this.jj_consume_token(374);
                this.jj_consume_token(453);
                this.jj_consume_token(454);
                window = this.overClause();
                return new RowNumberFunctionNode(null, window, this.getContextManager());
            }
        }
        this.jj_la1[218] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final WindowNode overClause() throws ParseException, StandardException {
        OrderByList orderCols = null;
        if (this.getToken((int)2).kind != 453 && this.getToken((int)2).kind != 480) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(372);
        switch (this.jj_nt.kind) {
            case 453: {
                this.jj_consume_token(453);
                switch (this.jj_nt.kind) {
                    case 200: {
                        orderCols = this.orderByClause(null);
                        break;
                    }
                    default: {
                        this.jj_la1[219] = this.jj_gen;
                    }
                }
                this.jj_consume_token(454);
                return new WindowDefinitionNode(null, orderCols, this.getContextManager());
            }
        }
        this.jj_la1[220] = this.jj_gen;
        if (this.jj_2_64(1)) {
            String windowRef = this.identifier(128, true);
            return new WindowReferenceNode(windowRef, this.getContextManager());
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AggregateNode aggregateExpression(String aggName, Class aggClass) throws ParseException, StandardException {
        boolean distinct = false;
        if (this.jj_2_65(1)) {
            distinct = this.setQuantifier();
        }
        ValueNode value = this.additiveExpression(null, 0);
        return new AggregateNode(value, aggClass, distinct, aggName, this.getContextManager());
    }

    public final AggregateNode generalAggregate() throws ParseException, StandardException {
        Token aggToken = this.builtInAggregateType();
        this.jj_consume_token(453);
        AggregateNode aggExpr = this.aggregateExpression(SQLParser.aggName(aggToken), SQLParser.aggClass(aggToken));
        this.jj_consume_token(454);
        return aggExpr;
    }

    public final Token builtInAggregateType() throws ParseException, StandardException {
        Token retval;
        switch (this.jj_nt.kind) {
            case 181: {
                retval = this.jj_consume_token(181);
                break;
            }
            case 77: {
                retval = this.jj_consume_token(77);
                break;
            }
            case 182: {
                retval = this.jj_consume_token(182);
                break;
            }
            case 236: {
                retval = this.jj_consume_token(236);
                break;
            }
            default: {
                this.jj_la1[221] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return retval;
    }

    public final ValueNode castSpecification() throws ParseException, StandardException {
        int length = -1;
        TableName[] udtName = new TableName[1];
        this.jj_consume_token(87);
        this.jj_consume_token(453);
        ValueNode value = this.castOperand();
        this.jj_consume_token(72);
        DataTypeDescriptor dts = this.dataTypeCast(udtName);
        this.jj_consume_token(454);
        CastNode castNode = new CastNode(value, dts, this.getContextManager());
        castNode.setForExternallyGeneratedCASTnode();
        castNode.setTargetUDTName(udtName[0]);
        ValueNode treeTop = castNode;
        if (dts.getTypeId().userType()) {
            treeTop = new JavaToSQLValueNode(new SQLToJavaValueNode(treeTop, this.getContextManager()), this.getContextManager());
        }
        return treeTop;
    }

    public final ValueNode nextValueExpression() throws ParseException, StandardException {
        this.jj_consume_token(188);
        this.jj_consume_token(258);
        this.jj_consume_token(144);
        TableName sequenceName = this.qualifiedName(128);
        this.checkVersion(180, "NEXT VALUE");
        return new NextSequenceNode(sequenceName, this.getContextManager());
    }

    public final int charOrVarchar() throws ParseException {
        switch (this.jj_nt.kind) {
            case 88: {
                this.jj_consume_token(88);
                return 1;
            }
            case 261: {
                this.jj_consume_token(261);
                return 12;
            }
        }
        this.jj_la1[222] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode castOperand() throws ParseException, StandardException {
        if (this.jj_2_66(1)) {
            ValueNode value = this.additiveExpression(null, 0);
            return value;
        }
        switch (this.jj_nt.kind) {
            case 191: {
                this.jj_consume_token(191);
                return new UntypedNullConstantNode(this.getContextManager());
            }
        }
        this.jj_la1[223] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ParameterNode dynamicParameterSpecification() throws ParseException, StandardException {
        this.jj_consume_token(472);
        return this.makeParameterNode();
    }

    public final ValueNode whereClause(Token beginToken) throws ParseException, StandardException {
        ValueNode value = this.valueExpression();
        Token endToken = this.getToken(0);
        value.setBeginOffset(beginToken.endOffset + 1);
        value.setEndOffset(endToken.endOffset);
        return value;
    }

    public final GroupByList groupByClause() throws ParseException, StandardException {
        this.jj_consume_token(155);
        this.jj_consume_token(83);
        if (this.getToken((int)1).kind == 331 && this.getToken((int)2).kind == 453) {
            this.jj_consume_token(331);
            this.jj_consume_token(453);
            GroupByList groupingCols = this.groupingColumnReferenceList();
            this.jj_consume_token(454);
            groupingCols.setRollup();
            return groupingCols;
        }
        if (this.jj_2_67(1)) {
            GroupByList groupingCols = this.groupingColumnReferenceList();
            return groupingCols;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final GroupByList groupingColumnReferenceList() throws ParseException, StandardException {
        GroupByList groupingCols = new GroupByList(this.getContextManager());
        this.groupingColumnReference(groupingCols);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[224] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.groupingColumnReference(groupingCols);
        }
        return groupingCols;
    }

    public final void groupingColumnReference(GroupByList groupingCols) throws ParseException, StandardException {
        ValueNode columnExpression = this.additiveExpression(null, 0);
        HasNodeVisitor visitor = new HasNodeVisitor(AggregateNode.class);
        columnExpression.accept(visitor);
        if (visitor.hasNode()) {
            throw StandardException.newException("42Y26.S.0", new Object[0]);
        }
        CollectNodesVisitor<StaticMethodCallNode> functionSniffer = new CollectNodesVisitor<StaticMethodCallNode>(StaticMethodCallNode.class);
        columnExpression.accept(functionSniffer);
        for (StaticMethodCallNode node : functionSniffer.getList()) {
            node.setAppearsInGroupBy();
        }
        if (columnExpression.isParameterNode()) {
            throw StandardException.newException("42X01", "?");
        }
        groupingCols.addGroupByColumn(new GroupByColumn(columnExpression, this.getContextManager()));
    }

    public final ValueNode havingClause() throws ParseException, StandardException {
        this.jj_consume_token(156);
        ValueNode value = this.valueExpression();
        return value;
    }

    public final WindowList windowClause() throws ParseException, StandardException {
        WindowList windows = new WindowList(this.getContextManager());
        this.jj_consume_token(266);
        windows = this.windowDefinition(windows);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[225] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            windows = this.windowDefinition(windows);
        }
        return windows;
    }

    public final WindowList windowDefinition(WindowList wl) throws ParseException, StandardException {
        OrderByList orderCols = null;
        String windowName = this.identifier(128, true);
        this.jj_consume_token(72);
        this.jj_consume_token(453);
        switch (this.jj_nt.kind) {
            case 200: {
                orderCols = this.orderByClause(null);
                break;
            }
            default: {
                this.jj_la1[226] = this.jj_gen;
            }
        }
        this.jj_consume_token(454);
        wl.addWindow(new WindowDefinitionNode(windowName, orderCols, this.getContextManager()));
        return wl;
    }

    public final OptimizerPlan optimizerOverridePlan() throws ParseException, StandardException {
        this.jj_consume_token(359);
        OptimizerPlan optimizerOverridePlan = this.optimizerPlan();
        return optimizerOverridePlan;
    }

    public final OptimizerPlan optimizerPlan() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 453) {
            OptimizerPlan plan = this.optimizerJoin();
            return plan;
        }
        if (this.jj_2_68(1)) {
            OptimizerPlan plan = this.optimizerRowSource();
            return plan;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final OptimizerPlan optimizerJoin() throws ParseException, StandardException {
        this.jj_consume_token(453);
        OptimizerPlan leftPlan = this.optimizerPlan();
        JoinStrategy strategy = this.joinStrategy();
        OptimizerPlan rightPlan = this.optimizerPlan();
        this.jj_consume_token(454);
        return new OptimizerPlan.Join(strategy, leftPlan, rightPlan);
    }

    public final JoinStrategy joinStrategy() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 455: {
                this.jj_consume_token(455);
                return new NestedLoopJoinStrategy();
            }
            case 456: {
                this.jj_consume_token(456);
                return new HashJoinStrategy();
            }
        }
        this.jj_la1[227] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final OptimizerPlan optimizerRowSource() throws ParseException, StandardException {
        TableName sourceName = null;
        Token leftParenToken = null;
        sourceName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 453: {
                leftParenToken = this.jj_consume_token(453);
                this.jj_consume_token(454);
                break;
            }
            default: {
                this.jj_la1[228] = this.jj_gen;
            }
        }
        if (leftParenToken != null) {
            return new OptimizerPlan.TableFunctionRS(sourceName.getSchemaName(), sourceName.getTableName());
        }
        return new OptimizerPlan.ConglomerateRS(sourceName.getSchemaName(), sourceName.getTableName());
    }

    public final StatementNode schemaDefinition() throws ParseException, StandardException {
        String schemaName = null;
        String authName = null;
        this.jj_consume_token(222);
        if (this.jj_2_69(1)) {
            schemaName = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 76: {
                    this.jj_consume_token(76);
                    authName = this.identifier(128, true);
                    break;
                }
                default: {
                    this.jj_la1[229] = this.jj_gen;
                }
            }
            if (authName != null) {
                this.checkVersion(140, "AUTHORIZATION");
            }
            if (schemaName.startsWith("SYS")) {
                throw StandardException.newException("42939", schemaName);
            }
            return new CreateSchemaNode(schemaName, authName, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 76: {
                this.jj_consume_token(76);
                authName = this.identifier(128, true);
                this.checkVersion(140, "AUTHORIZATION");
                if (authName.startsWith("SYS")) {
                    throw StandardException.newException("42939", authName);
                }
                return new CreateSchemaNode(authName, authName, this.getContextManager());
            }
        }
        this.jj_la1[230] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode roleDefinition() throws ParseException, StandardException {
        String roleName = null;
        this.jj_consume_token(373);
        roleName = this.identifier(128, true);
        this.checkVersion(170, "ROLES");
        this.checkSqlStandardAccess("CREATE ROLE");
        if (roleName.startsWith("SYS")) {
            throw StandardException.newException("4293A", roleName);
        }
        return new CreateRoleNode(roleName, this.getContextManager());
    }

    public final StatementNode sequenceDefinition() throws ParseException, StandardException {
        TableName qualifiedSequenceName = null;
        DataTypeDescriptor dtd = null;
        Long initialValue = null;
        Long stepValue = null;
        Long maxValue = null;
        Long minValue = null;
        Boolean cycle = Boolean.FALSE;
        Object[] optionalClauses = new Object[6];
        this.jj_consume_token(432);
        qualifiedSequenceName = this.qualifiedName(128);
        while (this.jj_2_70(1)) {
            this.sequenceGeneratorOption(optionalClauses);
        }
        this.checkVersion(180, "SEQUENCES");
        if (optionalClauses[0] != null) {
            dtd = (DataTypeDescriptor)optionalClauses[0];
        }
        if (optionalClauses[1] != null) {
            initialValue = (Long)optionalClauses[1];
        }
        if (optionalClauses[2] != null) {
            stepValue = (Long)optionalClauses[2];
        }
        if (optionalClauses[3] != null && !(optionalClauses[3] instanceof Boolean)) {
            maxValue = (Long)optionalClauses[3];
        }
        if (optionalClauses[4] != null && !(optionalClauses[4] instanceof Boolean)) {
            minValue = (Long)optionalClauses[4];
        }
        if (optionalClauses[5] != null) {
            cycle = (Boolean)optionalClauses[5];
        }
        return new CreateSequenceNode(qualifiedSequenceName, dtd, initialValue, stepValue, maxValue, minValue, cycle, this.getContextManager());
    }

    public final void sequenceGeneratorOption(Object[] optionalClauses) throws ParseException, StandardException {
        Serializable option = null;
        int optionIndex = -1;
        Boolean[] cycleOption = new Boolean[1];
        Object optionName = null;
        Token optionToken = null;
        block0 : switch (this.jj_nt.kind) {
            case 72: {
                optionToken = this.jj_consume_token(72);
                option = this.exactIntegerType();
                optionIndex = 0;
                break;
            }
            case 346: {
                optionToken = this.jj_consume_token(346);
                this.jj_consume_token(267);
                option = this.exactIntegerObject();
                optionIndex = 1;
                break;
            }
            case 294: {
                optionToken = this.jj_consume_token(294);
                this.jj_consume_token(83);
                option = this.exactIntegerObject();
                optionIndex = 2;
                break;
            }
            default: {
                this.jj_la1[233] = this.jj_gen;
                if (this.jj_2_71(1)) {
                    switch (this.jj_nt.kind) {
                        case 308: {
                            optionToken = this.jj_consume_token(308);
                            option = this.exactIntegerObject();
                            break;
                        }
                        default: {
                            this.jj_la1[231] = this.jj_gen;
                            if (this.getToken((int)2).kind == 308) {
                                this.jj_consume_token(189);
                                optionToken = this.jj_consume_token(308);
                                option = Boolean.FALSE;
                                break;
                            }
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    optionIndex = 3;
                    break;
                }
                if (this.jj_2_72(1)) {
                    switch (this.jj_nt.kind) {
                        case 310: {
                            optionToken = this.jj_consume_token(310);
                            option = this.exactIntegerObject();
                            break;
                        }
                        default: {
                            this.jj_la1[232] = this.jj_gen;
                            if (this.getToken((int)2).kind == 310) {
                                this.jj_consume_token(189);
                                optionToken = this.jj_consume_token(310);
                                option = Boolean.FALSE;
                                break;
                            }
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    optionIndex = 4;
                    break;
                }
                switch (this.jj_nt.kind) {
                    case 189: 
                    case 283: {
                        optionToken = this.cycleClause(cycleOption);
                        option = cycleOption[0];
                        optionIndex = 5;
                        break block0;
                    }
                }
                this.jj_la1[234] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (optionIndex != -1) {
            if (optionalClauses[optionIndex] != null) {
                throw StandardException.newException("42XAJ", optionToken.image);
            }
            optionalClauses[optionIndex] = option;
        }
    }

    public final Token cycleClause(Boolean[] cycleOption) throws ParseException, StandardException {
        Token token = null;
        switch (this.jj_nt.kind) {
            case 283: {
                token = this.jj_consume_token(283);
                cycleOption[0] = Boolean.TRUE;
                return token;
            }
            case 189: {
                this.jj_consume_token(189);
                token = this.jj_consume_token(283);
                cycleOption[0] = Boolean.FALSE;
                return token;
            }
        }
        this.jj_la1[235] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Long exactIntegerObject() throws ParseException, StandardException {
        long exactNumeric = this.exactNumber();
        return exactNumeric;
    }

    public final Long stepValue() throws ParseException, StandardException {
        this.jj_consume_token(294);
        this.jj_consume_token(83);
        long stepValue = this.exactNumber();
        return stepValue;
    }

    public final StatementNode dropSequenceStatement() throws ParseException, StandardException {
        this.jj_consume_token(432);
        TableName sequenceName = this.qualifiedName(128);
        this.jj_consume_token(217);
        this.checkVersion(180, "SEQUENCES");
        return new DropSequenceNode(sequenceName, this.getContextManager());
    }

    public final StatementNode tableDefinition() throws ParseException, StandardException {
        char lockGranularity = 'R';
        Properties properties = null;
        ResultColumnList resultColumns = null;
        boolean withData = true;
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        if (this.getToken((int)1).kind == 453 && this.getToken((int)3).kind != 458 && this.getToken((int)3).kind != 454) {
            TableElementList tableElementList = this.tableElementList();
            switch (this.jj_nt.kind) {
                case 59: {
                    properties = this.propertyList(false);
                    this.jj_consume_token(64);
                    break;
                }
                default: {
                    this.jj_la1[236] = this.jj_gen;
                }
            }
            return new CreateTableNode(tableName, tableElementList, properties, lockGranularity, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 72: 
            case 453: {
                switch (this.jj_nt.kind) {
                    case 453: {
                        this.jj_consume_token(453);
                        resultColumns = this.tableColumnList();
                        this.jj_consume_token(454);
                        break;
                    }
                    default: {
                        this.jj_la1[237] = this.jj_gen;
                    }
                }
                this.jj_consume_token(72);
                ResultSetNode queryExpression = this.queryExpression(null, 0);
                this.jj_consume_token(267);
                switch (this.jj_nt.kind) {
                    case 189: {
                        this.jj_consume_token(189);
                        withData = false;
                        break;
                    }
                    default: {
                        this.jj_la1[238] = this.jj_gen;
                    }
                }
                this.jj_consume_token(284);
                if (withData) {
                    throw StandardException.newException("0A000.S", "WITH DATA");
                }
                HasNodeVisitor visitor = new HasNodeVisitor(ParameterNode.class);
                queryExpression.accept(visitor);
                if (visitor.hasNode()) {
                    throw StandardException.newException("42X99", new Object[0]);
                }
                return new CreateTableNode(tableName, resultColumns, queryExpression, this.getContextManager());
            }
        }
        this.jj_la1[239] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList tableColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumns = new ResultColumnList(this.getContextManager());
        this.columnNameList(resultColumns);
        return resultColumns;
    }

    public final Properties propertyList(boolean propertiesUseAllowed) throws ParseException, StandardException {
        FormatableProperties properties = new FormatableProperties();
        this.jj_consume_token(59);
        StringTokenizer commaSeparatedProperties = new StringTokenizer(this.getToken((int)1).image, ",");
        while (commaSeparatedProperties.hasMoreTokens()) {
            String currentProperty = commaSeparatedProperties.nextToken();
            StringTokenizer equalOperatorSeparatedProperty = new StringTokenizer(currentProperty, "=", true);
            if (equalOperatorSeparatedProperty.countTokens() != 3) {
                throw StandardException.newException("XCY04.S", new Object[0]);
            }
            String key = equalOperatorSeparatedProperty.nextToken().trim();
            if (!equalOperatorSeparatedProperty.nextToken().equals("=")) {
                throw StandardException.newException("XCY04.S", new Object[0]);
            }
            String value = equalOperatorSeparatedProperty.nextToken().trim();
            SQLParser.verifyImageLength(value);
            if (properties.put(key, value = value.startsWith("'") && value.endsWith("'") ? StringUtil.compressQuotes(value.substring(1, value.length() - 1), SINGLEQUOTES) : (value.startsWith("\"") && value.endsWith("\"") ? StringUtil.compressQuotes(value.substring(1, value.length() - 1), DOUBLEQUOTES) : value.toUpperCase())) == null) continue;
            throw StandardException.newException("42Y49", key);
        }
        if (!propertiesUseAllowed) {
            this.checkInternalFeature("DERBY-PROPERTIES");
        }
        return properties;
    }

    public final char DB2lockGranularityClause() throws ParseException, StandardException {
        this.jj_consume_token(305);
        char lockGranularity = this.lockGranularity();
        return lockGranularity;
    }

    public final char lockGranularity() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 239: {
                this.jj_consume_token(239);
                return 'T';
            }
            case 332: {
                this.jj_consume_token(332);
                return 'R';
            }
        }
        this.jj_la1[240] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode indexDefinition() throws ParseException, StandardException {
        Boolean unique = Boolean.FALSE;
        Properties properties = null;
        ArrayList<String> indexColumnList = new ArrayList<String>();
        switch (this.jj_nt.kind) {
            case 252: {
                unique = this.unique();
                break;
            }
            default: {
                this.jj_la1[241] = this.jj_gen;
            }
        }
        this.jj_consume_token(400);
        TableName indexName = this.qualifiedName(128);
        this.jj_consume_token(195);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(453);
        this.indexColumnList(indexColumnList);
        this.jj_consume_token(454);
        switch (this.jj_nt.kind) {
            case 59: {
                properties = this.propertyList(false);
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[242] = this.jj_gen;
            }
        }
        if (indexName.getSchemaName() == null) {
            indexName.setSchemaName(tableName.getSchemaName());
        } else if (tableName.getSchemaName() == null) {
            tableName.setSchemaName(indexName.getSchemaName());
        } else if (!indexName.getSchemaName().equals(tableName.getSchemaName())) {
            throw StandardException.newException("X0Y26.S", indexName, tableName);
        }
        return new CreateIndexNode(unique, DEFAULT_INDEX_TYPE, indexName, tableName, indexColumnList, properties, this.getContextManager());
    }

    public final Boolean unique() throws ParseException, StandardException {
        this.jj_consume_token(252);
        return Boolean.TRUE;
    }

    public final StatementNode procedureDefinition() throws ParseException, StandardException {
        Object[] procedureElements = new Object[12];
        this.jj_consume_token(211);
        TableName procedureName = this.qualifiedName(128);
        procedureElements[0] = this.procedureParameterList(procedureElements);
        block3: while (true) {
            this.routineElement(true, false, procedureElements);
            switch (this.jj_nt.kind) {
                case 139: 
                case 189: 
                case 190: 
                case 277: 
                case 282: 
                case 288: 
                case 289: 
                case 299: 
                case 312: 
                case 330: 
                case 417: 
                case 421: 
                case 426: 
                case 437: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[243] = this.jj_gen;
        this.checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, procedureElements);
        return this.getCreateAliasNode(procedureName, (String)procedureElements[4], procedureElements, 'P');
    }

    public final void routineElement(boolean isProcedure, boolean isTableFunction, Object[] routineElements) throws ParseException, StandardException {
        int clausePosition = -1;
        Object clauseValue = null;
        block0 : switch (this.jj_nt.kind) {
            case 437: {
                this.jj_consume_token(437);
                clauseValue = this.qualifiedName(128);
                clausePosition = 1;
                throw StandardException.newException("0A000.S", "SPECIFIC identifier");
            }
            case 289: 
            case 426: {
                switch (this.jj_nt.kind) {
                    case 289: {
                        this.jj_consume_token(289);
                        break;
                    }
                    default: {
                        this.jj_la1[244] = this.jj_gen;
                    }
                }
                this.jj_consume_token(426);
                this.jj_consume_token(434);
                int drs = this.uint_value();
                if (!isProcedure) {
                    throw StandardException.newException("42X01", "RESULT SETS");
                }
                clauseValue = ReuseFactory.getInteger(drs);
                clausePosition = 2;
                break;
            }
            case 299: {
                this.jj_consume_token(299);
                this.jj_consume_token(402);
                clauseValue = "JAVA";
                clausePosition = 3;
                break;
            }
            case 288: {
                this.jj_consume_token(288);
                clauseValue = Boolean.TRUE;
                clausePosition = 7;
                this.checkVersion(170, "DETERMINISTIC");
                break;
            }
            case 190: {
                this.jj_consume_token(190);
                this.jj_consume_token(288);
                clauseValue = Boolean.FALSE;
                clausePosition = 7;
                this.checkVersion(170, "DETERMINISTIC");
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                switch (this.jj_nt.kind) {
                    case 317: {
                        this.jj_consume_token(317);
                        clauseValue = this.string();
                        clausePosition = 4;
                        break block0;
                    }
                    case 335: {
                        this.jj_consume_token(335);
                        this.checkVersion(190, "EXTERNAL SECURITY");
                        this.checkSqlStandardAccess("EXTERNAL SECURITY");
                        clauseValue = new Boolean(this.routineSecurityClause());
                        clausePosition = 10;
                        break block0;
                    }
                }
                this.jj_la1[245] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 417: {
                this.jj_consume_token(417);
                this.jj_consume_token(441);
                clauseValue = this.parameterStyle(isTableFunction);
                clausePosition = 5;
                break;
            }
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(231);
                clauseValue = ReuseFactory.getShort((short)3);
                clausePosition = 6;
                break;
            }
            case 282: {
                this.jj_consume_token(282);
                this.jj_consume_token(231);
                clauseValue = ReuseFactory.getShort((short)2);
                clausePosition = 6;
                break;
            }
            case 421: {
                this.jj_consume_token(421);
                this.jj_consume_token(231);
                this.jj_consume_token(284);
                clauseValue = ReuseFactory.getShort((short)1);
                clausePosition = 6;
                break;
            }
            case 312: {
                this.jj_consume_token(312);
                this.jj_consume_token(231);
                this.jj_consume_token(284);
                if (!isProcedure) {
                    throw StandardException.newException("42X01", "MODIFIES SQL DATA");
                }
                clauseValue = ReuseFactory.getShort((short)0);
                clausePosition = 6;
                break;
            }
            case 277: 
            case 330: {
                clauseValue = this.calledOnNullInput(isProcedure);
                clausePosition = 8;
                break;
            }
            default: {
                this.jj_la1[246] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (clausePosition != -1) {
            if (routineElements[clausePosition] != null) {
                String which = ROUTINE_CLAUSE_NAMES[clausePosition];
                throw StandardException.newException("42613", which);
            }
            routineElements[clausePosition] = clauseValue;
        }
    }

    public final Boolean calledOnNullInput(boolean isProcedure) throws ParseException, StandardException {
        Boolean calledOnNull;
        switch (this.jj_nt.kind) {
            case 277: {
                this.jj_consume_token(277);
                calledOnNull = Boolean.TRUE;
                break;
            }
            case 330: {
                this.jj_consume_token(330);
                this.jj_consume_token(191);
                if (isProcedure) {
                    throw StandardException.newException("42X01", "RETURNS NULL ON NULL INPUT");
                }
                calledOnNull = Boolean.FALSE;
                break;
            }
            default: {
                this.jj_la1[247] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(195);
        this.jj_consume_token(191);
        this.jj_consume_token(164);
        return calledOnNull;
    }

    public final boolean routineSecurityClause() throws ParseException, StandardException {
        boolean result = false;
        switch (this.jj_nt.kind) {
            case 298: {
                this.jj_consume_token(298);
                result = false;
                break;
            }
            case 287: {
                this.jj_consume_token(287);
                result = true;
                break;
            }
            default: {
                this.jj_la1[248] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final Short parameterStyle(boolean isTableFunction) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 402: {
                this.jj_consume_token(402);
                if (isTableFunction) {
                    throw StandardException.newException("42ZB2", new Object[0]);
                }
                return ReuseFactory.getShort((short)0);
            }
            case 392: {
                this.jj_consume_token(392);
                if (!isTableFunction) {
                    throw StandardException.newException("42ZB1", new Object[0]);
                }
                return ReuseFactory.getShort((short)1);
            }
            case 391: {
                this.jj_consume_token(391);
                this.checkVersion(220, "DERBY");
                if (isTableFunction) {
                    throw StandardException.newException("42ZB2", new Object[0]);
                }
                return ReuseFactory.getShort((short)2);
            }
        }
        this.jj_la1[249] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] procedureParameterList(Object[] procedureElements) throws ParseException, StandardException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<TypeDescriptor> types = new ArrayList<TypeDescriptor>();
        ArrayList<Integer> inOut = new ArrayList<Integer>();
        Object[] result = new Object[3];
        Boolean ellipsis = null;
        this.jj_consume_token(453);
        if (this.jj_2_73(1)) {
            this.procedureParameterDefinition(names, types, inOut);
            block6: while (true) {
                switch (this.jj_nt.kind) {
                    case 458: {
                        break;
                    }
                    default: {
                        this.jj_la1[250] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(458);
                this.procedureParameterDefinition(names, types, inOut);
            }
            switch (this.jj_nt.kind) {
                case 479: {
                    ellipsis = this.ellipsis();
                    break;
                }
                default: {
                    this.jj_la1[251] = this.jj_gen;
                }
            }
        }
        this.jj_consume_token(454);
        procedureElements[11] = ellipsis;
        result[0] = names;
        result[1] = types;
        result[2] = inOut;
        return result;
    }

    public final void procedureParameterDefinition(List<String> names, List<TypeDescriptor> types, List<Integer> inOut) throws ParseException, StandardException {
        String parameterName = "";
        Integer inout = this.inoutParameter();
        if (this.dataTypeCheck(2)) {
            parameterName = this.identifier(128, true);
        }
        DataTypeDescriptor typeDescriptor = this.dataTypeDDL();
        names.add(parameterName);
        types.add(typeDescriptor.getCatalogType());
        inOut.add(inout);
    }

    public final Integer inoutParameter() throws ParseException {
        int mode = 1;
        block0 : switch (this.jj_nt.kind) {
            case 160: 
            case 296: 
            case 416: {
                switch (this.jj_nt.kind) {
                    case 160: {
                        this.jj_consume_token(160);
                        break block0;
                    }
                    case 416: {
                        this.jj_consume_token(416);
                        mode = 4;
                        break block0;
                    }
                    case 296: {
                        this.jj_consume_token(296);
                        mode = 2;
                        break block0;
                    }
                }
                this.jj_la1[252] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[253] = this.jj_gen;
            }
        }
        return ReuseFactory.getInteger(mode);
    }

    public final StatementNode functionDefinition() throws ParseException, StandardException {
        Object[] functionElements = new Object[12];
        this.jj_consume_token(149);
        TableName functionName = this.qualifiedName(128);
        functionElements[0] = this.functionParameterList(functionElements);
        this.jj_consume_token(330);
        TypeDescriptor returnType = this.functionReturnDataType();
        block3: while (true) {
            this.routineElement(false, returnType.isRowMultiSet(), functionElements);
            switch (this.jj_nt.kind) {
                case 139: 
                case 189: 
                case 190: 
                case 277: 
                case 282: 
                case 288: 
                case 289: 
                case 299: 
                case 312: 
                case 330: 
                case 417: 
                case 421: 
                case 426: 
                case 437: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[254] = this.jj_gen;
        functionElements[9] = returnType;
        this.checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, functionElements);
        return this.getCreateAliasNode(functionName, (String)functionElements[4], functionElements, 'F');
    }

    public final Object[] functionParameterList(Object[] functionElements) throws ParseException, StandardException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<TypeDescriptor> types = new ArrayList<TypeDescriptor>();
        ArrayList<Integer> inOut = new ArrayList<Integer>();
        Object[] result = new Object[3];
        Boolean ellipsis = null;
        this.jj_consume_token(453);
        if (this.jj_2_74(1)) {
            this.functionParameterDefinition(names, types, inOut);
            block6: while (true) {
                switch (this.jj_nt.kind) {
                    case 458: {
                        break;
                    }
                    default: {
                        this.jj_la1[255] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(458);
                this.functionParameterDefinition(names, types, inOut);
            }
            switch (this.jj_nt.kind) {
                case 479: {
                    ellipsis = this.ellipsis();
                    break;
                }
                default: {
                    this.jj_la1[256] = this.jj_gen;
                }
            }
        }
        this.jj_consume_token(454);
        functionElements[11] = ellipsis;
        result[0] = names;
        result[1] = types;
        result[2] = inOut;
        return result;
    }

    public final Boolean ellipsis() throws ParseException, StandardException {
        this.jj_consume_token(479);
        this.checkVersion(220, "...");
        return Boolean.TRUE;
    }

    public final void functionParameterDefinition(List<String> names, List<TypeDescriptor> types, List<Integer> inOut) throws ParseException, StandardException {
        String parameterName = "";
        if (this.dataTypeCheck(2)) {
            parameterName = this.identifier(128, true);
        }
        DataTypeDescriptor typeDescriptor = this.dataTypeDDL();
        names.add(parameterName);
        types.add(typeDescriptor.getCatalogType());
        inOut.add(ReuseFactory.getInteger(1));
    }

    public final TypeDescriptor functionReturnDataType() throws ParseException, StandardException {
        TypeDescriptor typeDescriptor;
        if (this.jj_2_75(1)) {
            typeDescriptor = this.catalogType();
        } else {
            switch (this.jj_nt.kind) {
                case 239: {
                    typeDescriptor = this.functionTableType();
                    break;
                }
                default: {
                    this.jj_la1[257] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return typeDescriptor;
    }

    public final TypeDescriptor functionTableType() throws ParseException, StandardException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<TypeDescriptor> types = new ArrayList<TypeDescriptor>();
        this.jj_consume_token(239);
        this.jj_consume_token(453);
        this.functionTableReturnColumn(names, types);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[258] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.functionTableReturnColumn(names, types);
        }
        this.jj_consume_token(454);
        this.checkVersion(160, "CREATE FUNCTION...RETURNS TABLE");
        int columnCount = names.size();
        String[] nameArray = new String[columnCount];
        names.toArray(nameArray);
        TypeDescriptor[] typeArray = new TypeDescriptor[columnCount];
        types.toArray(typeArray);
        for (int i = 0; i < columnCount; ++i) {
            if (typeArray[i].getJDBCTypeId() != 2009) continue;
            throw StandardException.newException("42ZB3", new Object[0]);
        }
        return DataTypeDescriptor.getRowMultiSet(nameArray, typeArray);
    }

    public final void functionTableReturnColumn(ArrayList<String> names, ArrayList<TypeDescriptor> types) throws ParseException, StandardException {
        String name = this.identifier(128, true);
        DataTypeDescriptor typeDescriptor = this.dataTypeDDL();
        names.add(name);
        types.add(typeDescriptor.getCatalogType());
    }

    public final StatementNode udtDefinition() throws ParseException, StandardException {
        this.jj_consume_token(355);
        TableName udtName = this.qualifiedName(128);
        this.jj_consume_token(139);
        this.jj_consume_token(317);
        String externalName = this.string();
        this.jj_consume_token(299);
        this.jj_consume_token(402);
        this.checkVersion(180, "CREATE TYPE");
        return this.getCreateAliasNode(udtName, externalName, null, 'A');
    }

    public final StatementNode aggregateDefinition() throws ParseException, StandardException {
        DataTypeDescriptor returnType = null;
        Object[] aggElements = new Object[2];
        this.jj_consume_token(391);
        this.jj_consume_token(383);
        TableName aggregateName = this.qualifiedName(128);
        this.jj_consume_token(144);
        DataTypeDescriptor forType = this.dataTypeDDL();
        switch (this.jj_nt.kind) {
            case 330: {
                this.jj_consume_token(330);
                returnType = this.dataTypeDDL();
                break;
            }
            default: {
                this.jj_la1[259] = this.jj_gen;
            }
        }
        this.jj_consume_token(139);
        this.jj_consume_token(317);
        String externalName = this.string();
        this.checkVersion(220, "CREATE DERBY AGGREGATE");
        if (returnType == null) {
            returnType = forType;
        }
        aggElements[0] = forType.getCatalogType();
        aggElements[1] = returnType.getCatalogType();
        return this.getCreateAliasNode(aggregateName, externalName, aggElements, 'G');
    }

    public final StatementNode viewDefinition(Token beginToken) throws ParseException, StandardException {
        ResultColumnList resultColumns = null;
        Object checkTok = null;
        OrderByList orderCols = null;
        ValueNode[] offsetClauses = new ValueNode[2];
        boolean hasJDBClimitClause = false;
        this.jj_consume_token(263);
        TableName tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 453: {
                this.jj_consume_token(453);
                resultColumns = this.viewColumnList();
                this.jj_consume_token(454);
                break;
            }
            default: {
                this.jj_la1[260] = this.jj_gen;
            }
        }
        this.jj_consume_token(72);
        ResultSetNode queryExpression = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 200: {
                orderCols = this.orderByClause(queryExpression);
                break;
            }
            default: {
                this.jj_la1[261] = this.jj_gen;
            }
        }
        hasJDBClimitClause = this.offsetFetchFirstClause(offsetClauses);
        int checkOptionType = 0;
        Token endToken = this.getToken(0);
        HasNodeVisitor visitor = new HasNodeVisitor(ParameterNode.class);
        queryExpression.accept(visitor);
        if (visitor.hasNode()) {
            throw StandardException.newException("42X98", new Object[0]);
        }
        return new CreateViewNode(tableName, resultColumns, queryExpression, checkOptionType, StringUtil.slice(this.statementSQLText, beginToken.beginOffset, endToken.endOffset, false), orderCols, offsetClauses[0], offsetClauses[1], hasJDBClimitClause, this.getContextManager());
    }

    public final ResultColumnList viewColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumns = new ResultColumnList(this.getContextManager());
        this.columnNameList(resultColumns);
        return resultColumns;
    }

    public final StatementNode triggerDefinition() throws ParseException, StandardException {
        Boolean isRow = Boolean.FALSE;
        Token[] tokenHolder = new Token[1];
        Object checkTok = null;
        ResultColumnList triggerColumns = new ResultColumnList(this.getContextManager());
        List<TriggerReferencingStruct> refClause = null;
        ValueNode whenClause = null;
        Token whenOpen = null;
        Token whenClose = null;
        this.jj_consume_token(442);
        TableName triggerName = this.qualifiedName(128);
        Boolean isBefore = this.beforeOrAfter();
        int triggerEvent = this.triggerEvent(triggerColumns);
        this.jj_consume_token(195);
        TableName tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 423: {
                refClause = this.triggerReferencingClause();
                break;
            }
            default: {
                this.jj_la1[262] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 144: {
                this.jj_consume_token(144);
                this.jj_consume_token(396);
                isRow = this.rowOrStatement();
                break;
            }
            default: {
                this.jj_la1[263] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 408: {
                this.jj_consume_token(408);
                this.jj_consume_token(390);
                break;
            }
            default: {
                this.jj_la1[264] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 358: {
                this.jj_consume_token(358);
                whenOpen = this.jj_consume_token(453);
                whenClause = this.valueExpression();
                whenClose = this.jj_consume_token(454);
                break;
            }
            default: {
                this.jj_la1[265] = this.jj_gen;
            }
        }
        StatementNode actionNode = this.proceduralStatement(tokenHolder);
        int actionEnd = this.getToken((int)0).endOffset;
        int actionBegin = tokenHolder[0].beginOffset;
        actionNode.setBeginOffset(actionBegin);
        actionNode.setEndOffset(actionEnd);
        if (isBefore.booleanValue() && actionNode instanceof DMLModStatementNode) {
            throw StandardException.newException("42Z9D", actionNode.statementToString(), "BEFORE");
        }
        HasNodeVisitor visitor = new HasNodeVisitor(ParameterNode.class);
        actionNode.accept(visitor);
        if (whenClause != null) {
            whenClause.accept(visitor);
        }
        if (visitor.hasNode()) {
            throw StandardException.newException("42Y27", new Object[0]);
        }
        String actionText = StringUtil.slice(this.statementSQLText, actionBegin, actionEnd, false);
        String whenText = null;
        if (whenClause != null) {
            this.checkVersion(230, "WHEN");
            int whenOffset = whenOpen.endOffset + 1;
            int whenEnd = whenClose.beginOffset - 1;
            whenClause.setBeginOffset(whenOffset);
            whenClause.setEndOffset(whenEnd);
            whenText = StringUtil.slice(this.statementSQLText, whenOffset, whenEnd, false);
        }
        return new CreateTriggerNode(triggerName, tableName, triggerEvent, triggerColumns, isBefore, isRow, true, refClause, whenClause, whenText, actionNode, actionText, this.getContextManager());
    }

    public final StatementNode synonymDefinition() throws ParseException, StandardException {
        this.jj_consume_token(348);
        TableName synonymName = this.qualifiedName(128);
        this.jj_consume_token(144);
        TableName targetName = this.qualifiedName(128);
        this.checkVersion(130, "CREATE SYNONYM");
        return this.getCreateAliasNode(synonymName, targetName, null, 'S');
    }

    public final Boolean beforeOrAfter() throws ParseException {
        switch (this.jj_nt.kind) {
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(84);
                this.jj_consume_token(384);
                return Boolean.TRUE;
            }
            case 382: {
                this.jj_consume_token(382);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[266] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int triggerEvent(ResultColumnList rcl) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 166: {
                this.jj_consume_token(166);
                return 4;
            }
            case 122: {
                this.jj_consume_token(122);
                return 2;
            }
            case 254: {
                this.jj_consume_token(254);
                switch (this.jj_nt.kind) {
                    case 194: {
                        this.jj_consume_token(194);
                        this.columnNameList(rcl);
                        break;
                    }
                    default: {
                        this.jj_la1[267] = this.jj_gen;
                    }
                }
                return 1;
            }
        }
        this.jj_la1[268] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Boolean rowOrStatement() throws ParseException {
        switch (this.jj_nt.kind) {
            case 332: {
                this.token = this.jj_consume_token(332);
                return Boolean.TRUE;
            }
            case 347: {
                this.token = this.jj_consume_token(347);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[269] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List<TriggerReferencingStruct> triggerReferencingClause() throws ParseException, StandardException {
        ArrayList<TriggerReferencingStruct> expressions = new ArrayList<TriggerReferencingStruct>();
        this.jj_consume_token(423);
        this.triggerReferencingExpression(expressions);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 409: 
                case 410: 
                case 414: 
                case 415: {
                    break;
                }
                default: {
                    this.jj_la1[270] = this.jj_gen;
                    break block3;
                }
            }
            this.triggerReferencingExpression(expressions);
        }
        return expressions;
    }

    public final void triggerReferencingExpression(List<TriggerReferencingStruct> expressions) throws ParseException, StandardException {
        boolean isNew = true;
        boolean isRow = true;
        block0 : switch (this.jj_nt.kind) {
            case 409: {
                this.jj_consume_token(409);
                switch (this.jj_nt.kind) {
                    case 239: 
                    case 332: {
                        switch (this.jj_nt.kind) {
                            case 332: {
                                this.jj_consume_token(332);
                                break block0;
                            }
                            case 239: {
                                this.jj_consume_token(239);
                                isRow = false;
                                break block0;
                            }
                        }
                        this.jj_la1[271] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[272] = this.jj_gen;
                break;
            }
            case 414: {
                this.jj_consume_token(414);
                isNew = false;
                switch (this.jj_nt.kind) {
                    case 239: 
                    case 332: {
                        switch (this.jj_nt.kind) {
                            case 332: {
                                this.jj_consume_token(332);
                                break block0;
                            }
                            case 239: {
                                this.jj_consume_token(239);
                                isRow = false;
                                break block0;
                            }
                        }
                        this.jj_la1[273] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[274] = this.jj_gen;
                break;
            }
            case 410: {
                this.jj_consume_token(410);
                isRow = false;
                break;
            }
            case 415: {
                this.jj_consume_token(415);
                isNew = false;
                isRow = false;
                break;
            }
            default: {
                this.jj_la1[275] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(72);
        String identifier = this.identifier(128, true);
        expressions.add(new TriggerReferencingStruct(isRow, isNew, identifier));
    }

    public final ValueNode defaultClause(long[] autoIncrementInfo, String columnName) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 119: 
            case 267: {
                switch (this.jj_nt.kind) {
                    case 267: {
                        this.jj_consume_token(267);
                        break;
                    }
                    default: {
                        this.jj_la1[276] = this.jj_gen;
                    }
                }
                Token beginToken = this.jj_consume_token(119);
                ValueNode value = this.defaultOption(beginToken, autoIncrementInfo, columnName);
                return value;
            }
            case 292: {
                ValueNode value = this.generatedColumnOption(autoIncrementInfo);
                return value;
            }
        }
        this.jj_la1[277] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode defaultNullOnlyClause() throws ParseException, StandardException {
        this.jj_consume_token(119);
        this.jj_consume_token(191);
        return new UntypedNullConstantNode(this.getContextManager());
    }

    public final ValueNode generatedColumnOption(long[] autoIncrementInfo) throws ParseException, StandardException {
        ValueNode value = null;
        autoIncrementInfo[0] = 1L;
        autoIncrementInfo[1] = 1L;
        autoIncrementInfo[2] = 1L;
        autoIncrementInfo[3] = 0L;
        this.jj_consume_token(292);
        switch (this.jj_nt.kind) {
            case 274: {
                value = this.generatedAlways(autoIncrementInfo);
                return value;
            }
            case 83: {
                value = this.generatedByDefault(autoIncrementInfo);
                return value;
            }
        }
        this.jj_la1[278] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode generatedAlways(long[] autoIncrementInfo) throws ParseException, StandardException {
        ValueNode value = null;
        this.jj_consume_token(274);
        if (this.getToken((int)1).kind == 72 && this.getToken((int)2).kind == 158) {
            this.asIdentity(autoIncrementInfo);
            return value;
        }
        if (this.getToken((int)1).kind == 72 && this.getToken((int)2).kind == 453) {
            value = this.generationClause();
            return value;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode generatedByDefault(long[] autoIncrementInfo) throws ParseException, StandardException {
        DefaultNode value = null;
        this.jj_consume_token(83);
        this.jj_consume_token(119);
        this.asIdentity(autoIncrementInfo);
        this.checkVersion(130, "GENERATED BY DEFAULT");
        value = new DefaultNode(this.getContextManager());
        return value;
    }

    public final void asIdentity(long[] autoIncrementInfo) throws ParseException, StandardException {
        this.jj_consume_token(72);
        this.jj_consume_token(158);
        switch (this.jj_nt.kind) {
            case 453: {
                this.jj_consume_token(453);
                this.autoIncrementBeginEnd(autoIncrementInfo);
                this.jj_consume_token(454);
                break;
            }
            default: {
                this.jj_la1[279] = this.jj_gen;
            }
        }
    }

    public final ValueNode generationClause() throws ParseException, StandardException {
        ValueNode value = null;
        Token beginToken = null;
        Token endToken = null;
        this.jj_consume_token(72);
        beginToken = this.jj_consume_token(453);
        value = this.valueExpression();
        endToken = this.jj_consume_token(454);
        this.checkVersion(170, "GENERATED COLUMN");
        return new GenerationClauseNode(value, StringUtil.slice(this.statementSQLText, beginToken.endOffset + 1, endToken.beginOffset - 1, true), this.getContextManager());
    }

    public final void autoIncrementBeginEnd(long[] autoIncrementInfo) throws ParseException, StandardException {
        long autoIncrementInitial = 1L;
        long autoIncrementIncrement = 1L;
        switch (this.jj_nt.kind) {
            case 294: {
                this.jj_consume_token(294);
                this.jj_consume_token(83);
                autoIncrementInfo[1] = autoIncrementIncrement = this.exactNumber();
                autoIncrementInfo[3] = 0L;
                return;
            }
            case 346: {
                this.jj_consume_token(346);
                this.jj_consume_token(267);
                autoIncrementInitial = this.exactNumber();
                switch (this.jj_nt.kind) {
                    case 458: {
                        this.jj_consume_token(458);
                        this.jj_consume_token(294);
                        this.jj_consume_token(83);
                        autoIncrementIncrement = this.exactNumber();
                        break;
                    }
                    default: {
                        this.jj_la1[280] = this.jj_gen;
                    }
                }
                autoIncrementInfo[0] = autoIncrementInitial;
                autoIncrementInfo[1] = autoIncrementIncrement;
                autoIncrementInfo[3] = 0L;
                return;
            }
        }
        this.jj_la1[281] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode defaultOption(Token beginToken, long[] autoIncrementInfo, String columnName) throws ParseException, StandardException {
        Object errorTok = null;
        Object initialTok = null;
        if (this.getToken((int)1).kind == 191 && this.getToken((int)2).kind != 460 && this.getToken((int)2).kind != 463) {
            this.jj_consume_token(191);
            return new UntypedNullConstantNode(this.getContextManager());
        }
        if (this.jj_2_76(1)) {
            ValueNode value = this.DB2DefaultOption(columnName);
            Token endToken = this.getToken(0);
            value.setBeginOffset(beginToken.beginOffset);
            value.setEndOffset(endToken.endOffset);
            value = new DefaultNode(value, StringUtil.slice(this.statementSQLText, beginToken.beginOffset + 7, endToken.endOffset, true), this.getContextManager());
            return value;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode DB2DefaultOption(String columnName) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 436) {
            this.jj_consume_token(108);
            switch (this.jj_nt.kind) {
                case 222: {
                    this.jj_consume_token(222);
                    break;
                }
                case 436: {
                    this.jj_consume_token(436);
                    break;
                }
                default: {
                    this.jj_la1[282] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return new SpecialFunctionNode(2, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 112: 
            case 226: 
            case 256: {
                ValueNode value = this.userNode();
                return value;
            }
            case 363: {
                ValueNode value = this.currentRoleNode();
                return value;
            }
        }
        this.jj_la1[283] = this.jj_gen;
        if (this.getToken((int)1).kind == 285 || this.getToken((int)1).kind == 350 || this.getToken((int)1).kind == 351) {
            ValueNode value = this.miscBuiltins();
            return value;
        }
        if (this.getToken((int)2).kind == 453 || this.getToken((int)4).kind == 453 && this.getToken((int)2).kind != 458) {
            ValueNode value = this.miscBuiltins();
            throw StandardException.newException("42894", columnName);
        }
        if (this.jj_2_77(1)) {
            ValueNode value = this.datetimeValueFunction();
            return value;
        }
        switch (this.jj_nt.kind) {
            case 140: 
            case 249: 
            case 451: 
            case 457: 
            case 459: 
            case 487: 
            case 490: 
            case 491: 
            case 492: {
                ValueNode value = this.literal();
                return value;
            }
        }
        this.jj_la1[284] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode literal() throws ParseException, StandardException {
        String sign = "";
        switch (this.jj_nt.kind) {
            case 457: 
            case 459: 
            case 487: 
            case 492: {
                switch (this.jj_nt.kind) {
                    case 457: 
                    case 459: {
                        sign = this.sign();
                        break;
                    }
                    default: {
                        this.jj_la1[285] = this.jj_gen;
                    }
                }
                ValueNode constantNode = this.numericLiteral(sign);
                return constantNode;
            }
            case 490: {
                CharConstantNode constantNode = this.stringLiteral();
                return constantNode;
            }
            case 491: {
                ValueNode constantNode = this.hexLiteral();
                return constantNode;
            }
            case 451: {
                ValueNode constantNode = this.dateTimeLiteral();
                return constantNode;
            }
            case 140: 
            case 249: {
                Token tok = this.booleanLiteral();
                return new BooleanConstantNode(StringUtil.SQLEqualsIgnoreCase(tok.image, "true"), this.getContextManager());
            }
        }
        this.jj_la1[286] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final NumericConstantNode intLiteral() throws ParseException, StandardException {
        NumericConstantNode result;
        String sign = null;
        switch (this.jj_nt.kind) {
            case 457: 
            case 459: {
                sign = this.sign();
                break;
            }
            default: {
                this.jj_la1[287] = this.jj_gen;
            }
        }
        Token tok = this.jj_consume_token(487);
        String num = tok.image;
        if (sign != null && sign.equals("-")) {
            num = sign.concat(num);
        }
        try {
            result = this.getNumericNode(num, true);
        }
        catch (NumberFormatException e) {
            throw StandardException.newException("42X20", new Object[0]);
        }
        return result;
    }

    public final ValueNode numericLiteral(String sign) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 487: {
                Token tok = this.jj_consume_token(487);
                String num = tok.image;
                if (sign.equals("-")) {
                    num = sign.concat(num);
                }
                return this.getNumericNode(num, false);
            }
            case 492: {
                Double doubleValue;
                Token tok = this.jj_consume_token(492);
                StringBuffer doubleImage = new StringBuffer(sign);
                doubleImage.append(tok.image);
                String doubleString = doubleImage.toString();
                int ePosn = doubleString.indexOf(69);
                if (ePosn == -1) {
                    ePosn = doubleString.indexOf(101);
                }
                SanityManager.ASSERT(ePosn != -1, "no E or e in approximate numeric");
                if (doubleString.length() > 30) {
                    throw StandardException.newException("42820", doubleString, "DOUBLE");
                }
                int dotPosn = doubleString.substring(0, ePosn).indexOf(46);
                if (dotPosn == -1) {
                    doubleImage.insert(ePosn, '.');
                    doubleString = doubleImage.toString();
                    ++ePosn;
                }
                try {
                    doubleValue = Double.valueOf(doubleString);
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("22018", "DOUBLE");
                }
                double dv = doubleValue;
                if (dv == 0.0 && Double.parseDouble(doubleString.substring(0, ePosn - 1)) != 0.0) {
                    throw StandardException.newException("22003", "DOUBLE");
                }
                if (Double.isNaN(dv) || Double.isInfinite(dv)) {
                    throw StandardException.newException("22003", "DOUBLE");
                }
                return new NumericConstantNode(TypeId.getBuiltInTypeId(8), doubleValue, this.getContextManager());
            }
        }
        this.jj_la1[288] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dateTimeLiteral() throws ParseException, StandardException {
        this.jj_consume_token(451);
        ValueNode constantNode = this.escapedDateTimeLiteral();
        this.jj_consume_token(452);
        return constantNode;
    }

    public final ValueNode escapedDateTimeLiteral() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 114: {
                this.jj_consume_token(114);
                ValueNode constantNode = this.bareDateLiteral();
                return constantNode;
            }
            case 238: {
                this.jj_consume_token(238);
                ValueNode constantNode = this.bareTimeLiteral();
                return constantNode;
            }
            case 250: {
                this.jj_consume_token(250);
                ValueNode constantNode = this.bareTimestampLiteral();
                return constantNode;
            }
        }
        this.jj_la1[289] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode bareDateLiteral() throws ParseException, StandardException {
        String dateString = this.string();
        return new UserTypeConstantNode(this.getLanguageConnectionContext().getDataValueFactory().getDateValue(dateString, true), this.getContextManager());
    }

    public final ValueNode bareTimeLiteral() throws ParseException, StandardException {
        String timeString = this.string();
        return new UserTypeConstantNode(this.getLanguageConnectionContext().getDataValueFactory().getTimeValue(timeString, true), this.getContextManager());
    }

    public final ValueNode bareTimestampLiteral() throws ParseException, StandardException {
        String timestampString = this.string();
        return new UserTypeConstantNode(this.getLanguageConnectionContext().getDataValueFactory().getTimestampValue(timestampString, true), this.getContextManager());
    }

    public final String string() throws ParseException, StandardException {
        Token tok = this.jj_consume_token(490);
        SQLParser.verifyImageLength(tok.image);
        return StringUtil.compressQuotes(tok.image.substring(1, tok.image.length() - 1), SINGLEQUOTES);
    }

    public final CharConstantNode stringLiteral() throws ParseException, StandardException {
        Token tok = this.jj_consume_token(490);
        if (tok.image.length() - 2 > 32672) {
            throw StandardException.newException("54002", StringUtil.formatForPrint(tok.image));
        }
        String string = StringUtil.compressQuotes(tok.image.substring(1, tok.image.length() - 1), SINGLEQUOTES);
        return new CharConstantNode(string, this.getContextManager());
    }

    public final ValueNode hexLiteral() throws ParseException, StandardException {
        Token tok = this.jj_consume_token(491);
        String hexLiteral = tok.image;
        if (hexLiteral.length() - 3 > 16336) {
            throw StandardException.newException("54002", StringUtil.formatForPrint(hexLiteral));
        }
        if ((hexLiteral.length() - 3) % 2 == 1) {
            throw StandardException.newException("42606", StringUtil.formatForPrint(hexLiteral));
        }
        int bitLength = (hexLiteral.length() - 3) / 2;
        return new VarbitConstantNode(hexLiteral.substring(2, hexLiteral.length() - 1), bitLength, this.getContextManager());
    }

    public final TableName constraintNameDefinition() throws ParseException, StandardException {
        this.jj_consume_token(100);
        TableName constraintName = this.qualifiedName(128);
        return constraintName;
    }

    public final ConstraintDefinitionNode checkConstraintDefinition(TableName constraintName, String columnName) throws ParseException, StandardException {
        ResultColumnList rclList = null;
        this.jj_consume_token(91);
        Token beginToken = this.jj_consume_token(453);
        ValueNode value = this.valueExpression();
        Token endToken = this.jj_consume_token(454);
        if (columnName != null) {
            rclList = new ResultColumnList(this.getContextManager());
            rclList.addElement(new ResultColumn(columnName, null, this.getContextManager()));
        }
        value.setBeginOffset(beginToken.beginOffset);
        value.setEndOffset(endToken.endOffset);
        return new ConstraintDefinitionNode(constraintName, 4, rclList, null, value, StringUtil.slice(this.statementSQLText, beginToken.beginOffset, endToken.endOffset, true), 2, 5, this.getContextManager());
    }

    public final StatementNode spsRenameStatement() throws ParseException, StandardException {
        StatementNode qtn;
        this.jj_consume_token(424);
        switch (this.jj_nt.kind) {
            case 239: {
                qtn = this.renameTableStatement();
                break;
            }
            case 400: {
                qtn = this.renameIndexStatement();
                break;
            }
            case 96: {
                qtn = this.renameColumnStatement();
                break;
            }
            default: {
                this.jj_la1[290] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return qtn;
    }

    public final StatementNode renameTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(243);
        String newTableName = this.identifier(128, true);
        return new RenameNode(tableName, null, newTableName, false, 1, this.getContextManager());
    }

    public final StatementNode renameIndexStatement() throws ParseException, StandardException {
        this.jj_consume_token(400);
        String oldIndexName = this.identifier(128, true);
        this.jj_consume_token(243);
        String newIndexName = this.identifier(128, true);
        return new RenameNode(null, oldIndexName, newIndexName, false, 3, this.getContextManager());
    }

    public final StatementNode renameColumnStatement() throws ParseException, StandardException {
        this.jj_consume_token(96);
        ColumnReference oldColumnReference = this.columnReference();
        this.jj_consume_token(243);
        String newColumnName = this.identifier(128, true);
        if (oldColumnReference.getQualifiedTableName() == null) {
            throw StandardException.newException("42Y55", "RENAME COLUMN", oldColumnReference.getColumnName());
        }
        return new RenameNode(oldColumnReference.getQualifiedTableName(), oldColumnReference.getColumnName(), newColumnName, false, 2, this.getContextManager());
    }

    public final StatementNode lockStatement() throws ParseException, StandardException {
        this.jj_consume_token(405);
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(160);
        boolean exclusiveMode = this.lockMode();
        this.jj_consume_token(408);
        return new LockTableNode(tableName, exclusiveMode, this.getContextManager());
    }

    public final boolean lockMode() throws ParseException {
        switch (this.jj_nt.kind) {
            case 398: {
                this.jj_consume_token(398);
                return true;
            }
            case 435: {
                this.jj_consume_token(435);
                return false;
            }
        }
        this.jj_la1[291] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode execStatement() throws ParseException, StandardException {
        this.jj_consume_token(137);
        this.jj_consume_token(347);
        TableName stmtName = this.qualifiedName(128);
        return new ExecSPSNode(stmtName, this.getContextManager());
    }

    public final TransactionStatementNode setIsolationStatement() throws ParseException, StandardException {
        this.setIsolationHeader();
        block0 : switch (this.jj_nt.kind) {
            case 243: 
            case 467: {
                switch (this.jj_nt.kind) {
                    case 467: {
                        this.jj_consume_token(467);
                        break block0;
                    }
                    case 243: {
                        this.jj_consume_token(243);
                        break block0;
                    }
                }
                this.jj_la1[292] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[293] = this.jj_gen;
            }
        }
        TransactionStatementNode tranNode = this.transactionMode();
        return tranNode;
    }

    public final void setIsolationHeader() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 172: {
                this.jj_consume_token(172);
                break;
            }
            default: {
                this.jj_la1[294] = this.jj_gen;
                if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 172) {
                    this.jj_consume_token(108);
                    this.jj_consume_token(172);
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final TransactionStatementNode transactionMode() throws ParseException, StandardException {
        int isolationLevel = this.isolationLevelDB2OrReset();
        return new SetTransactionIsolationNode(isolationLevel, this.getContextManager());
    }

    public final int isolationLevelDB2OrReset() throws ParseException {
        switch (this.jj_nt.kind) {
            case 425: {
                this.jj_consume_token(425);
                return 0;
            }
        }
        this.jj_la1[295] = this.jj_gen;
        if (this.jj_2_78(1)) {
            int isolationLevel = this.isolationLevelDB2();
            return isolationLevel;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevelDB2() throws ParseException {
        switch (this.jj_nt.kind) {
            case 388: 
            case 429: 
            case 430: 
            case 445: {
                int isolationLevel = this.isolationLevelDB2Abbrev();
                return isolationLevel;
            }
            case 328: 
            case 336: {
                switch (this.jj_nt.kind) {
                    case 328: {
                        this.jj_consume_token(328);
                        this.jj_consume_token(213);
                        break;
                    }
                    case 336: {
                        this.jj_consume_token(336);
                        break;
                    }
                    default: {
                        this.jj_la1[296] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return 4;
            }
            case 113: {
                this.jj_consume_token(113);
                this.jj_consume_token(439);
                return 2;
            }
            case 394: {
                this.jj_consume_token(394);
                this.jj_consume_token(213);
                return 1;
            }
        }
        this.jj_la1[297] = this.jj_gen;
        if (this.getToken((int)1).kind == 213 && this.getToken((int)2).kind == 280) {
            this.jj_consume_token(213);
            this.jj_consume_token(280);
            return 2;
        }
        if (this.getToken((int)1).kind == 213 && this.getToken((int)2).kind == 356) {
            this.jj_consume_token(213);
            this.jj_consume_token(356);
            return 1;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevelDB2Abbrev() throws ParseException {
        switch (this.jj_nt.kind) {
            case 429: {
                this.jj_consume_token(429);
                return 4;
            }
            case 430: {
                this.jj_consume_token(430);
                return 3;
            }
            case 388: {
                this.jj_consume_token(388);
                return 2;
            }
            case 445: {
                this.jj_consume_token(445);
                return 1;
            }
        }
        this.jj_la1[298] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevel() throws ParseException {
        this.jj_consume_token(172);
        this.jj_consume_token(302);
        int isolationLevel = this.levelOfIsolation();
        return isolationLevel;
    }

    public final int levelOfIsolation() throws ParseException {
        switch (this.jj_nt.kind) {
            case 213: {
                this.jj_consume_token(213);
                return this.levelOfIsolationRead();
            }
            case 328: {
                this.jj_consume_token(328);
                this.jj_consume_token(213);
                return 3;
            }
            case 336: {
                this.jj_consume_token(336);
                return 4;
            }
        }
        this.jj_la1[299] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int levelOfIsolationRead() throws ParseException {
        switch (this.jj_nt.kind) {
            case 356: {
                this.jj_consume_token(356);
                return 1;
            }
            case 280: {
                this.jj_consume_token(280);
                return 2;
            }
        }
        this.jj_la1[300] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode simpleValueSpecification() throws ParseException, StandardException {
        ValueNode value = this.literal();
        return value;
    }

    public final StatementNode setRoleStatement() throws ParseException, StandardException {
        this.jj_consume_token(373);
        StatementNode role = this.setRoleSpecification();
        if (this.parameterList != null && this.parameterList.size() > 0) {
            this.setUpAndLinkParameters();
            ParameterNode p = this.parameterList.get(0);
            p.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), false, 128));
        }
        return role;
    }

    public final StatementNode setRoleSpecification() throws ParseException, StandardException {
        String roleName = null;
        this.checkVersion(170, "ROLES");
        this.checkSqlStandardAccess("SET ROLE");
        switch (this.jj_nt.kind) {
            case 371: {
                this.jj_consume_token(371);
                return new SetRoleNode(roleName, 0, this.getContextManager());
            }
        }
        this.jj_la1[301] = this.jj_gen;
        if (this.jj_2_79(1)) {
            roleName = this.identifier(128, true);
            return new SetRoleNode(roleName, 0, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 472: {
                this.dynamicParameterSpecification();
                return new SetRoleNode(null, 1, this.getContextManager());
            }
            case 490: {
                roleName = this.string();
                roleName = IdUtil.parseRoleId(roleName);
                return new SetRoleNode(roleName, 0, this.getContextManager());
            }
        }
        this.jj_la1[302] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode setSchemaStatement() throws ParseException, StandardException {
        this.setSchemaHeader();
        switch (this.jj_nt.kind) {
            case 467: {
                this.jj_consume_token(467);
                break;
            }
            default: {
                this.jj_la1[303] = this.jj_gen;
            }
        }
        StatementNode setSchema = this.setSchemaValues();
        if (this.parameterList != null && this.parameterList.size() > 0) {
            this.setUpAndLinkParameters();
            ParameterNode p = this.parameterList.get(0);
            p.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), false, 128));
        }
        return setSchema;
    }

    public final void setSchemaHeader() throws ParseException, StandardException {
        block0 : switch (this.jj_nt.kind) {
            case 222: {
                this.jj_consume_token(222);
                break;
            }
            default: {
                this.jj_la1[305] = this.jj_gen;
                if (this.getToken((int)1).kind == 108 && (this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 436)) {
                    this.jj_consume_token(108);
                    switch (this.jj_nt.kind) {
                        case 222: {
                            this.jj_consume_token(222);
                            break block0;
                        }
                        case 436: {
                            this.jj_consume_token(436);
                            break block0;
                        }
                    }
                    this.jj_la1[304] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final StatementNode setSchemaValues() throws ParseException, StandardException {
        if (this.jj_2_80(1)) {
            String schemaName = this.identifier(128, true);
            return new SetSchemaNode(schemaName, 0, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 256: {
                this.jj_consume_token(256);
                return new SetSchemaNode(null, 1, this.getContextManager());
            }
            case 472: {
                this.dynamicParameterSpecification();
                return new SetSchemaNode(null, 2, this.getContextManager());
            }
            case 490: {
                String schemaName = this.string();
                IdUtil.checkIdentifierLengthLimit(schemaName, 128);
                return new SetSchemaNode(schemaName, 0, this.getContextManager());
            }
        }
        this.jj_la1[306] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode setMessageLocaleStatement() throws ParseException, StandardException {
        this.jj_consume_token(406);
        String messageLocale = this.string();
        this.getContextManager().setMessageLocale(messageLocale);
        return new NOPStatementNode(this.getContextManager());
    }

    public final ValueNode valueSpecification() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 140: 
            case 249: 
            case 451: 
            case 457: 
            case 459: 
            case 487: 
            case 490: 
            case 491: 
            case 492: {
                ValueNode value = this.literal();
                return value;
            }
            case 112: 
            case 226: 
            case 256: 
            case 363: 
            case 472: {
                ValueNode value = this.generalValueSpecification();
                return value;
            }
            case 192: {
                this.jj_consume_token(192);
                this.jj_consume_token(453);
                ValueNode leftExpression = this.valueExpression();
                this.jj_consume_token(458);
                ValueNode rightExpression = this.valueExpression();
                this.jj_consume_token(454);
                ContextManager cm = this.getContextManager();
                ValueNodeList whenList = new ValueNodeList(cm);
                ValueNodeList thenElseList = new ValueNodeList(cm);
                whenList.addElement(new BinaryRelationalOperatorNode(0, leftExpression, rightExpression, false, cm));
                thenElseList.addElement(new UntypedNullConstantNode(cm));
                thenElseList.addElement(leftExpression);
                return new ConditionalNode(null, whenList, thenElseList, cm);
            }
        }
        this.jj_la1[307] = this.jj_gen;
        if (this.getToken((int)1).kind == 86 && this.getToken((int)2).kind == 358) {
            this.jj_consume_token(86);
            ConditionalNode value = this.searchedCaseExpression();
            return value;
        }
        switch (this.jj_nt.kind) {
            case 86: {
                this.jj_consume_token(86);
                ValueNode caseOperand = this.valueExpression();
                ConditionalNode value = this.simpleCaseExpression(new CachedValueNode(caseOperand));
                return value;
            }
        }
        this.jj_la1[308] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ConditionalNode searchedCaseExpression() throws ParseException, StandardException {
        ContextManager cm = this.getContextManager();
        ValueNodeList whenList = new ValueNodeList(cm);
        ValueNodeList thenElseList = new ValueNodeList(cm);
        ValueNode elseExpr = null;
        block6: while (true) {
            this.whenThenExpression(whenList, thenElseList);
            switch (this.jj_nt.kind) {
                case 358: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[309] = this.jj_gen;
        switch (this.jj_nt.kind) {
            case 130: {
                this.jj_consume_token(130);
                elseExpr = this.thenElseExpression();
                break;
            }
            default: {
                this.jj_la1[310] = this.jj_gen;
            }
        }
        this.jj_consume_token(131);
        if (elseExpr == null) {
            elseExpr = new UntypedNullConstantNode(cm);
        }
        thenElseList.addElement(elseExpr);
        return new ConditionalNode(null, whenList, thenElseList, cm);
    }

    public final void whenThenExpression(ValueNodeList whenList, ValueNodeList thenElseList) throws ParseException, StandardException {
        this.jj_consume_token(358);
        ValueNode expr = this.valueExpression();
        this.jj_consume_token(349);
        ValueNode thenExpr = this.thenElseExpression();
        whenList.addElement(expr);
        thenElseList.addElement(thenExpr);
    }

    public final ValueNode thenElseExpression() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 191) {
            this.jj_consume_token(191);
            return new UntypedNullConstantNode(this.getContextManager());
        }
        if (this.jj_2_81(1)) {
            ValueNode expr = this.valueExpression();
            return expr;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ConditionalNode simpleCaseExpression(CachedValueNode caseOperand) throws ParseException, StandardException {
        ContextManager cm = this.getContextManager();
        ValueNodeList whenList = new ValueNodeList(cm);
        ValueNodeList thenElseList = new ValueNodeList(cm);
        ValueNode elseExpr = null;
        block6: while (true) {
            this.simpleWhenClause(caseOperand, whenList, thenElseList);
            switch (this.jj_nt.kind) {
                case 358: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[311] = this.jj_gen;
        switch (this.jj_nt.kind) {
            case 130: {
                this.jj_consume_token(130);
                elseExpr = this.thenElseExpression();
                break;
            }
            default: {
                this.jj_la1[312] = this.jj_gen;
            }
        }
        this.jj_consume_token(131);
        if (elseExpr == null) {
            elseExpr = new UntypedNullConstantNode(cm);
        }
        thenElseList.addElement(elseExpr);
        return new ConditionalNode(caseOperand, whenList, thenElseList, cm);
    }

    public final void simpleWhenClause(ValueNode caseOperand, ValueNodeList whenList, ValueNodeList thenElseList) throws ParseException, StandardException {
        this.jj_consume_token(358);
        ValueNode expr = this.whenOperandList(caseOperand);
        this.jj_consume_token(349);
        ValueNode thenExpr = this.thenElseExpression();
        whenList.addElement(expr);
        thenElseList.addElement(thenExpr);
    }

    public final ValueNode whenOperandList(ValueNode caseOperand) throws ParseException, StandardException {
        ValueNode rest = null;
        ValueNode first = this.whenOperand(caseOperand);
        switch (this.jj_nt.kind) {
            case 458: {
                this.jj_consume_token(458);
                rest = this.whenOperandList(caseOperand);
                break;
            }
            default: {
                this.jj_la1[313] = this.jj_gen;
            }
        }
        if (rest == null) {
            return first;
        }
        return new OrNode(first, rest, this.getContextManager());
    }

    public final ValueNode whenOperand(ValueNode caseOperand) throws ParseException, StandardException {
        ContextManager cm = this.getContextManager();
        if (this.remainingPredicateFollows()) {
            ValueNode expr = this.remainingPredicate(caseOperand);
            return expr;
        }
        if (this.jj_2_82(1)) {
            ValueNode expr = this.valueExpression();
            return new BinaryRelationalOperatorNode(0, caseOperand, expr, false, cm);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementNode tableConstraintDefinition() throws ParseException, StandardException {
        Properties properties = null;
        TableName constraintName = null;
        switch (this.jj_nt.kind) {
            case 100: {
                constraintName = this.constraintNameDefinition();
                break;
            }
            default: {
                this.jj_la1[314] = this.jj_gen;
            }
        }
        ConstraintDefinitionNode tcdn = this.tableConstraint(constraintName);
        switch (this.jj_nt.kind) {
            case 59: {
                properties = this.propertyList(false);
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[315] = this.jj_gen;
            }
        }
        if (properties != null) {
            tcdn.setProperties(properties);
        }
        return tcdn;
    }

    public final ConstraintDefinitionNode tableConstraint(TableName constraintName) throws ParseException, StandardException {
        ConstraintDefinitionNode tcdn;
        boolean[] cc = null;
        switch (this.jj_nt.kind) {
            case 208: 
            case 252: {
                tcdn = this.uniqueConstraintDefinition(constraintName);
                break;
            }
            case 145: {
                tcdn = this.referentialConstraintDefinition(constraintName);
                break;
            }
            case 91: {
                tcdn = this.checkConstraintDefinition(constraintName, null);
                break;
            }
            default: {
                this.jj_la1[316] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.jj_2_83(1)) {
            cc = this.constraintCharacteristics();
        }
        if (cc != null) {
            tcdn.setCharacteristics(cc);
        }
        return tcdn;
    }

    public final ConstraintDefinitionNode uniqueConstraintDefinition(TableName constraintName) throws ParseException, StandardException {
        int constraintType = this.uniqueSpecification(null);
        this.jj_consume_token(453);
        ResultColumnList uniqueColumnList = this.uniqueColumnList();
        this.jj_consume_token(454);
        return new ConstraintDefinitionNode(constraintName, ReuseFactory.getInteger(constraintType), uniqueColumnList, null, null, null, 2, 5, this.getContextManager());
    }

    public final int uniqueSpecification(String columnName) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 252: {
                this.jj_consume_token(252);
                return 3;
            }
            case 208: {
                this.jj_consume_token(208);
                this.jj_consume_token(174);
                return 2;
            }
        }
        this.jj_la1[317] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList uniqueColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumns = new ResultColumnList(this.getContextManager());
        this.columnNameList(resultColumns);
        return resultColumns;
    }

    public final ConstraintDefinitionNode referentialConstraintDefinition(TableName constraintName) throws ParseException, StandardException {
        ResultColumnList fkRcl = new ResultColumnList(this.getContextManager());
        ResultColumnList refRcl = new ResultColumnList(this.getContextManager());
        int[] refActions = new int[]{2, 2};
        this.jj_consume_token(145);
        this.jj_consume_token(174);
        this.jj_consume_token(453);
        this.columnNameList(fkRcl);
        this.jj_consume_token(454);
        TableName referencedTable = this.referencesSpecification(refRcl, refActions);
        return new FKConstraintDefinitionNode(constraintName, referencedTable, fkRcl, refRcl, refActions, this.getContextManager());
    }

    public final TableName referencesSpecification(ResultColumnList rcl, int[] refActions) throws ParseException, StandardException {
        TableName tableName = null;
        this.jj_consume_token(215);
        tableName = this.referencedTableAndColumns(rcl);
        switch (this.jj_nt.kind) {
            case 195: {
                this.jj_consume_token(195);
                this.referentialTriggeredAction(refActions);
                break;
            }
            default: {
                this.jj_la1[318] = this.jj_gen;
            }
        }
        return tableName;
    }

    public final TableName referencedTableAndColumns(ResultColumnList rcl) throws ParseException, StandardException {
        TableName tableName = null;
        tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 453: {
                this.jj_consume_token(453);
                this.columnNameList(rcl);
                this.jj_consume_token(454);
                break;
            }
            default: {
                this.jj_la1[319] = this.jj_gen;
            }
        }
        return tableName;
    }

    public final void referentialTriggeredAction(int[] refActions) throws ParseException, StandardException {
        block0 : switch (this.jj_nt.kind) {
            case 254: {
                refActions[1] = this.updateRule();
                switch (this.jj_nt.kind) {
                    case 195: {
                        this.jj_consume_token(195);
                        refActions[0] = this.deleteRule();
                        break block0;
                    }
                }
                this.jj_la1[320] = this.jj_gen;
                break;
            }
            case 122: {
                refActions[0] = this.deleteRule();
                switch (this.jj_nt.kind) {
                    case 195: {
                        this.jj_consume_token(195);
                        refActions[1] = this.updateRule();
                        break block0;
                    }
                }
                this.jj_la1[321] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[322] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int updateRule() throws ParseException {
        this.jj_consume_token(254);
        int action = this.updateReferentialAction();
        return action;
    }

    public final int deleteRule() throws ParseException {
        this.jj_consume_token(122);
        int action = this.deleteReferentialAction();
        return action;
    }

    public final int updateReferentialAction() throws ParseException {
        switch (this.jj_nt.kind) {
            case 217: {
                this.jj_consume_token(217);
                return 1;
            }
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(273);
                return 2;
            }
        }
        this.jj_la1[323] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int deleteReferentialAction() throws ParseException {
        switch (this.jj_nt.kind) {
            case 84: {
                this.jj_consume_token(84);
                return 0;
            }
            case 217: {
                this.jj_consume_token(217);
                return 1;
            }
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(273);
                return 2;
            }
            case 227: {
                this.jj_consume_token(227);
                switch (this.jj_nt.kind) {
                    case 191: {
                        this.jj_consume_token(191);
                        return 3;
                    }
                    case 119: {
                        this.jj_consume_token(119);
                        return 4;
                    }
                }
                this.jj_la1[324] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[325] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final boolean[] constraintCharacteristics() throws ParseException, StandardException {
        boolean deferrable = false;
        boolean initiallyDeferred = false;
        boolean enforced = true;
        boolean[] explicitlySpecified = new boolean[]{false, false};
        switch (this.jj_nt.kind) {
            case 162: {
                initiallyDeferred = this.initiallyDeferred();
                explicitlySpecified[1] = true;
                if (this.getToken((int)1).kind == 120 || this.getToken((int)2).kind == 120) {
                    deferrable = this.deferrable();
                    explicitlySpecified[0] = true;
                }
                if (this.getToken((int)1).kind != 290 && this.getToken((int)2).kind != 290) break;
                enforced = this.constraintEnforcement();
                break;
            }
            default: {
                this.jj_la1[327] = this.jj_gen;
                if (this.getToken((int)1).kind == 120 || this.getToken((int)2).kind == 120) {
                    deferrable = this.deferrable();
                    explicitlySpecified[0] = true;
                    switch (this.jj_nt.kind) {
                        case 162: {
                            initiallyDeferred = this.initiallyDeferred();
                            explicitlySpecified[1] = true;
                            break;
                        }
                        default: {
                            this.jj_la1[326] = this.jj_gen;
                        }
                    }
                    if (this.getToken((int)1).kind != 290 && this.getToken((int)2).kind != 290) break;
                    enforced = this.constraintEnforcement();
                    break;
                }
                if (this.getToken((int)1).kind == 290 || this.getToken((int)2).kind == 290) {
                    enforced = this.constraintEnforcement();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (!explicitlySpecified[0] && explicitlySpecified[1] && initiallyDeferred) {
            deferrable = true;
        }
        if (explicitlySpecified[0] && !deferrable && explicitlySpecified[1] && initiallyDeferred) {
            throw StandardException.newException("42X97", new Object[0]);
        }
        return new boolean[]{deferrable, initiallyDeferred, enforced};
    }

    public final boolean initiallyDeferred() throws ParseException {
        this.jj_consume_token(162);
        switch (this.jj_nt.kind) {
            case 159: {
                this.jj_consume_token(159);
                return false;
            }
            case 121: {
                this.jj_consume_token(121);
                return true;
            }
        }
        this.jj_la1[328] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final boolean deferrable() throws ParseException {
        boolean deferrable = true;
        switch (this.jj_nt.kind) {
            case 190: {
                this.jj_consume_token(190);
                deferrable = false;
                break;
            }
            default: {
                this.jj_la1[329] = this.jj_gen;
            }
        }
        this.jj_consume_token(120);
        return deferrable;
    }

    public final boolean constraintEnforcement() throws ParseException {
        boolean enforced = true;
        switch (this.jj_nt.kind) {
            case 190: {
                this.jj_consume_token(190);
                enforced = false;
                break;
            }
            default: {
                this.jj_la1[330] = this.jj_gen;
            }
        }
        this.jj_consume_token(290);
        return enforced;
    }

    public final void columnConstraintDefinition(DataTypeDescriptor[] dataTypeDescriptor, TableElementList tableElementList, String columnName) throws ParseException, StandardException {
        TableName constraintName = null;
        boolean[] cc = null;
        switch (this.jj_nt.kind) {
            case 100: {
                constraintName = this.constraintNameDefinition();
                break;
            }
            default: {
                this.jj_la1[331] = this.jj_gen;
            }
        }
        ConstraintDefinitionNode tcdn = this.columnConstraint(constraintName, dataTypeDescriptor, columnName);
        if (this.jj_2_84(1)) {
            cc = this.constraintCharacteristics();
        }
        if (cc != null) {
            if (tcdn == null) {
                throw StandardException.newException("42XAN", new Object[0]);
            }
            tcdn.setCharacteristics(cc);
        }
        if (tcdn == null) {
            return;
        }
        tableElementList.addTableElement(tcdn);
    }

    public final ConstraintDefinitionNode columnConstraint(TableName constraintName, DataTypeDescriptor[] dataTypeDescriptor, String columnName) throws ParseException, StandardException {
        Properties properties = null;
        ResultColumnList refRcl = new ResultColumnList(this.getContextManager());
        int[] refActions = new int[]{2, 2};
        switch (this.jj_nt.kind) {
            case 190: {
                this.jj_consume_token(190);
                this.jj_consume_token(191);
                if (dataTypeDescriptor[0] == null) {
                    throw StandardException.newException("42XAB", new Object[0]);
                }
                dataTypeDescriptor[0] = dataTypeDescriptor[0].getNullabilityType(false);
                return null;
            }
            case 208: 
            case 252: {
                int constraintType = this.uniqueSpecification(columnName);
                switch (this.jj_nt.kind) {
                    case 59: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(64);
                        break;
                    }
                    default: {
                        this.jj_la1[332] = this.jj_gen;
                    }
                }
                ResultColumnList uniqueColumnList = new ResultColumnList(this.getContextManager());
                uniqueColumnList.addElement(new ResultColumn(columnName, null, this.getContextManager()));
                return new ConstraintDefinitionNode(constraintName, ReuseFactory.getInteger(constraintType), uniqueColumnList, properties, null, null, 2, 5, this.getContextManager());
            }
            case 215: {
                TableName referencedTable = this.referencesSpecification(refRcl, refActions);
                switch (this.jj_nt.kind) {
                    case 59: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(64);
                        break;
                    }
                    default: {
                        this.jj_la1[333] = this.jj_gen;
                    }
                }
                ResultColumnList fkRcl = new ResultColumnList(this.getContextManager());
                fkRcl.addElement(new ResultColumn(columnName, null, this.getContextManager()));
                FKConstraintDefinitionNode tcdn = new FKConstraintDefinitionNode(constraintName, referencedTable, fkRcl, refRcl, refActions, this.getContextManager());
                if (properties != null) {
                    tcdn.setProperties(properties);
                }
                return tcdn;
            }
            case 91: {
                ConstraintDefinitionNode tcdn = this.checkConstraintDefinition(constraintName, columnName);
                return tcdn;
            }
        }
        this.jj_la1[334] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropRoleStatement() throws ParseException, StandardException {
        this.jj_consume_token(373);
        String roleName = this.identifier(128, true);
        this.checkVersion(170, "ROLES");
        this.checkSqlStandardAccess("DROP ROLE");
        return new DropRoleNode(roleName, this.getContextManager());
    }

    public final StatementNode dropSchemaStatement() throws ParseException, StandardException {
        this.jj_consume_token(222);
        String schemaName = this.identifier(128, true);
        this.jj_consume_token(217);
        DropSchemaNode stmt = new DropSchemaNode(schemaName, 1, this.getContextManager());
        return stmt;
    }

    public final StatementNode alterTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        StatementNode node = this.alterTableBody(tableName);
        return node;
    }

    public final StatementNode alterTableBody(TableName tableName) throws ParseException, StandardException {
        char lockGranularity = '\u0000';
        TableElementList tableElementList = new TableElementList(this.getContextManager());
        int[] changeType = new int[1];
        int[] behavior = new int[1];
        String indexName = null;
        switch (this.jj_nt.kind) {
            case 386: {
                StatementNode sn;
                this.jj_consume_token(386);
                switch (this.jj_nt.kind) {
                    case 401: {
                        sn = this.inplaceCompress(tableName);
                        break;
                    }
                    default: {
                        this.jj_la1[335] = this.jj_gen;
                        sn = this.sequentialCompress(tableName);
                    }
                }
                return sn;
            }
            case 66: {
                StatementNode sn;
                this.jj_consume_token(66);
                switch (this.jj_nt.kind) {
                    case 129: {
                        sn = this.dropStatistics(tableName);
                        break;
                    }
                    case 254: {
                        sn = this.updateStatistics(tableName);
                        break;
                    }
                    default: {
                        this.jj_la1[336] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return sn;
            }
            case 254: {
                this.jj_consume_token(254);
                this.jj_consume_token(431);
                indexName = this.identifier(128, true);
                this.checkVersion(170, "SYSCS_UPDATE_STATISTICS");
                this.checkInternalFeature("UPDATE STATISTICS");
                return new AlterTableNode(tableName, 5, false, indexName, this.getContextManager());
            }
            case 431: {
                this.jj_consume_token(431);
                this.jj_consume_token(129);
                indexName = this.identifier(128, true);
                this.checkVersion(210, "SYSCS_UPDATE_STATISTICS");
                this.checkInternalFeature("DROP STATISTICS");
                return new AlterTableNode(tableName, 6, false, indexName, this.getContextManager());
            }
            case 129: {
                StatementNode sn;
                this.jj_consume_token(129);
                if (this.jj_2_85(1)) {
                    sn = this.dropColumnDefinition(tableName, tableElementList, changeType, behavior);
                } else if (this.jj_2_86(1)) {
                    sn = this.dropTableConstraintDefinitionCore(tableName, tableElementList, changeType, behavior);
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                return sn;
            }
        }
        this.jj_la1[337] = this.jj_gen;
        if (this.jj_2_87(1)) {
            lockGranularity = this.alterTableAction(tableElementList, changeType, behavior);
            return new AlterTableNode(tableName, changeType[0], tableElementList, lockGranularity, behavior[0], this.getContextManager());
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropStatistics(TableName tableName) throws ParseException, StandardException {
        this.jj_consume_token(129);
        this.jj_consume_token(431);
        this.checkVersion(210, "SYSCS_DROP_STATISTICS");
        this.checkInternalFeature("DROP STATISTICS");
        return new AlterTableNode(tableName, 6, true, null, this.getContextManager());
    }

    public final StatementNode updateStatistics(TableName tableName) throws ParseException, StandardException {
        this.jj_consume_token(254);
        this.jj_consume_token(431);
        this.checkVersion(170, "SYSCS_UPDATE_STATISTICS");
        this.checkInternalFeature("UPDATE STATISTICS");
        int[] changeType = new int[1];
        return new AlterTableNode(tableName, 5, true, null, this.getContextManager());
    }

    public final StatementNode inplaceCompress(TableName tableName) throws ParseException, StandardException {
        Token purge = null;
        Token defragment = null;
        Token truncate = null;
        this.jj_consume_token(401);
        switch (this.jj_nt.kind) {
            case 420: {
                purge = this.jj_consume_token(420);
                break;
            }
            default: {
                this.jj_la1[338] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 393: {
                defragment = this.jj_consume_token(393);
                break;
            }
            default: {
                this.jj_la1[339] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 443: {
                truncate = this.jj_consume_token(443);
                break;
            }
            default: {
                this.jj_la1[340] = this.jj_gen;
            }
        }
        this.checkInternalFeature("COMPRESS");
        return new AlterTableNode(tableName, purge != null, defragment != null, truncate != null, this.getContextManager());
    }

    public final StatementNode sequentialCompress(TableName tableName) throws ParseException, StandardException {
        Token tok = null;
        switch (this.jj_nt.kind) {
            case 433: {
                tok = this.jj_consume_token(433);
                break;
            }
            default: {
                this.jj_la1[341] = this.jj_gen;
            }
        }
        this.checkInternalFeature("COMPRESS");
        return new AlterTableNode(tableName, tok != null, this.getContextManager());
    }

    public final char alterTableAction(TableElementList tableElementList, int[] changeType, int[] behavior) throws ParseException, StandardException {
        char lockGranularity = '\u0000';
        Object tok = null;
        long[] autoIncrementInfo = new long[4];
        switch (this.jj_nt.kind) {
            case 65: {
                ColumnDefinitionNode cdn;
                TableElementNode tableElement;
                this.jj_consume_token(65);
                if (this.jj_2_88(1)) {
                    tableElement = this.addColumnDefinition(tableElementList);
                } else {
                    switch (this.jj_nt.kind) {
                        case 91: 
                        case 100: 
                        case 145: 
                        case 208: 
                        case 252: {
                            tableElement = this.tableConstraintDefinition();
                            break;
                        }
                        default: {
                            this.jj_la1[342] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                if (tableElement instanceof ColumnDefinitionNode && (cdn = (ColumnDefinitionNode)tableElement).isAutoincrementColumn()) {
                    throw StandardException.newException("42601.S.372", new Object[0]);
                }
                changeType[0] = 1;
                tableElementList.addTableElement(tableElement);
                return lockGranularity;
            }
        }
        this.jj_la1[344] = this.jj_gen;
        if (this.getToken((int)1).kind == 68 && this.getToken((int)2).kind != 100) {
            this.jj_consume_token(68);
            switch (this.jj_nt.kind) {
                case 96: {
                    this.jj_consume_token(96);
                    break;
                }
                default: {
                    this.jj_la1[343] = this.jj_gen;
                }
            }
            String columnName = this.identifier(128, true);
            TableElementNode tableElement = this.columnAlterClause(columnName);
            changeType[0] = 3;
            tableElementList.addTableElement(tableElement);
            return lockGranularity;
        }
        switch (this.jj_nt.kind) {
            case 68: {
                this.jj_consume_token(68);
                TableName constraintName = this.constraintNameDefinition();
                boolean enforced = this.constraintEnforcement();
                ConstraintDefinitionNode cdn = new ConstraintDefinitionNode(constraintName, 7, null, null, null, null, 2, 7, this.getContextManager());
                boolean[] cc = new boolean[]{false, false, enforced};
                cdn.setCharacteristics(cc);
                changeType[0] = 3;
                tableElementList.addTableElement(cdn);
                return lockGranularity;
            }
            case 305: {
                lockGranularity = this.DB2lockGranularityClause();
                changeType[0] = 4;
                return lockGranularity;
            }
        }
        this.jj_la1[345] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropColumnDefinition(TableName tableName, TableElementList tableElementList, int[] changeType, int[] behavior) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[346] = this.jj_gen;
            }
        }
        String columnName = this.identifier(128, true);
        this.dropColumnReferentialAction(behavior);
        ModifyColumnNode tableElement = new ModifyColumnNode(4, columnName, null, null, null, this.getContextManager());
        tableElementList.addTableElement(tableElement);
        return new AlterTableNode(tableName, 2, tableElementList, '\u0000', behavior[0], this.getContextManager());
    }

    public final void dropColumnReferentialAction(int[] behavior) throws ParseException {
        int refBehavior = 0;
        block0 : switch (this.jj_nt.kind) {
            case 84: 
            case 217: {
                switch (this.jj_nt.kind) {
                    case 84: {
                        this.jj_consume_token(84);
                        refBehavior = 0;
                        break block0;
                    }
                    case 217: {
                        this.jj_consume_token(217);
                        refBehavior = 1;
                        break block0;
                    }
                }
                this.jj_la1[347] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[348] = this.jj_gen;
            }
        }
        behavior[0] = refBehavior;
    }

    public final TableElementNode addColumnDefinition(TableElementList tableElementList) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[349] = this.jj_gen;
            }
        }
        TableElementNode tableElement = this.columnDefinition(tableElementList);
        return tableElement;
    }

    public final TableElementNode columnAlterClause(String columnName) throws ParseException, StandardException {
        long[] autoIncrementInfo = new long[4];
        long autoIncrementIncrement = 1L;
        long autoIncrementRestartWith = 1L;
        DataTypeDescriptor typeDescriptor = null;
        if (this.getToken((int)2).kind == 284) {
            this.jj_consume_token(227);
            this.jj_consume_token(284);
            this.jj_consume_token(355);
            typeDescriptor = this.dataTypeDDL();
            return new ModifyColumnNode(0, columnName, null, typeDescriptor, null, this.getContextManager());
        }
        if (this.getToken((int)2).kind == 294) {
            this.jj_consume_token(227);
            this.jj_consume_token(294);
            this.jj_consume_token(83);
            autoIncrementInfo[1] = autoIncrementIncrement = this.exactNumber();
            autoIncrementInfo[3] = 2L;
            return new ModifyColumnNode(1, columnName, null, null, autoIncrementInfo, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 329: {
                this.jj_consume_token(329);
                this.jj_consume_token(267);
                autoIncrementInfo[0] = autoIncrementRestartWith = this.exactNumber();
                autoIncrementInfo[3] = 1L;
                return new ModifyColumnNode(1, columnName, null, null, autoIncrementInfo, this.getContextManager());
            }
        }
        this.jj_la1[353] = this.jj_gen;
        if (this.getToken((int)1).kind == 267 || this.getToken((int)1).kind == 119 || this.getToken((int)1).kind == 227 && this.getToken((int)2).kind == 119) {
            switch (this.jj_nt.kind) {
                case 227: {
                    this.jj_consume_token(227);
                    break;
                }
                default: {
                    this.jj_la1[350] = this.jj_gen;
                }
            }
            ValueNode defaultNode = this.defaultClause(autoIncrementInfo, columnName);
            return this.wrapAlterColumnDefaultValue(defaultNode, columnName, autoIncrementInfo);
        }
        if (this.getToken((int)1).kind == 129 && this.getToken((int)2).kind == 119) {
            this.jj_consume_token(129);
            this.jj_consume_token(119);
            UntypedNullConstantNode defaultNode = new UntypedNullConstantNode(this.getContextManager());
            return this.wrapAlterColumnDefaultValue(defaultNode, columnName, autoIncrementInfo);
        }
        if (this.getToken((int)1).kind == 191 || this.getToken((int)1).kind == 129 && this.getToken((int)2).kind == 190) {
            switch (this.jj_nt.kind) {
                case 191: {
                    this.jj_consume_token(191);
                    break;
                }
                case 129: {
                    this.jj_consume_token(129);
                    this.jj_consume_token(190);
                    this.jj_consume_token(191);
                    break;
                }
                default: {
                    this.jj_la1[351] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return new ModifyColumnNode(2, columnName, null, null, null, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 190 || this.getToken((int)1).kind == 227 && this.getToken((int)2).kind == 190) {
            switch (this.jj_nt.kind) {
                case 190: {
                    this.jj_consume_token(190);
                    this.jj_consume_token(191);
                    break;
                }
                case 227: {
                    this.jj_consume_token(227);
                    this.jj_consume_token(190);
                    this.jj_consume_token(191);
                    break;
                }
                default: {
                    this.jj_la1[352] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return new ModifyColumnNode(3, columnName, null, null, null, this.getContextManager());
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropTableConstraintDefinitionCore(TableName tableName, TableElementList tableElementList, int[] changeType, int[] behavior) throws ParseException, StandardException {
        TableElementNode tableElement = this.dropTableConstraintDefinition();
        tableElementList.addTableElement(tableElement);
        return new AlterTableNode(tableName, 2, tableElementList, '\u0000', behavior[0], this.getContextManager());
    }

    public final TableElementNode dropTableConstraintDefinition() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 100) {
            this.jj_consume_token(100);
            TableName constraintName = this.qualifiedName(128);
            return new ConstraintDefinitionNode(constraintName, 5, null, null, null, null, 2, 5, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 208) {
            this.jj_consume_token(208);
            this.jj_consume_token(174);
            return new ConstraintDefinitionNode(null, 5, null, null, null, null, 2, 5, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 145) {
            this.jj_consume_token(145);
            this.jj_consume_token(174);
            TableName constraintName = this.qualifiedName(128);
            return new ConstraintDefinitionNode(constraintName, 5, null, null, null, null, 2, 6, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 252) {
            this.jj_consume_token(252);
            TableName constraintName = this.qualifiedName(128);
            return new ConstraintDefinitionNode(constraintName, 5, null, null, null, null, 2, 3, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 91: {
                this.jj_consume_token(91);
                TableName constraintName = this.qualifiedName(128);
                return new ConstraintDefinitionNode(constraintName, 5, null, null, null, null, 2, 4, this.getContextManager());
            }
        }
        this.jj_la1[354] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        return new DropTableNode(tableName, 2, this.getContextManager());
    }

    public final StatementNode dropIndexStatement() throws ParseException, StandardException {
        this.jj_consume_token(400);
        TableName indexName = this.qualifiedName(128);
        return new DropIndexNode(indexName, this.getContextManager());
    }

    public final StatementNode dropAliasStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 211: {
                this.jj_consume_token(211);
                TableName aliasName = this.qualifiedName(128);
                return this.dropAliasNode(aliasName, 'P');
            }
            case 149: {
                this.jj_consume_token(149);
                TableName aliasName = this.qualifiedName(128);
                return this.dropAliasNode(aliasName, 'F');
            }
            case 348: {
                this.jj_consume_token(348);
                TableName aliasName = this.qualifiedName(128);
                this.checkVersion(130, "DROP SYNONYM");
                return this.dropAliasNode(aliasName, 'S');
            }
            case 355: {
                this.jj_consume_token(355);
                TableName aliasName = this.qualifiedName(128);
                this.jj_consume_token(217);
                this.checkVersion(180, "DROP TYPE");
                return this.dropAliasNode(aliasName, 'A');
            }
            case 391: {
                this.jj_consume_token(391);
                this.jj_consume_token(383);
                TableName aliasName = this.qualifiedName(128);
                this.jj_consume_token(217);
                this.checkVersion(220, "DROP DERBY AGGREGATE");
                return this.dropAliasNode(aliasName, 'G');
            }
        }
        this.jj_la1[355] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropViewStatement() throws ParseException, StandardException {
        this.jj_consume_token(263);
        TableName viewName = this.qualifiedName(128);
        return new DropViewNode(viewName, this.getContextManager());
    }

    public final StatementNode dropTriggerStatement() throws ParseException, StandardException {
        this.jj_consume_token(442);
        TableName triggerName = this.qualifiedName(128);
        return new DropTriggerNode(triggerName, this.getContextManager());
    }

    public final StatementNode truncateTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(354);
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        return new AlterTableNode(tableName, this.getContextManager());
    }

    public final StatementNode grantStatement() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 154 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 195) || this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind))) {
            StatementNode node;
            this.jj_consume_token(154);
            this.checkVersion(140, "GRANT");
            this.checkSqlStandardAccess("GRANT");
            switch (this.jj_nt.kind) {
                case 66: 
                case 122: 
                case 166: 
                case 215: 
                case 225: 
                case 254: 
                case 442: {
                    node = this.tableGrantStatement();
                    break;
                }
                case 137: {
                    node = this.routineGrantStatement();
                    break;
                }
                case 357: {
                    node = this.usageGrantStatement();
                    break;
                }
                default: {
                    this.jj_la1[356] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return node;
        }
        if (this.getToken((int)1).kind == 154 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 243) || !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind))) {
            this.jj_consume_token(154);
            StatementNode node = this.roleGrantStatement();
            return node;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode tableGrantStatement() throws ParseException, StandardException {
        PrivilegeNode privileges = this.tablePrivileges();
        this.jj_consume_token(243);
        List<String> grantees = this.granteeList();
        return new GrantNode(privileges, grantees, this.getContextManager());
    }

    public final PrivilegeNode tablePrivileges() throws ParseException, StandardException {
        TablePrivilegesNode tablePrivilegesNode = null;
        TableName objectName = null;
        tablePrivilegesNode = this.tableActions();
        this.jj_consume_token(195);
        switch (this.jj_nt.kind) {
            case 239: {
                this.jj_consume_token(239);
                break;
            }
            default: {
                this.jj_la1[357] = this.jj_gen;
            }
        }
        objectName = this.qualifiedName(128);
        return new PrivilegeNode(0, objectName, tablePrivilegesNode, this.getContextManager());
    }

    public final TablePrivilegesNode tableActions() throws ParseException, StandardException {
        TablePrivilegesNode tableActionsNode = new TablePrivilegesNode(this.getContextManager());
        switch (this.jj_nt.kind) {
            case 66: {
                this.jj_consume_token(66);
                this.jj_consume_token(210);
                tableActionsNode.addAll();
                return tableActionsNode;
            }
            case 122: 
            case 166: 
            case 215: 
            case 225: 
            case 254: 
            case 442: {
                this.tableAction(tableActionsNode);
                block7: while (true) {
                    switch (this.jj_nt.kind) {
                        case 458: {
                            break;
                        }
                        default: {
                            this.jj_la1[358] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(458);
                    this.tableAction(tableActionsNode);
                }
                return tableActionsNode;
            }
        }
        this.jj_la1[359] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode routineGrantStatement() throws ParseException, StandardException {
        this.jj_consume_token(137);
        this.jj_consume_token(195);
        RoutineDesignator routine = this.routineDesignator();
        this.jj_consume_token(243);
        List<String> grantees = this.granteeList();
        PrivilegeNode routinePrivilege = new PrivilegeNode(1, routine, null, this.getContextManager());
        return new GrantNode(routinePrivilege, grantees, this.getContextManager());
    }

    public final StatementNode usageGrantStatement() throws ParseException, StandardException {
        this.jj_consume_token(357);
        this.jj_consume_token(195);
        Integer objectType = this.usableObjects();
        TableName name = this.qualifiedName(128);
        this.jj_consume_token(243);
        List<String> grantees = this.granteeList();
        this.checkVersion(180, "GRANT USAGE");
        PrivilegeNode privilegeNode = new PrivilegeNode(objectType, name, "USAGE", false, this.getContextManager());
        return new GrantNode(privilegeNode, grantees, this.getContextManager());
    }

    public final Integer usableObjects() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 391: {
                this.jj_consume_token(391);
                this.jj_consume_token(383);
                return ReuseFactory.getInteger(4);
            }
            case 432: {
                this.jj_consume_token(432);
                return ReuseFactory.getInteger(2);
            }
            case 355: {
                this.jj_consume_token(355);
                return ReuseFactory.getInteger(3);
            }
        }
        this.jj_la1[360] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final RoutineDesignator routineDesignator() throws ParseException, StandardException {
        Token procOrFunction;
        List<TypeDescriptor> paramTypeList = null;
        switch (this.jj_nt.kind) {
            case 149: {
                procOrFunction = this.jj_consume_token(149);
                break;
            }
            case 211: {
                procOrFunction = this.jj_consume_token(211);
                break;
            }
            default: {
                this.jj_la1[361] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        TableName name = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 453: {
                this.jj_consume_token(453);
                paramTypeList = this.parameterTypeList();
                this.jj_consume_token(454);
                break;
            }
            default: {
                this.jj_la1[362] = this.jj_gen;
            }
        }
        return new RoutineDesignator(name, procOrFunction.kind == 149, paramTypeList);
    }

    public final List<TypeDescriptor> parameterTypeList() throws ParseException, StandardException {
        ArrayList<TypeDescriptor> list = new ArrayList<TypeDescriptor>();
        if (this.jj_2_89(1)) {
            TypeDescriptor type = this.catalogType();
            list.add(type);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 458: {
                        break;
                    }
                    default: {
                        this.jj_la1[363] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(458);
                type = this.catalogType();
                list.add(type);
            }
        }
        return list;
    }

    public final void tableAction(TablePrivilegesNode tablePrivilegesNode) throws ParseException, StandardException {
        ResultColumnList columnList = null;
        switch (this.jj_nt.kind) {
            case 225: {
                this.jj_consume_token(225);
                switch (this.jj_nt.kind) {
                    case 453: {
                        columnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[364] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(0, columnList);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                tablePrivilegesNode.addAction(1, null);
                break;
            }
            case 166: {
                this.jj_consume_token(166);
                tablePrivilegesNode.addAction(2, null);
                break;
            }
            case 254: {
                this.jj_consume_token(254);
                switch (this.jj_nt.kind) {
                    case 453: {
                        columnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[365] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(3, columnList);
                break;
            }
            case 215: {
                this.jj_consume_token(215);
                switch (this.jj_nt.kind) {
                    case 453: {
                        columnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[366] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(4, columnList);
                break;
            }
            case 442: {
                this.jj_consume_token(442);
                tablePrivilegesNode.addAction(5, null);
                break;
            }
            default: {
                this.jj_la1[367] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final ResultColumnList privilegeColumnList() throws ParseException, StandardException {
        ResultColumnList cl = new ResultColumnList(this.getContextManager());
        this.jj_consume_token(453);
        this.columnNameList(cl);
        this.jj_consume_token(454);
        return cl;
    }

    public final List<String> granteeList() throws ParseException, StandardException {
        ArrayList<String> list = new ArrayList<String>();
        this.grantee(list);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[368] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.grantee(list);
        }
        return list;
    }

    public final void grantee(List<String> list) throws ParseException, StandardException {
        if (this.jj_2_90(1)) {
            String str = this.identifier(128, true);
            list.add(str);
        } else {
            switch (this.jj_nt.kind) {
                case 212: {
                    this.jj_consume_token(212);
                    list.add("PUBLIC");
                    break;
                }
                default: {
                    this.jj_la1[369] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final StatementNode roleGrantStatement() throws ParseException, StandardException {
        List<String> rolesGranted = this.roleList();
        this.jj_consume_token(243);
        List<String> grantees = this.granteeList();
        this.checkSqlStandardAccess("GRANT <role>");
        this.checkVersion(170, "ROLES");
        return new GrantRoleNode(rolesGranted, grantees, this.getContextManager());
    }

    public final List<String> roleList() throws ParseException, StandardException {
        ArrayList<String> list = new ArrayList<String>();
        this.roleElement(list);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 458: {
                    break;
                }
                default: {
                    this.jj_la1[370] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(458);
            this.roleElement(list);
        }
        return list;
    }

    public final void roleElement(List<String> list) throws ParseException, StandardException {
        String str = this.identifier(128, true);
        list.add(str);
    }

    public final StatementNode revokeStatement() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 218 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 195) || this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind))) {
            StatementNode node;
            this.jj_consume_token(218);
            this.checkVersion(140, "REVOKE");
            this.checkSqlStandardAccess("REVOKE");
            switch (this.jj_nt.kind) {
                case 66: 
                case 122: 
                case 166: 
                case 215: 
                case 225: 
                case 254: 
                case 442: {
                    node = this.tableRevokeStatement();
                    break;
                }
                case 137: {
                    node = this.routineRevokeStatement();
                    break;
                }
                case 357: {
                    node = this.usageRevokeStatement();
                    break;
                }
                default: {
                    this.jj_la1[371] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return node;
        }
        if (this.getToken((int)1).kind == 218 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 147) || !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind))) {
            this.jj_consume_token(218);
            this.checkVersion(170, "ROLES");
            this.checkSqlStandardAccess("REVOKE <role>");
            StatementNode node = this.roleRevokeStatement();
            return node;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode tableRevokeStatement() throws ParseException, StandardException {
        PrivilegeNode privileges = null;
        privileges = this.tablePrivileges();
        this.jj_consume_token(147);
        List<String> grantees = this.granteeList();
        return new RevokeNode(privileges, grantees, this.getContextManager());
    }

    public final StatementNode routineRevokeStatement() throws ParseException, StandardException {
        RoutineDesignator routine = null;
        this.jj_consume_token(137);
        this.jj_consume_token(195);
        routine = this.routineDesignator();
        this.jj_consume_token(147);
        List<String> grantees = this.granteeList();
        this.jj_consume_token(217);
        PrivilegeNode routinePrivilege = new PrivilegeNode(1, routine, null, this.getContextManager());
        return new RevokeNode(routinePrivilege, grantees, this.getContextManager());
    }

    public final StatementNode usageRevokeStatement() throws ParseException, StandardException {
        this.jj_consume_token(357);
        this.jj_consume_token(195);
        Integer objectType = this.usableObjects();
        TableName name = this.qualifiedName(128);
        this.jj_consume_token(147);
        List<String> grantees = this.granteeList();
        this.jj_consume_token(217);
        this.checkVersion(180, "REVOKE USAGE");
        PrivilegeNode privilegeNode = new PrivilegeNode(objectType, name, "USAGE", true, this.getContextManager());
        return new RevokeNode(privilegeNode, grantees, this.getContextManager());
    }

    public final StatementNode roleRevokeStatement() throws ParseException, StandardException {
        List<String> rolesRevoked = this.roleList();
        this.jj_consume_token(147);
        List<String> grantees = this.granteeList();
        return new RevokeRoleNode(rolesRevoked, grantees, this.getContextManager());
    }

    public final String internalIdentifier(int id_length_limit, boolean checkLength) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 480: {
                Token tok = this.jj_consume_token(480);
                String str = StringUtil.SQLToUpperCase(tok.image);
                if (checkLength) {
                    IdUtil.checkIdentifierLengthLimit(str, id_length_limit);
                }
                this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
                this.lastTokenDelimitedIdentifier = false;
                this.thirdToLastIdentifierToken = this.nextToLastIdentifierToken;
                this.nextToLastIdentifierToken = this.lastIdentifierToken;
                this.lastIdentifierToken = tok;
                return str;
            }
            case 486: {
                String str = this.delimitedIdentifier();
                if (checkLength) {
                    IdUtil.checkIdentifierLengthLimit(str, id_length_limit);
                }
                return str;
            }
        }
        this.jj_la1[372] = this.jj_gen;
        if (this.jj_2_91(1)) {
            String str = this.nonReservedKeyword();
            return StringUtil.SQLToUpperCase(str);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String identifier(int id_length_limit, boolean checkLength) throws ParseException, StandardException {
        String id = this.internalIdentifier(id_length_limit, checkLength);
        return id;
    }

    public final String delimitedIdentifier() throws ParseException {
        Token tok = this.jj_consume_token(486);
        String str = tok.image.substring(1, tok.image.length() - 1);
        str = SQLParser.normalizeDelimitedID(str);
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = true;
        this.thirdToLastIdentifierToken = this.nextToLastIdentifierToken;
        this.nextToLastIdentifierToken = this.lastIdentifierToken;
        this.lastIdentifierToken = tok;
        return str;
    }

    public final String reservedKeyword() throws ParseException {
        Token tok;
        switch (this.jj_nt.kind) {
            case 65: {
                tok = this.jj_consume_token(65);
                break;
            }
            case 66: {
                tok = this.jj_consume_token(66);
                break;
            }
            case 67: {
                tok = this.jj_consume_token(67);
                break;
            }
            case 68: {
                tok = this.jj_consume_token(68);
                break;
            }
            case 69: {
                tok = this.jj_consume_token(69);
                break;
            }
            case 70: {
                tok = this.jj_consume_token(70);
                break;
            }
            case 71: {
                tok = this.jj_consume_token(71);
                break;
            }
            case 72: {
                tok = this.jj_consume_token(72);
                break;
            }
            case 73: {
                tok = this.jj_consume_token(73);
                break;
            }
            case 74: {
                tok = this.jj_consume_token(74);
                break;
            }
            case 75: {
                tok = this.jj_consume_token(75);
                break;
            }
            case 76: {
                tok = this.jj_consume_token(76);
                break;
            }
            case 77: {
                tok = this.jj_consume_token(77);
                break;
            }
            case 78: {
                tok = this.jj_consume_token(78);
                break;
            }
            case 79: {
                tok = this.jj_consume_token(79);
                break;
            }
            case 81: {
                tok = this.jj_consume_token(81);
                break;
            }
            case 82: {
                tok = this.jj_consume_token(82);
                break;
            }
            case 83: {
                tok = this.jj_consume_token(83);
                break;
            }
            case 84: {
                tok = this.jj_consume_token(84);
                break;
            }
            case 85: {
                tok = this.jj_consume_token(85);
                break;
            }
            case 86: {
                tok = this.jj_consume_token(86);
                break;
            }
            case 87: {
                tok = this.jj_consume_token(87);
                break;
            }
            case 88: {
                tok = this.jj_consume_token(88);
                break;
            }
            case 89: {
                tok = this.jj_consume_token(89);
                break;
            }
            case 91: {
                tok = this.jj_consume_token(91);
                break;
            }
            case 92: {
                tok = this.jj_consume_token(92);
                break;
            }
            case 94: {
                tok = this.jj_consume_token(94);
                break;
            }
            case 95: {
                tok = this.jj_consume_token(95);
                break;
            }
            case 96: {
                tok = this.jj_consume_token(96);
                break;
            }
            case 97: {
                tok = this.jj_consume_token(97);
                break;
            }
            case 98: {
                tok = this.jj_consume_token(98);
                break;
            }
            case 99: {
                tok = this.jj_consume_token(99);
                break;
            }
            case 100: {
                tok = this.jj_consume_token(100);
                break;
            }
            case 101: {
                tok = this.jj_consume_token(101);
                break;
            }
            case 102: {
                tok = this.jj_consume_token(102);
                break;
            }
            case 103: {
                tok = this.jj_consume_token(103);
                break;
            }
            case 104: {
                tok = this.jj_consume_token(104);
                break;
            }
            case 106: {
                tok = this.jj_consume_token(106);
                break;
            }
            case 107: {
                tok = this.jj_consume_token(107);
                break;
            }
            case 108: {
                tok = this.jj_consume_token(108);
                break;
            }
            case 109: {
                tok = this.jj_consume_token(109);
                break;
            }
            case 110: {
                tok = this.jj_consume_token(110);
                break;
            }
            case 111: {
                tok = this.jj_consume_token(111);
                break;
            }
            case 112: {
                tok = this.jj_consume_token(112);
                break;
            }
            case 113: {
                tok = this.jj_consume_token(113);
                break;
            }
            case 115: {
                tok = this.jj_consume_token(115);
                break;
            }
            case 116: {
                tok = this.jj_consume_token(116);
                break;
            }
            case 117: {
                tok = this.jj_consume_token(117);
                break;
            }
            case 118: {
                tok = this.jj_consume_token(118);
                break;
            }
            case 119: {
                tok = this.jj_consume_token(119);
                break;
            }
            case 120: {
                tok = this.jj_consume_token(120);
                break;
            }
            case 121: {
                tok = this.jj_consume_token(121);
                break;
            }
            case 122: {
                tok = this.jj_consume_token(122);
                break;
            }
            case 123: {
                tok = this.jj_consume_token(123);
                break;
            }
            case 124: {
                tok = this.jj_consume_token(124);
                break;
            }
            case 125: {
                tok = this.jj_consume_token(125);
                break;
            }
            case 126: {
                tok = this.jj_consume_token(126);
                break;
            }
            case 127: {
                tok = this.jj_consume_token(127);
                break;
            }
            case 128: {
                tok = this.jj_consume_token(128);
                break;
            }
            case 129: {
                tok = this.jj_consume_token(129);
                break;
            }
            case 130: {
                tok = this.jj_consume_token(130);
                break;
            }
            case 131: {
                tok = this.jj_consume_token(131);
                break;
            }
            case 132: {
                tok = this.jj_consume_token(132);
                break;
            }
            case 133: {
                tok = this.jj_consume_token(133);
                break;
            }
            case 134: {
                tok = this.jj_consume_token(134);
                break;
            }
            case 135: {
                tok = this.jj_consume_token(135);
                break;
            }
            case 136: {
                tok = this.jj_consume_token(136);
                break;
            }
            case 137: {
                tok = this.jj_consume_token(137);
                break;
            }
            case 138: {
                tok = this.jj_consume_token(138);
                break;
            }
            case 139: {
                tok = this.jj_consume_token(139);
                break;
            }
            case 140: {
                tok = this.jj_consume_token(140);
                break;
            }
            case 141: {
                tok = this.jj_consume_token(141);
                break;
            }
            case 142: {
                tok = this.jj_consume_token(142);
                break;
            }
            case 143: {
                tok = this.jj_consume_token(143);
                break;
            }
            case 144: {
                tok = this.jj_consume_token(144);
                break;
            }
            case 145: {
                tok = this.jj_consume_token(145);
                break;
            }
            case 146: {
                tok = this.jj_consume_token(146);
                break;
            }
            case 147: {
                tok = this.jj_consume_token(147);
                break;
            }
            case 148: {
                tok = this.jj_consume_token(148);
                break;
            }
            case 149: {
                tok = this.jj_consume_token(149);
                break;
            }
            case 150: {
                tok = this.jj_consume_token(150);
                break;
            }
            case 366: {
                tok = this.jj_consume_token(366);
                break;
            }
            case 151: {
                tok = this.jj_consume_token(151);
                break;
            }
            case 152: {
                tok = this.jj_consume_token(152);
                break;
            }
            case 153: {
                tok = this.jj_consume_token(153);
                break;
            }
            case 154: {
                tok = this.jj_consume_token(154);
                break;
            }
            case 155: {
                tok = this.jj_consume_token(155);
                break;
            }
            case 156: {
                tok = this.jj_consume_token(156);
                break;
            }
            case 157: {
                tok = this.jj_consume_token(157);
                break;
            }
            case 158: {
                tok = this.jj_consume_token(158);
                break;
            }
            case 159: {
                tok = this.jj_consume_token(159);
                break;
            }
            case 160: {
                tok = this.jj_consume_token(160);
                break;
            }
            case 161: {
                tok = this.jj_consume_token(161);
                break;
            }
            case 162: {
                tok = this.jj_consume_token(162);
                break;
            }
            case 163: {
                tok = this.jj_consume_token(163);
                break;
            }
            case 296: {
                tok = this.jj_consume_token(296);
                break;
            }
            case 164: {
                tok = this.jj_consume_token(164);
                break;
            }
            case 165: {
                tok = this.jj_consume_token(165);
                break;
            }
            case 166: {
                tok = this.jj_consume_token(166);
                break;
            }
            case 167: {
                tok = this.jj_consume_token(167);
                break;
            }
            case 168: {
                tok = this.jj_consume_token(168);
                break;
            }
            case 169: {
                tok = this.jj_consume_token(169);
                break;
            }
            case 170: {
                tok = this.jj_consume_token(170);
                break;
            }
            case 171: {
                tok = this.jj_consume_token(171);
                break;
            }
            case 172: {
                tok = this.jj_consume_token(172);
                break;
            }
            case 173: {
                tok = this.jj_consume_token(173);
                break;
            }
            case 174: {
                tok = this.jj_consume_token(174);
                break;
            }
            case 175: {
                tok = this.jj_consume_token(175);
                break;
            }
            case 176: {
                tok = this.jj_consume_token(176);
                break;
            }
            case 177: {
                tok = this.jj_consume_token(177);
                break;
            }
            case 178: {
                tok = this.jj_consume_token(178);
                break;
            }
            case 179: {
                tok = this.jj_consume_token(179);
                break;
            }
            case 180: {
                tok = this.jj_consume_token(180);
                break;
            }
            case 181: {
                tok = this.jj_consume_token(181);
                break;
            }
            case 182: {
                tok = this.jj_consume_token(182);
                break;
            }
            case 183: {
                tok = this.jj_consume_token(183);
                break;
            }
            case 185: {
                tok = this.jj_consume_token(185);
                break;
            }
            case 186: {
                tok = this.jj_consume_token(186);
                break;
            }
            case 187: {
                tok = this.jj_consume_token(187);
                break;
            }
            case 411: {
                tok = this.jj_consume_token(411);
                break;
            }
            case 188: {
                tok = this.jj_consume_token(188);
                break;
            }
            case 189: {
                tok = this.jj_consume_token(189);
                break;
            }
            case 371: {
                tok = this.jj_consume_token(371);
                break;
            }
            case 190: {
                tok = this.jj_consume_token(190);
                break;
            }
            case 191: {
                tok = this.jj_consume_token(191);
                break;
            }
            case 192: {
                tok = this.jj_consume_token(192);
                break;
            }
            case 193: {
                tok = this.jj_consume_token(193);
                break;
            }
            case 194: {
                tok = this.jj_consume_token(194);
                break;
            }
            case 195: {
                tok = this.jj_consume_token(195);
                break;
            }
            case 196: {
                tok = this.jj_consume_token(196);
                break;
            }
            case 197: {
                tok = this.jj_consume_token(197);
                break;
            }
            case 198: {
                tok = this.jj_consume_token(198);
                break;
            }
            case 199: {
                tok = this.jj_consume_token(199);
                break;
            }
            case 200: {
                tok = this.jj_consume_token(200);
                break;
            }
            case 416: {
                tok = this.jj_consume_token(416);
                break;
            }
            case 201: {
                tok = this.jj_consume_token(201);
                break;
            }
            case 202: {
                tok = this.jj_consume_token(202);
                break;
            }
            case 203: {
                tok = this.jj_consume_token(203);
                break;
            }
            case 204: {
                tok = this.jj_consume_token(204);
                break;
            }
            case 205: {
                tok = this.jj_consume_token(205);
                break;
            }
            case 206: {
                tok = this.jj_consume_token(206);
                break;
            }
            case 207: {
                tok = this.jj_consume_token(207);
                break;
            }
            case 208: {
                tok = this.jj_consume_token(208);
                break;
            }
            case 209: {
                tok = this.jj_consume_token(209);
                break;
            }
            case 210: {
                tok = this.jj_consume_token(210);
                break;
            }
            case 211: {
                tok = this.jj_consume_token(211);
                break;
            }
            case 212: {
                tok = this.jj_consume_token(212);
                break;
            }
            case 213: {
                tok = this.jj_consume_token(213);
                break;
            }
            case 214: {
                tok = this.jj_consume_token(214);
                break;
            }
            case 215: {
                tok = this.jj_consume_token(215);
                break;
            }
            case 216: {
                tok = this.jj_consume_token(216);
                break;
            }
            case 217: {
                tok = this.jj_consume_token(217);
                break;
            }
            case 218: {
                tok = this.jj_consume_token(218);
                break;
            }
            case 219: {
                tok = this.jj_consume_token(219);
                break;
            }
            case 220: {
                tok = this.jj_consume_token(220);
                break;
            }
            case 221: {
                tok = this.jj_consume_token(221);
                break;
            }
            case 222: {
                tok = this.jj_consume_token(222);
                break;
            }
            case 223: {
                tok = this.jj_consume_token(223);
                break;
            }
            case 224: {
                tok = this.jj_consume_token(224);
                break;
            }
            case 225: {
                tok = this.jj_consume_token(225);
                break;
            }
            case 226: {
                tok = this.jj_consume_token(226);
                break;
            }
            case 227: {
                tok = this.jj_consume_token(227);
                break;
            }
            case 228: {
                tok = this.jj_consume_token(228);
                break;
            }
            case 229: {
                tok = this.jj_consume_token(229);
                break;
            }
            case 230: {
                tok = this.jj_consume_token(230);
                break;
            }
            case 231: {
                tok = this.jj_consume_token(231);
                break;
            }
            case 232: {
                tok = this.jj_consume_token(232);
                break;
            }
            case 233: {
                tok = this.jj_consume_token(233);
                break;
            }
            case 234: {
                tok = this.jj_consume_token(234);
                break;
            }
            case 235: {
                tok = this.jj_consume_token(235);
                break;
            }
            case 236: {
                tok = this.jj_consume_token(236);
                break;
            }
            case 237: {
                tok = this.jj_consume_token(237);
                break;
            }
            case 239: {
                tok = this.jj_consume_token(239);
                break;
            }
            case 240: {
                tok = this.jj_consume_token(240);
                break;
            }
            case 241: {
                tok = this.jj_consume_token(241);
                break;
            }
            case 242: {
                tok = this.jj_consume_token(242);
                break;
            }
            case 243: {
                tok = this.jj_consume_token(243);
                break;
            }
            case 247: {
                tok = this.jj_consume_token(247);
                break;
            }
            case 244: {
                tok = this.jj_consume_token(244);
                break;
            }
            case 245: {
                tok = this.jj_consume_token(245);
                break;
            }
            case 246: {
                tok = this.jj_consume_token(246);
                break;
            }
            case 249: {
                tok = this.jj_consume_token(249);
                break;
            }
            case 251: {
                tok = this.jj_consume_token(251);
                break;
            }
            case 252: {
                tok = this.jj_consume_token(252);
                break;
            }
            case 253: {
                tok = this.jj_consume_token(253);
                break;
            }
            case 254: {
                tok = this.jj_consume_token(254);
                break;
            }
            case 255: {
                tok = this.jj_consume_token(255);
                break;
            }
            case 256: {
                tok = this.jj_consume_token(256);
                break;
            }
            case 257: {
                tok = this.jj_consume_token(257);
                break;
            }
            case 259: {
                tok = this.jj_consume_token(259);
                break;
            }
            case 261: {
                tok = this.jj_consume_token(261);
                break;
            }
            case 262: {
                tok = this.jj_consume_token(262);
                break;
            }
            case 263: {
                tok = this.jj_consume_token(263);
                break;
            }
            case 264: {
                tok = this.jj_consume_token(264);
                break;
            }
            case 265: {
                tok = this.jj_consume_token(265);
                break;
            }
            case 267: {
                tok = this.jj_consume_token(267);
                break;
            }
            case 268: {
                tok = this.jj_consume_token(268);
                break;
            }
            case 269: {
                tok = this.jj_consume_token(269);
                break;
            }
            case 270: {
                tok = this.jj_consume_token(270);
                break;
            }
            case 360: {
                tok = this.jj_consume_token(360);
                break;
            }
            case 361: {
                tok = this.jj_consume_token(361);
                break;
            }
            case 363: {
                tok = this.jj_consume_token(363);
                break;
            }
            case 367: {
                tok = this.jj_consume_token(367);
                break;
            }
            case 368: {
                tok = this.jj_consume_token(368);
                break;
            }
            case 370: {
                tok = this.jj_consume_token(370);
                break;
            }
            case 375: {
                tok = this.jj_consume_token(375);
                break;
            }
            case 248: {
                tok = this.jj_consume_token(248);
                break;
            }
            case 376: {
                tok = this.jj_consume_token(376);
                break;
            }
            case 377: {
                tok = this.jj_consume_token(377);
                break;
            }
            case 379: {
                tok = this.jj_consume_token(379);
                break;
            }
            case 381: {
                tok = this.jj_consume_token(381);
                break;
            }
            case 378: {
                tok = this.jj_consume_token(378);
                break;
            }
            case 380: {
                tok = this.jj_consume_token(380);
                break;
            }
            default: {
                this.jj_la1[373] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = false;
        return tok.image;
    }

    public final String nonReservedKeyword() throws ParseException {
        Token tok;
        block0 : switch (this.jj_nt.kind) {
            case 271: {
                tok = this.jj_consume_token(271);
                break;
            }
            case 272: {
                tok = this.jj_consume_token(272);
                break;
            }
            case 273: {
                tok = this.jj_consume_token(273);
                break;
            }
            case 382: {
                tok = this.jj_consume_token(382);
                break;
            }
            case 383: {
                tok = this.jj_consume_token(383);
                break;
            }
            case 274: {
                tok = this.jj_consume_token(274);
                break;
            }
            case 384: {
                tok = this.jj_consume_token(384);
                break;
            }
            case 80: {
                tok = this.jj_consume_token(80);
                break;
            }
            case 275: {
                tok = this.jj_consume_token(275);
                break;
            }
            case 276: {
                tok = this.jj_consume_token(276);
                break;
            }
            case 277: {
                tok = this.jj_consume_token(277);
                break;
            }
            case 385: {
                tok = this.jj_consume_token(385);
                break;
            }
            case 278: {
                tok = this.jj_consume_token(278);
                break;
            }
            case 93: {
                tok = this.jj_consume_token(93);
                break;
            }
            case 279: {
                tok = this.jj_consume_token(279);
                break;
            }
            case 280: {
                tok = this.jj_consume_token(280);
                break;
            }
            case 386: {
                tok = this.jj_consume_token(386);
                break;
            }
            case 281: {
                tok = this.jj_consume_token(281);
                break;
            }
            case 282: {
                tok = this.jj_consume_token(282);
                break;
            }
            case 387: {
                tok = this.jj_consume_token(387);
                break;
            }
            case 105: {
                tok = this.jj_consume_token(105);
                break;
            }
            case 388: {
                tok = this.jj_consume_token(388);
                break;
            }
            case 362: {
                tok = this.jj_consume_token(362);
                break;
            }
            case 364: {
                tok = this.jj_consume_token(364);
                break;
            }
            case 283: {
                tok = this.jj_consume_token(283);
                break;
            }
            case 114: {
                tok = this.jj_consume_token(114);
                break;
            }
            case 284: {
                tok = this.jj_consume_token(284);
                break;
            }
            case 285: {
                tok = this.jj_consume_token(285);
                break;
            }
            case 286: {
                tok = this.jj_consume_token(286);
                break;
            }
            case 393: {
                tok = this.jj_consume_token(393);
                break;
            }
            case 394: {
                tok = this.jj_consume_token(394);
                break;
            }
            case 289: {
                tok = this.jj_consume_token(289);
                break;
            }
            case 365: {
                tok = this.jj_consume_token(365);
                break;
            }
            case 390: {
                tok = this.jj_consume_token(390);
                break;
            }
            case 391: {
                tok = this.jj_consume_token(391);
                break;
            }
            case 392: {
                tok = this.jj_consume_token(392);
                break;
            }
            case 395: {
                tok = this.jj_consume_token(395);
                break;
            }
            case 290: {
                tok = this.jj_consume_token(290);
                break;
            }
            case 396: {
                tok = this.jj_consume_token(396);
                break;
            }
            case 397: {
                tok = this.jj_consume_token(397);
                break;
            }
            case 398: {
                tok = this.jj_consume_token(398);
                break;
            }
            case 399: {
                tok = this.jj_consume_token(399);
                break;
            }
            case 291: {
                tok = this.jj_consume_token(291);
                break;
            }
            case 292: {
                tok = this.jj_consume_token(292);
                break;
            }
            case 293: {
                tok = this.jj_consume_token(293);
                break;
            }
            case 294: {
                tok = this.jj_consume_token(294);
                break;
            }
            case 400: {
                tok = this.jj_consume_token(400);
                break;
            }
            case 295: {
                tok = this.jj_consume_token(295);
                break;
            }
            case 401: {
                tok = this.jj_consume_token(401);
                break;
            }
            case 297: {
                tok = this.jj_consume_token(297);
                break;
            }
            case 402: {
                tok = this.jj_consume_token(402);
                break;
            }
            case 299: {
                tok = this.jj_consume_token(299);
                break;
            }
            case 300: {
                tok = this.jj_consume_token(300);
                break;
            }
            case 403: {
                tok = this.jj_consume_token(403);
                break;
            }
            case 301: {
                tok = this.jj_consume_token(301);
                break;
            }
            case 302: {
                tok = this.jj_consume_token(302);
                break;
            }
            case 303: {
                tok = this.jj_consume_token(303);
                break;
            }
            case 404: {
                tok = this.jj_consume_token(404);
                break;
            }
            case 405: {
                tok = this.jj_consume_token(405);
                break;
            }
            case 304: {
                tok = this.jj_consume_token(304);
                break;
            }
            case 305: {
                tok = this.jj_consume_token(305);
                break;
            }
            case 306: {
                tok = this.jj_consume_token(306);
                break;
            }
            case 369: {
                tok = this.jj_consume_token(369);
                break;
            }
            case 307: {
                tok = this.jj_consume_token(307);
                break;
            }
            case 308: {
                tok = this.jj_consume_token(308);
                break;
            }
            case 309: {
                tok = this.jj_consume_token(309);
                break;
            }
            case 310: {
                tok = this.jj_consume_token(310);
                break;
            }
            case 406: {
                tok = this.jj_consume_token(406);
                break;
            }
            case 407: {
                tok = this.jj_consume_token(407);
                break;
            }
            case 311: {
                tok = this.jj_consume_token(311);
                break;
            }
            case 408: {
                tok = this.jj_consume_token(408);
                break;
            }
            case 312: {
                tok = this.jj_consume_token(312);
                break;
            }
            case 313: {
                tok = this.jj_consume_token(313);
                break;
            }
            case 184: {
                tok = this.jj_consume_token(184);
                break;
            }
            case 314: {
                tok = this.jj_consume_token(314);
                break;
            }
            case 315: {
                tok = this.jj_consume_token(315);
                break;
            }
            case 316: {
                tok = this.jj_consume_token(316);
                break;
            }
            case 317: {
                tok = this.jj_consume_token(317);
                break;
            }
            case 318: {
                tok = this.jj_consume_token(318);
                break;
            }
            case 409: {
                tok = this.jj_consume_token(409);
                break;
            }
            case 410: {
                tok = this.jj_consume_token(410);
                break;
            }
            case 319: {
                tok = this.jj_consume_token(319);
                break;
            }
            case 320: {
                tok = this.jj_consume_token(320);
                break;
            }
            case 321: {
                tok = this.jj_consume_token(321);
                break;
            }
            case 322: {
                tok = this.jj_consume_token(322);
                break;
            }
            case 413: {
                tok = this.jj_consume_token(413);
                break;
            }
            default: {
                this.jj_la1[374] = this.jj_gen;
                if (this.getToken((int)1).kind == 323 && !this.seeingOffsetClause()) {
                    tok = this.jj_consume_token(323);
                    break;
                }
                switch (this.jj_nt.kind) {
                    case 414: {
                        tok = this.jj_consume_token(414);
                        break block0;
                    }
                    case 415: {
                        tok = this.jj_consume_token(415);
                        break block0;
                    }
                    case 412: {
                        tok = this.jj_consume_token(412);
                        break block0;
                    }
                    case 372: {
                        tok = this.jj_consume_token(372);
                        break block0;
                    }
                    case 324: {
                        tok = this.jj_consume_token(324);
                        break block0;
                    }
                    case 418: {
                        tok = this.jj_consume_token(418);
                        break block0;
                    }
                    case 325: {
                        tok = this.jj_consume_token(325);
                        break block0;
                    }
                    case 326: {
                        tok = this.jj_consume_token(326);
                        break block0;
                    }
                    case 419: {
                        tok = this.jj_consume_token(419);
                        break block0;
                    }
                    case 420: {
                        tok = this.jj_consume_token(420);
                        break block0;
                    }
                    case 421: {
                        tok = this.jj_consume_token(421);
                        break block0;
                    }
                    case 422: {
                        tok = this.jj_consume_token(422);
                        break block0;
                    }
                    case 327: {
                        tok = this.jj_consume_token(327);
                        break block0;
                    }
                    case 424: {
                        tok = this.jj_consume_token(424);
                        break block0;
                    }
                    case 328: {
                        tok = this.jj_consume_token(328);
                        break block0;
                    }
                    case 423: {
                        tok = this.jj_consume_token(423);
                        break block0;
                    }
                    case 425: {
                        tok = this.jj_consume_token(425);
                        break block0;
                    }
                    case 329: {
                        tok = this.jj_consume_token(329);
                        break block0;
                    }
                    case 426: {
                        tok = this.jj_consume_token(426);
                        break block0;
                    }
                    case 427: {
                        tok = this.jj_consume_token(427);
                        break block0;
                    }
                    case 428: {
                        tok = this.jj_consume_token(428);
                        break block0;
                    }
                    case 330: {
                        tok = this.jj_consume_token(330);
                        break block0;
                    }
                    case 373: {
                        tok = this.jj_consume_token(373);
                        break block0;
                    }
                    case 331: {
                        tok = this.jj_consume_token(331);
                        break block0;
                    }
                    case 332: {
                        tok = this.jj_consume_token(332);
                        break block0;
                    }
                    case 374: {
                        tok = this.jj_consume_token(374);
                        break block0;
                    }
                    case 429: {
                        tok = this.jj_consume_token(429);
                        break block0;
                    }
                    case 430: {
                        tok = this.jj_consume_token(430);
                        break block0;
                    }
                    case 334: {
                        tok = this.jj_consume_token(334);
                        break block0;
                    }
                    case 333: {
                        tok = this.jj_consume_token(333);
                        break block0;
                    }
                    case 335: {
                        tok = this.jj_consume_token(335);
                        break block0;
                    }
                    case 432: {
                        tok = this.jj_consume_token(432);
                        break block0;
                    }
                    case 433: {
                        tok = this.jj_consume_token(433);
                        break block0;
                    }
                    case 336: {
                        tok = this.jj_consume_token(336);
                        break block0;
                    }
                    case 434: {
                        tok = this.jj_consume_token(434);
                        break block0;
                    }
                    case 435: {
                        tok = this.jj_consume_token(435);
                        break block0;
                    }
                    case 437: {
                        tok = this.jj_consume_token(437);
                        break block0;
                    }
                    case 436: {
                        tok = this.jj_consume_token(436);
                        break block0;
                    }
                    case 337: {
                        tok = this.jj_consume_token(337);
                        break block0;
                    }
                    case 338: {
                        tok = this.jj_consume_token(338);
                        break block0;
                    }
                    case 339: {
                        tok = this.jj_consume_token(339);
                        break block0;
                    }
                    case 340: {
                        tok = this.jj_consume_token(340);
                        break block0;
                    }
                    case 341: {
                        tok = this.jj_consume_token(341);
                        break block0;
                    }
                    case 342: {
                        tok = this.jj_consume_token(342);
                        break block0;
                    }
                    case 343: {
                        tok = this.jj_consume_token(343);
                        break block0;
                    }
                    case 344: {
                        tok = this.jj_consume_token(344);
                        break block0;
                    }
                    case 345: {
                        tok = this.jj_consume_token(345);
                        break block0;
                    }
                    case 438: {
                        tok = this.jj_consume_token(438);
                        break block0;
                    }
                    case 439: {
                        tok = this.jj_consume_token(439);
                        break block0;
                    }
                    case 346: {
                        tok = this.jj_consume_token(346);
                        break block0;
                    }
                    case 347: {
                        tok = this.jj_consume_token(347);
                        break block0;
                    }
                    case 431: {
                        tok = this.jj_consume_token(431);
                        break block0;
                    }
                    case 440: {
                        tok = this.jj_consume_token(440);
                        break block0;
                    }
                    case 348: {
                        tok = this.jj_consume_token(348);
                        break block0;
                    }
                    case 441: {
                        tok = this.jj_consume_token(441);
                        break block0;
                    }
                    case 238: {
                        tok = this.jj_consume_token(238);
                        break block0;
                    }
                    case 349: {
                        tok = this.jj_consume_token(349);
                        break block0;
                    }
                    case 350: {
                        tok = this.jj_consume_token(350);
                        break block0;
                    }
                    case 351: {
                        tok = this.jj_consume_token(351);
                        break block0;
                    }
                    case 352: {
                        tok = this.jj_consume_token(352);
                        break block0;
                    }
                    case 353: {
                        tok = this.jj_consume_token(353);
                        break block0;
                    }
                    case 442: {
                        tok = this.jj_consume_token(442);
                        break block0;
                    }
                    case 354: {
                        tok = this.jj_consume_token(354);
                        break block0;
                    }
                    case 443: {
                        tok = this.jj_consume_token(443);
                        break block0;
                    }
                    case 250: {
                        tok = this.jj_consume_token(250);
                        break block0;
                    }
                    case 355: {
                        tok = this.jj_consume_token(355);
                        break block0;
                    }
                    case 444: {
                        tok = this.jj_consume_token(444);
                        break block0;
                    }
                    case 356: {
                        tok = this.jj_consume_token(356);
                        break block0;
                    }
                    case 445: {
                        tok = this.jj_consume_token(445);
                        break block0;
                    }
                    case 357: {
                        tok = this.jj_consume_token(357);
                        break block0;
                    }
                    case 258: {
                        tok = this.jj_consume_token(258);
                        break block0;
                    }
                    case 260: {
                        tok = this.jj_consume_token(260);
                        break block0;
                    }
                    case 417: {
                        tok = this.jj_consume_token(417);
                        break block0;
                    }
                    case 358: {
                        tok = this.jj_consume_token(358);
                        break block0;
                    }
                    case 446: {
                        tok = this.jj_consume_token(446);
                        break block0;
                    }
                }
                this.jj_la1[375] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = false;
        this.thirdToLastIdentifierToken = this.nextToLastIdentifierToken;
        this.nextToLastIdentifierToken = this.lastIdentifierToken;
        this.lastIdentifierToken = tok;
        return tok.image;
    }

    public final String caseSensitiveIdentifierPlusReservedWords() throws ParseException {
        if (this.jj_2_92(1)) {
            String str = this.caseSensitiveIdentifier();
            return str;
        }
        switch (this.jj_nt.kind) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 296: 
            case 360: 
            case 361: 
            case 363: 
            case 366: 
            case 367: 
            case 368: 
            case 370: 
            case 371: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 411: 
            case 416: {
                String str = this.reservedKeyword();
                return str;
            }
        }
        this.jj_la1[376] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String caseInsensitiveIdentifierPlusReservedWords() throws ParseException, StandardException {
        if (this.jj_2_93(1)) {
            String str = this.identifier(128, true);
            return str;
        }
        switch (this.jj_nt.kind) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 296: 
            case 360: 
            case 361: 
            case 363: 
            case 366: 
            case 367: 
            case 368: 
            case 370: 
            case 371: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 411: 
            case 416: {
                String str = this.reservedKeyword();
                return StringUtil.SQLToUpperCase(str);
            }
        }
        this.jj_la1[377] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String caseSensitiveIdentifier() throws ParseException {
        switch (this.jj_nt.kind) {
            case 480: {
                Token tok = this.jj_consume_token(480);
                this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
                this.lastTokenDelimitedIdentifier = false;
                return tok.image;
            }
            case 486: {
                String str = this.delimitedIdentifier();
                return str;
            }
        }
        this.jj_la1[378] = this.jj_gen;
        if (this.jj_2_94(1)) {
            String str = this.nonReservedKeyword();
            return str;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_54();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(53, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_55();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(54, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_56();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(55, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_57();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(56, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_58(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_58();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(57, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_59(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_59();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(58, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_60(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_60();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(59, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_61(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_61();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(60, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_62(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_62();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(61, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_63(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_63();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(62, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_64(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_64();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(63, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_65(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_65();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(64, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_66(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_66();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(65, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_67(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_67();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(66, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_68(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_68();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(67, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_69(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_69();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(68, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_70(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_70();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(69, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_71(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_71();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(70, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_72(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_72();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(71, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_73(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_73();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(72, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_74(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_74();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(73, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_75(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_75();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(74, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_76(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_76();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(75, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_77(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_77();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(76, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_78(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_78();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(77, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_79(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_79();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(78, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_80(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_80();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(79, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_81(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_81();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(80, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_82(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_82();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(81, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_83(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_83();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(82, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_84(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_84();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(83, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_85(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_85();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(84, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_86(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_86();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(85, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_87(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_87();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(86, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_88(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_88();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(87, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_89(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_89();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(88, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_90(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_90();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(89, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_91(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_91();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(90, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_92(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_92();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(91, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_93(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_93();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(92, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_94(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_94();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(93, xla);
        }
    }

    private final boolean jj_3R_85() {
        return this.jj_3R_171();
    }

    private final boolean jj_3R_174() {
        return this.jj_3R_264();
    }

    private final boolean jj_3R_286() {
        return this.jj_scan_token(208);
    }

    private final boolean jj_3_29() {
        return this.jj_3R_78();
    }

    private final boolean jj_3R_173() {
        return this.jj_3R_263();
    }

    private final boolean jj_3R_291() {
        return this.jj_scan_token(486);
    }

    private final boolean jj_3R_282() {
        return this.jj_scan_token(162);
    }

    private final boolean jj_3R_279() {
        return this.jj_scan_token(363);
    }

    private final boolean jj_3R_86() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_172()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_173()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_174()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_45()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_175()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_176()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_177()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_178()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_172() {
        return this.jj_scan_token(366);
    }

    private final boolean jj_3_36() {
        return this.jj_3R_85();
    }

    private final boolean jj_3R_371() {
        return this.jj_scan_token(377);
    }

    private final boolean jj_3R_285() {
        return this.jj_scan_token(100);
    }

    private final boolean jj_3R_130() {
        return this.jj_scan_token(129);
    }

    private final boolean jj_3R_231() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 100;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_285()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 208;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_286()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 145;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_287()) {
                    this.jj_scanpos = xsp;
                    this.lookingAhead = true;
                    this.jj_semLA = this.getToken((int)1).kind == 252;
                    this.lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_288()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_289()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_366() {
        return this.jj_scan_token(327);
    }

    private final boolean jj_3R_77() {
        return this.jj_3R_83();
    }

    private final boolean jj_3_60() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_365() {
        return this.jj_scan_token(220);
    }

    private final boolean jj_3R_354() {
        return this.jj_scan_token(226);
    }

    private final boolean jj_3R_63() {
        return this.jj_3R_141();
    }

    private final boolean jj_3R_118() {
        return this.jj_3R_231();
    }

    private final boolean jj_3R_245() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_364() {
        return this.jj_scan_token(333);
    }

    private final boolean jj_3R_298() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_364()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_365()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_366()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_136() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(172)) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 172;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_245()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_353() {
        return this.jj_scan_token(112);
    }

    private final boolean jj_3_44() {
        return this.jj_3R_90();
    }

    private final boolean jj_3R_230() {
        return this.jj_3R_284();
    }

    private final boolean jj_3R_299() {
        return this.jj_3R_367();
    }

    private final boolean jj_3_91() {
        return this.jj_3R_121();
    }

    private final boolean jj_3_28() {
        return this.jj_3R_77();
    }

    private final boolean jj_3R_352() {
        return this.jj_scan_token(256);
    }

    private final boolean jj_3R_278() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_352()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_353()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_354()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_43() {
        return this.jj_3R_89();
    }

    private final boolean jj_3R_101() {
        return this.jj_3R_206();
    }

    private final boolean jj_3R_100() {
        return this.jj_3R_205();
    }

    private final boolean jj_3R_56() {
        return this.jj_3R_136();
    }

    private final boolean jj_3_59() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.newInvocationFollows(1);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_100()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_101()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_204() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_59()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_60()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 453 && (this.getToken((int)2).kind == 225 || this.getToken((int)2).kind == 259);
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_274()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_275()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_249() {
        return this.jj_3R_291();
    }

    private final boolean jj_3R_229() {
        return this.jj_3R_283();
    }

    private final boolean jj_3R_336() {
        return this.jj_3R_279();
    }

    private final boolean jj_3_35() {
        return this.jj_3R_84();
    }

    private final boolean jj_3R_369() {
        return this.jj_scan_token(369);
    }

    private final boolean jj_3R_253() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_158() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 460 && (this.getToken((int)3).kind == 455 || this.getToken((int)4).kind == 460 && this.getToken((int)5).kind == 455);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_253()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_28()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_135() {
        return this.jj_scan_token(137);
    }

    private final boolean jj_3R_335() {
        return this.jj_3R_278();
    }

    private final boolean jj_3_15() {
        return this.jj_3R_62();
    }

    private final boolean jj_3R_208() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_129() {
        return this.jj_scan_token(106);
    }

    private final boolean jj_3R_247() {
        return this.jj_3R_299();
    }

    private final boolean jj_3R_140() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.javaClassFollows();
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_247()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_35()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_334() {
        return this.jj_3R_384();
    }

    private final boolean jj_3R_267() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_334()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_335()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_336()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_248() {
        return this.jj_scan_token(480);
    }

    private final boolean jj_3R_141() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_248()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_249()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_91()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_228() {
        return this.jj_3R_282();
    }

    private final boolean jj_3R_374() {
        return this.jj_3R_90();
    }

    private final boolean jj_3R_308() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 460 && this.getToken((int)4).kind == 453;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_374()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_15()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_55() {
        return this.jj_3R_135();
    }

    private final boolean jj_3R_155() {
        return this.jj_scan_token(128);
    }

    private final boolean jj_3R_104() {
        return this.jj_3R_208();
    }

    private final boolean jj_3_3() {
        return this.jj_3R_48();
    }

    private final boolean jj_3R_116() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_228()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 120 || this.getToken((int)2).kind == 120;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_229()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 290 || this.getToken((int)2).kind == 290;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_230()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_2() {
        return this.jj_3R_47();
    }

    private final boolean jj_3R_74() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 326;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_155()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(128)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_54() {
        return this.jj_3R_134();
    }

    private final boolean jj_3R_76() {
        return this.jj_3R_158();
    }

    private final boolean jj_3R_99() {
        return this.jj_3R_204();
    }

    private final boolean jj_3R_407() {
        return this.jj_scan_token(140);
    }

    private final boolean jj_3_25() {
        return this.jj_3R_74();
    }

    private final boolean jj_3R_199() {
        return this.jj_3R_273();
    }

    private final boolean jj_3_1() {
        return this.jj_3R_46();
    }

    private final boolean jj_3R_406() {
        return this.jj_scan_token(249);
    }

    private final boolean jj_3R_383() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_406()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_407()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_133();
    }

    private final boolean jj_3_67() {
        return this.jj_3R_104();
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_132();
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_131();
    }

    private final boolean jj_3_34() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_95() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_199()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_50() {
        return this.jj_3R_130();
    }

    private final boolean jj_3R_49() {
        return this.jj_3R_129();
    }

    private final boolean jj_3_27() {
        return this.jj_3R_76();
    }

    private final boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_49()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_50()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_51()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_52()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_53()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_1()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_54()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_2()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_3()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_55()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_154() {
        return this.jj_scan_token(214);
    }

    private final boolean jj_3R_139() {
        return this.jj_scan_token(358);
    }

    private final boolean jj_3R_313() {
        return this.jj_3R_86();
    }

    private final boolean jj_3R_259() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = (this.getToken((int)1).kind == 366 || this.getToken((int)1).kind == 271 || this.getToken((int)1).kind == 272 || this.getToken((int)1).kind == 438 || this.getToken((int)1).kind == 311 || this.getToken((int)1).kind == 93 || this.getToken((int)1).kind == 258 || this.getToken((int)1).kind == 293 || this.getToken((int)1).kind == 235 || this.getToken((int)1).kind == 376 || this.getToken((int)1).kind == 255 || this.getToken((int)1).kind == 179 || this.getToken((int)1).kind == 444 || this.getToken((int)1).kind == 403 || this.getToken((int)1).kind == 370 || this.getToken((int)1).kind == 375 || this.getToken((int)1).kind == 248 || this.getToken((int)1).kind == 285 || this.getToken((int)1).kind == 350 || this.getToken((int)1).kind == 351 || this.getToken((int)1).kind == 128 || this.getToken((int)1).kind == 88 || this.getToken((int)1).kind == 261 || this.getToken((int)1).kind == 168 || this.getToken((int)1).kind == 167 || this.getToken((int)1).kind == 228 || this.getToken((int)1).kind == 368 || this.getToken((int)1).kind == 270 || this.getToken((int)1).kind == 314 || this.getToken((int)1).kind == 286 || this.getToken((int)1).kind == 157 || this.getToken((int)1).kind == 183 || this.getToken((int)1).kind == 224 || this.getToken((int)1).kind == 301 || this.getToken((int)1).kind == 404 || this.getToken((int)1).kind == 379 || this.getToken((int)1).kind == 381 || this.getToken((int)1).kind == 378 || this.getToken((int)1).kind == 380) && this.getToken((int)2).kind == 453;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_313()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_43()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_44()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_14() {
        return this.jj_3R_61();
    }

    private final boolean jj_3_58() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(72)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_63();
    }

    private final boolean jj_3R_59() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_61() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 358 && this.getToken((int)2).kind != 190;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_138()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 358 && this.getToken((int)2).kind == 190;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_139()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_138() {
        return this.jj_scan_token(358);
    }

    private final boolean jj_3R_157() {
        return this.jj_scan_token(66);
    }

    private final boolean jj_3_40() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_170() {
        return this.jj_3R_261();
    }

    private final boolean jj_3R_169() {
        return this.jj_3R_260();
    }

    private final boolean jj_3R_340() {
        return this.jj_3R_385();
    }

    private final boolean jj_3R_384() {
        return this.jj_scan_token(472);
    }

    private final boolean jj_3R_73() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_153()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_154()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_25()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_153() {
        return this.jj_scan_token(143);
    }

    private final boolean jj_3R_339() {
        return this.jj_scan_token(351);
    }

    private final boolean jj_3R_203() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3_57() {
        return this.jj_3R_99();
    }

    private final boolean jj_3R_98() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_57()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_203()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_338() {
        return this.jj_scan_token(285);
    }

    private final boolean jj_3R_75() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 127 && this.getToken((int)2).kind != 460 && this.getToken((int)2).kind != 463;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_156()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 66 && this.getToken((int)2).kind != 460 && this.getToken((int)2).kind != 463;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_157()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_156() {
        return this.jj_scan_token(127);
    }

    private final boolean jj_3_66() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_168() {
        return this.jj_scan_token(453);
    }

    private final boolean jj_3_26() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_337() {
        return this.jj_scan_token(350);
    }

    private final boolean jj_3R_270() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_337()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_338()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_339()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_340()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_345() {
        return this.jj_scan_token(368);
    }

    private final boolean jj_3_56() {
        return this.jj_3R_98();
    }

    private final boolean jj_3R_344() {
        return this.jj_scan_token(228);
    }

    private final boolean jj_3_42() {
        return this.jj_3R_88();
    }

    private final boolean jj_3R_343() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(168)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(167)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_272() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_343()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_344()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_345()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_342() {
        return this.jj_scan_token(261);
    }

    private final boolean jj_3R_167() {
        return this.jj_3R_259();
    }

    private final boolean jj_3R_430() {
        return this.jj_scan_token(225);
    }

    private final boolean jj_3R_295() {
        return this.jj_scan_token(309);
    }

    private final boolean jj_3R_341() {
        return this.jj_scan_token(88);
    }

    private final boolean jj_3R_306() {
        return this.jj_3R_272();
    }

    private final boolean jj_3R_271() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_341()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_342()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_256() {
        return this.jj_scan_token(460);
    }

    private final boolean jj_3R_166() {
        return this.jj_3R_258();
    }

    private final boolean jj_3R_194() {
        return this.jj_3R_272();
    }

    private final boolean jj_3R_92() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_50()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_194()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_50() {
        return this.jj_3R_74();
    }

    private final boolean jj_3R_429() {
        return this.jj_3R_431();
    }

    private final boolean jj_3R_165() {
        return this.jj_3R_205();
    }

    private final boolean jj_3R_120() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(96)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_65();
    }

    private final boolean jj_3R_261() {
        return this.jj_scan_token(188);
    }

    private final boolean jj_3R_128() {
        return this.jj_scan_token(218);
    }

    private final boolean jj_3R_428() {
        return this.jj_3R_430();
    }

    private final boolean jj_3R_427() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_428()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_429()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_41() {
        return this.jj_3R_87();
    }

    private final boolean jj_3_52() {
        return this.jj_3R_96();
    }

    private final boolean jj_3R_164() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_255() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(478)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(460)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_160() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)3).kind == 453;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_255()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_256()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_163() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_48() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 218 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 195) || this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind));
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_127()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 218 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 147) || !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind));
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_128()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_127() {
        return this.jj_scan_token(218);
    }

    private final boolean jj_3R_84() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.escapedValueFunctionFollows();
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_162()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 436;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_163()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)2).kind == 172;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_164()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_41()) {
                        this.jj_scanpos = xsp;
                        this.lookingAhead = true;
                        this.jj_semLA = this.newInvocationFollows(1);
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_165()) {
                            this.jj_scanpos = xsp;
                            this.lookingAhead = true;
                            this.jj_semLA = this.windowOrAggregateFunctionFollows();
                            this.lookingAhead = false;
                            if (!this.jj_semLA || this.jj_3R_166()) {
                                this.jj_scanpos = xsp;
                                this.lookingAhead = true;
                                this.jj_semLA = this.miscBuiltinFollows();
                                this.lookingAhead = false;
                                if (!this.jj_semLA || this.jj_3R_167()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_42()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_168()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_169()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_170()) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_162() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3R_372() {
        return this.jj_scan_token(193);
    }

    private final boolean jj_3R_305() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_372()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(117)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(116)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_252() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_305()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_306()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_290() {
        return this.jj_scan_token(305);
    }

    private final boolean jj_3R_82() {
        return this.jj_3R_160();
    }

    private final boolean jj_3R_201() {
        return this.jj_scan_token(320);
    }

    private final boolean jj_3R_412() {
        return this.jj_3R_384();
    }

    private final boolean jj_3R_117() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(96)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_63();
    }

    private final boolean jj_3R_260() {
        return this.jj_scan_token(87);
    }

    private final boolean jj_3_33() {
        return this.jj_3R_82();
    }

    private final boolean jj_3R_96() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 175;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_200()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_201()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_200() {
        return this.jj_scan_token(320);
    }

    private final boolean jj_3R_198() {
        return this.jj_scan_token(428);
    }

    private final boolean jj_3R_62() {
        return this.jj_3R_140();
    }

    private final boolean jj_3R_421() {
        return this.jj_scan_token(370);
    }

    private final boolean jj_3_24() {
        return this.jj_3R_73();
    }

    private final boolean jj_3R_94() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 432;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_197()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_198()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_197() {
        return this.jj_scan_token(428);
    }

    private final boolean jj_3R_420() {
        return this.jj_scan_token(375);
    }

    private final boolean jj_3R_415() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_420()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_421()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_72() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_152()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_24()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_152() {
        return this.jj_3R_252();
    }

    private final boolean jj_3R_418() {
        return this.jj_scan_token(453);
    }

    private final boolean jj_3R_417() {
        return this.jj_3R_427();
    }

    private final boolean jj_3R_411() {
        return this.jj_scan_token(361);
    }

    private final boolean jj_3R_410() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_417()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_418()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_387() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_411()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_412()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_401() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(181)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(77)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(182)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(236)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_235() {
        return this.jj_3R_290();
    }

    private final boolean jj_3R_399() {
        return this.jj_scan_token(459);
    }

    private final boolean jj_3R_398() {
        return this.jj_scan_token(457);
    }

    private final boolean jj_3R_373() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_398()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_399()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_363() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3R_397() {
        return this.jj_scan_token(185);
    }

    private final boolean jj_3R_362() {
        return this.jj_3R_387();
    }

    private final boolean jj_3R_396() {
        return this.jj_3R_251();
    }

    private final boolean jj_3_94() {
        return this.jj_3R_121();
    }

    private final boolean jj_3R_297() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_362()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_363()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_83() {
        return this.jj_3R_116();
    }

    private final boolean jj_3R_395() {
        return this.jj_scan_token(80);
    }

    private final boolean jj_3R_237() {
        return this.jj_3R_291();
    }

    private final boolean jj_3R_381() {
        return this.jj_scan_token(491);
    }

    private final boolean jj_3R_376() {
        return this.jj_3R_401();
    }

    private final boolean jj_3R_394() {
        return this.jj_scan_token(318);
    }

    private final boolean jj_3R_234() {
        return this.jj_scan_token(68);
    }

    private final boolean jj_3R_122() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_236()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_237()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_94()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_236() {
        return this.jj_scan_token(480);
    }

    private final boolean jj_3R_196() {
        return this.jj_scan_token(83);
    }

    private final boolean jj_3R_393() {
        return this.jj_scan_token(278);
    }

    private final boolean jj_3R_233() {
        return this.jj_scan_token(68);
    }

    private final boolean jj_3R_93() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 422;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_195()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_196()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_195() {
        return this.jj_scan_token(83);
    }

    private final boolean jj_3R_392() {
        return this.jj_scan_token(275);
    }

    private final boolean jj_3_38() {
        return this.jj_scan_token(147);
    }

    private final boolean jj_3_65() {
        return this.jj_3R_75();
    }

    private final boolean jj_3_39() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_102() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_65()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_79();
    }

    private final boolean jj_3R_419() {
        return this.jj_scan_token(138);
    }

    private final boolean jj_3R_380() {
        return this.jj_scan_token(490);
    }

    private final boolean jj_3_12() {
        return this.jj_3R_59();
    }

    private final boolean jj_3_88() {
        return this.jj_3R_120();
    }

    private final boolean jj_3R_370() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_392()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_393()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_394()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_395()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_396()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_397()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_307() {
        return this.jj_3R_373();
    }

    private final boolean jj_3_93() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_119() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_232()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 68 && this.getToken((int)2).kind != 100;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_233()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_234()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_235()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_232() {
        return this.jj_scan_token(65);
    }

    private final boolean jj_3_90() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_207() {
        return false;
    }

    private final boolean jj_3R_254() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_307()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_308();
    }

    private final boolean jj_3_64() {
        return this.jj_3R_63();
    }

    private final boolean jj_3_82() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_262() {
        return this.jj_3R_314();
    }

    private final boolean jj_3_63() {
        return this.jj_3R_103();
    }

    private final boolean jj_3R_403() {
        return this.jj_scan_token(248);
    }

    private final boolean jj_3_92() {
        return this.jj_3R_122();
    }

    private final boolean jj_3R_171() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_92()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_262()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_13() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_103() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 453 || this.getToken((int)2).kind == 480;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_207()) {
            return true;
        }
        return this.jj_scan_token(372);
    }

    private final boolean jj_3R_151() {
        return this.jj_scan_token(411);
    }

    private final boolean jj_3R_402() {
        return this.jj_3R_415();
    }

    private final boolean jj_3R_377() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_402()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_403()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_62() {
        return this.jj_3R_103();
    }

    private final boolean jj_3R_312() {
        return this.jj_scan_token(374);
    }

    private final boolean jj_3R_150() {
        return this.jj_scan_token(187);
    }

    private final boolean jj_3R_386() {
        return this.jj_3R_410();
    }

    private final boolean jj_3_49() {
        return this.jj_3R_93();
    }

    private final boolean jj_3R_311() {
        return this.jj_3R_376();
    }

    private final boolean jj_3R_149() {
        return this.jj_scan_token(185);
    }

    private final boolean jj_3_61() {
        return this.jj_3R_102();
    }

    private final boolean jj_3R_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_149()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_150()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_151()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_324() {
        return this.jj_scan_token(404);
    }

    private final boolean jj_3R_310() {
        return this.jj_scan_token(105);
    }

    private final boolean jj_3R_258() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_310()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_311()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_312()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_323() {
        return this.jj_3R_377();
    }

    private final boolean jj_3R_322() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(444)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(403)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_321() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(255)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(179)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_159() {
        return this.jj_3R_254();
    }

    private final boolean jj_3R_189() {
        return this.jj_scan_token(111);
    }

    private final boolean jj_3R_296() {
        return this.jj_scan_token(254);
    }

    private final boolean jj_3R_320() {
        return this.jj_scan_token(376);
    }

    private final boolean jj_3R_264() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_320()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_321()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_322()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_323()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_324()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_188() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3_81() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_187() {
        return this.jj_scan_token(110);
    }

    private final boolean jj_3_89() {
        return this.jj_3R_113();
    }

    private final boolean jj_3R_361() {
        return this.jj_3R_386();
    }

    private final boolean jj_3_11() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_186() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_251() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(88)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(89)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_409() {
        return this.jj_scan_token(224);
    }

    private final boolean jj_3R_202() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_185() {
        return this.jj_scan_token(109);
    }

    private final boolean jj_3R_408() {
        return this.jj_3R_416();
    }

    private final boolean jj_3R_385() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_408()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_409()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_382() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3R_89() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 285;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_184()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_185()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 350;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_186()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_187()) {
                        this.jj_scanpos = xsp;
                        this.lookingAhead = true;
                        this.jj_semLA = this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 351;
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_188()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_189()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_184() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_97() {
        return this.jj_3R_202();
    }

    private final boolean jj_3R_88() {
        return this.jj_3R_63();
    }

    private final boolean jj_3_47() {
        return this.jj_3R_93();
    }

    private final boolean jj_3_55() {
        return this.jj_3R_97();
    }

    private final boolean jj_3R_294() {
        return this.jj_scan_token(166);
    }

    private final boolean jj_3R_148() {
        return this.jj_3R_251();
    }

    private final boolean jj_3R_147() {
        return this.jj_scan_token(261);
    }

    private final boolean jj_3R_69() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_147()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_148()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_48() {
        return this.jj_3R_94();
    }

    private final boolean jj_3R_60() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_431() {
        return this.jj_scan_token(259);
    }

    private final boolean jj_3R_183() {
        return this.jj_scan_token(86);
    }

    private final boolean jj_3R_304() {
        return this.jj_3R_371();
    }

    private final boolean jj_3R_79() {
        return this.jj_3R_159();
    }

    private final boolean jj_3R_303() {
        return this.jj_3R_370();
    }

    private final boolean jj_3R_302() {
        return this.jj_3R_369();
    }

    private final boolean jj_3R_348() {
        return this.jj_scan_token(189);
    }

    private final boolean jj_3R_70() {
        return false;
    }

    private final boolean jj_3R_182() {
        return this.jj_scan_token(86);
    }

    private final boolean jj_3R_347() {
        return this.jj_scan_token(283);
    }

    private final boolean jj_3R_276() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_347()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_348()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_68() {
        return false;
    }

    private final boolean jj_3R_300() {
        return this.jj_3R_368();
    }

    private final boolean jj_3_23() {
        return this.jj_3R_72();
    }

    private final boolean jj_3R_391() {
        return this.jj_scan_token(351);
    }

    private final boolean jj_3R_301() {
        return this.jj_scan_token(360);
    }

    private final boolean jj_3_22() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)3).kind != 300;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_70()) {
            return true;
        }
        return this.jj_3R_71();
    }

    private final boolean jj_3_86() {
        return this.jj_3R_118();
    }

    private final boolean jj_3_87() {
        return this.jj_3R_119();
    }

    private final boolean jj_3_85() {
        return this.jj_3R_117();
    }

    private final boolean jj_3R_293() {
        return this.jj_3R_361();
    }

    private final boolean jj_3R_405() {
        return this.jj_scan_token(492);
    }

    private final boolean jj_3_21() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind != 300;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_68()) {
            return true;
        }
        return this.jj_3R_69();
    }

    private final boolean jj_3R_212() {
        return this.jj_3R_276();
    }

    private final boolean jj_3R_181() {
        return this.jj_scan_token(192);
    }

    private final boolean jj_3R_390() {
        return this.jj_scan_token(350);
    }

    private final boolean jj_3R_110() {
        return this.jj_scan_token(189);
    }

    private final boolean jj_3R_180() {
        return this.jj_3R_267();
    }

    private final boolean jj_3R_109() {
        return this.jj_scan_token(310);
    }

    private final boolean jj_3R_404() {
        return this.jj_scan_token(487);
    }

    private final boolean jj_3R_379() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_404()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_405()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_250() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_22()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_23()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_300()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_301()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_302()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_303()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_304()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_389() {
        return this.jj_scan_token(285);
    }

    private final boolean jj_3R_368() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_389()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_390()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_391()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_87() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_179()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_180()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_181()) {
                    this.jj_scanpos = xsp;
                    this.lookingAhead = true;
                    this.jj_semLA = this.getToken((int)1).kind == 86 && this.getToken((int)2).kind == 358;
                    this.lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_182()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_183()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_179() {
        return this.jj_3R_266();
    }

    private final boolean jj_3R_319() {
        return this.jj_scan_token(293);
    }

    private final boolean jj_3_72() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_109()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)2).kind == 310;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_110()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_108() {
        return this.jj_scan_token(189);
    }

    private final boolean jj_3R_107() {
        return this.jj_scan_token(308);
    }

    private final boolean jj_3R_318() {
        return this.jj_scan_token(311);
    }

    private final boolean jj_3_20() {
        return this.jj_3R_67();
    }

    private final boolean jj_3_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_107()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)2).kind == 308;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_108()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_211() {
        return this.jj_scan_token(294);
    }

    private final boolean jj_3R_210() {
        return this.jj_scan_token(346);
    }

    private final boolean jj_3R_121() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(271)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(272)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(273)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(382)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(383)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(274)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(384)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(80)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(275)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(276)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(277)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(385)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(278)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(93)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(279)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(280)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(386)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(281)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(282)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(387)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(105)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(388)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(362)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(364)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(283)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(114)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(284)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(285)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(286)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(393)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(394)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(289)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(365)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(390)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(391)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(392)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(395)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(290)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(396)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(397)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(398)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(399)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(291)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(292)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(293)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(294)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(400)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(295)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(401)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(297)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(402)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(299)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(300)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(403)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(301)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(302)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(303)) {
                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                            if (this.jj_scan_token(404)) {
                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                if (this.jj_scan_token(405)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(304)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(305)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(306)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(369)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(307)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(308)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(309)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(310)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(406)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(407)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(311)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(408)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(312)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(313)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(184)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(314)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(315)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(316)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(317)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(318)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(409)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(410)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(319)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(320)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(321)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(322)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(413)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                this.lookingAhead = true;
                                                                                                                                                                                                                                                                                                                                                                this.jj_semLA = this.getToken((int)1).kind == 323 && !this.seeingOffsetClause();
                                                                                                                                                                                                                                                                                                                                                                this.lookingAhead = false;
                                                                                                                                                                                                                                                                                                                                                                if (!this.jj_semLA || this.jj_scan_token(323)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(414)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(415)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(412)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(372)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(324)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(418)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(325)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(326)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(419)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(420)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(421)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(422)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(327)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(424)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(328)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(423)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(425)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(329)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(426)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(427)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(428)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(330)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(373)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(331)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(332)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(374)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(429)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(430)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(334)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(333)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(335)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(432)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(433)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(336)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(434)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(435)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(437)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(436)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(337)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(338)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(339)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(340)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(341)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(342)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(343)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(344)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(345)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(438)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(439)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(346)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(347)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(431)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(440)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(348)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(441)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(238)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(349)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(350)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(351)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(352)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(353)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(442)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(354)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(443)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(250)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(355)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(444)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(356)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(445)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(357)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(258)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(260)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(417)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(358)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(446)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_209() {
        return this.jj_scan_token(72);
    }

    private final boolean jj_3R_317() {
        return this.jj_scan_token(438);
    }

    private final boolean jj_3R_106() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_209()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_210()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_211()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_71()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_72()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_212()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_75() {
        return this.jj_3R_113();
    }

    private final boolean jj_3R_316() {
        return this.jj_scan_token(272);
    }

    private final boolean jj_3R_315() {
        return this.jj_scan_token(271);
    }

    private final boolean jj_3R_263() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_315()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_316()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_317()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_318()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_319()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_113() {
        return this.jj_3R_66();
    }

    private final boolean jj_3R_81() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3R_80() {
        return this.jj_scan_token(133);
    }

    private final boolean jj_3_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 451 && this.getToken((int)2).kind != 303;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_81()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_10() {
        return this.jj_3R_59();
    }

    private final boolean jj_3_54() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_215() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_112() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_215()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_66();
    }

    private final boolean jj_3R_146() {
        return this.jj_3R_67();
    }

    private final boolean jj_3R_66() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.commonDatatypeName(false);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_145()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind != 292;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_146()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_145() {
        return this.jj_3R_250();
    }

    private final boolean jj_3R_367() {
        return this.jj_3R_388();
    }

    private final boolean jj_3_80() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_333() {
        return this.jj_3R_383();
    }

    private final boolean jj_3R_332() {
        return this.jj_3R_382();
    }

    private final boolean jj_3R_246() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_126() {
        return this.jj_scan_token(154);
    }

    private final boolean jj_3R_137() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(222)) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 108 && (this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 436);
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_246()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_31() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_331() {
        return this.jj_3R_381();
    }

    private final boolean jj_3_70() {
        return this.jj_3R_106();
    }

    private final boolean jj_3R_330() {
        return this.jj_3R_380();
    }

    private final boolean jj_3_74() {
        return this.jj_3R_112();
    }

    private final boolean jj_3R_378() {
        return this.jj_3R_373();
    }

    private final boolean jj_3R_329() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_378()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_379();
    }

    private final boolean jj_3R_266() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_329()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_330()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_331()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_332()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_333()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_269() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_57() {
        return this.jj_3R_137();
    }

    private final boolean jj_3R_47() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 154 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 195) || this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind));
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_125()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 154 && (this.getToken((int)2).kind == 442 && (this.getToken((int)3).kind == 458 && !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 243) || !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind));
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_126()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_125() {
        return this.jj_scan_token(154);
    }

    private final boolean jj_3R_221() {
        return this.jj_3R_266();
    }

    private final boolean jj_3_19() {
        return this.jj_3R_66();
    }

    private final boolean jj_3R_65() {
        return this.jj_3R_63();
    }

    private final boolean jj_3_77() {
        return this.jj_3R_89();
    }

    private final boolean jj_3R_268() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_292() {
        return this.jj_scan_token(122);
    }

    private final boolean jj_3_79() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_134() {
        return this.jj_scan_token(354);
    }

    private final boolean jj_3R_220() {
        return this.jj_3R_259();
    }

    private final boolean jj_3R_191() {
        return this.jj_3R_269();
    }

    private final boolean jj_3R_244() {
        return this.jj_3R_298();
    }

    private final boolean jj_3_18() {
        return this.jj_3R_65();
    }

    private final boolean jj_3R_90() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = !this.distinctUDAFollows();
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_190()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.distinctUDAFollows();
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_191()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_190() {
        return this.jj_3R_268();
    }

    private final boolean jj_3R_349() {
        return this.jj_scan_token(160);
    }

    private final boolean jj_3R_277() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_349()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_350()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_351()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_243() {
        return this.jj_3R_297();
    }

    private final boolean jj_3_51() {
        return this.jj_3R_95();
    }

    private final boolean jj_3R_219() {
        return this.jj_3R_259();
    }

    private final boolean jj_3R_242() {
        return this.jj_3R_296();
    }

    private final boolean jj_3_69() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_351() {
        return this.jj_scan_token(296);
    }

    private final boolean jj_3R_350() {
        return this.jj_scan_token(416);
    }

    private final boolean jj_3R_218() {
        return this.jj_3R_279();
    }

    private final boolean jj_3R_241() {
        return this.jj_3R_295();
    }

    private final boolean jj_3R_213() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_277()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_217() {
        return this.jj_3R_278();
    }

    private final boolean jj_3R_414() {
        return this.jj_3R_419();
    }

    private final boolean jj_3R_346() {
        return this.jj_scan_token(453);
    }

    private final boolean jj_3R_240() {
        return this.jj_3R_294();
    }

    private final boolean jj_3_30() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_239() {
        return this.jj_3R_293();
    }

    private final boolean jj_3R_114() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 436;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_216()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_217()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_218()) {
                    this.jj_scanpos = xsp;
                    this.lookingAhead = true;
                    this.jj_semLA = this.getToken((int)1).kind == 285 || this.getToken((int)1).kind == 350 || this.getToken((int)1).kind == 351;
                    this.lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_219()) {
                        this.jj_scanpos = xsp;
                        this.lookingAhead = true;
                        this.jj_semLA = this.getToken((int)2).kind == 453 || this.getToken((int)4).kind == 453 && this.getToken((int)2).kind != 458;
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_220()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_77()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_221()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_216() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_400() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_414()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_214() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_133() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_238()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_239()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_240()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_241()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_242()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_243()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_244()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_238() {
        return this.jj_3R_292();
    }

    private final boolean jj_3R_111() {
        if (this.jj_3R_213()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_214()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_66();
    }

    private final boolean jj_3R_328() {
        return this.jj_scan_token(380);
    }

    private final boolean jj_3R_327() {
        return this.jj_scan_token(378);
    }

    private final boolean jj_3R_375() {
        return this.jj_3R_400();
    }

    private final boolean jj_3R_326() {
        return this.jj_scan_token(381);
    }

    private final boolean jj_3R_105() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_325() {
        return this.jj_scan_token(379);
    }

    private final boolean jj_3R_265() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_325()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_326()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_327()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_328()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_73() {
        return this.jj_3R_111();
    }

    private final boolean jj_3R_144() {
        return this.jj_scan_token(195);
    }

    private final boolean jj_3_76() {
        return this.jj_3R_114();
    }

    private final boolean jj_3R_309() {
        return this.jj_3R_375();
    }

    private final boolean jj_3R_143() {
        return this.jj_scan_token(195);
    }

    private final boolean jj_3R_142() {
        return this.jj_scan_token(190);
    }

    private final boolean jj_3R_64() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_142()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 195 && this.getToken((int)2).kind == 97;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_143()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 195 && this.getToken((int)2).kind == 220;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_144()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_9() {
        return this.jj_3R_58();
    }

    private final boolean jj_3R_193() {
        return this.jj_3R_271();
    }

    private final boolean jj_3R_388() {
        return this.jj_3R_413();
    }

    private final boolean jj_3R_257() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(190)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_309();
    }

    private final boolean jj_3_17() {
        return this.jj_3R_64();
    }

    private final boolean jj_3_46() {
        return this.jj_3R_92();
    }

    private final boolean jj_3_84() {
        return this.jj_3R_116();
    }

    private final boolean jj_3R_206() {
        return this.jj_scan_token(239);
    }

    private final boolean jj_3_37() {
        return this.jj_3R_86();
    }

    private final boolean jj_3R_91() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_192()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_46()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_193()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_192() {
        return this.jj_3R_270();
    }

    private final boolean jj_3R_58() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_358() {
        return this.jj_scan_token(445);
    }

    private final boolean jj_3R_132() {
        return this.jj_scan_token(118);
    }

    private final boolean jj_3R_413() {
        return this.jj_3R_171();
    }

    private final boolean jj_3_68() {
        return this.jj_3R_105();
    }

    private final boolean jj_3R_357() {
        return this.jj_scan_token(388);
    }

    private final boolean jj_3R_356() {
        return this.jj_scan_token(430);
    }

    private final boolean jj_3R_289() {
        return this.jj_scan_token(91);
    }

    private final boolean jj_3R_355() {
        return this.jj_scan_token(429);
    }

    private final boolean jj_3_8() {
        return this.jj_3R_56();
    }

    private final boolean jj_3R_161() {
        return this.jj_3R_257();
    }

    private final boolean jj_3_7() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_426() {
        return this.jj_scan_token(183);
    }

    private final boolean jj_3R_273() {
        return this.jj_scan_token(191);
    }

    private final boolean jj_3R_227() {
        return this.jj_scan_token(213);
    }

    private final boolean jj_3R_275() {
        return this.jj_scan_token(453);
    }

    private final boolean jj_3R_425() {
        return this.jj_scan_token(157);
    }

    private final boolean jj_3R_178() {
        return this.jj_3R_265();
    }

    private final boolean jj_3R_360() {
        return this.jj_scan_token(190);
    }

    private final boolean jj_3R_124() {
        return this.jj_scan_token(227);
    }

    private final boolean jj_3R_280() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_355()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_356()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_357()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_358()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_226() {
        return this.jj_scan_token(213);
    }

    private final boolean jj_3R_284() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_360()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(290);
    }

    private final boolean jj_3R_67() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_288() {
        return this.jj_scan_token(252);
    }

    private final boolean jj_3R_424() {
        return this.jj_scan_token(286);
    }

    private final boolean jj_3_6() {
        return this.jj_3R_57();
    }

    private final boolean jj_3_5() {
        return this.jj_3R_56();
    }

    private final boolean jj_3R_314() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(65)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(66)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(67)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(68)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(69)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(70)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(71)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(72)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(73)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(74)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(75)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(76)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(77)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(78)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(79)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(81)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(82)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(83)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(84)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(85)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(86)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(87)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(88)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(89)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(91)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(92)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(94)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(95)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(96)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(97)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(98)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(99)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(100)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(101)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(102)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(103)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(104)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(106)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(107)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(108)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(109)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(110)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(111)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(112)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(113)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(115)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(116)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(117)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(118)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(119)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(120)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(121)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(122)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(123)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(124)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(125)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(126)) {
                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                            if (this.jj_scan_token(127)) {
                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                if (this.jj_scan_token(128)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(129)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(130)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(131)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(132)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(133)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(134)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(135)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(136)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(137)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(138)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(139)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(140)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(141)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(142)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(143)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(144)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(145)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(146)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(147)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(148)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(149)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(150)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(366)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(151)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(152)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(153)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(154)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(155)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(156)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(157)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(158)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(159)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(160)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(161)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(162)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(163)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(296)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(164)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(165)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(166)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(167)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(168)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(169)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(170)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(171)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(172)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(173)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(174)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(175)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(176)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(177)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(178)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(179)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(180)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(181)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(182)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(183)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(185)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(186)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(187)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(411)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(188)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(189)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(371)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(190)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(191)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(192)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(193)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(194)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(195)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(196)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(197)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(198)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(199)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(200)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(416)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(201)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(202)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(203)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(204)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(205)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(206)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(207)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(208)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(209)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(210)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(211)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(212)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(213)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(214)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(215)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(216)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(217)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(218)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(219)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(220)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(221)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(222)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(223)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(224)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(225)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(226)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(227)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(228)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(229)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(230)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(231)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(232)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(233)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(234)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(235)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(236)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(237)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(239)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(240)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(241)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(242)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(243)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(247)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(244)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(245)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(246)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(249)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(251)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(252)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(253)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(254)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(255)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(256)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(257)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(259)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(261)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(262)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(263)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(264)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(265)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(267)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(268)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(269)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(270)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(360)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(361)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(363)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(367)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(368)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(370)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(375)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(248)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(376)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(377)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(379)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(381)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(378)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(380)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                              