/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.HasCorrelatedCRsVisitor;
import org.apache.derby.impl.sql.compile.HasVariantValueNodeVisitor;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.MaterializeSubqueryNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

class SubqueryNode
extends ValueNode {
    ResultSetNode resultSet;
    int subqueryType;
    boolean underTopAndNode;
    boolean preprocessed;
    boolean distinctExpression;
    boolean whereSubquery;
    ValueNode leftOperand;
    boolean pushedNewPredicate;
    boolean havingSubquery = false;
    BinaryComparisonOperatorNode parentComparisonOperator;
    private BooleanConstantNode trueNode;
    private int subqueryNumber = -1;
    private int pointOfAttachment = -1;
    private boolean foundCorrelation;
    private boolean doneCorrelationCheck;
    private boolean foundVariant;
    private boolean doneInvariantCheck;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;
    static final int NOTIMPLEMENTED_SUBQUERY = -1;
    static final int FROM_SUBQUERY = 0;
    static final int IN_SUBQUERY = 1;
    static final int NOT_IN_SUBQUERY = 2;
    static final int EQ_ANY_SUBQUERY = 3;
    static final int EQ_ALL_SUBQUERY = 4;
    static final int NE_ANY_SUBQUERY = 5;
    static final int NE_ALL_SUBQUERY = 6;
    static final int GT_ANY_SUBQUERY = 7;
    static final int GT_ALL_SUBQUERY = 8;
    static final int GE_ANY_SUBQUERY = 9;
    static final int GE_ALL_SUBQUERY = 10;
    static final int LT_ANY_SUBQUERY = 11;
    static final int LT_ALL_SUBQUERY = 12;
    static final int LE_ANY_SUBQUERY = 13;
    static final int LE_ALL_SUBQUERY = 14;
    static final int EXISTS_SUBQUERY = 15;
    static final int NOT_EXISTS_SUBQUERY = 16;
    static final int EXPRESSION_SUBQUERY = 17;

    SubqueryNode(ResultSetNode resultSet, int subqueryType, ValueNode leftOperand, OrderByList orderCols, ValueNode offset, ValueNode fetchFirst, boolean hasJDBClimitClause, ContextManager cm) {
        super(cm);
        this.resultSet = resultSet;
        this.subqueryType = subqueryType;
        this.orderByList = orderCols;
        this.offset = offset;
        this.fetchFirst = fetchFirst;
        this.hasJDBClimitClause = hasJDBClimitClause;
        this.underTopAndNode = false;
        this.leftOperand = leftOperand;
    }

    @Override
    public String toString() {
        return "subqueryType: " + this.subqueryType + "\n" + "underTopAndNode: " + this.underTopAndNode + "\n" + "subqueryNumber: " + this.subqueryNumber + "\n" + "pointOfAttachment: " + this.pointOfAttachment + "\n" + "preprocessed: " + this.preprocessed + "\n" + "distinctExpression: " + this.distinctExpression + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.resultSet != null) {
            this.printLabel(depth, "resultSet: ");
            this.resultSet.treePrint(depth + 1);
        }
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.orderByList != null) {
            this.printLabel(depth, "orderByList: ");
            this.orderByList.treePrint(depth + 1);
        }
        if (this.offset != null) {
            this.printLabel(depth, "offset: ");
            this.offset.treePrint(depth + 1);
        }
        if (this.fetchFirst != null) {
            this.printLabel(depth, "fetchFirst: ");
            this.fetchFirst.treePrint(depth + 1);
        }
    }

    ResultSetNode getResultSet() {
        return this.resultSet;
    }

    int getSubqueryType() {
        return this.subqueryType;
    }

    void setSubqueryType(int subqueryType) {
        this.subqueryType = subqueryType;
    }

    void setPointOfAttachment(int pointOfAttachment) throws StandardException {
        if (!this.isMaterializable()) {
            this.pointOfAttachment = pointOfAttachment;
        }
    }

    boolean getUnderTopAndNode() {
        return this.underTopAndNode;
    }

    int getPointOfAttachment() {
        SanityManager.ASSERT(this.pointOfAttachment >= 0, "pointOfAttachment expected to be >= 0");
        return this.pointOfAttachment;
    }

    boolean getPreprocessed() {
        return this.preprocessed;
    }

    void setParentComparisonOperator(BinaryComparisonOperatorNode parent) {
        this.parentComparisonOperator = parent;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.resultSet instanceof SelectNode) {
            ResultColumnList selectRCL = this.resultSet.getResultColumns();
            SelectNode select = (SelectNode)this.resultSet;
            PredicateList selectPL = select.getWherePredicates();
            SanityManager.ASSERT(selectPL != null, "selectPL expected to be non-null");
            selectRCL.remapColumnReferencesToExpressions();
            selectPL.remapColumnReferencesToExpressions();
        }
        return this;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.checkReliability(32, "42Z91");
        ResultColumnList resultColumns = this.resultSet.getResultColumns();
        if (this.subqueryType != 15 && resultColumns.visibleSize() != 1) {
            throw StandardException.newException("42X39", new Object[0]);
        }
        this.resultSet.verifySelectStarSubquery(fromList, this.subqueryType);
        if (this.subqueryType == 15) {
            this.resultSet = this.resultSet.setResultToBooleanTrueNode(true);
        }
        CompilerContext cc = this.getCompilerContext();
        cc.pushCurrentPrivType(0);
        this.resultSet = this.resultSet.bindNonVTITables(this.getDataDictionary(), fromList);
        this.resultSet = this.resultSet.bindVTITables(fromList);
        if (this.subqueryNumber == -1) {
            this.subqueryNumber = cc.getNextSubqueryNumber();
        }
        this.resultSet.rejectParameters();
        if (this.subqueryType == 15) {
            this.resultSet.bindTargetExpressions(fromList);
            this.resultSet.bindUntypedNullsToResultColumns(null);
            this.resultSet = this.resultSet.setResultToBooleanTrueNode(false);
        }
        if (this.leftOperand != null) {
            this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, aggregates);
        }
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.resultSet);
        }
        this.resultSet.bindExpressions(fromList);
        this.resultSet.bindResultColumns(fromList);
        if (this.orderByList != null) {
            this.orderByList.bindOrderByColumns(this.resultSet);
        }
        SubqueryNode.bindOffsetFetch(this.offset, this.fetchFirst);
        this.resultSet.bindUntypedNullsToResultColumns(null);
        resultColumns = this.resultSet.getResultColumns();
        if (this.leftOperand != null && this.leftOperand.requiresTypeFromContext()) {
            this.leftOperand.setType(((ResultColumn)resultColumns.elementAt(0)).getTypeServices());
        }
        this.setDataTypeServices(resultColumns);
        subqueryList.addSubqueryNode(this);
        cc.popCurrentPrivType();
        return this;
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        SelectNode select;
        boolean flattenable;
        boolean haveOrderBy;
        if (this.preprocessed) {
            return this;
        }
        this.preprocessed = true;
        ValueNode topNode = this;
        if (this.orderByList != null) {
            haveOrderBy = true;
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.resultSet.pushOrderByList(this.orderByList);
            this.orderByList = null;
        } else {
            haveOrderBy = false;
        }
        this.resultSet = this.resultSet.preprocess(numTables, null, null);
        if (this.leftOperand != null) {
            this.leftOperand = this.leftOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        }
        if (this.resultSet instanceof SelectNode && ((SelectNode)this.resultSet).hasDistinct()) {
            ((SelectNode)this.resultSet).clearDistinct();
            if (this.subqueryType == 17) {
                this.distinctExpression = true;
            }
        }
        if ((this.isIN() || this.isANY()) && this.resultSet.returnsAtMostOneRow() && !this.hasCorrelatedCRs()) {
            this.changeToCorrespondingExpressionType();
        }
        boolean bl = flattenable = this.resultSet instanceof RowResultSetNode && this.underTopAndNode && !this.havingSubquery && !haveOrderBy && this.offset == null && this.fetchFirst == null && !this.isWhereExistsAnyInWithWhereSubquery() && this.parentComparisonOperator != null;
        if (flattenable) {
            this.leftOperand = this.parentComparisonOperator.getLeftOperand();
            RowResultSetNode rrsn = (RowResultSetNode)this.resultSet;
            FromList fl = new FromList(this.getContextManager());
            outerSubqueryList.removeElement(this);
            if (rrsn.subquerys.size() != 0) {
                fl.addElement(rrsn);
                outerFromList.destructiveAppend(fl);
            }
            outerSubqueryList.destructiveAppend(rrsn.subquerys);
            return this.getNewJoinCondition(this.leftOperand, this.getRightOperand());
        }
        boolean flattenableNotExists = this.isNOT_EXISTS() || this.canAllBeFlattened();
        boolean bl2 = flattenable = this.resultSet instanceof SelectNode && !((SelectNode)this.resultSet).hasWindows() && !haveOrderBy && this.offset == null && this.fetchFirst == null && this.underTopAndNode && !this.havingSubquery && !this.isWhereExistsAnyInWithWhereSubquery() && (this.isIN() || this.isANY() || this.isEXISTS() || flattenableNotExists || this.parentComparisonOperator != null);
        if (flattenable && !(select = (SelectNode)this.resultSet).hasAggregatesInSelectList() && select.havingClause == null) {
            FromBaseTable fbt;
            ValueNode origLeftOperand = this.leftOperand;
            boolean additionalEQ = this.subqueryType == 1 || this.subqueryType == 3;
            boolean bl3 = additionalEQ = additionalEQ && (this.leftOperand instanceof ConstantNode || this.leftOperand instanceof ColumnReference || this.leftOperand.requiresTypeFromContext());
            if (this.parentComparisonOperator != null) {
                this.leftOperand = this.parentComparisonOperator.getLeftOperand();
            }
            if (!flattenableNotExists && select.uniqueSubquery(additionalEQ)) {
                return this.flattenToNormalJoin(numTables, outerFromList, outerSubqueryList, outerPredicateList);
            }
            if ((this.isIN() || this.isANY() || this.isEXISTS() || flattenableNotExists) && (this.leftOperand == null || this.leftOperand.categorize(new JBitSet(numTables), false)) && select.getWherePredicates().allPushable() && (fbt = this.singleFromBaseTable(select.getFromList())) != null && (!flattenableNotExists || select.getWherePredicates().allReference(fbt) && this.rightOperandFlattenableToNotExists(numTables, fbt))) {
                return this.flattenToExistsJoin(numTables, outerFromList, outerSubqueryList, outerPredicateList, flattenableNotExists);
            }
            this.leftOperand = origLeftOperand;
        }
        this.resultSet.pushQueryExpressionSuffix();
        this.resultSet.pushOffsetFetchFirst(this.offset, this.fetchFirst, this.hasJDBClimitClause);
        if (this.leftOperand != null) {
            topNode = this.pushNewPredicate(numTables);
            this.pushedNewPredicate = true;
        } else if (this.isEXISTS() || this.isNOT_EXISTS()) {
            topNode = this.genIsNullTree(this.isEXISTS());
            this.subqueryType = 15;
        }
        this.isInvariant();
        this.hasCorrelatedCRs();
        if (this.parentComparisonOperator != null) {
            this.parentComparisonOperator.setRightOperand(topNode);
            return this.parentComparisonOperator;
        }
        return topNode;
    }

    private FromBaseTable singleFromBaseTable(FromList fromList) {
        FromBaseTable fbt = null;
        if (fromList.size() == 1) {
            ResultSetNode child;
            FromTable ft = (FromTable)fromList.elementAt(0);
            if (ft instanceof FromBaseTable) {
                fbt = (FromBaseTable)ft;
            } else if (ft instanceof ProjectRestrictNode && (child = ((ProjectRestrictNode)ft).getChildResult()) instanceof FromBaseTable) {
                fbt = (FromBaseTable)child;
            }
        }
        return fbt;
    }

    private boolean rightOperandFlattenableToNotExists(int numTables, FromBaseTable fbt) throws StandardException {
        boolean flattenable = true;
        if (this.leftOperand != null) {
            JBitSet tableSet = new JBitSet(numTables);
            this.getRightOperand().categorize(tableSet, false);
            flattenable = tableSet.get(fbt.getTableNumber());
        }
        return flattenable;
    }

    private boolean canAllBeFlattened() throws StandardException {
        boolean result = false;
        if (this.isNOT_IN() || this.isALL()) {
            result = !this.leftOperand.getTypeServices().isNullable() && !this.getRightOperand().getTypeServices().isNullable();
        }
        return result;
    }

    private ValueNode flattenToNormalJoin(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        SelectNode select = (SelectNode)this.resultSet;
        FromList fl = select.getFromList();
        int[] tableNumbers = fl.getTableNumbers();
        outerSubqueryList.removeElement(this);
        select.decrementLevel(1);
        outerFromList.destructiveAppend(fl);
        outerPredicateList.destructiveAppend(select.getWherePredicates());
        outerSubqueryList.destructiveAppend(select.getWhereSubquerys());
        outerSubqueryList.destructiveAppend(select.getSelectSubquerys());
        if (this.leftOperand == null) {
            return new BooleanConstantNode(true, this.getContextManager());
        }
        ValueNode rightOperand = this.getRightOperand();
        if (rightOperand instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)rightOperand;
            int tableNumber = cr.getTableNumber();
            for (int index = 0; index < tableNumbers.length; ++index) {
                if (tableNumber != tableNumbers[index]) continue;
                cr.setSourceLevel(cr.getSourceLevel() - 1);
                break;
            }
        }
        return this.getNewJoinCondition(this.leftOperand, rightOperand);
    }

    private ValueNode flattenToExistsJoin(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList, boolean flattenableNotExists) throws StandardException {
        SelectNode select = (SelectNode)this.resultSet;
        select.getFromList().genExistsBaseTables(this.resultSet.getReferencedTableMap(), outerFromList, flattenableNotExists);
        return this.flattenToNormalJoin(numTables, outerFromList, outerSubqueryList, outerPredicateList);
    }

    private ValueNode getRightOperand() {
        ResultColumn firstRC = (ResultColumn)this.resultSet.getResultColumns().elementAt(0);
        return firstRC.getExpression();
    }

    private boolean isInvariant() throws StandardException {
        if (this.doneInvariantCheck) {
            return !this.foundVariant;
        }
        this.doneInvariantCheck = true;
        HasVariantValueNodeVisitor visitor = new HasVariantValueNodeVisitor();
        this.resultSet.accept(visitor);
        this.foundVariant = visitor.hasVariant();
        return !this.foundVariant;
    }

    boolean hasCorrelatedCRs() throws StandardException {
        if (this.doneCorrelationCheck) {
            return this.foundCorrelation;
        }
        this.doneCorrelationCheck = true;
        ResultSetNode realSubquery = this.resultSet;
        ResultColumnList oldRCL = null;
        if (this.pushedNewPredicate) {
            SanityManager.ASSERT(this.resultSet instanceof ProjectRestrictNode, "resultSet expected to be a ProjectRestrictNode!");
            realSubquery = ((ProjectRestrictNode)this.resultSet).getChildResult();
            oldRCL = realSubquery.getResultColumns();
            if (oldRCL.size() > 1) {
                ResultColumnList newRCL = new ResultColumnList(this.getContextManager());
                newRCL.addResultColumn(oldRCL.getResultColumn(1));
                realSubquery.setResultColumns(newRCL);
            }
        }
        HasCorrelatedCRsVisitor visitor = new HasCorrelatedCRsVisitor();
        realSubquery.accept(visitor);
        this.foundCorrelation = visitor.hasCorrelatedCRs();
        if (this.pushedNewPredicate && oldRCL.size() > 1) {
            realSubquery.setResultColumns(oldRCL);
        }
        return this.foundCorrelation;
    }

    private UnaryComparisonOperatorNode pushNewPredicate(int numTables) throws StandardException {
        BinaryComparisonOperatorNode bcoNode;
        UnaryComparisonOperatorNode ucoNode = null;
        ContextManager cm = this.getContextManager();
        this.resultSet = this.resultSet.ensurePredicateList(numTables);
        ResultColumnList resultColumns = this.resultSet.getResultColumns();
        ResultColumnList newRCL = resultColumns.copyListAndObjects();
        newRCL.genVirtualColumnNodes(this.resultSet, resultColumns);
        this.resultSet = new ProjectRestrictNode(this.resultSet, newRCL, null, null, null, null, null, cm);
        resultColumns = newRCL;
        ResultColumn firstRC = (ResultColumn)resultColumns.elementAt(0);
        ValueNode rightOperand = firstRC.getExpression();
        BinaryOperatorNode andLeft = bcoNode = this.getNewJoinCondition(this.leftOperand, rightOperand);
        if (this.isNOT_IN() || this.isALL()) {
            boolean leftNullable = this.leftOperand.getTypeServices().isNullable();
            boolean rightNullable = rightOperand.getTypeServices().isNullable();
            if (leftNullable || rightNullable) {
                BooleanConstantNode falseNode = new BooleanConstantNode(false, cm);
                OrNode newOr = new OrNode(bcoNode, falseNode, cm);
                newOr.postBindFixup();
                andLeft = newOr;
                if (leftNullable) {
                    IsNullNode leftIsNull = new IsNullNode(this.leftOperand, false, cm);
                    leftIsNull.bindComparisonOperator();
                    newOr = new OrNode(leftIsNull, andLeft, cm);
                    newOr.postBindFixup();
                    andLeft = newOr;
                }
                if (rightNullable) {
                    IsNullNode rightIsNull = new IsNullNode(rightOperand, false, cm);
                    rightIsNull.bindComparisonOperator();
                    newOr = new OrNode(rightIsNull, andLeft, cm);
                    newOr.postBindFixup();
                    andLeft = newOr;
                }
            }
        }
        AndNode andNode = new AndNode(andLeft, this.getTrueNode(), cm);
        JBitSet tableMap = new JBitSet(numTables);
        andNode.postBindFixup();
        Predicate predicate = new Predicate(andNode, tableMap, cm);
        predicate.categorize();
        this.resultSet = this.resultSet.addNewPredicate(predicate);
        this.leftOperand = null;
        firstRC.setType(this.getTypeServices());
        firstRC.setExpression(this.getTrueNode());
        switch (this.subqueryType) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                ucoNode = new IsNullNode(this, true, cm);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                ucoNode = new IsNullNode(this, false, cm);
                break;
            }
            default: {
                SanityManager.NOTREACHED();
            }
        }
        ucoNode.bindComparisonOperator();
        return ucoNode;
    }

    private BinaryComparisonOperatorNode getNewJoinCondition(ValueNode leftOperand, ValueNode rightOperand) throws StandardException {
        int operatorType = this.subqueryType;
        if (this.subqueryType == 17) {
            SanityManager.ASSERT(this.parentComparisonOperator != null, "parentComparisonOperator expected to be non-null");
            int parentOperator = -1;
            if (this.parentComparisonOperator.isRelationalOperator()) {
                RelationalOperator ro = (RelationalOperator)((Object)this.parentComparisonOperator);
                parentOperator = ro.getOperator();
            }
            if (parentOperator == 1) {
                operatorType = 3;
            } else if (parentOperator == 2) {
                operatorType = 5;
            } else if (parentOperator == 6) {
                operatorType = 13;
            } else if (parentOperator == 5) {
                operatorType = 11;
            } else if (parentOperator == 4) {
                operatorType = 9;
            } else if (parentOperator == 3) {
                operatorType = 7;
            }
        }
        boolean bcoType = false;
        int kind = -1;
        switch (operatorType) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                kind = 0;
                break;
            }
            case 4: 
            case 5: {
                kind = 5;
                break;
            }
            case 8: 
            case 13: {
                kind = 3;
                break;
            }
            case 10: 
            case 11: {
                kind = 4;
                break;
            }
            case 9: 
            case 12: {
                kind = 1;
                break;
            }
            case 7: 
            case 14: {
                kind = 2;
                break;
            }
            default: {
                SanityManager.ASSERT(false, "subqueryType (" + this.subqueryType + ") is an unexpected type");
            }
        }
        BinaryRelationalOperatorNode bcoNode = new BinaryRelationalOperatorNode(kind, leftOperand, rightOperand, false, this.getContextManager());
        bcoNode.bindComparisonOperator();
        return bcoNode;
    }

    @Override
    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        ValueNode result = this;
        if (underNotNode) {
            switch (this.subqueryType) {
                case 17: {
                    result = this.genEqualsFalseTree();
                    break;
                }
                case 15: {
                    this.subqueryType = 16;
                    break;
                }
                case 1: 
                case 3: {
                    this.subqueryType = 2;
                    break;
                }
                case 5: {
                    this.subqueryType = 4;
                    break;
                }
                case 9: {
                    this.subqueryType = 12;
                    break;
                }
                case 7: {
                    this.subqueryType = 14;
                    break;
                }
                case 13: {
                    this.subqueryType = 8;
                    break;
                }
                case 11: {
                    this.subqueryType = 10;
                    break;
                }
                case 4: {
                    this.subqueryType = 5;
                    break;
                }
                case 6: {
                    this.subqueryType = 3;
                    break;
                }
                case 10: {
                    this.subqueryType = 11;
                    break;
                }
                case 8: {
                    this.subqueryType = 13;
                    break;
                }
                case 14: {
                    this.subqueryType = 7;
                    break;
                }
                case 12: {
                    this.subqueryType = 9;
                    break;
                }
                default: {
                    SanityManager.ASSERT(false, "NOT is not supported for this time of subquery");
                }
            }
        }
        return result;
    }

    @Override
    ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        this.underTopAndNode = underTopAndNode;
        return this;
    }

    @Override
    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        if (simplePredsOnly) {
            return false;
        }
        return this.isMaterializable();
    }

    public boolean isMaterializable() throws StandardException {
        boolean retval;
        boolean bl = retval = this.subqueryType == 17 && !this.hasCorrelatedCRs() && this.isInvariant();
        if (retval && this.resultSet instanceof SelectNode) {
            SelectNode select = (SelectNode)this.resultSet;
            FromList fromList = select.getFromList();
            fromList.setLevel(0);
        }
        return retval;
    }

    void optimize(DataDictionary dataDictionary, double outerRows) throws StandardException {
        this.resultSet = this.resultSet.optimize(dataDictionary, null, outerRows);
    }

    void modifyAccessPaths() throws StandardException {
        this.resultSet = this.resultSet.modifyAccessPaths();
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        if (this.isInvariant()) {
            if (!this.hasCorrelatedCRs() && this.subqueryType == 17) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionBuilder, MethodBuilder mbex) throws StandardException {
        int nargs;
        CompilerContext cc = this.getCompilerContext();
        SanityManager.ASSERT(expressionBuilder instanceof ActivationClassBuilder, "Expecting an ActivationClassBuilder");
        ActivationClassBuilder acb = (ActivationClassBuilder)expressionBuilder;
        String resultSetString = this.subqueryType == 17 ? "getOnceResultSet" : "getAnyResultSet";
        CostEstimate costEstimate = this.resultSet.getFinalCostEstimate();
        String subqueryTypeString = this.getTypeCompiler().interfaceName();
        MethodBuilder mb = acb.newGeneratedFun(subqueryTypeString, 4);
        LocalField rsFieldLF = acb.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.NoPutResultSet");
        ResultSetNode subNode = null;
        if (!this.isMaterializable()) {
            MethodBuilder executeMB = acb.getExecuteMethod();
            if (this.pushedNewPredicate && !this.hasCorrelatedCRs()) {
                SanityManager.ASSERT(this.resultSet instanceof ProjectRestrictNode, "resultSet expected to be a ProjectRestrictNode!");
                subNode = ((ProjectRestrictNode)this.resultSet).getChildResult();
                LocalField subRS = acb.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.NoPutResultSet");
                mb.getField(subRS);
                mb.conditionalIfNull();
                MaterializeSubqueryNode materialSubNode = new MaterializeSubqueryNode(subRS, this.getContextManager());
                materialSubNode.setCostEstimate(this.resultSet.getFinalCostEstimate());
                ((ProjectRestrictNode)this.resultSet).setChildResult(materialSubNode);
                subNode.generate(acb, mb);
                mb.startElseCode();
                mb.getField(subRS);
                mb.completeConditional();
                mb.setField(subRS);
                executeMB.pushNull("org.apache.derby.iapi.sql.execute.NoPutResultSet");
                executeMB.setField(subRS);
            }
            executeMB.pushNull("org.apache.derby.iapi.sql.execute.NoPutResultSet");
            executeMB.setField(rsFieldLF);
            mb.getField(rsFieldLF);
            mb.conditionalIfNull();
        }
        acb.pushGetResultSetFactoryExpression(mb);
        this.resultSet.generate(acb, mb);
        int subqResultSetNumber = cc.getNextResultSetNumber();
        this.resultSet.getResultColumns().setResultSetNumber(subqResultSetNumber);
        this.resultSet.getResultColumns().generateNulls(acb, mb);
        if (this.subqueryType == 17) {
            int cardinalityCheck = this.distinctExpression ? 3 : (this.resultSet.returnsAtMostOneRow() ? 2 : 1);
            mb.push(cardinalityCheck);
            nargs = 8;
        } else {
            nargs = 7;
        }
        mb.push(subqResultSetNumber);
        mb.push(this.subqueryNumber);
        mb.push(this.pointOfAttachment);
        mb.push(costEstimate.rowCount());
        mb.push(costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, resultSetString, "org.apache.derby.iapi.sql.execute.NoPutResultSet", nargs);
        if (!this.isMaterializable()) {
            if (this.pushedNewPredicate && !this.hasCorrelatedCRs()) {
                ((ProjectRestrictNode)this.resultSet).setChildResult(subNode);
            }
            mb.startElseCode();
            mb.getField(rsFieldLF);
            mb.completeConditional();
        }
        mb.setField(rsFieldLF);
        mb.getField(rsFieldLF);
        mb.callMethod((short)185, null, "openCore", "void", 0);
        mb.getField(rsFieldLF);
        mb.callMethod((short)185, null, "getNextRowCore", "org.apache.derby.iapi.sql.execute.ExecRow", 0);
        mb.push(1);
        mb.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "getColumn", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
        mb.cast(subqueryTypeString);
        if (this.isMaterializable()) {
            mb.getField(rsFieldLF);
            mb.callMethod((short)185, "org.apache.derby.iapi.sql.ResultSet", "close", "void", 0);
        }
        mb.methodReturn();
        mb.complete();
        if (this.isMaterializable()) {
            LocalField lf = this.generateMaterialization(acb, mb, subqueryTypeString);
            mbex.getField(lf);
        } else {
            mbex.pushThis();
            mbex.callMethod((short)182, null, mb.getName(), subqueryTypeString, 0);
        }
    }

    private LocalField generateMaterialization(ActivationClassBuilder acb, MethodBuilder mbsq, String type) {
        MethodBuilder mb = acb.getExecuteMethod();
        LocalField field = acb.newFieldDeclaration(2, type);
        mb.pushThis();
        mb.callMethod((short)182, null, mbsq.getName(), type, 0);
        mb.setField(field);
        return field;
    }

    private BooleanConstantNode getTrueNode() throws StandardException {
        if (this.trueNode == null) {
            this.trueNode = new BooleanConstantNode(true, this.getContextManager());
        }
        return this.trueNode;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (v instanceof HasCorrelatedCRsVisitor && this.doneCorrelationCheck) {
            ((HasCorrelatedCRsVisitor)v).setHasCorrelatedCRs(this.foundCorrelation);
            return;
        }
        if (this.resultSet != null) {
            this.resultSet = (ResultSetNode)this.resultSet.accept(v);
        }
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
    }

    private boolean isIN() {
        return this.subqueryType == 1;
    }

    private boolean isNOT_IN() {
        return this.subqueryType == 2;
    }

    private boolean isANY() {
        switch (this.subqueryType) {
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private boolean isALL() {
        switch (this.subqueryType) {
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    private boolean isEXISTS() {
        return this.subqueryType == 15;
    }

    private boolean isNOT_EXISTS() {
        return this.subqueryType == 16;
    }

    private void changeToCorrespondingExpressionType() throws StandardException {
        int nodeType = -1;
        switch (this.subqueryType) {
            case 1: 
            case 3: {
                nodeType = 0;
                break;
            }
            case 5: {
                nodeType = 5;
                break;
            }
            case 13: {
                nodeType = 3;
                break;
            }
            case 11: {
                nodeType = 4;
                break;
            }
            case 9: {
                nodeType = 1;
                break;
            }
            case 7: {
                nodeType = 2;
                break;
            }
            default: {
                SanityManager.NOTREACHED();
            }
        }
        BinaryRelationalOperatorNode bcon = new BinaryRelationalOperatorNode(nodeType, this.leftOperand, this, false, this.getContextManager());
        this.subqueryType = 17;
        this.setDataTypeServices(this.resultSet.getResultColumns());
        this.parentComparisonOperator = bcon;
        this.parentComparisonOperator.bindComparisonOperator();
        this.leftOperand = null;
    }

    private void setDataTypeServices(ResultColumnList resultColumns) throws StandardException {
        DataTypeDescriptor dts = this.subqueryType == 17 ? ((ResultColumn)resultColumns.elementAt(0)).getTypeServices() : this.getTrueNode().getTypeServices();
        this.setType(dts.getNullabilityType(true));
    }

    @Override
    boolean isEquivalent(ValueNode o) {
        return false;
    }

    public boolean isHavingSubquery() {
        return this.havingSubquery;
    }

    public void setHavingSubquery(boolean havingSubquery) {
        this.havingSubquery = havingSubquery;
    }

    boolean isWhereSubquery() {
        return this.whereSubquery;
    }

    void setWhereSubquery(boolean whereSubquery) {
        this.whereSubquery = whereSubquery;
    }

    boolean isWhereExistsAnyInWithWhereSubquery() throws StandardException {
        if (this.isWhereSubquery() && (this.isEXISTS() || this.isANY() || this.isIN())) {
            if (this.resultSet instanceof SelectNode) {
                SelectNode sn = (SelectNode)this.resultSet;
                if (sn.originalWhereClauseHadSubqueries) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public OrderByList getOrderByList() {
        return this.orderByList;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public ValueNode getFetchFirst() {
        return this.fetchFirst;
    }

    public boolean hasJDBClimitClause() {
        return this.hasJDBClimitClause;
    }
}

