/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class UnaryComparisonOperatorNode
extends UnaryOperatorNode {
    UnaryComparisonOperatorNode(ValueNode operator, ContextManager cm) throws StandardException {
        super(operator, cm);
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregates);
        this.bindComparisonOperator();
        return this;
    }

    void bindComparisonOperator() throws StandardException {
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, false));
    }

    @Override
    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        if (!underNotNode) {
            return this;
        }
        return this.getNegation(this.operand);
    }

    abstract UnaryOperatorNode getNegation(ValueNode var1) throws StandardException;

    /*
     * WARNING - void declaration
     */
    public ColumnReference getColumnOperand(Optimizable optTable, int columnPosition) {
        ColumnReference cr;
        SanityManager.ASSERT(optTable instanceof FromBaseTable);
        FromBaseTable ft = (FromBaseTable)optTable;
        if (this.operand instanceof ColumnReference && (cr = (ColumnReference)this.operand).getTableNumber() == ft.getTableNumber() && cr.getSource().getColumnPosition() == columnPosition) {
            void var4_4;
            return var4_4;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ColumnReference getColumnOperand(Optimizable optTable) {
        ColumnReference cr;
        if (this.operand instanceof ColumnReference && (cr = (ColumnReference)this.operand).getTableNumber() == optTable.getTableNumber()) {
            void var2_2;
            return var2_2;
        }
        return null;
    }

    public ValueNode getOperand(ColumnReference cRef, int refSetSize, boolean otherSide) {
        if (otherSide) {
            return null;
        }
        if (this.operand instanceof ColumnReference) {
            JBitSet cRefTables = new JBitSet(refSetSize);
            JBitSet crTables = new JBitSet(refSetSize);
            BaseTableNumbersVisitor btnVis = new BaseTableNumbersVisitor(crTables);
            ColumnReference cr = (ColumnReference)this.operand;
            try {
                cr.accept(btnVis);
                btnVis.setTableMap(cRefTables);
                cRef.accept(btnVis);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT("Failed when trying to find base table number for column reference check:", se);
            }
            crTables.and(cRefTables);
            if (crTables.getFirstSetBit() != -1 && cr.getSource().getColumnPosition() == cRef.getColumnNumber()) {
                return this.operand;
            }
        }
        return null;
    }

    public boolean selfComparison(ColumnReference cr) {
        SanityManager.ASSERT(cr == this.operand, "ColumnReference not found in IsNullNode.");
        return false;
    }

    public ValueNode getExpressionOperand(int tableNumber, int columnNumber, Optimizable ft) {
        return null;
    }

    public void generateExpressionOperand(Optimizable optTable, int columnPosition, ExpressionClassBuilderInterface acbi, MethodBuilder mb) throws StandardException {
        ExpressionClassBuilder acb = (ExpressionClassBuilder)acbi;
        acb.generateNull(mb, this.operand.getTypeCompiler(), this.operand.getTypeServices().getCollationType());
    }

    public int getStartOperator(Optimizable optTable) {
        SanityManager.THROWASSERT("getStartOperator not expected to be called for " + this.getClass().getName());
        return 1;
    }

    public int getStopOperator(Optimizable optTable) {
        SanityManager.THROWASSERT("getStopOperator not expected to be called for " + this.getClass().getName());
        return -1;
    }

    public void generateOrderedNulls(MethodBuilder mb) {
        mb.push(true);
    }

    public void generateQualMethod(ExpressionClassBuilderInterface acbi, MethodBuilder mb, Optimizable optTable) throws StandardException {
        ExpressionClassBuilder acb = (ExpressionClassBuilder)acbi;
        MethodBuilder qualMethod = acb.newUserExprFun();
        acb.generateNull(qualMethod, this.operand.getTypeCompiler(), this.operand.getTypeServices().getCollationType());
        qualMethod.methodReturn();
        qualMethod.complete();
        acb.pushMethodReference(mb, qualMethod);
    }

    public void generateAbsoluteColumnId(MethodBuilder mb, Optimizable optTable) {
        int columnPosition = this.getAbsoluteColumnPosition(optTable);
        mb.push(columnPosition);
    }

    public void generateRelativeColumnId(MethodBuilder mb, Optimizable optTable) {
        int columnPosition = this.getAbsoluteColumnPosition(optTable);
        columnPosition = optTable.convertAbsoluteToRelativeColumnPosition(columnPosition);
        mb.push(columnPosition);
    }

    private int getAbsoluteColumnPosition(Optimizable optTable) {
        ColumnReference cr = (ColumnReference)this.operand;
        int columnPosition = cr.getSource().getColumnPosition();
        ConglomerateDescriptor bestCD = optTable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        if (bestCD.isIndex()) {
            columnPosition = bestCD.getIndexDescriptor().getKeyColumnPosition(columnPosition);
            SanityManager.ASSERT(columnPosition > 0, "Base column not found in index");
        }
        return columnPosition - 1;
    }

    public boolean orderedNulls() {
        return true;
    }

    public boolean isQualifier(Optimizable optTable, boolean forPush) {
        if (!(this.operand instanceof ColumnReference)) {
            return false;
        }
        ColumnReference cr = (ColumnReference)this.operand;
        FromTable ft = (FromTable)optTable;
        return cr.getTableNumber() == ft.getTableNumber();
    }

    public int getOrderableVariantType(Optimizable optTable) throws StandardException {
        return this.operand.getOrderableVariantType();
    }
}

