/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.ScanResultSet;
import org.apache.derby.shared.common.sanity.SanityManager;

public class HashScanResultSet
extends ScanResultSet
implements CursorResultSet {
    private boolean hashtableBuilt;
    private ExecIndexRow startPosition;
    private ExecIndexRow stopPosition;
    protected ExecRow compactRow;
    protected boolean firstNext = true;
    private int numFetchedOnNext;
    private int entryVectorSize;
    private List entryVector;
    private long conglomId;
    protected StaticCompiledOpenConglomInfo scoci;
    private GeneratedMethod startKeyGetter;
    private int startSearchOperator;
    private GeneratedMethod stopKeyGetter;
    private int stopSearchOperator;
    public Qualifier[][] scanQualifiers;
    public Qualifier[][] nextQualifiers;
    private int initialCapacity;
    private float loadFactor;
    private int maxCapacity;
    public String userSuppliedOptimizerOverrides;
    public boolean forUpdate;
    private boolean runTimeStatisticsOn;
    public int[] keyColumns;
    private boolean sameStartStopPosition;
    private boolean skipNullKeyColumns;
    private boolean keepAfterCommit;
    protected BackingStoreHashtable hashtable;
    protected boolean eliminateDuplicates;
    public Properties scanProperties;
    public String startPositionString;
    public String stopPositionString;
    public int hashtableSize;
    public boolean isConstraint;
    public static final int DEFAULT_INITIAL_CAPACITY = -1;
    public static final float DEFAULT_LOADFACTOR = -1.0f;
    public static final int DEFAULT_MAX_CAPACITY = -1;

    HashScanResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, int resultRowTemplate, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] scanQualifiers, Qualifier[][] nextQualifiers, int initialCapacity, float loadFactor, int maxCapacity, int hashKeyItem, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int lockMode, boolean tableLocked, int isolationLevel, boolean skipNullKeyColumns, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, resultRowTemplate, lockMode, tableLocked, isolationLevel, colRefItem, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.scoci = scoci;
        this.conglomId = conglomId;
        SanityManager.ASSERT(activation != null, "hash scan must get activation context");
        if (sameStartStopPosition) {
            SanityManager.ASSERT(stopKeyGetter == null, "stopKeyGetter expected to be null when sameStartStopPosition is true");
        }
        this.startKeyGetter = startKeyGetter;
        this.startSearchOperator = startSearchOperator;
        this.stopKeyGetter = stopKeyGetter;
        this.stopSearchOperator = stopSearchOperator;
        this.sameStartStopPosition = sameStartStopPosition;
        this.scanQualifiers = scanQualifiers;
        this.nextQualifiers = nextQualifiers;
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.maxCapacity = maxCapacity;
        this.tableName = tableName;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.indexName = indexName;
        this.isConstraint = isConstraint;
        this.forUpdate = forUpdate;
        this.skipNullKeyColumns = skipNullKeyColumns;
        this.keepAfterCommit = activation.getResultSetHoldability();
        FormatableArrayHolder fah = (FormatableArrayHolder)activation.getPreparedStatement().getSavedObject(hashKeyItem);
        FormatableIntHolder[] fihArray = (FormatableIntHolder[])fah.getArray(FormatableIntHolder[].class);
        this.keyColumns = new int[fihArray.length];
        for (int index = 0; index < fihArray.length; ++index) {
            this.keyColumns[index] = fihArray[index].getInt();
        }
        this.runTimeStatisticsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.setRowLocationsState();
        this.compactRow = this.getCompactRow(this.candidate, this.accessedCols, false);
        this.recordConstructorTime();
    }

    @Override
    boolean canGetInstantaneousLocks() {
        return true;
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(!this.isOpen, "HashScanResultSet already open");
        TransactionController tc = this.activation.getTransactionController();
        this.initIsolationLevel();
        if (this.startKeyGetter != null) {
            this.startPosition = (ExecIndexRow)this.startKeyGetter.invoke(this.activation);
            if (this.sameStartStopPosition) {
                this.stopPosition = this.startPosition;
            }
        }
        if (this.stopKeyGetter != null) {
            this.stopPosition = (ExecIndexRow)this.stopKeyGetter.invoke(this.activation);
        }
        if (!this.skipScan(this.startPosition, this.stopPosition) && !this.hashtableBuilt) {
            DataValueDescriptor[] startPositionRow = this.startPosition == null ? null : this.startPosition.getRowArray();
            DataValueDescriptor[] stopPositionRow = this.stopPosition == null ? null : this.stopPosition.getRowArray();
            this.hashtable = tc.createBackingStoreHashtableFromScan(this.conglomId, this.forUpdate ? 4 : 0, this.lockMode, this.isolationLevel, this.accessedCols, startPositionRow, this.startSearchOperator, this.scanQualifiers, stopPositionRow, this.stopSearchOperator, -1L, this.keyColumns, this.eliminateDuplicates, -1L, this.maxCapacity, this.initialCapacity, this.loadFactor, this.runTimeStatisticsOn, this.skipNullKeyColumns, this.keepAfterCommit, this.fetchRowLocations);
            if (this.runTimeStatisticsOn) {
                this.hashtableSize = this.hashtable.size();
                if (this.scanProperties == null) {
                    this.scanProperties = new Properties();
                }
                try {
                    if (this.hashtable != null) {
                        this.hashtable.getAllRuntimeStats(this.scanProperties);
                    }
                }
                catch (StandardException se) {
                    // empty catch block
                }
            }
            this.hashtableBuilt = true;
            this.activation.informOfRowCount(this, this.hashtableSize);
        }
        this.isOpen = true;
        this.resetProbeVariables();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        SanityManager.ASSERT(this.isOpen, "HashScanResultSet already open");
        this.beginTime = this.getCurrentTimeMillis();
        this.resetProbeVariables();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private void resetProbeVariables() throws StandardException {
        this.firstNext = true;
        this.numFetchedOnNext = 0;
        this.entryVector = null;
        this.entryVectorSize = 0;
        if (this.nextQualifiers != null) {
            this.clearOrderableCache(this.nextQualifiers);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow result = null;
        DataValueDescriptor[] columns = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen && this.hashtableBuilt) {
            do {
                if (this.firstNext) {
                    Object hashEntry;
                    this.firstNext = false;
                    if (this.keyColumns.length == 1) {
                        hashEntry = this.hashtable.get(this.nextQualifiers[0][0].getOrderable());
                    } else {
                        KeyHasher mh = new KeyHasher(this.keyColumns.length);
                        SanityManager.ASSERT(this.nextQualifiers.length == 1);
                        for (int index = 0; index < this.keyColumns.length; ++index) {
                            DataValueDescriptor dvd = this.nextQualifiers[0][index].getOrderable();
                            if (dvd == null) {
                                mh = null;
                                break;
                            }
                            mh.setObject(index, this.nextQualifiers[0][index].getOrderable());
                        }
                        Object object = hashEntry = mh == null ? null : this.hashtable.get(mh);
                    }
                    if (hashEntry instanceof List) {
                        this.entryVector = (List)hashEntry;
                        this.entryVectorSize = this.entryVector.size();
                        columns = this.unpackHashValue(this.entryVector.get(0));
                    } else {
                        this.entryVector = null;
                        this.entryVectorSize = 0;
                        columns = this.unpackHashValue(hashEntry);
                    }
                } else if (this.numFetchedOnNext < this.entryVectorSize) {
                    columns = this.unpackHashValue(this.entryVector.get(this.numFetchedOnNext));
                }
                if (columns != null) {
                    if (RowUtil.qualifyRow(columns, this.nextQualifiers)) {
                        this.setCompatRow(this.compactRow, columns);
                        ++this.rowsSeen;
                        result = this.compactRow;
                    } else {
                        result = null;
                    }
                    ++this.numFetchedOnNext;
                    continue;
                }
                result = null;
            } while (result == null && this.numFetchedOnNext < this.entryVectorSize);
        }
        this.setCurrentRow(result);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.hashtableBuilt) {
                this.scanProperties = this.getScanProperties();
                if (this.runTimeStatisticsOn) {
                    this.startPositionString = this.printStartPosition();
                    this.stopPositionString = this.printStopPosition();
                }
                this.hashtable.close();
                this.hashtable = null;
                this.hashtableBuilt = false;
            }
            this.startPosition = null;
            this.stopPosition = null;
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of HashScanResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime;
        }
        return totTime;
    }

    @Override
    public boolean requiresRelocking() {
        return this.isolationLevel == 2 || this.isolationLevel == 3 || this.isolationLevel == 1;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        if (!this.hashtableBuilt) {
            return null;
        }
        SanityManager.ASSERT(this.currentRow != null, "There must be a current row when fetching the row location");
        DataValueDescriptor rlCandidate = this.currentRow.getColumn(this.currentRow.nColumns());
        if (!(rlCandidate instanceof RowLocation)) {
            SanityManager.THROWASSERT("rlCandidate expected to be instanceof RowLocation, not " + rlCandidate.getClass().getName());
        }
        return (RowLocation)this.currentRow.getColumn(this.currentRow.nColumns());
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.THROWASSERT("getCurrentRow() not expected to be called for HSRS");
        return null;
    }

    public String printStartPosition() {
        return this.printPosition(this.startSearchOperator, this.startKeyGetter, this.startPosition);
    }

    public String printStopPosition() {
        if (this.sameStartStopPosition) {
            return this.printPosition(this.stopSearchOperator, this.startKeyGetter, this.startPosition);
        }
        return this.printPosition(this.stopSearchOperator, this.stopKeyGetter, this.stopPosition);
    }

    private String printPosition(int searchOperator, GeneratedMethod positionGetter, ExecIndexRow eiRow) {
        String idt = "";
        String output = "";
        if (positionGetter == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U", new Object[0]) + "\n";
        }
        ExecIndexRow positioner = null;
        try {
            positioner = (ExecIndexRow)positionGetter.invoke(this.activation);
        }
        catch (StandardException e) {
            if (eiRow == null) {
                return "\t" + MessageService.getTextMessage("42Z38.U", new Object[0]);
            }
            return "\t" + MessageService.getTextMessage("42Z39.U", new Object[0]) + "\n";
        }
        if (positioner == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U", new Object[0]) + "\n";
        }
        String searchOp = null;
        switch (searchOperator) {
            case 1: {
                searchOp = ">=";
                break;
            }
            case -1: {
                searchOp = ">";
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unknown search operator " + searchOperator);
                searchOp = "unknown value (" + searchOperator + ")";
            }
        }
        output = output + "\t" + MessageService.getTextMessage("42Z40.U", searchOp, String.valueOf(positioner.nColumns())) + "\n";
        output = output + "\t" + MessageService.getTextMessage("42Z41.U", new Object[0]) + "\n";
        boolean colSeen = false;
        for (int position = 0; position < positioner.nColumns(); ++position) {
            if (positioner.areNullsOrdered(position)) {
                output = output + position + " ";
                colSeen = true;
            }
            if (!colSeen || position != positioner.nColumns() - 1) continue;
            output = output + "\n";
        }
        return output;
    }

    public Properties getScanProperties() {
        return this.scanProperties;
    }

    @Override
    public boolean isForUpdate() {
        return this.forUpdate;
    }
}

