/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.db.TriggerExecutionContext;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionStmtValidator;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;
import org.apache.derby.impl.sql.execute.TriggerEvent;

class InternalTriggerExecutionContext
implements TriggerExecutionContext,
ExecutionStmtValidator {
    protected int dmlType;
    protected String statementText;
    protected ConnectionContext cc;
    protected UUID targetTableId;
    protected String targetTableName;
    protected LanguageConnectionContext lcc;
    protected CursorResultSet beforeResultSet;
    protected CursorResultSet afterResultSet;
    protected ExecRow afterRow;
    protected boolean cleanupCalled;
    protected TriggerEvent event;
    protected TriggerDescriptor triggerd;
    private Vector<ResultSet> resultSetVector;
    private Vector<AutoincrementCounter> aiCounters;
    private Hashtable<String, Long> aiHT;

    InternalTriggerExecutionContext(LanguageConnectionContext lcc, ConnectionContext cc, String statementText, int dmlType, UUID targetTableId, String targetTableName, Vector<AutoincrementCounter> aiCounters) throws StandardException {
        this.dmlType = dmlType;
        this.statementText = statementText;
        this.cc = cc;
        this.lcc = lcc;
        this.targetTableId = targetTableId;
        this.targetTableName = targetTableName;
        this.resultSetVector = new Vector();
        this.aiCounters = aiCounters;
        lcc.pushTriggerExecutionContext(this);
    }

    void setBeforeResultSet(CursorResultSet rs) {
        this.beforeResultSet = rs;
    }

    void setAfterResultSet(CursorResultSet rs) throws StandardException {
        this.afterResultSet = rs;
        if (this.aiCounters != null) {
            if (this.triggerd.isRowTrigger()) {
                rs.open();
                this.afterRow = rs.getNextRow();
                rs.close();
            } else if (!this.triggerd.isBeforeTrigger()) {
                this.resetAICounters(false);
            }
        }
    }

    void setCurrentTriggerEvent(TriggerEvent event) {
        this.event = event;
    }

    void clearCurrentTriggerEvent() {
        this.event = null;
    }

    void setTrigger(TriggerDescriptor triggerd) {
        this.triggerd = triggerd;
    }

    void clearTrigger() throws StandardException {
        this.event = null;
        this.triggerd = null;
        if (this.afterResultSet != null) {
            this.afterResultSet.close();
            this.afterResultSet = null;
        }
        if (this.beforeResultSet != null) {
            this.beforeResultSet.close();
            this.beforeResultSet = null;
        }
    }

    protected void cleanup() throws StandardException {
        this.lcc.popTriggerExecutionContext(this);
        Enumeration<ResultSet> e = this.resultSetVector.elements();
        while (e.hasMoreElements()) {
            ResultSet rs = e.nextElement();
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        this.resultSetVector = null;
        if (this.afterResultSet != null) {
            this.afterResultSet.close();
            this.afterResultSet = null;
        }
        if (this.beforeResultSet != null) {
            this.beforeResultSet.close();
            this.beforeResultSet = null;
        }
        this.lcc = null;
        this.cleanupCalled = true;
    }

    private void ensureProperContext() throws SQLException {
        if (this.cleanupCalled) {
            throw new SQLException(MessageService.getTextMessage("XCL31.S", new Object[0]), "XCL31", 20000);
        }
    }

    @Override
    public void validateStatement(ConstantAction constantAction) throws StandardException {
        if (constantAction instanceof DDLConstantAction) {
            throw StandardException.newException("X0Y69.S", this.triggerd.getName());
        }
    }

    @Override
    public String getTargetTableName() {
        return this.targetTableName;
    }

    @Override
    public UUID getTargetTableId() {
        return this.targetTableId;
    }

    @Override
    public int getEventType() {
        return this.dmlType;
    }

    @Override
    public String getEventStatementText() {
        return this.statementText;
    }

    @Override
    public ResultSet getOldRowSet() throws SQLException {
        this.ensureProperContext();
        if (this.beforeResultSet == null) {
            return null;
        }
        try {
            CursorResultSet brs = this.beforeResultSet;
            if (brs instanceof TemporaryRowHolderResultSet) {
                brs = (CursorResultSet)((TemporaryRowHolderResultSet)brs).clone();
            } else if (brs instanceof TableScanResultSet) {
                brs = (CursorResultSet)((TableScanResultSet)brs).clone();
            }
            brs.open();
            ResultSet rs = this.cc.getResultSet(brs);
            this.resultSetVector.addElement(rs);
            return rs;
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public ResultSet getNewRowSet() throws SQLException {
        this.ensureProperContext();
        if (this.afterResultSet == null) {
            return null;
        }
        try {
            CursorResultSet ars = this.afterResultSet;
            if (ars instanceof TemporaryRowHolderResultSet) {
                ars = (CursorResultSet)((TemporaryRowHolderResultSet)ars).clone();
            } else if (ars instanceof TableScanResultSet) {
                ars = (CursorResultSet)((TableScanResultSet)ars).clone();
            }
            ars.open();
            ResultSet rs = this.cc.getResultSet(ars);
            this.resultSetVector.addElement(rs);
            return rs;
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public ResultSet getOldRow() throws SQLException {
        ResultSet rs = this.getOldRowSet();
        if (rs != null) {
            rs.next();
        }
        return rs;
    }

    @Override
    public ResultSet getNewRow() throws SQLException {
        ResultSet rs = this.getNewRowSet();
        if (rs != null) {
            rs.next();
        }
        return rs;
    }

    @Override
    public Long getAutoincrementValue(String identity) {
        Long value;
        if (this.aiHT != null && (value = this.aiHT.get(identity)) != null) {
            return value;
        }
        if (this.aiCounters != null) {
            for (AutoincrementCounter aic : this.aiCounters) {
                if (!identity.equals(aic.getIdentity())) continue;
                return aic.getCurrentValue();
            }
        }
        return null;
    }

    public void copyHashtableToAIHT(Map<String, Long> from) {
        if (from == null) {
            return;
        }
        if (this.aiHT == null) {
            this.aiHT = new Hashtable();
        }
        this.aiHT.putAll(from);
    }

    public void resetAICounters(boolean begin) {
        if (this.aiCounters == null) {
            return;
        }
        this.afterRow = null;
        for (AutoincrementCounter aic : this.aiCounters) {
            aic.reset(begin);
        }
    }

    public void updateAICounters() throws StandardException {
        if (this.aiCounters == null) {
            return;
        }
        for (AutoincrementCounter aic : this.aiCounters) {
            DataValueDescriptor dvd = this.afterRow.getColumn(aic.getColumnPosition());
            aic.update(dvd.getLong());
        }
    }

    public String toString() {
        return this.triggerd.getName();
    }
}

