/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.RISetChecker;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.TriggerEventActivator;
import org.apache.derby.impl.sql.execute.TriggerEvents;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.UpdateConstantAction;
import org.apache.derby.shared.common.sanity.SanityManager;

class UpdateResultSet
extends DMLWriteResultSet {
    private TransactionController tc;
    private ExecRow newBaseRow;
    private ExecRow row;
    private ExecRow deferredSparseRow;
    UpdateConstantAction constants;
    private NoPutResultSet source;
    NoPutResultSet savedSource;
    private RowChanger rowChanger;
    protected ConglomerateController deferredBaseCC;
    protected long[] deferredUniqueCIDs;
    protected boolean[] deferredUniqueCreated;
    protected ConglomerateController[] deferredUniqueCC;
    protected ScanController[] deferredUniqueScans;
    private TemporaryRowHolderImpl deletedRowHolder;
    private TemporaryRowHolderImpl insertedRowHolder;
    private RISetChecker riChecker;
    private TriggerInfo triggerInfo;
    private TriggerEventActivator triggerActivator;
    private boolean updatingReferencedKey;
    private boolean updatingForeignKey;
    private int numOpens;
    private long heapConglom;
    private FKInfo[] fkInfoArray;
    private FormatableBitSet baseRowReadList;
    private GeneratedMethod generationClauses;
    private GeneratedMethod checkGM;
    private int resultWidth;
    private int numberOfBaseColumns;
    private ExecRow deferredTempRow;
    private ExecRow deferredBaseRow;
    private ExecRow oldDeletedRow;
    private ResultDescription triggerResultDescription;
    int lockMode;
    boolean deferred;
    boolean beforeUpdateCopyRequired = false;
    private List<UUID> violatingCheckConstraints;
    private BackingStoreHashtable deferredChecks;

    UpdateResultSet(NoPutResultSet source, GeneratedMethod generationClauses, GeneratedMethod checkGM, Activation activation) throws StandardException {
        this(source, generationClauses, checkGM, activation, activation.getConstantAction(), null);
    }

    UpdateResultSet(NoPutResultSet source, GeneratedMethod generationClauses, GeneratedMethod checkGM, Activation activation, int constantActionItem, int rsdItem) throws StandardException {
        this(source, generationClauses, checkGM, activation, (ConstantAction)activation.getPreparedStatement().getSavedObject(constantActionItem), (ResultDescription)activation.getPreparedStatement().getSavedObject(rsdItem));
        this.deferred = true;
    }

    UpdateResultSet(NoPutResultSet source, GeneratedMethod generationClauses, GeneratedMethod checkGM, Activation activation, ConstantAction passedInConstantAction, ResultDescription passedInRsd) throws StandardException {
        super(activation, passedInConstantAction);
        this.tc = activation.getTransactionController();
        this.source = source;
        this.generationClauses = generationClauses;
        this.checkGM = checkGM;
        this.constants = (UpdateConstantAction)this.constantAction;
        this.fkInfoArray = this.constants.getFKInfo();
        this.triggerInfo = this.constants.getTriggerInfo();
        this.heapConglom = this.constants.conglomId;
        this.baseRowReadList = this.constants.getBaseRowReadList();
        this.resultDescription = passedInRsd == null ? source.getResultDescription() : passedInRsd;
        if (this.resultDescription == null) {
            SanityManager.ASSERT(this.triggerInfo == null, "triggers need a result description to pass to result sets given to users");
        }
        if (this.fkInfoArray != null) {
            for (FKInfo fkInfo : this.fkInfoArray) {
                if (fkInfo.type == 2) {
                    this.updatingReferencedKey = true;
                    SanityManager.ASSERT(this.constants.deferred, "updating referenced key but update not deferred, wuzzup?");
                    continue;
                }
                this.updatingForeignKey = true;
            }
        }
        this.resultWidth = this.resultDescription.getColumnCount();
        this.numberOfBaseColumns = (this.resultWidth - 1) / 2;
        this.newBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
        this.deferred = this.constants.deferred;
        if (this.triggerInfo != null || this.fkInfoArray != null) {
            this.beforeUpdateCopyRequired = true;
        }
    }

    @Override
    public void open() throws StandardException {
        this.setup();
        this.collectAffectedRows();
        if (this.deferred) {
            this.runChecker(true);
            this.fireBeforeTriggers();
            this.updateDeferredRows();
            this.rowChanger.finish();
            this.runChecker(false);
            this.fireAfterTriggers();
        } else {
            this.rowChanger.finish();
        }
        this.cleanUp();
    }

    @Override
    void setup() throws StandardException {
        super.setup();
        this.lockMode = this.decodeLockMode(this.constants.lockMode);
        boolean firstOpen = this.rowChanger == null;
        this.rowCount = 0L;
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.source;
        }
        if (firstOpen) {
            this.rowChanger = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getRowChanger(this.heapConglom, this.constants.heapSCOCI, this.heapDCOCI, this.constants.irgs, this.constants.indexCIDS, this.constants.indexSCOCIs, this.indexDCOCIs, this.constants.numColumns, this.tc, this.constants.changedColumnIds, this.constants.getBaseRowReadList(), this.constants.getBaseRowReadMap(), this.constants.getStreamStorableHeapColIds(), this.activation);
            this.rowChanger.setIndexNames(this.constants.indexNames);
        }
        this.rowChanger.open(this.lockMode);
        if (this.numOpens++ == 0) {
            this.source.openCore();
        } else {
            this.source.reopenCore();
        }
        if (this.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (this.fkInfoArray != null) {
            if (this.riChecker == null) {
                this.riChecker = new RISetChecker(this.lcc, this.tc, this.fkInfoArray);
            } else {
                this.riChecker.reopen();
            }
        }
        if (this.deferred) {
            if (firstOpen) {
                this.deferredTempRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns + 1, this.lcc);
                this.oldDeletedRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
                this.triggerResultDescription = this.resultDescription != null ? this.resultDescription.truncateColumns(this.numberOfBaseColumns + 1) : null;
            }
            Properties properties = new Properties();
            this.rowChanger.getHeapConglomerateController().getInternalTablePropertySet(properties);
            if (this.beforeUpdateCopyRequired) {
                this.deletedRowHolder = new TemporaryRowHolderImpl(this.activation, properties, this.triggerResultDescription);
            }
            this.insertedRowHolder = new TemporaryRowHolderImpl(this.activation, properties, this.triggerResultDescription);
            this.rowChanger.setRowHolder(this.insertedRowHolder);
        }
    }

    private FormatableBitSet checkStreamCols() {
        DataValueDescriptor[] cols = this.row.getRowArray();
        FormatableBitSet streamCols = null;
        for (int i = 0; i < this.numberOfBaseColumns; ++i) {
            if (!(cols[i + this.numberOfBaseColumns] instanceof StreamStorable)) continue;
            if (streamCols == null) {
                streamCols = new FormatableBitSet(this.numberOfBaseColumns);
            }
            streamCols.set(i);
        }
        return streamCols;
    }

    private void objectifyStream(ExecRow tempRow, FormatableBitSet streamCols) throws StandardException {
        DataValueDescriptor[] cols = tempRow.getRowArray();
        for (int i = 0; i < this.numberOfBaseColumns; ++i) {
            if (cols[i] == null || !streamCols.get(i)) continue;
            ((StreamStorable)((Object)cols[i])).loadStream();
        }
    }

    private boolean evaluateCheckConstraints() throws StandardException {
        boolean result = true;
        if (this.checkGM != null) {
            SQLBoolean allOk = (SQLBoolean)this.checkGM.invoke(this.activation);
            result = allOk.isNull() || allOk.getBoolean();
        }
        return result;
    }

    public boolean collectAffectedRows() throws StandardException {
        boolean rowsFound = false;
        this.row = this.getNextRowCore(this.source);
        if (this.row != null) {
            rowsFound = true;
        } else {
            this.activation.addWarning(StandardException.newWarning("02000", new Object[0]));
        }
        TableScanResultSet tableScan = (TableScanResultSet)this.activation.getForUpdateIndexScan();
        boolean notifyCursor = tableScan != null;
        boolean checkStream = this.deferred && rowsFound && !this.constants.singleRowSource;
        FormatableBitSet streamCols = checkStream ? this.checkStreamCols() : null;
        boolean bl = checkStream = streamCols != null;
        while (this.row != null) {
            boolean allOk;
            this.evaluateGenerationClauses(this.generationClauses, this.activation, this.source, this.row, true);
            if (this.deferred) {
                if (this.triggerInfo == null && !(allOk = this.evaluateCheckConstraints())) {
                    DataValueDescriptor[] rw = this.row.getRowArray();
                    SQLRef r = (SQLRef)rw[rw.length - 1];
                    RowLocation baseRowLocation = (RowLocation)r.getObject();
                    this.deferredChecks = DeferredConstraintsMemory.rememberCheckViolations(this.lcc, this.constants.targetUUID, this.constants.getSchemaName(), this.constants.getTableName(), this.deferredChecks, this.violatingCheckConstraints, baseRowLocation, new DeferredConstraintsMemory.CheckInfo[1]);
                }
                RowUtil.copyRefColumns(this.deferredTempRow, this.row, this.numberOfBaseColumns, this.numberOfBaseColumns + 1);
                if (checkStream) {
                    this.objectifyStream(this.deferredTempRow, streamCols);
                }
                this.insertedRowHolder.insert(this.deferredTempRow);
                if (this.beforeUpdateCopyRequired) {
                    RowUtil.copyRefColumns(this.oldDeletedRow, this.row, this.numberOfBaseColumns);
                    this.deletedRowHolder.insert(this.oldDeletedRow);
                }
                if (this.deferredBaseRow == null) {
                    this.deferredBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns, this.lcc);
                    RowUtil.copyCloneColumns(this.deferredBaseRow, this.row, this.numberOfBaseColumns);
                    this.deferredSparseRow = this.makeDeferredSparseRow(this.deferredBaseRow, this.baseRowReadList, this.lcc);
                }
            } else {
                allOk = this.evaluateCheckConstraints();
                RowLocation baseRowLocation = (RowLocation)this.row.getColumn(this.resultWidth).getObject();
                if (!allOk) {
                    this.deferredChecks = DeferredConstraintsMemory.rememberCheckViolations(this.lcc, this.constants.targetUUID, this.constants.getSchemaName(), this.constants.getTableName(), this.deferredChecks, this.violatingCheckConstraints, baseRowLocation, new DeferredConstraintsMemory.CheckInfo[1]);
                }
                RowUtil.copyRefColumns(this.newBaseRow, this.row, this.numberOfBaseColumns, this.numberOfBaseColumns);
                if (this.riChecker != null) {
                    this.riChecker.doFKCheck(this.activation, this.newBaseRow);
                }
                this.source.updateRow(this.newBaseRow, this.rowChanger);
                this.rowChanger.updateRow(this.row, this.newBaseRow, baseRowLocation);
                if (notifyCursor) {
                    this.notifyForUpdateCursor(this.row.getRowArray(), this.newBaseRow.getRowArray(), baseRowLocation, tableScan);
                }
            }
            ++this.rowCount;
            if (this.constants.singleRowSource) {
                this.row = null;
                continue;
            }
            this.row = this.getNextRowCore(this.source);
        }
        return rowsFound;
    }

    @Override
    protected ExecRow getNextRowCore(NoPutResultSet source) throws StandardException {
        ExecRow nextRow = super.getNextRowCore(source);
        if (nextRow != null && this.constants.underMerge()) {
            nextRow = this.processMergeRow(source, nextRow);
        }
        return nextRow;
    }

    private ExecRow processMergeRow(NoPutResultSet sourceRS, ExecRow row) throws StandardException {
        return this.normalizeRow(sourceRS, row);
    }

    private void notifyForUpdateCursor(DataValueDescriptor[] row, DataValueDescriptor[] newBaseRow, RowLocation rl, TableScanResultSet tableScan) throws StandardException {
        int[] indexCols = tableScan.indexCols;
        int[] changedCols = this.constants.changedColumnIds;
        boolean placedForward = false;
        boolean decided = false;
        boolean overlap = false;
        for (int i = 0; i < indexCols.length; ++i) {
            boolean ascending;
            int basePos = indexCols[i];
            if (basePos > 0) {
                ascending = true;
            } else {
                ascending = false;
                basePos = -basePos;
            }
            for (int j = 0; j < changedCols.length; ++j) {
                if (basePos != changedCols[j]) continue;
                decided = true;
                int[] map = this.constants.getBaseRowReadMap();
                int k = map == null ? basePos - 1 : map[basePos - 1];
                DataValueDescriptor key = row[k];
                if (ascending && key.greaterThan(newBaseRow[k], key).equals(true) || !ascending && key.lessThan(newBaseRow[k], key).equals(true)) {
                    placedForward = true;
                    break;
                }
                if (!key.equals(newBaseRow[k], key).equals(true)) break;
                decided = false;
                overlap = true;
                break;
            }
            if (decided) break;
        }
        if (overlap && !decided) {
            placedForward = true;
        }
        if (placedForward) {
            int maxCapacity = this.lcc.getOptimizerFactory().getMaxMemoryPerTable() / 16;
            if (maxCapacity < 100) {
                maxCapacity = 100;
            }
            if (tableScan.past2FutureTbl == null) {
                double rowCnt = tableScan.getEstimatedRowCount();
                int initCapacity = 32768;
                if (rowCnt > 0.0 && (rowCnt = rowCnt / 0.75 + 1.0) < (double)initCapacity) {
                    initCapacity = (int)rowCnt;
                }
                if (maxCapacity < initCapacity) {
                    initCapacity = maxCapacity;
                }
                tableScan.past2FutureTbl = new BackingStoreHashtable(this.tc, null, new int[]{0}, false, -1L, maxCapacity, initCapacity, -1.0f, false, tableScan.getActivation().getResultSetHoldability());
            }
            tableScan.past2FutureTbl.putRow(false, new DataValueDescriptor[]{rl.cloneValue(false)}, null);
        }
    }

    void fireBeforeTriggers() throws StandardException {
        if (this.deferred && this.triggerInfo != null) {
            if (this.triggerActivator == null) {
                this.triggerActivator = new TriggerEventActivator(this.lcc, this.constants.targetUUID, this.triggerInfo, 1, this.activation, null);
            } else {
                this.triggerActivator.reopen();
            }
            this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_UPDATE, this.deletedRowHolder.getResultSet(), this.insertedRowHolder.getResultSet(), this.constants.getBaseRowReadMap());
        }
    }

    void fireAfterTriggers() throws StandardException {
        if (this.deferred && this.triggerActivator != null) {
            this.triggerActivator.notifyEvent(TriggerEvents.AFTER_UPDATE, this.deletedRowHolder.getResultSet(), this.insertedRowHolder.getResultSet(), this.constants.getBaseRowReadMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDeferredRows() throws StandardException {
        if (this.deferred) {
            this.deferredBaseCC = this.tc.openCompiledConglomerate(false, 8196, this.lockMode, 5, this.constants.heapSCOCI, this.heapDCOCI);
            CursorResultSet rs = this.insertedRowHolder.getResultSet();
            try {
                ExecRow deferredTempRow2;
                FormatableBitSet readBitSet = RowUtil.shift(this.baseRowReadList, 1);
                rs.open();
                while ((deferredTempRow2 = rs.getNextRow()) != null) {
                    boolean allOk = true;
                    if (this.triggerInfo != null) {
                        this.source.setCurrentRow(this.deferredTempRow);
                        allOk = this.evaluateCheckConstraints();
                    }
                    DataValueDescriptor rlColumn = deferredTempRow2.getColumn(this.numberOfBaseColumns + 1);
                    RowLocation baseRowLocation = (RowLocation)rlColumn.getObject();
                    if (!allOk) {
                        this.deferredChecks = DeferredConstraintsMemory.rememberCheckViolations(this.lcc, this.constants.targetUUID, this.constants.getSchemaName(), this.constants.getTableName(), this.deferredChecks, this.violatingCheckConstraints, baseRowLocation, new DeferredConstraintsMemory.CheckInfo[1]);
                    }
                    boolean row_exists = this.deferredBaseCC.fetch(baseRowLocation, this.deferredSparseRow.getRowArray(), readBitSet);
                    SanityManager.ASSERT(row_exists, "did not find base row in deferred update");
                    RowUtil.copyRefColumns(this.newBaseRow, deferredTempRow2, this.numberOfBaseColumns);
                    this.rowChanger.updateRow(this.deferredBaseRow, this.newBaseRow, baseRowLocation);
                }
            }
            finally {
                this.source.clearCurrentRow();
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runChecker(boolean restrictCheckOnly) throws StandardException {
        int i;
        if (this.deferred && this.updatingReferencedKey) {
            for (i = 0; i < this.fkInfoArray.length; ++i) {
                if (this.fkInfoArray[i].type == 1) continue;
                CursorResultSet deletedRows = this.deletedRowHolder.getResultSet();
                try {
                    ExecRow deletedRow;
                    deletedRows.open();
                    while ((deletedRow = deletedRows.getNextRow()) != null) {
                        if (UpdateResultSet.foundRow(deletedRow, this.fkInfoArray[i].colArray, this.insertedRowHolder)) continue;
                        this.riChecker.doRICheck(this.activation, i, deletedRow, restrictCheckOnly, 1);
                    }
                    if (!restrictCheckOnly) continue;
                    this.riChecker.postCheck(i);
                    continue;
                }
                finally {
                    deletedRows.close();
                }
            }
        }
        if (this.deferred && this.updatingForeignKey) {
            for (i = 0; i < this.fkInfoArray.length; ++i) {
                if (this.fkInfoArray[i].type == 2) continue;
                CursorResultSet insertedRows = this.insertedRowHolder.getResultSet();
                try {
                    ExecRow insertedRow;
                    insertedRows.open();
                    while ((insertedRow = insertedRows.getNextRow()) != null) {
                        if (UpdateResultSet.foundRow(insertedRow, this.fkInfoArray[i].colArray, this.deletedRowHolder)) continue;
                        this.riChecker.doRICheck(this.activation, i, insertedRow, restrictCheckOnly, 0);
                    }
                    continue;
                }
                finally {
                    insertedRows.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean foundRow(ExecRow checkRow, int[] colsToCheck, TemporaryRowHolderImpl rowHolder) throws StandardException {
        boolean foundMatch = false;
        DataValueDescriptor[] checkRowArray = checkRow.getRowArray();
        CursorResultSet rs = rowHolder.getResultSet();
        try {
            ExecRow scanRow;
            rs.open();
            while ((scanRow = rs.getNextRow()) != null) {
                DataValueDescriptor scanCol;
                DataValueDescriptor checkCol;
                BooleanDataValue result;
                int i;
                DataValueDescriptor[] scanRowArray = scanRow.getRowArray();
                for (i = 0; i < colsToCheck.length && (result = (checkCol = checkRowArray[colsToCheck[i] - 1]).equals(scanCol = scanRowArray[colsToCheck[i] - 1], checkCol)).getBoolean(); ++i) {
                }
                if (i != colsToCheck.length) continue;
                foundMatch = true;
                break;
            }
        }
        finally {
            rs.close();
        }
        return foundMatch;
    }

    @Override
    public void cleanUp() throws StandardException {
        this.numOpens = 0;
        if (this.source != null) {
            this.source.close();
        }
        if (this.triggerActivator != null) {
            this.triggerActivator.cleanup();
        }
        if (this.rowChanger != null) {
            this.rowChanger.close();
        }
        if (this.deferredBaseCC != null) {
            this.deferredBaseCC.close();
        }
        this.deferredBaseCC = null;
        if (this.insertedRowHolder != null) {
            this.insertedRowHolder.close();
        }
        if (this.deletedRowHolder != null) {
            this.deletedRowHolder.close();
        }
        if (this.riChecker != null) {
            this.riChecker.close();
        }
        this.close();
        this.endTime = this.getCurrentTimeMillis();
    }

    @Override
    public void close() throws StandardException {
        super.close(this.constants.underMerge());
    }

    void rowChangerFinish() throws StandardException {
        this.rowChanger.finish();
    }

    @Override
    public void rememberConstraint(UUID cid) throws StandardException {
        if (this.violatingCheckConstraints == null) {
            this.violatingCheckConstraints = new ArrayList<UUID>();
        }
        this.violatingCheckConstraints.add(cid);
    }
}

