/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

abstract class RealBasicNoPutResultSetStatistics
implements ResultSetStatistics {
    public int numOpens;
    public int rowsSeen;
    public int rowsFiltered;
    public long constructorTime;
    public long openTime;
    public long nextTime;
    public long closeTime;
    public long inspectOverall;
    public long inspectNum;
    public String inspectDesc;
    public double optimizerEstimatedRowCount;
    public double optimizerEstimatedCost;

    public RealBasicNoPutResultSetStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        this.numOpens = numOpens;
        this.rowsSeen = rowsSeen;
        this.rowsFiltered = rowsFiltered;
        this.constructorTime = constructorTime;
        this.openTime = openTime;
        this.nextTime = nextTime;
        this.closeTime = closeTime;
        this.optimizerEstimatedRowCount = optimizerEstimatedRowCount;
        this.optimizerEstimatedCost = optimizerEstimatedCost;
    }

    protected final String dumpTimeStats(String indent, String subIndent) {
        return subIndent + MessageService.getTextMessage("42Z33.U", new Object[0]) + " " + this.constructorTime + "\n" + subIndent + MessageService.getTextMessage("42Z34.U", new Object[0]) + " " + this.openTime + "\n" + subIndent + MessageService.getTextMessage("42Z35.U", new Object[0]) + " " + this.nextTime + "\n" + subIndent + MessageService.getTextMessage("42Z36.U", new Object[0]) + " " + this.closeTime;
    }

    protected final String dumpEstimatedCosts(String subIndent) {
        return subIndent + MessageService.getTextMessage("43X07.U", new Double(this.optimizerEstimatedRowCount)) + "\n" + subIndent + MessageService.getTextMessage("43X08.U", new Double(this.optimizerEstimatedCost));
    }

    public Vector<ResultSetStatistics> getChildren() {
        return new Vector<ResultSetStatistics>();
    }

    public long getTotalTime() {
        return this.openTime + this.nextTime + this.closeTime;
    }

    public long getChildrenTime() {
        long childrenTime = 0L;
        Enumeration<ResultSetStatistics> e = this.getChildren().elements();
        while (e.hasMoreElements()) {
            childrenTime += ((RealBasicNoPutResultSetStatistics)e.nextElement()).getTotalTime();
        }
        return childrenTime;
    }

    public long getNodeTime() {
        return this.getTotalTime() - this.getChildrenTime();
    }

    public abstract String getNodeName();

    public String getNodeOn() {
        return "";
    }

    @Override
    public double getEstimatedRowCount() {
        return this.optimizerEstimatedRowCount;
    }

    @Override
    public String getRSXplainDetails() {
        return null;
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), new Integer(this.numOpens), null, null, null, (UUID)parentID, new Double(this.optimizerEstimatedRowCount), new Double(this.optimizerEstimatedCost), null, null, null, new Integer(this.rowsSeen), null, new Integer(this.rowsFiltered), new Integer(this.rowsSeen - this.rowsFiltered), null, null, (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }

    @Override
    public Object getResultSetTimingsDescriptor(Object timingID) {
        return new XPLAINResultSetTimingsDescriptor((UUID)timingID, new Long(this.constructorTime), new Long(this.openTime), new Long(this.nextTime), new Long(this.closeTime), new Long(this.getNodeTime()), XPLAINUtil.getAVGNextTime(this.nextTime, this.rowsSeen), null, null, null, null);
    }

    @Override
    public Object getSortPropsDescriptor(Object UUID2) {
        return null;
    }

    @Override
    public Object getScanPropsDescriptor(Object UUID2) {
        return null;
    }
}

