/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINSortPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class RealSortStatistics
extends RealNoPutResultSetStatistics {
    public int rowsInput;
    public int rowsReturned;
    public boolean eliminateDuplicates;
    public boolean inSortedOrder;
    public ResultSetStatistics childResultSetStatistics;
    public FormatableProperties sortProperties;

    public RealSortStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, int rowsInput, int rowsReturned, boolean eliminateDuplicates, boolean inSortedOrder, Properties sortProperties, double optimizerEstimatedRowCount, double optimizerEstimatedCost, ResultSetStatistics childResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.rowsInput = rowsInput;
        this.rowsReturned = rowsReturned;
        this.eliminateDuplicates = eliminateDuplicates;
        this.inSortedOrder = inSortedOrder;
        this.childResultSetStatistics = childResultSetStatistics;
        this.sortProperties = new FormatableProperties();
        Enumeration<Object> e = sortProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.sortProperties.put(key, sortProperties.get(key));
        }
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        String sortInfo = this.inSortedOrder ? "" : this.indent + MessageService.getTextMessage("43X40.U", new Object[0]) + ": \n" + PropertyUtil.sortProperties(this.sortProperties, this.subIndent);
        return this.indent + MessageService.getTextMessage("43Y06.U", new Object[0]) + ":\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X21.U", new Object[0]) + " = " + this.rowsInput + "\n" + this.indent + MessageService.getTextMessage("43X81.U", new Object[0]) + " = " + this.rowsReturned + "\n" + this.indent + MessageService.getTextMessage("43Y07.U", new Object[0]) + " = " + this.eliminateDuplicates + "\n" + this.indent + MessageService.getTextMessage("43X43.U", new Object[0]) + " = " + this.inSortedOrder + "\n" + sortInfo + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X05.U", new Object[0]) + ":\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        return this.childResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.childResultSetStatistics);
        return children;
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43Y08.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.childResultSetStatistics != null) {
            ++noChildren;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(visitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "SORT";
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), new Integer(this.numOpens), null, null, null, (UUID)parentID, new Double(this.optimizerEstimatedRowCount), new Double(this.optimizerEstimatedCost), null, null, new Integer(this.rowsInput), new Integer(this.rowsSeen), null, new Integer(this.rowsFiltered), new Integer(this.rowsReturned), null, null, (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }

    @Override
    public Object getSortPropsDescriptor(Object sortPropsID) {
        FormatableProperties props = this.sortProperties;
        XPLAINSortPropsDescriptor sortRSDescriptor = new XPLAINSortPropsDescriptor((UUID)sortPropsID, null, null, null, null, null, XPLAINUtil.getYesNoCharFromBoolean(this.eliminateDuplicates), XPLAINUtil.getYesNoCharFromBoolean(this.inSortedOrder), null);
        return XPLAINUtil.extractSortProps(sortRSDescriptor, props);
    }
}

