/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.index.B2IController;
import org.apache.derby.impl.store.access.btree.index.B2ICostController;
import org.apache.derby.impl.store.access.btree.index.B2IForwardScan;
import org.apache.derby.impl.store.access.btree.index.B2IMaxScan;
import org.apache.derby.impl.store.access.btree.index.B2IRowLocking1;
import org.apache.derby.impl.store.access.btree.index.B2IRowLocking2;
import org.apache.derby.impl.store.access.btree.index.B2IRowLocking3;
import org.apache.derby.impl.store.access.btree.index.B2IRowLockingRR;
import org.apache.derby.impl.store.access.btree.index.B2IStaticCompiledInfo;
import org.apache.derby.impl.store.access.btree.index.B2ITableLocking3;
import org.apache.derby.impl.store.access.btree.index.B2IUndo;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

public class B2I
extends BTree {
    private static final String PROPERTY_BASECONGLOMID = "baseConglomerateId";
    private static final String PROPERTY_ROWLOCCOLUMN = "rowLocationColumn";
    static final int FORMAT_NUMBER = 470;
    long baseConglomerateId;
    int rowLocationColumn;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(B2I.class);

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    @Override
    protected BTreeLockingPolicy getBtreeLockingPolicy(Transaction rawtran, int lock_level, int mode, int isolation_level, ConglomerateController base_cc, OpenBTree open_btree) throws StandardException {
        BTreeLockingPolicy ret_locking_policy = null;
        SanityManager.ASSERT(isolation_level == 5 || isolation_level == 4 || isolation_level == 3 || isolation_level == 2 || isolation_level == 1, "bad isolation_level = " + isolation_level);
        if (lock_level == 7) {
            ret_locking_policy = new B2ITableLocking3(rawtran, lock_level, rawtran.newLockingPolicy(2, isolation_level, true), base_cc, open_btree);
        } else if (lock_level == 6) {
            if (isolation_level == 5) {
                ret_locking_policy = new B2IRowLocking3(rawtran, lock_level, rawtran.newLockingPolicy(1, isolation_level, true), base_cc, open_btree);
            } else if (isolation_level == 4) {
                ret_locking_policy = new B2IRowLockingRR(rawtran, lock_level, rawtran.newLockingPolicy(1, isolation_level, true), base_cc, open_btree);
            } else if (isolation_level == 2 || isolation_level == 3) {
                ret_locking_policy = new B2IRowLocking2(rawtran, lock_level, rawtran.newLockingPolicy(1, isolation_level, true), base_cc, open_btree);
            } else if (isolation_level == 1) {
                ret_locking_policy = new B2IRowLocking1(rawtran, lock_level, rawtran.newLockingPolicy(1, isolation_level, true), base_cc, open_btree);
            }
        }
        SanityManager.ASSERT(ret_locking_policy != null, "ret_locking_policy == null");
        return ret_locking_policy;
    }

    @Override
    public final ConglomerateController lockTable(TransactionManager xact_manager, int open_mode, int lock_level, int isolation_level) throws StandardException {
        ConglomerateController cc = xact_manager.openConglomerate(this.baseConglomerateId, false, open_mode |= 0x40, lock_level, isolation_level);
        return cc;
    }

    private void traverseRight() {
        SanityManager.THROWASSERT("not implemented.");
    }

    public void create(TransactionManager xact_manager, int segmentId, long input_conglomid, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int temporaryFlag) throws StandardException {
        String property_value = null;
        Transaction rawtran = xact_manager.getRawStoreXact();
        if (properties == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_BASECONGLOMID);
        }
        property_value = properties.getProperty(PROPERTY_BASECONGLOMID);
        if (property_value == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_BASECONGLOMID);
        }
        if (property_value == null) {
            SanityManager.THROWASSERT("baseConglomerateIdproperty not passed to B2I.create()");
        }
        this.baseConglomerateId = Long.parseLong(property_value);
        property_value = properties.getProperty(PROPERTY_ROWLOCCOLUMN);
        if (property_value == null) {
            SanityManager.THROWASSERT("rowLocationColumnproperty not passed to B2I.create()");
        }
        if (property_value == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_BASECONGLOMID);
        }
        this.rowLocationColumn = Integer.parseInt(property_value);
        SanityManager.ASSERT(this.rowLocationColumn == template.length - 1, "rowLocationColumn is not the last column in the index");
        SanityManager.ASSERT(template[this.rowLocationColumn] instanceof RowLocation);
        if (this.rowLocationColumn < 1) {
            SanityManager.THROWASSERT("rowLocationColumn (" + this.rowLocationColumn + ") expected to be >= 1");
        }
        this.ascDescInfo = new boolean[template.length];
        for (int i = 0; i < this.ascDescInfo.length; ++i) {
            this.ascDescInfo[i] = columnOrder != null && i < columnOrder.length ? columnOrder[i].getIsAscending() : true;
        }
        this.collation_ids = ConglomerateUtil.createCollationIds(template.length, collationIds);
        this.hasCollatedTypes = B2I.hasCollatedColumns(this.collation_ids);
        super.create(rawtran, segmentId, input_conglomid, template, properties, this.getTypeFormatId(), temporaryFlag);
        ConglomerateController base_cc = xact_manager.openConglomerate(this.baseConglomerateId, false, 64, 7, 5);
        OpenBTree open_btree = new OpenBTree();
        B2ITableLocking3 b2i_locking_policy = new B2ITableLocking3(rawtran, 7, rawtran.newLockingPolicy(2, 5, true), base_cc, open_btree);
        open_btree.init(xact_manager, xact_manager, null, rawtran, false, 4, 7, b2i_locking_policy, this, null, null);
        LeafControlRow.initEmptyBtree(open_btree);
        open_btree.close();
        base_cc.close();
    }

    @Override
    public boolean fetchMaxOnBTree(TransactionManager xact_manager, Transaction rawtran, long conglomId, int open_mode, int lock_level, LockingPolicy locking_policy, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] fetchRow) throws StandardException {
        B2IMaxScan b2is = new B2IMaxScan();
        b2is.init(xact_manager, rawtran, open_mode, lock_level, locking_policy, isolation_level, true, scanColumnList, this, new B2IUndo());
        boolean row_exists = b2is.fetchMax(fetchRow);
        b2is.close();
        return row_exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long load(TransactionManager xact_manager, boolean createConglom, RowLocationRetRowSource rowSource) throws StandardException {
        long num_rows_loaded = 0L;
        B2IController b2ic = new B2IController();
        try {
            int open_mode = 4;
            if (createConglom) {
                open_mode |= 3;
            }
            b2ic.init(xact_manager, xact_manager.getRawStoreXact(), false, open_mode, 7, xact_manager.getRawStoreXact().newLockingPolicy(2, 5, true), true, this, new B2IUndo(), (B2IStaticCompiledInfo)null, (DynamicCompiledOpenConglomInfo)null);
            num_rows_loaded = b2ic.load(xact_manager, createConglom, rowSource);
        }
        finally {
            b2ic.close();
        }
        return num_rows_loaded;
    }

    @Override
    public ConglomerateController open(TransactionManager xact_manager, Transaction rawtran, boolean hold, int open_mode, int lock_level, LockingPolicy locking_policy, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        B2IController b2ic = new B2IController();
        b2ic.init(xact_manager, rawtran, hold, open_mode, lock_level, locking_policy, true, this, new B2IUndo(), (B2IStaticCompiledInfo)static_info, dynamic_info);
        return b2ic;
    }

    @Override
    public ScanManager openScan(TransactionManager xact_manager, Transaction rawtran, boolean hold, int open_mode, int lock_level, LockingPolicy locking_policy, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        B2IForwardScan b2is = new B2IForwardScan();
        b2is.init(xact_manager, rawtran, hold, open_mode, lock_level, locking_policy, isolation_level, true, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, this, new B2IUndo(), (B2IStaticCompiledInfo)static_info, dynamic_info);
        return b2is;
    }

    @Override
    public ScanManager defragmentConglomerate(TransactionManager xact_manager, Transaction rawtran, boolean hold, int open_mode, int lock_level, LockingPolicy locking_policy, int isolation_level) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public void purgeConglomerate(TransactionManager xact_manager, Transaction rawtran) throws StandardException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compressConglomerate(TransactionManager xact_manager, Transaction rawtran) throws StandardException {
        B2IController b2ic = new B2IController();
        try {
            int open_mode = 4;
            b2ic.init(xact_manager, xact_manager.getRawStoreXact(), false, open_mode, 7, xact_manager.getRawStoreXact().newLockingPolicy(2, 5, true), true, this, new B2IUndo(), (B2IStaticCompiledInfo)null, (DynamicCompiledOpenConglomInfo)null);
            b2ic.getContainer().compressContainer();
        }
        finally {
            b2ic.close();
        }
    }

    @Override
    public StoreCostController openStoreCost(TransactionManager xact_manager, Transaction rawtran) throws StandardException {
        B2ICostController b2icost = new B2ICostController();
        b2icost.init(xact_manager, this, rawtran);
        return b2icost;
    }

    @Override
    public void drop(TransactionManager xact_manager) throws StandardException {
        ConglomerateController base_cc = null;
        base_cc = this.lockTable(xact_manager, 4, 7, 4);
        xact_manager.getRawStoreXact().dropContainer(this.id);
        if (base_cc != null) {
            base_cc.close();
        }
    }

    @Override
    public StaticCompiledOpenConglomInfo getStaticCompiledConglomInfo(TransactionController xact_manager, long conglomId) throws StandardException {
        return new B2IStaticCompiledInfo(xact_manager, this);
    }

    @Override
    public int getTypeFormatId() {
        return 470;
    }

    public void writeExternal_v10_2(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.baseConglomerateId);
        out.writeInt(this.rowLocationColumn);
        FormatableBitSet ascDescBits = new FormatableBitSet(this.ascDescInfo.length);
        for (int i = 0; i < this.ascDescInfo.length; ++i) {
            if (!this.ascDescInfo[i]) continue;
            ascDescBits.set(i);
        }
        ascDescBits.writeExternal(out);
    }

    public void writeExternal_v10_3(ObjectOutput out) throws IOException {
        this.writeExternal_v10_2(out);
        if (this.conglom_format_id == 466 || this.conglom_format_id == 470) {
            ConglomerateUtil.writeCollationIdArray(this.collation_ids, out);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal_v10_3(out);
        if (this.conglom_format_id == 470) {
            out.writeBoolean(this.isUniqueWithDuplicateNulls());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        super.readExternal(in);
        this.baseConglomerateId = in.readLong();
        this.rowLocationColumn = in.readInt();
        FormatableBitSet ascDescBits = new FormatableBitSet();
        ascDescBits.readExternal(in);
        this.ascDescInfo = new boolean[ascDescBits.getLength()];
        for (i = 0; i < ascDescBits.getLength(); ++i) {
            this.ascDescInfo[i] = ascDescBits.isSet(i);
        }
        this.collation_ids = new int[this.format_ids.length];
        SanityManager.ASSERT(!this.hasCollatedTypes);
        for (i = 0; i < this.format_ids.length; ++i) {
            this.collation_ids[i] = 0;
        }
        this.setUniqueWithDuplicateNulls(false);
        if (this.conglom_format_id == 466 || this.conglom_format_id == 470) {
            SanityManager.ASSERT(this.collation_ids.length >= 2, "length = " + this.collation_ids.length);
            this.hasCollatedTypes = ConglomerateUtil.readCollationIdArray(this.collation_ids, in);
        } else if (this.conglom_format_id != 388) {
            SanityManager.THROWASSERT("Unexpected format id: " + this.conglom_format_id);
        }
        if (this.conglom_format_id == 470) {
            this.setUniqueWithDuplicateNulls(in.readBoolean());
        }
    }
}

