/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.log.Logger;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.raw.log.StreamLogScan;
import org.apache.derby.shared.common.sanity.SanityManager;

public class FileLogger
implements Logger {
    private LogRecord logRecord;
    protected byte[] encryptionBuffer;
    private DynamicByteArrayOutputStream logOutputBuffer;
    private FormatIdOutputStream logicalOut;
    private ArrayInputStream logIn;
    private LogToFile logFactory;

    public FileLogger(LogToFile logFactory) {
        this.logFactory = logFactory;
        this.logOutputBuffer = new DynamicByteArrayOutputStream(1024);
        this.logicalOut = new FormatIdOutputStream(this.logOutputBuffer);
        this.logIn = new ArrayInputStream();
        this.logRecord = new LogRecord();
    }

    public void close() throws IOException {
        if (this.logOutputBuffer != null) {
            this.logOutputBuffer.close();
            this.logOutputBuffer = null;
        }
        this.logIn = null;
        this.logFactory = null;
        this.logicalOut = null;
        this.logRecord = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LogInstant logAndDo(RawTransaction xact, Loggable operation) throws StandardException {
        boolean isLogPrepared = false;
        boolean inUserCode = false;
        try {
            LogCounter logInstant;
            int completeLength;
            TransactionId transactionId;
            block21: {
                byte[] preparedLog;
                this.logOutputBuffer.reset();
                transactionId = xact.getId();
                this.logRecord.setValue(transactionId, operation);
                inUserCode = true;
                this.logicalOut.writeObject(this.logRecord);
                inUserCode = false;
                int optionalDataLength = 0;
                int optionalDataOffset = 0;
                completeLength = 0;
                ByteArray preparedLogArray = operation.getPreparedLog();
                if (preparedLogArray != null) {
                    preparedLog = preparedLogArray.getArray();
                    optionalDataLength = preparedLogArray.getLength();
                    optionalDataOffset = preparedLogArray.getOffset();
                    this.logIn.setData(preparedLog);
                    this.logIn.setPosition(optionalDataOffset);
                    this.logIn.setLimit(optionalDataLength);
                    if (optionalDataLength != this.logIn.available()) {
                        SanityManager.THROWASSERT(" stream not set correctly " + optionalDataLength + " != " + this.logIn.available());
                    }
                } else {
                    preparedLog = null;
                    optionalDataLength = 0;
                }
                this.logicalOut.writeInt(optionalDataLength);
                completeLength = this.logOutputBuffer.getPosition() + optionalDataLength;
                logInstant = null;
                int encryptedLength = 0;
                try {
                    if (this.logFactory.databaseEncrypted()) {
                        int len;
                        encryptedLength = completeLength;
                        if (encryptedLength % this.logFactory.getEncryptionBlockSize() != 0) {
                            encryptedLength = encryptedLength + this.logFactory.getEncryptionBlockSize() - encryptedLength % this.logFactory.getEncryptionBlockSize();
                        }
                        if (this.encryptionBuffer == null || this.encryptionBuffer.length < encryptedLength) {
                            this.encryptionBuffer = new byte[encryptedLength];
                        }
                        System.arraycopy(this.logOutputBuffer.getByteArray(), 0, this.encryptionBuffer, 0, completeLength - optionalDataLength);
                        if (optionalDataLength > 0) {
                            System.arraycopy(preparedLog, optionalDataOffset, this.encryptionBuffer, completeLength - optionalDataLength, optionalDataLength);
                        }
                        SanityManager.ASSERT((len = this.logFactory.encrypt(this.encryptionBuffer, 0, encryptedLength, this.encryptionBuffer, 0)) == encryptedLength, "encrypted log buffer length != log buffer len");
                    }
                    if ((operation.group() & 3) != 0) {
                        LogToFile len = this.logFactory;
                        synchronized (len) {
                            long instant = 0L;
                            instant = this.logFactory.databaseEncrypted() ? this.logFactory.appendLogRecord(this.encryptionBuffer, 0, encryptedLength, null, -1, 0) : this.logFactory.appendLogRecord(this.logOutputBuffer.getByteArray(), 0, completeLength, preparedLog, optionalDataOffset, optionalDataLength);
                            logInstant = new LogCounter(instant);
                            operation.doMe(xact, logInstant, this.logIn);
                            break block21;
                        }
                    }
                    long instant = 0L;
                    instant = this.logFactory.databaseEncrypted() ? this.logFactory.appendLogRecord(this.encryptionBuffer, 0, encryptedLength, null, -1, 0) : this.logFactory.appendLogRecord(this.logOutputBuffer.getByteArray(), 0, completeLength, preparedLog, optionalDataOffset, optionalDataLength);
                    logInstant = new LogCounter(instant);
                    operation.doMe(xact, logInstant, this.logIn);
                }
                catch (StandardException se) {
                    throw this.logFactory.markCorrupt(StandardException.newException("XSLA1.D", se, operation));
                }
                catch (IOException ioe) {
                    throw this.logFactory.markCorrupt(StandardException.newException("XSLA1.D", ioe, operation));
                }
                finally {
                    this.logIn.clearLimit();
                }
            }
            if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                SanityManager.DEBUG(LogToFile.DBG_FLAG, "Write log record: tranId=" + transactionId.toString() + " instant: " + ((Object)logInstant).toString() + " length: " + completeLength + "\n" + operation + "\n");
            }
            return logInstant;
        }
        catch (IOException ioe) {
            if (inUserCode) {
                throw StandardException.newException("XSLB1.S", ioe, operation);
            }
            throw StandardException.newException("XSLB2.S", ioe, operation);
        }
    }

    @Override
    public LogInstant logAndUndo(RawTransaction xact, Compensation compensation, LogInstant undoInstant, LimitObjectInput in) throws StandardException {
        boolean inUserCode = false;
        try {
            this.logOutputBuffer.reset();
            TransactionId transactionId = xact.getId();
            this.logRecord.setValue(transactionId, compensation);
            inUserCode = true;
            this.logicalOut.writeObject(this.logRecord);
            inUserCode = false;
            this.logicalOut.writeLong(((LogCounter)undoInstant).getValueAsLong());
            int completeLength = this.logOutputBuffer.getPosition();
            long instant = 0L;
            if (this.logFactory.databaseEncrypted()) {
                int encryptedLength = completeLength;
                if (encryptedLength % this.logFactory.getEncryptionBlockSize() != 0) {
                    encryptedLength = encryptedLength + this.logFactory.getEncryptionBlockSize() - encryptedLength % this.logFactory.getEncryptionBlockSize();
                }
                if (this.encryptionBuffer == null || this.encryptionBuffer.length < encryptedLength) {
                    this.encryptionBuffer = new byte[encryptedLength];
                }
                System.arraycopy(this.logOutputBuffer.getByteArray(), 0, this.encryptionBuffer, 0, completeLength);
                int len = this.logFactory.encrypt(this.encryptionBuffer, 0, encryptedLength, this.encryptionBuffer, 0);
                SanityManager.ASSERT(len == encryptedLength, "encrypted log buffer length != log buffer len");
                instant = this.logFactory.appendLogRecord(this.encryptionBuffer, 0, encryptedLength, null, 0, 0);
            } else {
                instant = this.logFactory.appendLogRecord(this.logOutputBuffer.getByteArray(), 0, completeLength, null, 0, 0);
            }
            LogCounter logInstant = new LogCounter(instant);
            if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                SanityManager.DEBUG(LogToFile.DBG_FLAG, "Write CLR: Xact: " + transactionId.toString() + "clrinstant: " + ((Object)logInstant).toString() + " undoinstant " + undoInstant + "\n");
            }
            try {
                compensation.doMe(xact, logInstant, in);
            }
            catch (StandardException se) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA1.D", se, compensation));
            }
            catch (IOException ioe) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA1.D", ioe, compensation));
            }
            return logInstant;
        }
        catch (IOException ioe) {
            if (inUserCode) {
                throw StandardException.newException("XSLB1.S", ioe, compensation);
            }
            throw StandardException.newException("XSLB2.S", ioe, compensation);
        }
    }

    @Override
    public void flush(LogInstant where) throws StandardException {
        if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
            SanityManager.DEBUG(LogToFile.DBG_FLAG, "Flush log to " + where.toString());
        }
        this.logFactory.flush(where);
    }

    @Override
    public void flushAll() throws StandardException {
        this.logFactory.flushAll();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void reprepare(RawTransaction t, TransactionId prepareId, LogInstant prepareStopAt, LogInstant prepareStartAt) throws StandardException {
        block21: {
            if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                if (prepareStartAt != null) {
                    SanityManager.DEBUG(LogToFile.DBG_FLAG, "----------------------------------------------------\n\nBegin of RePrepare : " + prepareId.toString() + "start at " + prepareStartAt.toString() + " stop at " + prepareStopAt.toString() + "\n----------------------------------------------------\n");
                } else {
                    SanityManager.DEBUG(LogToFile.DBG_FLAG, "----------------------------------------------------\n\nBegin of Reprepare: " + prepareId.toString() + "start at end of log stop at " + prepareStopAt.toString() + "\n----------------------------------------------------\n");
                }
            }
            clrskipped = 0;
            logrecordseen = 0;
            lop = null;
            rawInput = null;
            try {
                block22: {
                    if (prepareStartAt != null) break block22;
                    scanLog = (StreamLogScan)this.logFactory.openBackwardsScan(prepareStopAt);
                    ** GOTO lbl39
                }
                if (prepareStartAt.lessThan(prepareStopAt)) {
                    if (rawInput == null) return;
                }
                ** GOTO lbl-1000
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", cnfe, new Object[0]));
                    catch (IOException ioe) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", ioe, new Object[0]));
                    }
                    catch (StandardException se) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA8.D", se, new Object[]{prepareId, lop, null}));
                    }
                }
                catch (Throwable var13_17) {
                    if (rawInput == null) throw var13_17;
                    try {
                        rawInput.close();
                        throw var13_17;
                    }
                    catch (IOException ioe) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", ioe, new Object[]{prepareId}));
                    }
                }
            }
            try {
                rawInput.close();
                return;
            }
            catch (IOException ioe) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", ioe, new Object[]{prepareId}));
            }
lbl-1000:
            // 1 sources

            {
                scanLog = (StreamLogScan)this.logFactory.openBackwardsScan(((LogCounter)prepareStartAt).getValueAsLong(), prepareStopAt);
lbl39:
                // 2 sources

                SanityManager.ASSERT(scanLog != null, "cannot open log for prepare");
                rawInput = new ArrayInputStream(new byte[4096]);
                while ((record = scanLog.getNextRecord((ArrayInputStream)rawInput, prepareId, 0)) != null) {
                    SanityManager.ASSERT(record.getTransactionId().equals(prepareId), "getNextRecord return unqualified log rec for prepare");
                    ++logrecordseen;
                    if (record.isCLR()) {
                        ++clrskipped;
                        record.skipLoggable();
                        prepareInstant = rawInput.readLong();
                        if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                            SanityManager.DEBUG(LogToFile.DBG_FLAG, "Skipping over CLRs, reset scan to " + LogCounter.toDebugString(prepareInstant));
                        }
                        scanLog.resetPosition(new LogCounter(prepareInstant));
                        continue;
                    }
                    if (!record.requiresPrepareLocks() || (lop = record.getRePreparable()) == null) continue;
                    lop.reclaimPrepareLocks(t, t.newLockingPolicy(1, 4, true));
                    if (!SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) continue;
                    SanityManager.DEBUG(LogToFile.DBG_FLAG, "Reprepare log record at instant " + scanLog.getInstant() + " : " + lop);
                }
                if (rawInput == null) break block21;
            }
            try {
                rawInput.close();
            }
            catch (IOException ioe) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", ioe, new Object[]{prepareId}));
            }
        }
        if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
            SanityManager.DEBUG(LogToFile.DBG_FLAG, "Finish prepare, clr skipped = " + clrskipped + ", record seen = " + logrecordseen + "\n");
        }
        if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG) == false) return;
        SanityManager.DEBUG(LogToFile.DBG_FLAG, "----------------------------------------------------\nEnd of recovery rePrepare\n, clr skipped = " + clrskipped + ", record seen = " + logrecordseen + "\n----------------------------------------------------\n");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void undo(RawTransaction t, TransactionId undoId, LogInstant undoStopAt, LogInstant undoStartAt) throws StandardException {
        block24: {
            block23: {
                if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                    if (undoStartAt != null) {
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "\nUndo transaction: " + undoId.toString() + "start at " + undoStartAt.toString() + " stop at " + undoStopAt.toString());
                    } else {
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "\nUndo transaction: " + undoId.toString() + "start at end of log stop at " + undoStopAt.toString());
                    }
                }
                clrgenerated = 0;
                clrskipped = 0;
                logrecordseen = 0;
                compensation = null;
                lop = null;
                rawInput = null;
                try {
                    block25: {
                        if (undoStartAt != null) break block25;
                        scanLog = (StreamLogScan)this.logFactory.openBackwardsScan(undoStopAt);
                        ** GOTO lbl47
                    }
                    if (undoStartAt.lessThan(undoStopAt)) {
                        if (compensation == null) break block23;
                    }
                    ** GOTO lbl-1000
                }
                catch (ClassNotFoundException cnfe) {
                    try {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", cnfe, new Object[0]));
                        catch (IOException ioe) {
                            throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", ioe, new Object[0]));
                        }
                        catch (StandardException se) {
                            throw this.logFactory.markCorrupt(StandardException.newException("XSLA8.D", se, new Object[]{undoId, lop, compensation}));
                        }
                    }
                    catch (Throwable var15_22) {
                        if (compensation != null) {
                            compensation.releaseResource(t);
                        }
                        if (rawInput == null) throw var15_22;
                        try {
                            rawInput.close();
                            throw var15_22;
                        }
                        catch (IOException ioe) {
                            throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", ioe, new Object[]{undoId}));
                        }
                    }
                }
                compensation.releaseResource(t);
            }
            if (rawInput == null) return;
            try {
                rawInput.close();
                return;
            }
            catch (IOException ioe) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", ioe, new Object[]{undoId}));
            }
lbl-1000:
            // 1 sources

            {
                undoStartInstant = ((LogCounter)undoStartAt).getValueAsLong();
                scanLog = (StreamLogScan)this.logFactory.openBackwardsScan(undoStartInstant, undoStopAt);
lbl47:
                // 2 sources

                SanityManager.ASSERT(scanLog != null, "cannot open log for undo");
                rawInput = new ArrayInputStream(new byte[4096]);
                while ((record = scanLog.getNextRecord((ArrayInputStream)rawInput, undoId, 0)) != null) {
                    SanityManager.ASSERT(record.getTransactionId().equals(undoId), "getNextRecord return unqualified log record for undo");
                    ++logrecordseen;
                    if (record.isCLR()) {
                        ++clrskipped;
                        record.skipLoggable();
                        undoInstant = rawInput.readLong();
                        if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                            SanityManager.DEBUG(LogToFile.DBG_FLAG, "Skipping over CLRs, reset scan to " + LogCounter.toDebugString(undoInstant));
                        }
                        scanLog.resetPosition(new LogCounter(undoInstant));
                        continue;
                    }
                    lop = record.getUndoable();
                    if (lop == null) continue;
                    optionalDataLength = rawInput.readInt();
                    savePosition = rawInput.getPosition();
                    rawInput.setLimit(optionalDataLength);
                    compensation = lop.generateUndo(t, (LimitObjectInput)rawInput);
                    if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "Rollback log record at instant " + LogCounter.toDebugString(scanLog.getInstant()) + " : " + lop);
                    }
                    ++clrgenerated;
                    if (compensation == null) continue;
                    rawInput.setLimit(savePosition, optionalDataLength);
                    t.logAndUndo((Compensation)compensation, new LogCounter(scanLog.getInstant()), (LimitObjectInput)rawInput);
                    compensation.releaseResource(t);
                    compensation = null;
                }
                if (compensation == null) break block24;
            }
            compensation.releaseResource(t);
        }
        if (rawInput != null) {
            try {
                rawInput.close();
            }
            catch (IOException ioe) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", ioe, new Object[]{undoId}));
            }
        }
        if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG) == false) return;
        SanityManager.DEBUG(LogToFile.DBG_FLAG, "Finish undo, clr generated = " + clrgenerated + ", clr skipped = " + clrskipped + ", record seen = " + logrecordseen + "\n");
    }

    protected long redo(RawTransaction recoveryTransaction, TransactionFactory transFactory, StreamLogScan redoScan, long redoLWM, long ttabInstant) throws IOException, StandardException, ClassNotFoundException {
        if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
            SanityManager.DEBUG(LogToFile.DBG_FLAG, "In recovery redo, redoLWM = " + redoLWM);
        }
        int scanCount = 0;
        int redoCount = 0;
        int prepareCount = 0;
        int clrCount = 0;
        int btranCount = 0;
        int etranCount = 0;
        TransactionId tranId = null;
        long instant = 0L;
        this.logIn.setData(this.logOutputBuffer.getByteArray());
        StreamLogScan undoScan = null;
        Loggable op = null;
        long logEnd = 0L;
        try {
            LogRecord record;
            while ((record = redoScan.getNextRecord(this.logIn, null, 0)) != null) {
                ++scanCount;
                long undoInstant = 0L;
                instant = redoScan.getInstant();
                logEnd = redoScan.getLogRecordEnd();
                if (SanityManager.DEBUG_ON(LogToFile.DUMP_LOG_ONLY) || SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                    if (SanityManager.DEBUG_ON(LogToFile.DUMP_LOG_ONLY)) {
                        SanityManager.DEBUG_SET(LogToFile.DBG_FLAG);
                    }
                    op = record.getLoggable();
                    tranId = record.getTransactionId();
                    if (record.isCLR()) {
                        undoInstant = this.logIn.readLong();
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "scanned " + tranId + " : " + op + " instant = " + LogCounter.toDebugString(instant) + " undoInstant : " + LogCounter.toDebugString(undoInstant));
                    } else {
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "scanned " + tranId + " : " + op + " instant = " + LogCounter.toDebugString(instant) + " logEnd = " + LogCounter.toDebugString(logEnd) + " logIn at " + this.logIn.getPosition() + " available " + this.logIn.available());
                    }
                    if (SanityManager.DEBUG_ON(LogToFile.DUMP_LOG_ONLY)) continue;
                }
                if (redoLWM != 0L && instant < redoLWM && !record.isFirst() && !record.isComplete() && !record.isPrepare()) continue;
                tranId = record.getTransactionId();
                if (!transFactory.findTransaction(tranId, recoveryTransaction)) {
                    if (redoLWM != 0L && instant < redoLWM && (record.isPrepare() || record.isComplete())) {
                        ++etranCount;
                        continue;
                    }
                    if (ttabInstant == 0L && !record.isFirst()) {
                        throw StandardException.newException("XSLAO.D", MessageService.getTextMessage("L012", tranId));
                    }
                    if (ttabInstant != 0L && instant > ttabInstant && !record.isFirst()) {
                        SanityManager.THROWASSERT("log record is Not first but transaction is not in transaction table (2) : " + tranId);
                    }
                    ++btranCount;
                    recoveryTransaction.setTransactionId(record.getLoggable(), tranId);
                } else {
                    if (ttabInstant == 0L && record.isFirst()) {
                        throw StandardException.newException("XSLAO.D", MessageService.getTextMessage("L013", tranId));
                    }
                    if (ttabInstant != 0L && instant > ttabInstant && record.isFirst()) {
                        SanityManager.THROWASSERT("log record is first but transaction is already in transaction table (3): " + tranId);
                    }
                    if (record.isPrepare()) {
                        ++prepareCount;
                    }
                    if (record.isFirst()) {
                        ++btranCount;
                        continue;
                    }
                }
                op = record.getLoggable();
                if (!record.isCLR() && this.logIn.available() < 4) {
                    SanityManager.THROWASSERT("not enough bytes read in : " + this.logIn.available() + " for " + op + " instant " + LogCounter.toDebugString(instant));
                }
                SanityManager.ASSERT(!recoveryTransaction.handlesPostTerminationWork(), "recovery transaction handles post termination work");
                if (op.needsRedo(recoveryTransaction)) {
                    ++redoCount;
                    if (record.isCLR()) {
                        ++clrCount;
                        SanityManager.ASSERT(op instanceof Compensation);
                        if (undoInstant == 0L) {
                            undoInstant = this.logIn.readLong();
                        }
                        if (undoScan == null) {
                            undoScan = (StreamLogScan)this.logFactory.openForwardsScan(undoInstant, (LogInstant)null);
                        } else {
                            undoScan.resetPosition(new LogCounter(undoInstant));
                        }
                        this.logIn.clearLimit();
                        LogRecord undoRecord = undoScan.getNextRecord(this.logIn, null, 0);
                        Undoable undoOp = undoRecord.getUndoable();
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "Redoing CLR: undoInstant = " + LogCounter.toDebugString(undoInstant) + " clrinstant = " + LogCounter.toDebugString(instant));
                        SanityManager.ASSERT(undoRecord.getTransactionId().equals(tranId));
                        SanityManager.ASSERT(undoOp != null);
                        ((Compensation)op).setUndoOp(undoOp);
                    }
                    if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
                        SanityManager.DEBUG(LogToFile.DBG_FLAG, "redoing " + op + " instant = " + LogCounter.toDebugString(instant));
                    }
                    int dataLength = this.logIn.readInt();
                    this.logIn.setLimit(dataLength);
                    op.doMe(recoveryTransaction, new LogCounter(instant), this.logIn);
                    op.releaseResource(recoveryTransaction);
                    op = null;
                }
                if (!record.isComplete()) continue;
                ++etranCount;
                SanityManager.ASSERT(!recoveryTransaction.handlesPostTerminationWork(), "recovery xact handles post termination work");
                recoveryTransaction.commit();
            }
            long end = redoScan.getLogRecordEnd();
            if (end != 0L && LogCounter.getLogFileNumber(logEnd) < LogCounter.getLogFileNumber(end)) {
                logEnd = end;
            }
        }
        catch (StandardException se) {
            throw StandardException.newException("XSLA7.D", se, op);
        }
        finally {
            redoScan.close();
            redoScan = null;
            if (undoScan != null) {
                undoScan.close();
                undoScan = null;
            }
            if (op != null) {
                op.releaseResource(recoveryTransaction);
            }
        }
        if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
            SanityManager.DEBUG(LogToFile.DBG_FLAG, "----------------------------------------------------\nEnd of recovery redo\nScanned = " + scanCount + " log records" + ", redid = " + redoCount + " ( clr = " + clrCount + " )" + " begintran = " + btranCount + " endtran = " + etranCount + " preparetran = " + prepareCount + "\n log ends at " + LogCounter.toDebugString(logEnd) + "\n----------------------------------------------------\n");
        }
        if (instant != 0L) {
            SanityManager.ASSERT(LogCounter.getLogFileNumber(instant) < LogCounter.getLogFileNumber(logEnd) || LogCounter.getLogFileNumber(instant) == LogCounter.getLogFileNumber(logEnd) && LogCounter.getLogFilePosition(instant) <= LogCounter.getLogFilePosition(logEnd));
        } else {
            SanityManager.ASSERT(logEnd == 0L);
        }
        return logEnd;
    }

    protected Loggable readLogRecord(StreamLogScan scan, int size) throws IOException, StandardException, ClassNotFoundException {
        Loggable lop = null;
        ArrayInputStream logInputBuffer = new ArrayInputStream(new byte[size]);
        LogRecord record = scan.getNextRecord(logInputBuffer, null, 0);
        if (record != null) {
            lop = record.getLoggable();
        }
        return lop;
    }
}

