/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;

public final class SystemPermission
extends BasicPermission {
    private static final long serialVersionUID = 1965420504091489898L;
    public static final String SERVER = "server";
    public static final String ENGINE = "engine";
    public static final String JMX = "jmx";
    public static final String SHUTDOWN = "shutdown";
    public static final String CONTROL = "control";
    public static final String MONITOR = "monitor";
    private static final Set<String> LEGAL_NAMES = new HashSet<String>();
    private static final List<String> LEGAL_ACTIONS;
    private String actions;

    public SystemPermission(String name, String actions) {
        super(name);
        this.validateNameAndActions(name, actions);
    }

    private void validateNameAndActions(String name, String actions) {
        if (!LEGAL_NAMES.contains(name)) {
            throw new IllegalArgumentException("Unknown permission " + name);
        }
        this.actions = SystemPermission.getCanonicalForm(actions);
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    private static String getCanonicalForm(String actions) {
        Set<String> actionSet = SystemPermission.parseActions(actions);
        ArrayList<String> legalActions = new ArrayList<String>(LEGAL_ACTIONS);
        legalActions.retainAll(actionSet);
        return SystemPermission.buildActionsString(legalActions);
    }

    static Set<String> parseActions(String actions) {
        HashSet<String> actionSet = new HashSet<String>();
        for (String s : actions.split(",", -1)) {
            actionSet.add(s.trim().toLowerCase(Locale.ENGLISH));
        }
        return actionSet;
    }

    static String buildActionsString(Iterable<String> actions) {
        StringBuilder sb = new StringBuilder();
        for (String action : actions) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(action);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        SystemPermission osp = (SystemPermission)other;
        return this.getActions().equals(osp.getActions());
    }

    @Override
    public boolean implies(Permission permission) {
        int permissionMask;
        if (!super.implies(permission)) {
            return false;
        }
        int myActionMask = SystemPermission.getActionMask(this.getActions());
        return (myActionMask & (permissionMask = SystemPermission.getActionMask(permission.getActions()))) == permissionMask;
    }

    private static int getActionMask(String actions) {
        int mask = 0;
        StringTokenizer st = new StringTokenizer(actions, ",");
        while (st.hasMoreTokens()) {
            int validAction = LEGAL_ACTIONS.indexOf(st.nextElement());
            if (validAction == -1) continue;
            mask |= 1 << validAction;
        }
        return mask;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.validateNameAndActions(this.getName(), this.getActions());
    }

    static {
        LEGAL_NAMES.add(SERVER);
        LEGAL_NAMES.add(ENGINE);
        LEGAL_NAMES.add(JMX);
        LEGAL_ACTIONS = new ArrayList<String>();
        LEGAL_ACTIONS.add(CONTROL);
        LEGAL_ACTIONS.add(MONITOR);
        LEGAL_ACTIONS.add(SHUTDOWN);
    }
}

