/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.vti;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.derby.vti.StringColumnVTI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlVTI
extends StringColumnVTI {
    private String _rowTag;
    private InputStream _xmlResource;
    private int _rowIdx = -1;
    private int _rowCount = -1;
    private String[] _currentRow;
    private DocumentBuilder _builder;
    private NodeList _rawRows;
    private int _firstChildTagIdx;

    public XmlVTI(InputStream xmlResource, String rowTag, int firstChildTagIdx, String ... columnTags) {
        super(columnTags);
        this._xmlResource = xmlResource;
        this._rowTag = rowTag;
        this._firstChildTagIdx = firstChildTagIdx;
    }

    public static XmlVTI xmlVTI(String fileName, String rowTag, String ... childTags) throws Exception {
        return XmlVTI.xmlVTI(fileName, rowTag, null, XmlVTI.asList(childTags));
    }

    public static XmlVTI xmlVTIFromURL(String urlString, String rowTag, String ... childTags) throws Exception {
        return XmlVTI.xmlVTIFromURL(urlString, rowTag, null, XmlVTI.asList(childTags));
    }

    public static XmlVTI xmlVTI(final String fileName, String rowTag, ArrayList<String> parentTags, ArrayList<String> childTags) throws Exception {
        FileInputStream fis = AccessController.doPrivileged(new PrivilegedAction<FileInputStream>(){

            @Override
            public FileInputStream run() {
                try {
                    return new FileInputStream(new File(fileName));
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException(ioe.getMessage(), ioe);
                }
            }
        });
        return XmlVTI.xmlVTI(fis, rowTag, parentTags, childTags);
    }

    public static XmlVTI xmlVTIFromURL(final String urlString, String rowTag, ArrayList<String> parentTags, ArrayList<String> childTags) throws Exception {
        InputStream is = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                try {
                    return new URL(urlString).openStream();
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException(ioe.getMessage(), ioe);
                }
            }
        });
        return XmlVTI.xmlVTI(is, rowTag, parentTags, childTags);
    }

    private static XmlVTI xmlVTI(InputStream xmlResource, String rowTag, ArrayList<String> parentTags, ArrayList<String> childTags) throws Exception {
        if (parentTags == null) {
            parentTags = new ArrayList();
        }
        if (childTags == null) {
            childTags = new ArrayList();
        }
        String[] allTags = new String[parentTags.size() + childTags.size()];
        int idx = 0;
        for (String tag : parentTags) {
            allTags[idx++] = tag;
        }
        for (String tag : childTags) {
            allTags[idx++] = tag;
        }
        return new XmlVTI(xmlResource, rowTag, parentTags.size(), allTags);
    }

    public static ArrayList<String> asList(String ... cells) {
        ArrayList<String> retval = new ArrayList<String>();
        for (String cell : cells) {
            retval.add(cell);
        }
        return retval;
    }

    @Override
    protected String getRawColumn(int columnNumber) throws SQLException {
        try {
            return this._currentRow[columnNumber - 1];
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    @Override
    public void close() throws SQLException {
        this._builder = null;
        this._rawRows = null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (this._rowIdx < 0) {
                this.readRows();
            }
            if (++this._rowIdx < this._rowCount) {
                this.parseRow(this._rowIdx);
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            throw new SQLException(t.getMessage());
        }
    }

    private void readRows() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this._builder = factory.newDocumentBuilder();
        Document doc = this._builder.parse(this._xmlResource);
        Element root = doc.getDocumentElement();
        this._rawRows = root.getElementsByTagName(this._rowTag);
        this._rowCount = this._rawRows.getLength();
        this._xmlResource.close();
    }

    private void parseRow(int rowNumber) throws Exception {
        Element rawRow = (Element)this._rawRows.item(rowNumber);
        int columnCount = this.getColumnCount();
        this._currentRow = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            this._currentRow[i] = this.findColumnValue(rawRow, i);
        }
    }

    private String findColumnValue(Element rawRow, int columnNumber) throws Exception {
        NodeList children;
        String columnName;
        String contents;
        boolean inParent;
        boolean bl = inParent = columnNumber < this._firstChildTagIdx;
        if (inParent) {
            Node parent = rawRow.getParentNode();
            if (parent == null || !(parent instanceof Element)) {
                return null;
            }
            rawRow = (Element)parent;
        }
        if ("".equals(contents = rawRow.getAttribute(columnName = this.getColumnName(columnNumber + 1)))) {
            contents = null;
        }
        if (contents == null && (children = rawRow.getElementsByTagName(columnName)) != null && children.getLength() > 0) {
            int childCount = children.getLength();
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < childCount; ++j) {
                Element child = (Element)children.item(j);
                if (j != 0) {
                    buffer.append(" ");
                }
                buffer.append(this.squeezeText(child));
            }
            contents = buffer.toString();
        }
        if (inParent && contents == null) {
            return this.findColumnValue(rawRow, columnNumber);
        }
        return contents;
    }

    private String squeezeText(Element node) throws Exception {
        String text = null;
        Node textChild = node.getFirstChild();
        if (textChild != null) {
            text = textChild.getNodeValue();
        }
        return text;
    }
}

