/*******************************************************************************
 * Copyright (c) 2017 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package com.ibm.ws.jpa;

import org.junit.ClassRule;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.Suite.SuiteClasses;

import componenttest.rules.repeater.FeatureReplacementAction;
import componenttest.rules.repeater.RepeatTests;

@RunWith(Suite.class)
@SuiteClasses({
                TestExample_EJB.class,
                TestExample_Web.class,
                TestOLGH8820_EJB.class,
                TestOLGH8820_Web.class,
                TestOLGH10240_EJB.class,
                TestOLGH10240_Web.class,
                TestTXSynchronization.class,
                TestTXDDSynchronization.class,
                TestCDI_WEB.class,
                TestCDI_EJB.class,
                componenttest.custom.junit.runner.AlwaysPassesTest.class
})
public class FATSuite {
    public final static String[] JAXB_PERMS = { "permission java.lang.RuntimePermission \"accessClassInPackage.com.sun.xml.internal.bind.v2.runtime.reflect\";",
                                                "permission java.lang.RuntimePermission \"accessClassInPackage.com.sun.xml.internal.bind\";" };

    @ClassRule
    public static RepeatTests r = RepeatTests
                    .withoutModification()
                    .andWith(FeatureReplacementAction.EE7_FEATURES())
                    .andWith(FeatureReplacementAction.EE9_FEATURES());
    public static String repeatPhase = "";
}
