/*******************************************************************************
 * Copyright (c) 2020 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.informix.jdbcx;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class IfxPreparedStatement implements PreparedStatement {
	PreparedStatement wrappedPS = null;

	static int failoverCounter = 0;
	static boolean failoverQuery = false;

	IfxPreparedStatement(PreparedStatement realPS) {
		wrappedPS = realPS;
	}

	@Override
	public void addBatch(String sql) throws SQLException {
		wrappedPS.addBatch(sql);
	}

	@Override
	public void cancel() throws SQLException {
		wrappedPS.cancel();
	}

	@Override
	public void clearBatch() throws SQLException {
		wrappedPS.clearBatch();
	}

	@Override
	public void clearWarnings() throws SQLException {
		wrappedPS.clearWarnings();
	}

	@Override
	public void close() throws SQLException {
		wrappedPS.close();
	}

	@Override
	public boolean execute(String sql) throws SQLException {
		boolean ret = wrappedPS.execute(sql);
		return ret;
	}

	@Override
	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		boolean ret = wrappedPS.execute(sql, autoGeneratedKeys);
		return ret;
	}

	@Override
	public boolean execute(String sql, int[] columnIndexes) throws SQLException {
		boolean ret = wrappedPS.execute(sql, columnIndexes);
		return ret;
	}

	@Override
	public boolean execute(String sql, String[] columnNames) throws SQLException {
		boolean ret = wrappedPS.execute(sql, columnNames);
		return ret;
	}

	@Override
	public int[] executeBatch() throws SQLException {
		int[] ret = null;
		boolean failOver = false;
		System.out.println("SIMHADB: executeBatch, this - " + this + ", wrapped - " + wrappedPS);

		if (IfxConnection.isFailoverEnabled()) {
			System.out
					.println("SIMHADB: executeBatch, failover Enabled, Counter -" + IfxConnection.getFailoverCounter());
			IfxConnection.incrementFailoverCounter();
			if (IfxConnection.getFailoverCounter() == IfxConnection.getFailoverValue())
				failOver = true;
		}

		if (failOver) {
			System.out.println("SIMHADB: Feigning query failover, close connection");
			IfxConnectionPoolDataSource.setTestingFailoverAtRuntime(false);
			Connection myconn = getConnection();
			try {
				myconn.rollback();
				myconn.close();
			} catch (Exception ex) {
				System.out.println("SIMHADB: on close connection, caught exc: " + ex);
			}
			String sqlReason = "Generated internally";
			String sqlState = "Generated reason";

			int reasonCode = IfxConnection.getSimSQLCode(); // FOR DB2 should be
															// -4498, Oracle
															// 17410
			System.out.println("SIMHADB: sqlcode set to: " + reasonCode);
			SQLException sqlex = new SQLException(sqlReason, sqlState, reasonCode);
			throw sqlex;
		} else {
			System.out.println("SIMHADB: ExecuteBatch");
			ret = wrappedPS.executeBatch();
		}

		System.out.println("SIMHADB: executeBatch - " + ret);
		return ret;
	}

	@Override
	public ResultSet executeQuery(String sql) throws SQLException {

		System.out.println("SIMHADB: executeQuery, this - " + this + ", sql - " + sql); // +
																						// ",
																						// fail
																						// Counter
																						// -"
																						// +
																						// failoverCounter
																						// +
																						// ",
																						// wrapped
																						// -
																						// "
																						// +
																						// wrappedStmt);

		simQueryFailover();

		ResultSet ret = wrappedPS.executeQuery(sql);
		System.out.println("SIMHADB: executeQuery exit, ret - " + ret);
		return ret;
	}

	@Override
	public int executeUpdate(String sql) throws SQLException {
		System.out.println("SIMHADB: executeUpdate, this - " + this + ", sql: " + sql);

		simQueryFailover();

		int ret = wrappedPS.executeUpdate(sql);
		System.out.println("SIMHADB: executeUpdate exit, ret - " + ret);
		return ret;
	}

	@Override
	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		System.out.println("SIMHADB: executeUpdate, this - " + this + ", sql: " + sql + ", keys: " + autoGeneratedKeys);

		simQueryFailover();
		int ret = wrappedPS.executeUpdate(sql, autoGeneratedKeys);
		System.out.println("SIMHADB: executeUpdate exit, ret - " + ret);
		return ret;
	}

	@Override
	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		System.out.println("SIMHADB: executeUpdate, this - " + this + ", sql: " + sql + ", columnindexes");

		simQueryFailover();
		int ret = wrappedPS.executeUpdate(sql, columnIndexes);
		System.out.println("SIMHADB: executeUpdate exit, ret - " + ret);
		return ret;
	}

	@Override
	public int executeUpdate(String sql, String[] columnNames) throws SQLException {
		System.out.println("SIMHADB: executeUpdate, this - " + this + ", sql: " + sql + ", columnnames");

		simQueryFailover();
		int ret = wrappedPS.executeUpdate(sql, columnNames);
		System.out.println("SIMHADB: executeUpdate exit, ret - " + ret);
		return ret;
	}

	@Override
	public Connection getConnection() throws SQLException {
		Connection ret = wrappedPS.getConnection();
		return ret;
	}

	@Override
	public int getFetchDirection() throws SQLException {
		int ret = wrappedPS.getFetchDirection();
		return ret;
	}

	@Override
	public int getFetchSize() throws SQLException {
		int ret = wrappedPS.getFetchSize();
		return ret;
	}

	@Override
	public ResultSet getGeneratedKeys() throws SQLException {
		ResultSet ret = wrappedPS.getGeneratedKeys();
		return ret;
	}

	@Override
	public int getMaxFieldSize() throws SQLException {
		int ret = wrappedPS.getMaxFieldSize();
		return ret;
	}

	@Override
	public int getMaxRows() throws SQLException {
		int ret = wrappedPS.getMaxRows();
		return ret;
	}

	@Override
	public boolean getMoreResults() throws SQLException {
		boolean ret = wrappedPS.getMoreResults();
		return ret;
	}

	@Override
	public boolean getMoreResults(int current) throws SQLException {
		boolean ret = wrappedPS.getMoreResults(current);
		return ret;
	}

	@Override
	public int getQueryTimeout() throws SQLException {
		int ret = wrappedPS.getQueryTimeout();
		return ret;
	}

	@Override
	public ResultSet getResultSet() throws SQLException {
		ResultSet ret = wrappedPS.getResultSet();
		return ret;
	}

	@Override
	public int getResultSetConcurrency() throws SQLException {
		int ret = wrappedPS.getResultSetConcurrency();
		return ret;
	}

	@Override
	public int getResultSetHoldability() throws SQLException {
		int ret = wrappedPS.getResultSetHoldability();
		return ret;
	}

	@Override
	public int getResultSetType() throws SQLException {
		int ret = wrappedPS.getResultSetType();
		return ret;
	}

	@Override
	public int getUpdateCount() throws SQLException {
		int ret = wrappedPS.getUpdateCount();
		return ret;
	}

	@Override
	public SQLWarning getWarnings() throws SQLException {
		SQLWarning ret = wrappedPS.getWarnings();
		return ret;
	}

	@Override
	public void setCursorName(String name) throws SQLException {
		wrappedPS.setCursorName(name);
	}

	@Override
	public void setEscapeProcessing(boolean enable) throws SQLException {
		wrappedPS.setEscapeProcessing(enable);
	}

	@Override
	public void setFetchDirection(int direction) throws SQLException {
		wrappedPS.setFetchDirection(direction);
	}

	@Override
	public void setFetchSize(int rows) throws SQLException {
		wrappedPS.setFetchSize(rows);
	}

	@Override
	public void setMaxFieldSize(int max) throws SQLException {
		wrappedPS.setMaxFieldSize(max);
	}

	@Override
	public void setMaxRows(int max) throws SQLException {
		wrappedPS.setMaxRows(max);
	}

	@Override
	public void setQueryTimeout(int seconds) throws SQLException {
		wrappedPS.setQueryTimeout(seconds);
	}

	@Override
	public boolean isClosed() throws SQLException {
		boolean ret = wrappedPS.isClosed();
		return ret;
	}

	@Override
	public void setPoolable(boolean poolable) throws SQLException {
		wrappedPS.setPoolable(poolable);
	}

	@Override
	public boolean isPoolable() throws SQLException {
		boolean ret = wrappedPS.isPoolable();
		return ret;
	}

	@Override
	public <T> T unwrap(Class<T> iface) throws SQLException {
		T ret = wrappedPS.unwrap(iface);
		return ret;
	}

	@Override
	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		boolean ret = wrappedPS.isWrapperFor(iface);
		return ret;
	}

	@Override
	public void addBatch() throws SQLException {
		wrappedPS.addBatch();
	}

	@Override
	public void clearParameters() throws SQLException {
		wrappedPS.clearParameters();
	}

	@Override
	public boolean execute() throws SQLException {
		boolean ret = wrappedPS.execute();
		return ret;
	}

	@Override
	public ResultSet executeQuery() throws SQLException {
		System.out.println("SIMHADB: executeQuery, this - " + this); // + ",
																		// fail
																		// Counter
																		// -" +
																		// failoverCounter
																		// + ",
																		// wrapped
																		// - " +
																		// wrappedStmt);

		simQueryFailover();

		ResultSet ret = wrappedPS.executeQuery();
		System.out.println("SIMHADB: executeQuery exit, ret - " + ret);
		return ret;
	}

	@Override
	public int executeUpdate() throws SQLException {
		System.out.println("SIMHADB: executeUpdate, this - " + this);

		simQueryFailover();

		int ret = wrappedPS.executeUpdate();
		System.out.println("SIMHADB: executeUpdate exit, ret - " + ret);
		return ret;
	}

	@Override
	public ResultSetMetaData getMetaData() throws SQLException {
		ResultSetMetaData ret = wrappedPS.getMetaData();
		return ret;
	}

	@Override
	public ParameterMetaData getParameterMetaData() throws SQLException {
		ParameterMetaData ret = wrappedPS.getParameterMetaData();
		return ret;
	}

	@Override
	public void setArray(int parameterIndex, Array theArray) throws SQLException {
		wrappedPS.setArray(parameterIndex, theArray);
	}

	@Override
	public void setAsciiStream(int parameterIndex, InputStream theInputStream, int length) throws SQLException {
		wrappedPS.setAsciiStream(parameterIndex, theInputStream, length);
	}

	@Override
	public void setBigDecimal(int parameterIndex, BigDecimal theBigDecimal) throws SQLException {
		wrappedPS.setBigDecimal(parameterIndex, theBigDecimal);
	}

	@Override
	public void setBinaryStream(int parameterIndex, InputStream theInputStream, int length) throws SQLException {
		wrappedPS.setBinaryStream(parameterIndex, theInputStream, length);
	}

	@Override
	public void setBlob(int parameterIndex, Blob theBlob) throws SQLException {
		wrappedPS.setBlob(parameterIndex, theBlob);
	}

	@Override
	public void setBoolean(int parameterIndex, boolean theBoolean) throws SQLException {
		wrappedPS.setBoolean(parameterIndex, theBoolean);
	}

	@Override
	public void setByte(int parameterIndex, byte theByte) throws SQLException {
		wrappedPS.setByte(parameterIndex, theByte);
	}

	@Override
	public void setBytes(int parameterIndex, byte[] theBytes) throws SQLException {
		wrappedPS.setBytes(parameterIndex, theBytes);
	}

	@Override
	public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
		wrappedPS.setCharacterStream(parameterIndex, reader, length);
	}

	@Override
	public void setClob(int parameterIndex, Clob theClob) throws SQLException {
		wrappedPS.setClob(parameterIndex, theClob);
	}

	@Override
	public void setDate(int parameterIndex, Date theDate) throws SQLException {
		wrappedPS.setDate(parameterIndex, theDate);
	}

	@Override
	public void setDate(int parameterIndex, Date theDate, Calendar cal) throws SQLException {
		wrappedPS.setDate(parameterIndex, theDate, cal);
	}

	@Override
	public void setDouble(int parameterIndex, double theDouble) throws SQLException {
		wrappedPS.setDouble(parameterIndex, theDouble);
	}

	@Override
	public void setFloat(int parameterIndex, float theFloat) throws SQLException {
		wrappedPS.setFloat(parameterIndex, theFloat);
	}

	@Override
	public void setInt(int parameterIndex, int theInt) throws SQLException {
		wrappedPS.setInt(parameterIndex, theInt);
	}

	@Override
	public void setLong(int parameterIndex, long theLong) throws SQLException {
		wrappedPS.setLong(parameterIndex, theLong);
	}

	@Override
	public void setNull(int parameterIndex, int sqlType) throws SQLException {
		wrappedPS.setNull(parameterIndex, sqlType);
	}

	@Override
	public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
		wrappedPS.setNull(paramIndex, sqlType, typeName);
	}

	@Override
	public void setObject(int parameterIndex, Object theObject) throws SQLException {
		wrappedPS.setObject(parameterIndex, theObject);
	}

	@Override
	public void setObject(int parameterIndex, Object theObject, int targetSqlType) throws SQLException {
		wrappedPS.setObject(parameterIndex, theObject, targetSqlType);
	}

	@Override
	public void setObject(int parameterIndex, Object theObject, int targetSqlType, int scale) throws SQLException {
		wrappedPS.setObject(parameterIndex, theObject, targetSqlType, scale);
	}

	@Override
	public void setRef(int parameterIndex, Ref theRef) throws SQLException {
		wrappedPS.setRef(parameterIndex, theRef);
	}

	@Override
	public void setShort(int parameterIndex, short theShort) throws SQLException {
		wrappedPS.setShort(parameterIndex, theShort);
	}

	@Override
	public void setString(int parameterIndex, String theString) throws SQLException {
		wrappedPS.setString(parameterIndex, theString);
	}

	@Override
	public void setTime(int parameterIndex, Time theTime) throws SQLException {
		wrappedPS.setTime(parameterIndex, theTime);
	}

	@Override
	public void setTime(int parameterIndex, Time theTime, Calendar cal) throws SQLException {
		wrappedPS.setTime(parameterIndex, theTime, cal);
	}

	@Override
	public void setTimestamp(int parameterIndex, Timestamp theTimestamp) throws SQLException {
		wrappedPS.setTimestamp(parameterIndex, theTimestamp);
	}

	@Override
	public void setTimestamp(int parameterIndex, Timestamp theTimestamp, Calendar cal) throws SQLException {
		wrappedPS.setTimestamp(parameterIndex, theTimestamp, cal);
	}

	@Override
	public void setUnicodeStream(int parameterIndex, InputStream theInputStream, int length) throws SQLException {
		wrappedPS.setUnicodeStream(parameterIndex, theInputStream, length);
	}

	@Override
	public void setURL(int parameterIndex, URL theURL) throws SQLException {
		wrappedPS.setURL(parameterIndex, theURL);
	}

	@Override
	public void setRowId(int parameterIndex, RowId x) throws SQLException {
		wrappedPS.setRowId(parameterIndex, x);
	}

	@Override
	public void setNString(int parameterIndex, String value) throws SQLException {
		wrappedPS.setNString(parameterIndex, value);
	}

	@Override
	public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
		wrappedPS.setNCharacterStream(parameterIndex, value, length);
	}

	@Override
	public void setNClob(int parameterIndex, NClob value) throws SQLException {
		wrappedPS.setNClob(parameterIndex, value);
	}

	@Override
	public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
		wrappedPS.setClob(parameterIndex, reader, length);
	}

	@Override
	public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
		wrappedPS.setBlob(parameterIndex, inputStream, length);
	}

	@Override
	public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
		wrappedPS.setNClob(parameterIndex, reader, length);
	}

	@Override
	public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
		wrappedPS.setSQLXML(parameterIndex, xmlObject);
	}

	@Override
	public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
		wrappedPS.setAsciiStream(parameterIndex, x, length);
	}

	@Override
	public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
		wrappedPS.setBinaryStream(parameterIndex, x, length);
	}

	@Override
	public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
		wrappedPS.setCharacterStream(parameterIndex, reader, length);
	}

	@Override
	public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
		wrappedPS.setAsciiStream(parameterIndex, x);
	}

	@Override
	public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
		wrappedPS.setBinaryStream(parameterIndex, x);
	}

	@Override
	public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
		wrappedPS.setCharacterStream(parameterIndex, reader);
	}

	@Override
	public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
		wrappedPS.setNCharacterStream(parameterIndex, value);
	}

	@Override
	public void setClob(int parameterIndex, Reader reader) throws SQLException {
		wrappedPS.setClob(parameterIndex, reader);
	}

	@Override
	public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
		wrappedPS.setBlob(parameterIndex, inputStream);
	}

	@Override
	public void setNClob(int parameterIndex, Reader reader) throws SQLException {
		wrappedPS.setNClob(parameterIndex, reader);
	}

	private void simQueryFailover() throws SQLException {
		if (IfxConnection.isQueryFailoverEnabled() && IfxConnectionPoolDataSource.isTestingFailoverAtRuntime()) {
			System.out.println("SIMHADB: executeQuery/Update, failover Enabled, Counter -"
					+ IfxConnection.getQueryFailoverCounter());
			IfxConnection.incrementQueryFailoverCounter();

			if (IfxConnection.getQueryFailoverCounter() == 1) {
				System.out.println("SIMHADB: Feigning executequery/Update failover, rollback on connection");
				Connection myconn = getConnection();
				try {
					myconn.rollback();
					// myconn.close();

				} catch (Exception ex) {
					System.out.println("SIMHADB: on close connection, caught exc: " + ex);
				}
				String sqlReason = "Generated internally";
				String sqlState = "Generated reason";
				int reasonCode = IfxConnection.getSimSQLCode(); // FOR DB2
																// should be
																// -4498, Oracle
																// 17410
				SQLException sqlex = new SQLException(sqlReason, sqlState, reasonCode);
				throw sqlex;
			}
			if (IfxConnection.getQueryFailoverCounter() == 4) {
				System.out.println("SIMHADB: counter reached 4 disable startup flag");
				IfxConnectionPoolDataSource.setTestingFailoverAtRuntime(false);
			}
			if (IfxConnection.getQueryFailoverCounter() >= 2 && IfxConnection.getQueryFailoverCounter() <= 4) {

				System.out.println("SIMHADB: Feigning query failover - (2,3)");
				// Connection myconn = getConnection();

				String sqlReason = "Generated internally";
				String sqlState = "Generated reason";
				int reasonCode = IfxConnection.getSimSQLCode(); // FOR DB2
																// should be
																// -4498, Oracle
																// 17410
				SQLException sqlex = new SQLException(sqlReason, sqlState, reasonCode);
				throw sqlex;
			}

		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.sql.Statement#closeOnCompletion()
	 */
	@Override
	public void closeOnCompletion() throws SQLException {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.sql.Statement#isCloseOnCompletion()
	 */
	@Override
	public boolean isCloseOnCompletion() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}
}
