/*******************************************************************************
 * Copyright (c) 2018, 2020 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.tx.jta.fat.hibernate;

import org.junit.ClassRule;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.Suite.SuiteClasses;

import componenttest.rules.repeater.FeatureReplacementAction;
import componenttest.rules.repeater.JakartaEE9Action;
import componenttest.rules.repeater.RepeatTests;

@RunWith(Suite.class)
@SuiteClasses({
                HibernateTxTest.class,
})
public class FATSuite {

    @ClassRule
    public static RepeatTests r = RepeatTests.withoutModification()
                    .andWith(FeatureReplacementAction.EE8_FEATURES().removeFeature("jdbc-4.1").addFeature("jdbc-4.2"))
                    .andWith(new JakartaEE9Action()) /* test EE9 with jdbc-4.2 */
                    .andWith(new JakartaEE9Action().removeFeature("jdbc-4.2").addFeature("jdbc-4.3").withMinJavaLevel(11)) /* test EE9+jdbc4.3. Jdbc4.3 reqs. JSE11 */;
}
