/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.subsystem;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.VersionRange;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions(traceGroups={"featureManager"}, traceGroup="", messageBundle="com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages", traceExceptionThrow=false, traceExceptionHandling=false)
public class FeatureResourceImpl
implements FeatureResource {
    private static final TraceComponent tc = Tr.register(FeatureResourceImpl.class);
    private final String _symbolicName;
    private final Map<String, String> _rawAttributes;
    private final String _featureName;
    private final String _bundleRepositoryType;
    private String matchString = null;
    private final AtomicReference<VersionRange> _range = new AtomicReference();
    private final AtomicReference<String> _location = new AtomicReference();
    private final AtomicReference<List<String>> _osList = new AtomicReference();
    private final AtomicReference<Map<String, String>> _attributes = new AtomicReference();
    private final AtomicReference<Map<String, String>> _directives = new AtomicReference();
    private final AtomicInteger _startLevel = new AtomicInteger(-1);
    private volatile SubsystemContentType _type = null;
    static final long serialVersionUID = 6291164375568222026L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public FeatureResourceImpl(String key, Map<String, String> value, String bundleRepositoryType, String featureName) {
        this._symbolicName = key;
        this._rawAttributes = value;
        this._bundleRepositoryType = bundleRepositoryType;
        this._featureName = featureName;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getSymbolicName() {
        return this._symbolicName;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public VersionRange getVersionRange() {
        String range;
        VersionRange result = this._range.get();
        if (result == null && !this._range.compareAndSet(null, result = VersionUtility.stringToVersionRange(range = this._rawAttributes.get("version")))) {
            result = this._range.get();
        }
        return result;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public Map<String, String> getAttributes() {
        Map<String, String> result = this._attributes.get();
        if (result == null) {
            result = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this._rawAttributes.entrySet()) {
                String key = entry.getKey();
                if (key.endsWith(":")) continue;
                result.put(key, entry.getValue());
            }
            if (!this._attributes.compareAndSet(null, result = Collections.unmodifiableMap(result))) {
                result = this._attributes.get();
            }
        }
        return result;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public Map<String, String> getDirectives() {
        Map<String, String> result = this._directives.get();
        if (result == null) {
            result = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this._rawAttributes.entrySet()) {
                String key = entry.getKey();
                if (!key.endsWith(":")) continue;
                result.put(key.substring(0, key.length() - 1), entry.getValue());
            }
            if (!this._directives.compareAndSet(null, result = Collections.unmodifiableMap(result))) {
                result = this._directives.get();
            }
        }
        return result;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getLocation() {
        String result = this._location.get();
        if (result == null) {
            result = this._rawAttributes.get("location:");
            if (result == null) {
                result = "";
            }
            if (!this._location.compareAndSet(null, result)) {
                result = this._location.get();
            }
        }
        if ("".equals(result)) {
            result = null;
        }
        return result;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public List<String> getOsList() {
        List<String> result = this._osList.get();
        if (result == null) {
            String osData = this._rawAttributes.get("os");
            if (osData == null) {
                osData = "";
            }
            String[] parts = osData.split(",");
            result = new ArrayList<String>();
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (!"".equals(p.trim())) {
                    result.add(p.trim());
                }
                ++n2;
            }
            if (!this._osList.compareAndSet(null, result)) {
                result = this._osList.get();
            }
        }
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public boolean isType(SubsystemContentType type) {
        SubsystemContentType thisType = this.getType();
        return thisType == type;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public SubsystemContentType getType() {
        SubsystemContentType result = this._type;
        if (result == null) {
            result = this._type = SubsystemContentType.fromString(this.getRawType());
        }
        return result;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getRawType() {
        return this._rawAttributes.get("type");
    }

    public String toString() {
        if (this.matchString == null) {
            this.matchString = String.valueOf(this._symbolicName) + '/' + this.getVersionRange();
        }
        return this.matchString;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public int getStartLevel() {
        int result = this._startLevel.get();
        if (result == -1) {
            result = 12;
            String phase = this._rawAttributes.get("start-phase:");
            result = this.setStartLevel(phase, result);
            if (!this._startLevel.compareAndSet(-1, result)) {
                result = this._startLevel.get();
            }
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    private int setStartLevel(String phase, int original) {
        if (phase == null) {
            return original;
        }
        if ("APPLICATION".equals(phase)) {
            return 18;
        }
        if ("APPLICATION_LATE".equals(phase)) {
            return 19;
        }
        if ("APPLICATION_EARLY".equals(phase)) {
            return 17;
        }
        if ("SERVICE".equals(phase)) {
            return 9;
        }
        if ("SERVICE_LATE".equals(phase)) {
            return 10;
        }
        if ("SERVICE_EARLY".equals(phase)) {
            return 8;
        }
        if ("CONTAINER".equals(phase)) {
            return 12;
        }
        if ("CONTAINER_LATE".equals(phase)) {
            return 13;
        }
        if ("CONTAINER_EARLY".equals(phase)) {
            return 11;
        }
        Tr.warning(tc, "INVALID_START_PHASE_WARNING", phase, this._symbolicName, this._featureName);
        return original;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getLocation() == null ? 0 : this._location.get().hashCode());
        result = 31 * result + (this.getVersionRange() == null ? 0 : this._range.get().hashCode());
        result = 31 * result + (this._symbolicName == null ? 0 : this._symbolicName.hashCode());
        result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureResourceImpl other = (FeatureResourceImpl)obj;
        if (this.getLocation() == null ? other.getLocation() != null : !this._location.get().equals(other._location.get())) {
            return false;
        }
        if (this.getVersionRange() == null ? other.getVersionRange() != null : !this._range.get().equals(other._range.get())) {
            return false;
        }
        if (this._symbolicName == null ? other._symbolicName != null : !this._symbolicName.equals(other._symbolicName)) {
            return false;
        }
        if (this._type != other._type) {
            return false;
        }
        return !(this.getOsList() == null ? other.getOsList() != null : !this._osList.get().equals(other.getOsList()));
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getMatchString() {
        return this.toString();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getBundleRepositoryType() {
        return this._bundleRepositoryType;
    }
}

