/*******************************************************************************
 * Copyright (c) 2015 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.wsspi.persistence.internal.eclipselink.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.wsspi.persistence.internal.eclipselink.sql.delegate.DelegatingConnection;

@Trivial
public class WrappingConnection extends DelegatingConnection {

     public WrappingConnection(Connection conn) {
          super(conn);
     }

     private PreparedStatement wrap(PreparedStatement ps) {
          return new UnicodeFilteringPreparedStatement(ps);
     }

     public PreparedStatement prepareStatement(String sql) throws SQLException {
          return wrap(super.prepareStatement(sql));
     }

     public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
          return wrap(super.prepareStatement(sql, autoGeneratedKeys));
     }

     public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency)
          throws SQLException {
          return wrap(super.prepareStatement(sql, resultSetType, resultSetConcurrency));
     }

     public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency,
          int resultSetHoldability) throws SQLException {
          return wrap(super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
     }

     public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
          return wrap(super.prepareStatement(sql, columnIndexes));
     }

     public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
          return wrap(super.prepareStatement(sql, columnNames));
     }
}