/*******************************************************************************
 * Copyright (c) 1997, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.websphere.servlet.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ibm.ejs.ras.TraceNLS;

/**
 * 
 *  
 * Object that chains the responses of servlets together.
 *
 * A servlet chain acts as a response pipe that allows servlets
 * to filter the output of the previous servlet in the chain.
 * When a servlet writes header or output stream data to the response,
 * this data is fed into a chained request object that will be passed
 * to the next servlet in the chain.  The next servlet can examine the
 * contents of the chained request to see the response that was
 * generated by the previous servlet. The data written by the last
 * servlet in the chain will be sent back to the client (Deprecated since WebSphere 6.0).
 *
 * @deprecated
 *  Application developers requiring this functionality
 *  should implement this using javax.servlet.filter classes.
 *
 * @ibm-api
 */
@SuppressWarnings("unchecked")
public class ServletChain implements RequestDispatcher {
    Vector _dispatchers = new Vector();

    private static TraceNLS nls = TraceNLS.getTraceNLS(ServletChain.class, "com.ibm.ws.webcontainer.resources.Messages");

    public ServletChain() {
    }

    public ServletChain(RequestDispatcher[] dispatchers) {
        for(int i=0; i<dispatchers.length; i++) {
            addRequestDispatcher(dispatchers[i]);
        }
    }

    public void addRequestDispatcher(RequestDispatcher rd) {
        _dispatchers.addElement(rd);
    }

    public void addRequestDispatcher(int index, RequestDispatcher rd) {
        _dispatchers.insertElementAt(rd, index);
    }

    public void clear() {
        _dispatchers.removeAllElements();
    }

    public boolean containsRequestDispatcher(RequestDispatcher rd) {
        return _dispatchers.contains(rd);
    }

    public Enumeration enumeration() {
        return _dispatchers.elements();
    }

    public RequestDispatcher getRequestDispatcher(int index) {
        return(RequestDispatcher)_dispatchers.elementAt(index);
    }

    public int indexOf(RequestDispatcher rd) {
        return _dispatchers.indexOf(rd);
    }

    public boolean isEmpty() {
        return _dispatchers.isEmpty();
    }

    public boolean removeRequestDispatcher(RequestDispatcher rd) {
        synchronized(_dispatchers) {
            if(_dispatchers.contains(rd)) {
                _dispatchers.removeElement(rd);
                return true;
            }
            else {
                return false;
            }
        }
    }

    public RequestDispatcher removeRequestDispatcher(int index) {
        synchronized(_dispatchers) {
            RequestDispatcher rd = getRequestDispatcher(index);
            _dispatchers.removeElementAt(index);
            return rd;
        }
    }

    public RequestDispatcher setRequestDispatcher(int index, RequestDispatcher rd) {
        synchronized(_dispatchers) {
            RequestDispatcher old = getRequestDispatcher(index);
            _dispatchers.setElementAt(rd, index);
            return old;
        }
    }

    public int size() {
        return _dispatchers.size();
    }

    public void forward(ServletRequest req, ServletResponse resp)
    throws ServletException, IOException{
        handleDispatch(req, resp, false);
    }

    public void include(ServletRequest req, ServletResponse resp)
    throws ServletException, IOException{
        handleDispatch(req, resp, true);
    }

    private void handleDispatch(ServletRequest req, ServletResponse resp, boolean isInclude)
    throws ServletException, IOException{
        HttpServletRequest  request;
        HttpServletResponse response;
        try {
            request = (HttpServletRequest) req;
            response = (HttpServletResponse) resp;
        }
        catch(ClassCastException e) {
            com.ibm.wsspi.webcontainer.util.FFDCWrapper.processException(e, "com.ibm.websphere.servlet.filter.ServletChain.handleDispatch", "126", this);
            throw new ServletException (nls.getString("non-HTTP.request.or.response","non-HTTP request or response"), e);
        }

        Enumeration enumRequestDispatchers = enumeration();

        int chainedCount = 0;
        while(enumRequestDispatchers.hasMoreElements()) {
            RequestDispatcher rd = (RequestDispatcher)enumRequestDispatchers.nextElement();
            if(enumRequestDispatchers.hasMoreElements()) {
                ChainedResponse chainedResp = new ChainedResponse(request, response);
                if(chainedCount == 0) {
                    //defect 55215 - auto transfer non-content headers sent by client
                    //This allows servlets at the end of the chain to see headers that
                    //were sent by the client.
                    Enumeration names = request.getHeaderNames();
                    while(names.hasMoreElements()) {
                        String name = (String)names.nextElement();
                        String value = request.getHeader(name);
                        if(!name.toLowerCase().startsWith("content")) {
                            //don't transfer content headers
                            chainedResp.setAutoTransferringHeader(name, value);
                        }
                    }
                }
                if(isInclude) {
                    rd.include(request, chainedResp);
                }
                else {
                    rd.forward(request, chainedResp);
                }
                request = chainedResp.getChainedRequest();
            }
            else {
                if(isInclude) {
                    rd.include(request, response);
                }
                else {
                    rd.forward(request, response);
                }
            }
            chainedCount++;
        }
    }

    /**
     * Chain the responses of a set of request dispatchers together.
     */
    public static void chainRequestDispatchers(RequestDispatcher[] dispatchers, HttpServletRequest request, HttpServletResponse response)
    throws IOException, ServletException{
        for(int i=0; i<dispatchers.length-1; i++) {
            ChainedResponse chainedResp = new ChainedResponse(request, response);
            dispatchers[i].forward(request, chainedResp);
            request = chainedResp.getChainedRequest();
        }
        dispatchers[dispatchers.length-1].forward(request, response);
    }
}


