package com.ibm.ws.wsat.webservice.client;

import java.net.URL;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPBinding;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.wsat.webservice.client.wsat.Notification;

public class CoordinatorPortProxy {

    private static final TraceComponent tc = Tr.register(
                                                         CoordinatorPortProxy.class, "WSATWEBCLIENT", null);

    protected Descriptor _descriptor;

    public class Descriptor {
        private com.ibm.ws.wsat.webservice.client.CoordinatorService _service = null;
        private com.ibm.ws.wsat.webservice.client.CoordinatorPortType _proxy = null;
        private Dispatch<Source> _dispatch = null;
        private boolean _useJNDIOnly = false;

        public Descriptor() {
            init();
        }

        public Descriptor(URL wsdlLocation, QName serviceName) {
            if (serviceName != null)
                _service = new com.ibm.ws.wsat.webservice.client.CoordinatorService(wsdlLocation, serviceName);
            else
                _service = new CoordinatorService(wsdlLocation);
            initCommon();
        }

        public void init() {
            _service = null;
            _proxy = null;
            _dispatch = null;
            try
            {
                InitialContext ctx = new InitialContext();
                _service = (com.ibm.ws.wsat.webservice.client.CoordinatorService) ctx.lookup("java:comp/env/service/CoordinatorService");
            } catch (NamingException e)
            {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "JNDI lookup failure: javax.naming.NamingException: "
                             , e.getMessage());
                }
            }

            if (_service == null && !_useJNDIOnly)
                _service = new com.ibm.ws.wsat.webservice.client.CoordinatorService();
            initCommon();
        }

        private void initCommon() {
            _proxy = _service.getCoordinatorPort();
        }

        public com.ibm.ws.wsat.webservice.client.CoordinatorPortType getProxy() {
            return _proxy;
        }

        public void useJNDIOnly(boolean useJNDIOnly) {
            _useJNDIOnly = useJNDIOnly;
            init();
        }

        public Dispatch<Source> getDispatch() {
            if (_dispatch == null) {
                QName portQName = new QName("", "CoordinatorPort");
                _dispatch = _service.createDispatch(portQName, Source.class, Service.Mode.MESSAGE);

                String proxyEndpointUrl = getEndpoint();
                BindingProvider bp = _dispatch;
                String dispatchEndpointUrl = (String) bp.getRequestContext().get(BindingProvider.ENDPOINT_ADDRESS_PROPERTY);
                if (!dispatchEndpointUrl.equals(proxyEndpointUrl))
                    bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, proxyEndpointUrl);
            }
            return _dispatch;
        }

        public String getEndpoint() {
            BindingProvider bp = (BindingProvider) _proxy;
            return (String) bp.getRequestContext().get(BindingProvider.ENDPOINT_ADDRESS_PROPERTY);
        }

        public void setEndpoint(String endpointUrl) {
            BindingProvider bp = (BindingProvider) _proxy;
            bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endpointUrl);

            if (_dispatch != null) {
                bp = _dispatch;
                bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endpointUrl);
            }
        }

        public void setMTOMEnabled(boolean enable) {
            SOAPBinding binding = (SOAPBinding) ((BindingProvider) _proxy).getBinding();
            binding.setMTOMEnabled(enable);
        }
    }

    public CoordinatorPortProxy() {
        _descriptor = new Descriptor();
        _descriptor.setMTOMEnabled(false);
    }

    public CoordinatorPortProxy(URL wsdlLocation, QName serviceName) {
        _descriptor = new Descriptor(wsdlLocation, serviceName);
        _descriptor.setMTOMEnabled(false);
    }

    public Descriptor _getDescriptor() {
        return _descriptor;
    }

    public void committedOperation(Notification parameters) {
        _getDescriptor().getProxy().committedOperation(parameters);
    }

    public void readOnlyOperation(Notification parameters) {
        _getDescriptor().getProxy().readOnlyOperation(parameters);
    }

    public void abortedOperation(Notification parameters) {
        _getDescriptor().getProxy().abortedOperation(parameters);
    }

    public void preparedOperation(Notification parameters) {
        _getDescriptor().getProxy().preparedOperation(parameters);
    }

}