/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.svt.gs.util;

import com.ibm.websphere.svt.cc.ejb.session.CCManagerRemote;
import com.ibm.websphere.svt.cc.ejb.session.CCManagerService;
import com.ibm.websphere.svt.gs.ejb.CategoryLocal;
import com.ibm.websphere.svt.gs.ejb.CategoryLocalHome;
import com.ibm.websphere.svt.gs.ejb.CustomerInfoLocal;
import com.ibm.websphere.svt.gs.ejb.CustomerInfoLocalHome;
import com.ibm.websphere.svt.gs.ejb.CustomerLocal;
import com.ibm.websphere.svt.gs.ejb.CustomerLocalHome;
import com.ibm.websphere.svt.gs.ejb.InventoryLocal;
import com.ibm.websphere.svt.gs.ejb.InventoryLocalHome;
import com.ibm.websphere.svt.gs.ejb.MfgCategoryKey;
import com.ibm.websphere.svt.gs.ejb.MfgCategoryLocal;
import com.ibm.websphere.svt.gs.ejb.MfgCategoryLocalHome;
import com.ibm.websphere.svt.gs.ejb.SettingsKey;
import com.ibm.websphere.svt.gs.ejb.SettingsLocal;
import com.ibm.websphere.svt.gs.ejb.SettingsLocalHome;
import com.ibm.websphere.svt.gs.ejb.StoreCreditKey;
import com.ibm.websphere.svt.gs.ejb.StoreCreditLocal;
import com.ibm.websphere.svt.gs.ejb.StoreCreditLocalHome;
import com.ibm.websphere.svt.gs.utilities.AccessPropFile;
import com.ibm.websphere.svt.wsbank.ejb.BankManager;
import com.ibm.websphere.svt.wsbank.ejb.BankManagerService;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;

public class EJBUtils {
    private static String componentName = "com.ibm.websphere.svt.gs.util";
    private static Logger logger = Logger.getLogger(componentName);
    private static String className = EJBUtils.class.getName();
    private static final String CLIENTSIDE = "<====CCCCC ";
    private static CategoryLocalHome categoryHome = null;
    private static CustomerLocalHome customerHome = null;
    private static CustomerInfoLocalHome customerInfoHome = null;
    private static InventoryLocalHome inventoryHome = null;
    private static MfgCategoryLocalHome mfgCategoryHome = null;
    private static StoreCreditLocalHome storeCreditHome = null;
    private static SettingsLocalHome settingsHome = null;
    private static BankManagerService bankManagerService = null;
    private static CCManagerRemote _ccManager = null;
    private static DataSource gsDs = null;
    private static DataSource ccDs = null;
    private static DataSource wsbankDs = null;
    private static Queue gsShippingQueue = null;
    private static ConnectionFactory gsShippingQCF = null;

    static {
        try {
            InitialContext ctx = new InitialContext();
            categoryHome = (CategoryLocalHome)ctx.lookup("java:comp/env/ejb/Category");
            customerHome = (CustomerLocalHome)ctx.lookup("java:comp/env/ejb/Customer");
            customerInfoHome = (CustomerInfoLocalHome)ctx.lookup("java:comp/env/ejb/CustomerInfo");
            inventoryHome = (InventoryLocalHome)ctx.lookup("java:comp/env/ejb/Inventory");
            mfgCategoryHome = (MfgCategoryLocalHome)ctx.lookup("java:comp/env/ejb/MfgCategory");
            storeCreditHome = (StoreCreditLocalHome)ctx.lookup("java:comp/env/ejb/StoreCredit");
            settingsHome = (SettingsLocalHome)ctx.lookup("java:comp/env/ejb/Settings");
            bankManagerService = (BankManagerService)ctx.lookup("java:comp/env/service/BankManagerService");
            gsDs = (DataSource)ctx.lookup("java:comp/env/jdbc/gsdb");
            ccDs = (DataSource)ctx.lookup("java:comp/env/jdbc/ccdb");
            wsbankDs = (DataSource)ctx.lookup("java:comp/env/jdbc/wsbankdb");
            gsShippingQueue = (Queue)ctx.lookup("java:comp/env/jms/GSShippingQueue");
            gsShippingQCF = (ConnectionFactory)ctx.lookup("java:comp/env/jms/GSQueueConnectionFactory");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, CLIENTSIDE + e.getMessage());
            e.printStackTrace();
        }
    }

    public static DataSource getGsDs() {
        return gsDs;
    }

    public static DataSource getCcDs() {
        return ccDs;
    }

    public static DataSource getWsbankDs() {
        return wsbankDs;
    }

    public static Connection getGSShippingQCFConn() {
        String methodName = "getGSShippingQCFConn";
        Connection conn = null;
        try {
            conn = gsShippingQCF.createConnection();
        }
        catch (JMSException e) {
            logger.logp(Level.SEVERE, className, methodName, CLIENTSIDE + e.getMessage());
            e.printStackTrace();
        }
        return conn;
    }

    public static Queue getGSShippingQueue() {
        return gsShippingQueue;
    }

    public static BankManager getBankManager() {
        String methodName = "getBankManager";
        BankManager bankManager = null;
        try {
            bankManager = bankManagerService.getBankManager();
        }
        catch (ServiceException e) {
            logger.logp(Level.SEVERE, className, methodName, CLIENTSIDE + e.getMessage());
            e.printStackTrace();
        }
        return bankManager;
    }

    public static CCManagerRemote getCCManager() {
        String methodName = "getCCManager";
        if (_ccManager != null) {
            logger.logp(Level.FINER, className, methodName, "called before, return without hassle...");
            return _ccManager;
        }
        logger.logp(Level.FINE, className, methodName, "null static _ccManager, will have to obtain ...");
        try {
            URL wsdlLocation = new URL(AccessPropFile.getProperty("CCManager.WSDL.Address"));
            QName serviceName = null;
            serviceName = new QName("http://session.ejb.cc.svt.websphere.ibm.com/", "CCManagerService");
            CCManagerService service = new CCManagerService(wsdlLocation, serviceName);
            logger.logp(Level.FINE, className, methodName, "<====CCCCC Invoking static API CCManagerService...");
            _ccManager = service.getCCManagerPort();
            logger.logp(Level.INFO, className, methodName, "<====CCCCC got the CCManagerService port..");
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, CLIENTSIDE + e.getMessage());
            e.printStackTrace();
        }
        return _ccManager;
    }

    public static SettingsLocal createSettings(int id) {
        String methodName = "createSettings";
        SettingsLocal settings = null;
        try {
            settings = settingsHome.create(new Integer(id));
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return settings;
    }

    public static CategoryLocal createCategory(String categoryName) {
        String methodName = "createCategory";
        CategoryLocal category = null;
        try {
            category = categoryHome.create(categoryName);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return category;
    }

    public static CustomerLocal createCustomer(String custID) {
        String methodName = "createCustomer";
        CustomerLocal customer = null;
        try {
            customer = customerHome.create(custID);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return customer;
    }

    public static CustomerInfoLocal createCustomerInfo(String custID) {
        String methodName = "createCustomerInfo";
        CustomerInfoLocal customerInfo = null;
        try {
            customerInfo = customerInfoHome.create(custID);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return customerInfo;
    }

    public static InventoryLocal createInventory(String itemID) {
        String methodName = "createInventory";
        InventoryLocal inventory = null;
        try {
            inventory = inventoryHome.create(itemID);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return inventory;
    }

    public static MfgCategoryLocal createMfgCategory(String mfgName, CategoryLocal category) {
        String methodName = "createMfgCategory";
        MfgCategoryLocal mfgCategory = null;
        try {
            mfgCategory = mfgCategoryHome.create(mfgName, category);
            if (mfgCategory == null) {
                logger.logp(Level.INFO, className, methodName, "mfgName " + mfgName + " category " + category.getWrapper().getCategoryName() + " NULL????");
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return mfgCategory;
    }

    public static StoreCreditLocal createStoreCredit(String custID, Timestamp time) {
        String methodName = "createStoreCredit";
        StoreCreditLocal storeCredit = null;
        try {
            storeCredit = storeCreditHome.create(custID, time);
            logger.logp(Level.FINER, className, methodName, "Store credit created: " + storeCredit.toString());
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return storeCredit;
    }

    public static boolean removeCategory(String categoryName) {
        String methodName = "removeCategory";
        boolean wasRemoved = false;
        try {
            categoryHome.remove(categoryName);
            wasRemoved = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return wasRemoved;
    }

    public static boolean removeCustomer(String custID) {
        String methodName = "removeCustomer";
        boolean wasRemoved = false;
        try {
            customerHome.remove(custID);
            wasRemoved = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return wasRemoved;
    }

    public static boolean removeCustomerInfo(String custID) {
        String methodName = "removeCustomerInfo";
        boolean wasRemoved = false;
        try {
            customerInfoHome.remove(custID);
            wasRemoved = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return wasRemoved;
    }

    public static boolean removeInventory(String itemID) {
        String methodName = "removeInventory";
        boolean wasRemoved = false;
        try {
            inventoryHome.remove(itemID);
            wasRemoved = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return wasRemoved;
    }

    public static boolean removeMfgCategory(String mfgName, String category) {
        String methodName = "removeMfgCategory";
        boolean wasRemoved = false;
        try {
            mfgCategoryHome.remove(new MfgCategoryKey(mfgName, category));
            wasRemoved = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return wasRemoved;
    }

    public static boolean removeStoreCredit(String custID, Timestamp time) {
        String methodName = "removeStoreCredit";
        boolean wasRemoved = false;
        try {
            storeCreditHome.remove(new StoreCreditKey(custID, time));
            wasRemoved = true;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return wasRemoved;
    }

    public static SettingsLocal findSettingsByPrimaryKey(int id) {
        String methodName = "findSettingsByPrimaryKey";
        SettingsLocal settings = null;
        try {
            settings = settingsHome.findByPrimaryKey(new SettingsKey(new Integer(id)));
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return settings;
    }

    public static CategoryLocal findCategoryByPrimaryKey(String categoryName) {
        String methodName = "findCategoryByPrimaryKey";
        CategoryLocal category = null;
        try {
            category = categoryHome.findByPrimaryKey(categoryName);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return category;
    }

    public static CustomerLocal findCustomerByPrimaryKey(String custID) {
        String methodName = "findCustomerByPrimaryKey";
        CustomerLocal customer = null;
        try {
            customer = customerHome.findByPrimaryKey(custID);
            if (customer == null) {
                logger.logp(Level.FINE, className, methodName, "null customer: " + custID);
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return customer;
    }

    public static CustomerLocal findCustomerByPrimaryKeyForUpdate(String custID) {
        String methodName = "findCustomerByPrimaryKeyForUpdate";
        logger.logp(Level.FINE, className, methodName, "we are to find customer: " + custID);
        CustomerLocal customer = null;
        try {
            customer = customerHome.findByPrimaryKeyForUpdate(custID);
            if (customer == null) {
                logger.logp(Level.FINE, className, methodName, "null customer: " + custID);
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, "exception finding " + custID + ": " + e.getMessage());
            e.printStackTrace();
        }
        return customer;
    }

    public static CustomerInfoLocal findCustomerInfoByPrimaryKey(String custID) {
        String methodName = "findCustomerInfoByPrimaryKey";
        CustomerInfoLocal customerInfo = null;
        try {
            customerInfo = customerInfoHome.findByPrimaryKey(custID);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return customerInfo;
    }

    public static InventoryLocal findInventoryByPrimaryKey(String itemID) {
        String methodName = "findInventoryByPrimaryKey";
        InventoryLocal inventory = null;
        try {
            inventory = inventoryHome.findByPrimaryKey(itemID);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return inventory;
    }

    public static MfgCategoryLocal findMfgCategoryByPrimaryKey(String mfgName, String itemID) {
        String methodName = "findMfgCategoryByPrimaryKey";
        MfgCategoryLocal mfgCategory = null;
        try {
            mfgCategory = mfgCategoryHome.findByPrimaryKey(new MfgCategoryKey(mfgName, itemID));
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return mfgCategory;
    }

    public static Iterator findAllCategories() {
        String methodName = "findAllCategories";
        Collection categories = null;
        try {
            categories = categoryHome.findAllCategories();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return categories == null ? null : categories.iterator();
    }

    public static Iterator findAllCustomers() {
        String methodName = "findAllCustomers";
        Collection customers = null;
        try {
            customers = customerHome.findAllCustomers();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return customers == null ? null : customers.iterator();
    }

    public static Iterator findAllMfgCategories() {
        String methodName = "findAllMfgCategories";
        Collection mfgCategories = null;
        try {
            mfgCategories = mfgCategoryHome.findAll();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return mfgCategories == null ? null : mfgCategories.iterator();
    }

    public static Iterator findAllInventory() {
        String methodName = "findAllInventory";
        Collection inventory = null;
        try {
            inventory = inventoryHome.findAllInventory();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return inventory == null ? null : inventory.iterator();
    }

    public static Iterator findAllStoreCredit() {
        String methodName = "findAllStoreCredit";
        Collection credits = null;
        try {
            credits = storeCreditHome.findAll();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return credits == null ? null : credits.iterator();
    }

    public static Iterator findInventoryByMfgName(String mfgName) {
        String methodName = "findInventoryByMfgName";
        Collection inventory = null;
        try {
            inventory = inventoryHome.findByMfgName(mfgName);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return inventory == null ? null : inventory.iterator();
    }

    public static Iterator findInventoryByCategoryMfgName(String category, String mfgName) {
        String methodName = "findInventoryByCategoryMfgName";
        Collection inventory = null;
        try {
            inventory = inventoryHome.findByCategoryMfgName(category, mfgName);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return inventory == null ? null : inventory.iterator();
    }

    public static Iterator findInventoryByCategory(String categoryName) {
        String methodName = "findInventoryByCategory";
        Collection inventory = null;
        try {
            inventory = inventoryHome.findByCategory(categoryName);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, e.getMessage());
            e.printStackTrace();
        }
        return inventory == null ? null : inventory.iterator();
    }
}

