/*******************************************************************************
 * Copyright (c) 2011,2022 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package test.context;

import java.io.File;

import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.runner.RunWith;

import com.ibm.websphere.simplicity.ShrinkHelper;

import componenttest.annotation.Server;
import componenttest.annotation.TestServlet;
import componenttest.custom.junit.runner.FATRunner;
import componenttest.rules.repeater.JakartaEE10Action;
import componenttest.rules.repeater.JakartaEE9Action;
import componenttest.rules.repeater.RepeatTests;
import componenttest.topology.impl.LibertyServer;
import componenttest.topology.utils.FATServletClient;
import test.context.app.ContextServiceTestServlet;

@RunWith(FATRunner.class)
public class ContextServiceTest extends FATServletClient {
    @ClassRule
    public static RepeatTests r = RepeatTests
                    .withoutModification()
                    .andWith(new JakartaEE9Action())
                    .andWith(new JakartaEE10Action());

    @Server("com.ibm.ws.context.fat.customproviders")
    @TestServlet(servlet = ContextServiceTestServlet.class, path = "contextbvt/ContextServiceTestServlet")
    public static LibertyServer server;

    @BeforeClass
    public static void setUp() throws Exception {
        WebArchive contextbvtApp = ShrinkWrap.create(WebArchive.class, "contextbvt.war")
                        .addPackage("test.context.app") //
                        .addAsWebInfResource(new File("test-applications/contextbvt/resources/WEB-INF/web.xml"));
        ShrinkHelper.exportDropinAppToServer(server, contextbvtApp);

        server.addInstalledAppForValidation("contextbvt");

        server.startServer();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        server.stopServer();
    }
}
