/*******************************************************************************
 * Copyright (c) 2006, 2021 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package com.ibm.ws.ejbcontainer.injection.mix.ejb;

import java.rmi.RemoteException;

import javax.ejb.EJBObject;

public interface SuperEnvInjectionEJBRemote extends EJBObject {
    /**
     * Verify Environment Injection (field or method) occurred properly.
     **/
    public String verifyEnvInjection(int testpoint) throws RemoteException;

    /**
     * Provides a means to destroy a SLSB. Should throw unchecked EJBException
     * 
     * @throws java.rmi.RemoteException
     */
    public void discardInstance() throws RemoteException;
}
