/*******************************************************************************
 * Copyright (c) 2012, 2023 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.cdi.extension.tests;

import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.Suite.SuiteClasses;

import com.ibm.ws.fat.util.FatLogHandler;

/**
 * Tests specific to cdi-1.2
 */
@RunWith(Suite.class)
@SuiteClasses({
                AppExtensionTest.class,
                CDI12ExtensionTest.class,
                CDI12ExtensionSPIConstructorExceptionTest.class,
                CDI12ExtensionSPITest.class,
                CDI12NoExtensionSPITest.class,
                CDI40ExtensionSPITest.class,
                DynamicBeanExtensionTest.class,
                ObserverTest.class,
                WeldDevModeTest.class})

public class FATSuite {

    /**
     * @see {@link FatLogHandler#generateHelpFile()}
     */
    @BeforeClass
    public static void setUp() {
        FatLogHandler.generateHelpFile();
    }

}
