/*******************************************************************************
 * Copyright (c) 2017, 2023 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package test.concurrent;

import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

import com.ibm.websphere.simplicity.ShrinkHelper;

import componenttest.annotation.Server;
import componenttest.custom.junit.runner.FATRunner;
import componenttest.topology.impl.LibertyServer;
import componenttest.topology.utils.FATServletClient;
import componenttest.topology.utils.HttpUtils;

@RunWith(FATRunner.class)
public class ShippingEstimateDemoTest extends FATServletClient {

    public static final String APP_NAME = "shipestimate";

    @Server("com.ibm.ws.concurrent.fat.demo")
    public static LibertyServer server;

    @BeforeClass
    public static void setUp() throws Exception {
        WebArchive app = ShrinkWrap.create(WebArchive.class, APP_NAME + ".war")
                        .addPackage("com.ibm.example");
        ShrinkHelper.exportDropinAppToServer(server, app);
        server.startServer();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        server.stopServer();
    }

    @Test
    public void testDemo() throws Exception {
        HttpUtils.findStringInReadyUrl(server, '/' + APP_NAME,
                                       "Shipping & Handling Calculator");
        HttpUtils.findStringInReadyUrl(server, '/' + APP_NAME + "?stateName=Minnesota&productName=Printer",
                                       "61.9");
        HttpUtils.findStringInReadyUrl(server, '/' + APP_NAME + "?stateName=North+Dakota&productName=Monitor",
                                       "169.0");
    }
}
