/*******************************************************************************
 * Copyright (c) 2023 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package com.ibm.ws.jaxws.namespacecheck.wsdl.mainservice;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.Holder;

import com.ibm.ws.jaxws.namespacecheck.wsdl.importedserviceschema.PersonType;
import com.ibm.ws.jaxws.namespacecheck.wsdl.mainserviceschema.NameSpaceCheckMessage;
import com.ibm.ws.jaxws.namespacecheck.wsdl.mainserviceschema.NameSpaceCheckResponseMessage;

/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.3.6
 * Generated source version: 2.2
 *
 */
@WebService(name = "NameSpaceCheckPortType", targetNamespace = "http://com/ibm/ws/jaxws/wsdl/MainService.wsdl")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@XmlSeeAlso({
              com.ibm.ws.jaxws.namespacecheck.wsdl.importedserviceschema.ObjectFactory.class,
              com.ibm.ws.jaxws.namespacecheck.wsdl.mainserviceschema.ObjectFactory.class
})
public interface NameSpaceCheckPortType {

    /**
     *
     * @param person
     * @param parameters
     * @return
     *         returns com.ibm.ws.jaxws.namespacecheck.wsdl.mainserviceschema.NameSpaceCheckResponseMessage
     * @throws CustomFaultDetail
     */
    @WebMethod(operationName = "NameSpaceCheck", action = "tns:NameSpaceCheck")
    @WebResult(name = "NameSpaceCheckResponse", targetNamespace = "http://com/ibm/ws/jaxws/wsdl/MainServiceSchema.xsd", partName = "result")
    public NameSpaceCheckResponseMessage nameSpaceCheck(
                                                        @WebParam(name = "NameSpaceCheck", targetNamespace = "http://com/ibm/ws/jaxws/wsdl/MainServiceSchema.xsd",
                                                                  partName = "parameters") NameSpaceCheckMessage parameters,
                                                        @WebParam(name = "CPerson", targetNamespace = "http://com/ibm/ws/jaxws/wsdl/ImportedServiceSchema.xsd", header = true,
                                                                  mode = WebParam.Mode.INOUT, partName = "person") Holder<PersonType> person) throws CustomFaultDetail;

}
