/*******************************************************************************
 * Copyright (c) 2021 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.samples.jaxws2;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;

/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6 in JDK 6
 * Generated source version: 2.1
 *
 */
@WebServiceClient(name = "SayHelloServiceOne", targetNamespace = "http://jaxws2.samples.ibm.com", wsdlLocation = "META-INF/resources/wsdl/SayHelloServiceOne.wsdl")
public class SayHelloServiceOne extends Service {

    private final static URL SAYHELLOSERVICEONE_WSDL_LOCATION;
    private final static Logger logger = Logger.getLogger(com.ibm.samples.jaxws2.SayHelloServiceOne.class.getName());

    static {
        URL url = null;
        try {
            URL baseUrl;
            baseUrl = com.ibm.samples.jaxws2.SayHelloServiceOne.class.getResource(".");
            url = new URL(baseUrl, "SayHelloServiceOne.wsdl");
        } catch (MalformedURLException e) {
            logger.warning("Failed to create URL for the wsdl Location: 'SayHelloServiceOne.wsdl', retrying as a local file");
            logger.warning(e.getMessage());
        }
        SAYHELLOSERVICEONE_WSDL_LOCATION = url;
    }

    public SayHelloServiceOne(URL wsdlLocation, QName serviceName) {
        super(wsdlLocation, serviceName);
    }

    public SayHelloServiceOne() {
        super(SAYHELLOSERVICEONE_WSDL_LOCATION, new QName("http://jaxws2.samples.ibm.com", "SayHelloServiceOne"));
    }

    /**
     *
     * @return
     *         returns SayHello
     */
    @WebEndpoint(name = "SayHelloImplOnePort")
    public SayHello getSayHelloImplOnePort() {
        return super.getPort(new QName("http://jaxws2.samples.ibm.com", "SayHelloImplOnePort"), SayHello.class);
    }

    /**
     *
     * @param features
     *                     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy. Supported features not in the <code>features</code> parameter will have their
     *                     default
     *                     values.
     * @return
     *         returns SayHello
     */
    @WebEndpoint(name = "SayHelloImplOnePort")
    public SayHello getSayHelloImplOnePort(WebServiceFeature... features) {
        return super.getPort(new QName("http://jaxws2.samples.ibm.com", "SayHelloImplOnePort"), SayHello.class, features);
    }

}
