
--CONNECT 'jdbc:derby:BatchDB;create=true';

SET CURRENT SCHEMA = JBATCH;

-- ----------------------------------------------
-- DDL Statements for schemas. Replacing existing Batch table with modified identity.
-- ----------------------------------------------
ALTER TABLE "REMOTABLEPARTITON" DROP FOREIGN KEY "RMTBLPRTFKSTPXCTND";
ALTER TABLE "REMOTABLEPARTITON" DROP FOREIGN KEY "RMTBLPRTTFKJBXCTND";
ALTER TABLE "STEPTHREADEXECUTION" DROP FOREIGN KEY "STPTHRDXCTNFKJBXCD";
ALTER TABLE "JOBPARAMETER" DROP FOREIGN KEY "JBPRMETERFKJBXECID";
ALTER TABLE "JOBEXECUTION" DROP FOREIGN KEY "JBXCTNFKJBNSTNCEID";
ALTER TABLE "GROUPASSOCIATION" DROP FOREIGN KEY "GRPSSCTNFKJBNSTNCD";
ALTER TABLE "STEPTHREADINSTANCE" DROP FOREIGN KEY "STPTHRDNFKJBNSTNCD";
ALTER TABLE "STEPTHREADEXECUTION" DROP FOREIGN KEY "STPTHFKTPLVLSTPXCD";
ALTER TABLE "STEPTHREADINSTANCE" DROP FOREIGN KEY "STPTHRFKLTSTSTPXCD";
ALTER TABLE "JOBEXECUTION" DROP PRIMARY KEY;
ALTER TABLE "JOBINSTANCE" DROP PRIMARY KEY;
ALTER TABLE "STEPTHREADEXECUTION" DROP PRIMARY KEY;
ALTER TABLE "STEPTHREADEXECUTION" DROP UNIQUE "STPTHRADEXECUTION0";
ALTER TABLE "STEPTHREADINSTANCE" DROP PRIMARY KEY;
DROP TABLE "REMOTABLEPARTITION";
DROP TABLE "JOBEXECUTION";
DROP TABLE "JOBINSTANCE";
DROP TABLE "STEPTHREADEXECUTION";
DROP TABLE "STEPTHREADINSTANCE";
DROP TABLE "JOBPARAMETER";
DROP TABLE "GROUPASSOCIATION";

DROP SCHEMA "JBATCH" RESTRICT;
-- ----------------------------------------------
-- DDL Statements for schemas
-- ----------------------------------------------

CREATE SCHEMA "JBATCH";

-- ----------------------------------------------
-- DDL Statements for tables
-- ----------------------------------------------

CREATE TABLE "JBATCH"."STEPTHREADEXECUTION" ("STEPEXECID" BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH -1, INCREMENT BY 1), "THREADTYPE" VARCHAR(31), "BATCHSTATUS" INTEGER NOT NULL, "M_COMMIT" BIGINT NOT NULL, "ENDTIME" TIMESTAMP, "EXITSTATUS" VARCHAR(512), "M_FILTER" BIGINT NOT NULL, "INTERNALSTATUS" INTEGER NOT NULL, "PARTNUM" INTEGER NOT NULL, "USERDATA" BLOB(2147483647), "M_PROCESSSKIP" BIGINT NOT NULL, "M_READ" BIGINT NOT NULL, "M_READSKIP" BIGINT NOT NULL, "M_ROLLBACK" BIGINT NOT NULL, "STARTTIME" TIMESTAMP, "STEPNAME" VARCHAR(128) NOT NULL, "M_WRITE" BIGINT NOT NULL, "M_WRITESKIP" BIGINT NOT NULL, "FK_JOBEXECID" BIGINT NOT NULL, "FK_TOPLVL_STEPEXECID" BIGINT, "ISPARTITIONEDSTEP" SMALLINT DEFAULT 0);

CREATE TABLE "JBATCH"."JOBINSTANCE" ("JOBINSTANCEID" BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY, "AMCNAME" VARCHAR(512), "BATCHSTATUS" INTEGER NOT NULL, "CREATETIME" TIMESTAMP NOT NULL, "EXITSTATUS" VARCHAR(512), "INSTANCESTATE" INTEGER NOT NULL, "JOBNAME" VARCHAR(256), "JOBXMLNAME" VARCHAR(128), "JOBXML" BLOB(2147483647), "UPDATETIME" TIMESTAMP, "NUMEXECS" INTEGER NOT NULL, "RESTARTON" VARCHAR(128), "SUBMITTER" VARCHAR(256));

CREATE TABLE "JBATCH"."STEPTHREADINSTANCE" ("PARTNUM" INTEGER NOT NULL, "STEPNAME" VARCHAR(128) NOT NULL, "THREADTYPE" VARCHAR(31), "CHECKPOINTDATA" BLOB(2147483647), "FK_JOBINSTANCEID" BIGINT NOT NULL, "FK_LATEST_STEPEXECID" BIGINT NOT NULL, "PARTITIONED" SMALLINT NOT NULL DEFAULT 0, "PARTITIONPLANSIZE" INTEGER, "STARTCOUNT" INTEGER);

CREATE TABLE "JBATCH"."JOBEXECUTION" ("JOBEXECID" BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH -1, INCREMENT BY 1), "BATCHSTATUS" INTEGER NOT NULL, "CREATETIME" TIMESTAMP NOT NULL, "ENDTIME" TIMESTAMP, "EXECNUM" INTEGER NOT NULL, "EXITSTATUS" VARCHAR(512), "JOBPARAMETERS" BLOB(2147483647), "UPDATETIME" TIMESTAMP, "LOGPATH" VARCHAR(512), "RESTURL" VARCHAR(512), "SERVERID" VARCHAR(256), "STARTTIME" TIMESTAMP, "FK_JOBINSTANCEID" BIGINT NOT NULL);

CREATE TABLE "JBATCH"."JOBPARAMETER" ("NAME" VARCHAR(255), "VALUE" VARCHAR(255), "FK_JOBEXECID" BIGINT);

CREATE TABLE "JBATCH"."REMOTABLEPARTITION" (
    "PARTNUM" INTEGER NOT NULL,
    "STEPNAME" VARCHAR(255) NOT NULL,
    "INTERNALSTATE" INTEGER,
    "LASTUPDATED" TIMESTAMP,
    "LOGPATH" VARCHAR(512),
    "RESTURL" VARCHAR(512),
    "SERVERID" VARCHAR(256),
    "FK_JOBEXECUTIONID" BIGINT NOT NULL,
    "FK_STEPEXECUTIONID" BIGINT,
    PRIMARY KEY (
    "PARTNUM", "STEPNAME", "FK_JOBEXECUTIONID"));

-- ----------------------------------------------
-- DDL Statements for keys
-- ----------------------------------------------

-- PRIMARY/UNIQUE
ALTER TABLE "JBATCH"."STEPTHREADINSTANCE" ADD CONSTRAINT "SQL160428093053700" PRIMARY KEY ("PARTNUM", "STEPNAME", "FK_JOBINSTANCEID");

ALTER TABLE "JBATCH"."STEPTHREADEXECUTION" ADD CONSTRAINT "SQL160428093053820" PRIMARY KEY ("STEPEXECID");

ALTER TABLE "JBATCH"."STEPTHREADEXECUTION" ADD CONSTRAINT "STPTHRADEXECUTION0" UNIQUE ("FK_JOBEXECID", "STEPNAME", "PARTNUM");

ALTER TABLE "JBATCH"."JOBINSTANCE" ADD CONSTRAINT "SQL160428093053860" PRIMARY KEY ("JOBINSTANCEID");

ALTER TABLE "JBATCH"."JOBEXECUTION" ADD CONSTRAINT "SQL160428093053780" PRIMARY KEY ("JOBEXECID");

-- FOREIGN
ALTER TABLE "JBATCH"."STEPTHREADINSTANCE" ADD CONSTRAINT "STPTHRFKLTSTSTPXCD" FOREIGN KEY ("FK_LATEST_STEPEXECID") REFERENCES "JBATCH"."STEPTHREADEXECUTION" ("STEPEXECID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "JBATCH"."STEPTHREADINSTANCE" ADD CONSTRAINT "STPTHRDNFKJBNSTNCD" FOREIGN KEY ("FK_JOBINSTANCEID") REFERENCES "JBATCH"."JOBINSTANCE" ("JOBINSTANCEID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "JBATCH"."STEPTHREADEXECUTION" ADD CONSTRAINT "STPTHFKTPLVLSTPXCD" FOREIGN KEY ("FK_TOPLVL_STEPEXECID") REFERENCES "JBATCH"."STEPTHREADEXECUTION" ("STEPEXECID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "JBATCH"."STEPTHREADEXECUTION" ADD CONSTRAINT "STPTHRDXCTNFKJBXCD" FOREIGN KEY ("FK_JOBEXECID") REFERENCES "JBATCH"."JOBEXECUTION" ("JOBEXECID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "JBATCH"."JOBEXECUTION" ADD CONSTRAINT "JBXCTNFKJBNSTNCEID" FOREIGN KEY ("FK_JOBINSTANCEID") REFERENCES "JBATCH"."JOBINSTANCE" ("JOBINSTANCEID") ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "JBATCH"."JOBPARAMETER" ADD CONSTRAINT "JBPRMETERFKJBXECID" FOREIGN KEY ("FK_JOBEXECID") REFERENCES "JBATCH"."JOBEXECUTION" ("JOBEXECID")  ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE "JBATCH"."REMOTABLEPARTITION"
    ADD CONSTRAINT "RMTBLPRTFKSTPXCTND"
    FOREIGN KEY ("FK_STEPEXECUTIONID")
    REFERENCES "JBATCH"."STEPTHREADEXECUTION" ("STEPEXECID");

ALTER TABLE "JBATCH"."REMOTABLEPARTITION"
    ADD CONSTRAINT "RMTBLPRTTFKJBXCTND"
    FOREIGN KEY ("FK_JOBEXECUTIONID")
    REFERENCES "JBATCH"."JOBEXECUTION" ("JOBEXECID");
