/*******************************************************************************
 * Copyright (c) 2003, 2022 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package com.ibm.adapter;

/**
 * This class represents the connection handle states. A connection handle can
 * be in one of the following three states: active, inactive and closed.<p>
 */
public interface HandleStates {
    /** Connection handle state constants. */
    public static final int ACTIVE = 0,
                    INACTIVE = 1,
                    CLOSED = 2;

    /** List of Connection handle state names. */
    public static final String[] STATE_STRINGS = new String[] { "ACTIVE", "INACTIVE", "CLOSED" };

}
