CREATE TABLE ${schemaname}.JPA2Address (street VARCHAR2(30) NOT NULL, city VARCHAR2(255), state VARCHAR2(255), plusFour VARCHAR2(4), zip VARCHAR2(5), PRIMARY KEY (street));
CREATE TABLE ${schemaname}.JPA2Person (id NUMBER NOT NULL, age NUMBER, firstName VARCHAR2(20), lastName VARCHAR2(20), PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPAAddressBean (street VARCHAR2(40) NOT NULL, city VARCHAR2(30), state VARCHAR2(20), zip VARCHAR2(10), PRIMARY KEY (street));
CREATE TABLE ${schemaname}.JPACustomerPartTab (id NUMBER NOT NULL, name VARCHAR2(40), rating NUMBER, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPADeptBean (deptno NUMBER NOT NULL, budget REAL, name VARCHAR2(40), charityAmount NUMBER, charityName VARCHAR2(40), MGR_EMPID NUMBER, REPORTSTO_DEPTNO NUMBER, PRIMARY KEY (deptno));
CREATE TABLE ${schemaname}.JPAEmpBean (empid NUMBER NOT NULL, bonus NUMBER, execLevel CHAR, hireDate DATE, hireTime DATE, hireTimestamp TIMESTAMP, isManager NUMBER, name VARCHAR2(40), rating NUMBER, salary NUMBER, DEPT_DEPTNO NUMBER, HOME_STREET VARCHAR2(255), WORK_STREET VARCHAR2(255), PRIMARY KEY (empid));
CREATE TABLE ${schemaname}.JPALineItemPartTab (lid NUMBER NOT NULL, cost NUMBER, quantity NUMBER, ORDER_OID NUMBER, PRODUCT_PID NUMBER, PRIMARY KEY (lid));
CREATE TABLE ${schemaname}.JPAOrderPartTab (oid NUMBER NOT NULL, amount NUMBER, delivered NUMBER, CUSTOMER_ID NUMBER, PRIMARY KEY (oid));
CREATE TABLE ${schemaname}.JPAPartTab (partno NUMBER NOT NULL, name VARCHAR2(40), PARTTYPE VARCHAR2(31), assemblyCost NUMBER, massIncrement NUMBER, cost NUMBER, mass NUMBER, PRIMARY KEY (partno));
CREATE TABLE ${schemaname}.JPAProductPartTab (pid NUMBER NOT NULL, backorder NUMBER, description VARCHAR2(40), inventory NUMBER, SUPPLIER_ID NUMBER, PRIMARY KEY (pid));
CREATE TABLE ${schemaname}.JPAProjectBean (projid NUMBER NOT NULL, budget NUMBER, cost NUMBER, description VARCHAR2(40), durationDays NUMBER, name VARCHAR2(40), personMonths NUMBER, startTime NUMBER, DEPT_DEPTNO NUMBER, PRIMARY KEY (projid));
CREATE TABLE ${schemaname}.JPASupplierPartTab (sid NUMBER NOT NULL, name VARCHAR2(40), PRIMARY KEY (sid));
CREATE TABLE ${schemaname}.JPASupplierPartTab_JPAPartTab (SUPPLIERS_SID NUMBER, SUPPLIES_PARTNO NUMBER);
CREATE TABLE ${schemaname}.JPATaskBean (taskid NUMBER NOT NULL, cost NUMBER, description VARCHAR2(40), name VARCHAR2(40), PROJECT_PROJID NUMBER, PRIMARY KEY (taskid));
CREATE TABLE ${schemaname}.JPATaskBean_JPAEmpBean (TASKS_TASKID NUMBER, EMPS_EMPID NUMBER);
CREATE TABLE ${schemaname}.JPATypeTestBean (id NUMBER NOT NULL, ageofUniverse NUMBER, bigbytes BLOB, busPass BLOB, deficitUSA NUMBER, i1 NUMBER, i2 NUMBER, i4 NUMBER, i8 NUMBER, iboolean NUMBER, ibytes BLOB, ic NUMBER, ichars VARCHAR2(255), idouble NUMBER, ifloat REAL, name VARCHAR2(255), o1 NUMBER, o2 NUMBER, o4 NUMBER, o8 NUMBER, oboolean NUMBER, obytes BLOB, oc NUMBER, ochars VARCHAR2(255), odouble NUMBER, ofloat REAL, payScale VARCHAR2(20), sdate DATE, status NUMBER, stime DATE, stimestamp TIMESTAMP, ucalendar TIMESTAMP, udate TIMESTAMP, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPAUsagePartTab (id NUMBER NOT NULL, quantity NUMBER, CHILD_PARTNO NUMBER, PARENT_PARTNO NUMBER, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPAXYZ (id NUMBER NOT NULL, age NUMBER, firstName VARCHAR2(20), lastName VARCHAR2(20), PRIMARY KEY (id));
CREATE TABLE ${schemaname}.Person_residences (PERSON_ID NUMBER, street VARCHAR2(30), city VARCHAR2(255), state VARCHAR2(255), plusFour VARCHAR2(4), zip VARCHAR2(5));

CREATE TABLE ${schemaname}.JPAXMLAddressBean (street VARCHAR2(40) NOT NULL, city VARCHAR2(30), state VARCHAR2(20), zip VARCHAR2(10), PRIMARY KEY (street));
CREATE TABLE ${schemaname}.JPAXMLCustomerPartTab (id NUMBER NOT NULL, name VARCHAR2(40), rating NUMBER, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPAXMLDeptBean (deptno NUMBER NOT NULL, budget REAL, name VARCHAR2(40), MGR_EMPID integer, charityAmount NUMBER, charityName VARCHAR2(40), REPORTSTO_DEPTNO NUMBER, PRIMARY KEY (deptno));
CREATE TABLE ${schemaname}.JPAXMLEmpBean (empid integer NOT NULL, bonus NUMBER, execLevel CHAR, hireDate DATE, hireTime DATE, hireTimestamp TIMESTAMP, isManager NUMBER, name VARCHAR2(40), rating NUMBER, salary NUMBER, DEPT_DEPTNO NUMBER, HOME_STREET VARCHAR2(255), WORK_STREET VARCHAR2(255), PRIMARY KEY (empid));
CREATE TABLE ${schemaname}.JPAXMLLineItemPartTab (lid NUMBER NOT NULL, cost NUMBER, quantity NUMBER, PRODUCT_PID NUMBER, ORDER_OID NUMBER, PRIMARY KEY (lid));
CREATE TABLE ${schemaname}.JPAXMLOrderPartTab (oid NUMBER NOT NULL, amount NUMBER, delivered NUMBER, CUSTOMER_ID NUMBER, PRIMARY KEY (oid));
CREATE TABLE ${schemaname}.JPAXMLPartTab (partno NUMBER NOT NULL, name VARCHAR2(40), XMLPARTTYPE VARCHAR2(255), assemblyCost NUMBER, massIncrement NUMBER, cost NUMBER, mass NUMBER, PRIMARY KEY (partno));
CREATE TABLE ${schemaname}.JPAXMLProductPartTab (pid NUMBER NOT NULL, backorder NUMBER, description VARCHAR2(40), inventory NUMBER, SUPPLIER_ID NUMBER, PRIMARY KEY (pid));
CREATE TABLE ${schemaname}.JPAXMLProjectBean (projid integer NOT NULL, budget NUMBER, cost NUMBER, description VARCHAR2(40), durationDays NUMBER, name VARCHAR2(40), personMonths NUMBER, startTime NUMBER, DEPT_DEPTNO NUMBER, PRIMARY KEY (projid));
CREATE TABLE ${schemaname}.JPAXMLSupplierPartTab (sid NUMBER NOT NULL, name VARCHAR2(40), PRIMARY KEY (sid));
CREATE TABLE ${schemaname}.JPAXMLSUPPLIERPARTTAB_JPAXMLPA (SUPPLIERS_SID NUMBER, SUPPLIES_PARTNO NUMBER);
CREATE TABLE ${schemaname}.JPAXMLTaskBean (taskid NUMBER NOT NULL, cost NUMBER, description VARCHAR2(40), name VARCHAR2(40), PROJECT_PROJID integer, PRIMARY KEY (taskid));
CREATE TABLE ${schemaname}.JPAXMLTaskBean_JPAXMLEmpBean (TASKS_TASKID NUMBER, EMPS_EMPID integer);
CREATE TABLE ${schemaname}.JPAXMLTypeTestBean (id NUMBER NOT NULL, ageofUniverse NUMBER, bigbytes BLOB, busPass BLOB, deficitUSA NUMBER, i1 NUMBER, i2 NUMBER, i4 NUMBER, i8 NUMBER, iboolean NUMBER, ibytes BLOB, ic NUMBER, ichars VARCHAR2(255), idouble NUMBER, ifloat REAL, name VARCHAR2(255), o1 NUMBER, o2 NUMBER, o4 NUMBER, o8 NUMBER, oboolean NUMBER, obytes BLOB, oc NUMBER, ochars VARCHAR2(255), odouble NUMBER, ofloat REAL, payScale VARCHAR2(20), sdate DATE, status NUMBER, stime DATE, stimestamp TIMESTAMP, ucalendar TIMESTAMP, udate TIMESTAMP, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPAXMLUsageparttab (id NUMBER NOT NULL, quantity NUMBER, CHILD_PARTNO NUMBER, PARENT_PARTNO NUMBER, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPAXMLXYZ (id NUMBER NOT NULL, age NUMBER, firstName VARCHAR2(20), lastName VARCHAR2(20), PRIMARY KEY (id));

CREATE INDEX ${schemaname}.I_JPDPTBN_MGR ON ${schemaname}.JPADeptBean (MGR_EMPID);
CREATE INDEX ${schemaname}.I_JPDPTBN_REPORTSTO ON ${schemaname}.JPADeptBean (REPORTSTO_DEPTNO);
CREATE INDEX ${schemaname}.I_JPMPBEN_DEPT ON ${schemaname}.JPAEmpBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPMPBEN_HOME ON ${schemaname}.JPAEmpBean (HOME_STREET);
CREATE INDEX ${schemaname}.I_JPMPBEN_WORK ON ${schemaname}.JPAEmpBean (WORK_STREET);
CREATE INDEX ${schemaname}.I_JPLNTTB_ORDER ON ${schemaname}.JPALineItemPartTab (ORDER_OID);
CREATE INDEX ${schemaname}.I_JPLNTTB_PRODUCT ON ${schemaname}.JPALineItemPartTab (PRODUCT_PID);
CREATE INDEX ${schemaname}.I_JPRDTTB_CUSTOMER ON ${schemaname}.JPAOrderPartTab (CUSTOMER_ID);
CREATE INDEX ${schemaname}.I_JPPRTTB_DTYPE ON ${schemaname}.JPAPartTab (PARTTYPE);
CREATE INDEX ${schemaname}.I_JPPRTTB_SUPPLIER ON ${schemaname}.JPAProductPartTab (SUPPLIER_ID);
CREATE INDEX ${schemaname}.I_JPPRTBN_DEPT ON ${schemaname}.JPAProjectBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPSPTTB_ELEMENT ON ${schemaname}.JPASupplierPartTab_JPAPartTab (SUPPLIES_PARTNO);
CREATE INDEX ${schemaname}.I_JPSPTTB_SUPPLIERS_SID ON ${schemaname}.JPASupplierPartTab_JPAPartTab (SUPPLIERS_SID);
CREATE INDEX ${schemaname}.I_JPTSKBN_PROJECT ON ${schemaname}.JPATaskBean (PROJECT_PROJID);
CREATE INDEX ${schemaname}.I_JPTSPBN_ELEMENT ON ${schemaname}.JPATaskBean_JPAEmpBean (EMPS_EMPID);
CREATE INDEX ${schemaname}.I_JPTSPBN_TASKS_TASKID ON ${schemaname}.JPATaskBean_JPAEmpBean (TASKS_TASKID);
CREATE INDEX ${schemaname}.I_JPSGTTB_CHILD ON ${schemaname}.JPAUsagePartTab (CHILD_PARTNO);
CREATE INDEX ${schemaname}.I_JPSGTTB_PARENT ON ${schemaname}.JPAUsagePartTab (PARENT_PARTNO);
CREATE INDEX ${schemaname}.I_PRSNNCS_PERSON_ID ON ${schemaname}.Person_residences (PERSON_ID);

CREATE INDEX ${schemaname}.I_JPXMTBN_MGR ON ${schemaname}.JPAXMLDeptBean (MGR_EMPID);
CREATE INDEX ${schemaname}.I_JPXMTBN_REPORTSTO ON ${schemaname}.JPAXMLDeptBean (REPORTSTO_DEPTNO);
CREATE INDEX ${schemaname}.I_JPXMPBN_DEPT ON ${schemaname}.JPAXMLEmpBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPXMPBN_HOME ON ${schemaname}.JPAXMLEmpBean (HOME_STREET);
CREATE INDEX ${schemaname}.I_JPXMPBN_WORK ON ${schemaname}.JPAXMLEmpBean (WORK_STREET);
CREATE INDEX ${schemaname}.I_JPXMTTB_ORDER ON ${schemaname}.JPAXMLLineItemPartTab (ORDER_OID);
CREATE INDEX ${schemaname}.I_JPXMTTB_PRODUCT ON ${schemaname}.JPAXMLLineItemPartTab (PRODUCT_PID);
CREATE INDEX ${schemaname}.I_JPXMTTB_CUSTOMER ON ${schemaname}.JPAXMLOrderPartTab (CUSTOMER_ID);
CREATE INDEX ${schemaname}.I_JPXMTTB_DTYPE ON ${schemaname}.JPAXMLPartTab (XMLPARTTYPE);
CREATE INDEX ${schemaname}.I_JPXMTTB_SUPPLIER ON ${schemaname}.JPAXMLProductPartTab (SUPPLIER_ID);
CREATE INDEX ${schemaname}.I_JPXMTBN_DEPT ON ${schemaname}.JPAXMLProjectBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPXMMLP_ELEMENT ON ${schemaname}.JPAXMLSUPPLIERPARTTAB_JPAXMLPA (SUPPLIES_PARTNO);
CREATE INDEX ${schemaname}.I_JPXMMLP_SUPPLIERS_SID ON ${schemaname}.JPAXMLSUPPLIERPARTTAB_JPAXMLPA (SUPPLIERS_SID);
CREATE INDEX ${schemaname}.I_JPXMKBN_PROJECT ON ${schemaname}.JPAXMLTaskBean (PROJECT_PROJID);
CREATE INDEX ${schemaname}.I_JPXMPBN_ELEMENT ON ${schemaname}.JPAXMLTaskBean_JPAXMLEmpBean (EMPS_EMPID);
CREATE INDEX ${schemaname}.I_JPXMPBN_TASKS_TASKID ON ${schemaname}.JPAXMLTaskBean_JPAXMLEmpBean (TASKS_TASKID);
CREATE INDEX ${schemaname}.I_JPXMTTB_CHILD ON ${schemaname}.JPAXMLUsageparttab (CHILD_PARTNO);
CREATE INDEX ${schemaname}.I_JPXMTTB_PARENT ON ${schemaname}.JPAXMLUsageparttab (PARENT_PARTNO);
