/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Local;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerBean;
import org.rhq.enterprise.server.alert.AlertManagerBean;
import org.rhq.enterprise.server.auth.SubjectManagerBean;
import org.rhq.enterprise.server.authz.RoleManagerBean;
import org.rhq.enterprise.server.configuration.ConfigurationManagerBean;
import org.rhq.enterprise.server.content.AdvisoryManagerBean;
import org.rhq.enterprise.server.content.ContentManagerBean;
import org.rhq.enterprise.server.content.DistributionManagerBean;
import org.rhq.enterprise.server.content.RepoManagerBean;
import org.rhq.enterprise.server.event.EventManagerBean;
import org.rhq.enterprise.server.measurement.AvailabilityManagerBean;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementProblemManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerBean;
import org.rhq.enterprise.server.operation.OperationManagerBean;
import org.rhq.enterprise.server.report.DataAccessManagerBean;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerBean;
import org.rhq.enterprise.server.resource.ResourceManagerBean;
import org.rhq.enterprise.server.resource.ResourceTypeManagerBean;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerBean;
import org.rhq.enterprise.server.support.SupportManagerBean;
import org.rhq.enterprise.server.system.SystemManagerBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteAPIValidator {
    private static Class<?>[] beans = new Class[]{AdvisoryManagerBean.class, AlertDefinitionManagerBean.class, AlertManagerBean.class, AvailabilityManagerBean.class, CallTimeDataManagerBean.class, RepoManagerBean.class, ConfigurationManagerBean.class, ContentManagerBean.class, DataAccessManagerBean.class, DistributionManagerBean.class, EventManagerBean.class, MeasurementBaselineManagerBean.class, MeasurementDataManagerBean.class, MeasurementDefinitionManagerBean.class, MeasurementProblemManagerBean.class, MeasurementScheduleManagerBean.class, OperationManagerBean.class, ResourceFactoryManagerBean.class, ResourceGroupManagerBean.class, ResourceManagerBean.class, ResourceTypeManagerBean.class, RoleManagerBean.class, SubjectManagerBean.class, SupportManagerBean.class, SystemManagerBean.class};
    private static Set<String> finderMethodExceptions = new HashSet<String>();

    public static void validateAll() {
        int classesInError = 0;
        int totalErrors = 0;
        for (Class<?> managerBean : beans) {
            List<String> errors = RemoteAPIValidator.validate(managerBean);
            if (errors.isEmpty()) continue;
            ++classesInError;
            totalErrors += errors.size();
            for (String error : errors) {
                System.out.println(error);
            }
            System.out.println();
        }
        System.out.println(String.valueOf(beans.length) + " classes checked, " + classesInError + " in error");
        System.out.println(String.valueOf(totalErrors) + " total errors");
    }

    public static List<String> validate(Class<?> managerBean) {
        Method[] managerBeanMethods;
        String methodName;
        Method[] remoteMethods;
        ArrayList<String> errors = new ArrayList<String>();
        Class<?>[] interfaces = managerBean.getInterfaces();
        if (interfaces.length != 2) {
            errors.add(managerBean.getSimpleName() + " had " + interfaces.length + " interfaces, was expecting 2");
        }
        Class<?> localInterface = null;
        Class<?> remoteInterface = null;
        if (interfaces[0].getAnnotation(Local.class) != null) {
            localInterface = interfaces[0];
            remoteInterface = interfaces[1];
        } else {
            remoteInterface = interfaces[0];
            localInterface = interfaces[1];
        }
        WebService webService = remoteInterface.getAnnotation(WebService.class);
        if (webService == null) {
            errors.add(remoteInterface.getSimpleName() + ", missing @WebService class annotation");
        }
        for (Method remoteMethod : remoteMethods = remoteInterface.getMethods()) {
            WebMethod webMethod = remoteMethod.getAnnotation(WebMethod.class);
            if (webMethod == null) {
                errors.add(RemoteAPIValidator.format(remoteMethod) + ", missing @WebMethod method annotation");
            }
            methodName = remoteMethod.getName();
            Class<?>[] parameterTypes = remoteMethod.getParameterTypes();
            try {
                Class<?>[] remoteExceptions;
                Method localMethod = localInterface.getMethod(methodName, parameterTypes);
                Method managerBeanMethod = managerBean.getMethod(methodName, parameterTypes);
                Class<?>[] localExceptions = localMethod.getExceptionTypes();
                Class<?>[] managerBeanExceptions = managerBeanMethod.getExceptionTypes();
                for (Class<?> remoteException : remoteExceptions = remoteMethod.getExceptionTypes()) {
                    boolean found = false;
                    for (Class<?> localException : localExceptions) {
                        if (!remoteException.equals(localException)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        errors.add(RemoteAPIValidator.format(remoteMethod) + ", local method does not throw " + remoteException.getSimpleName());
                    }
                    for (Class<?> managerBeanException : managerBeanExceptions) {
                        if (!remoteException.equals(managerBeanException)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    errors.add(RemoteAPIValidator.format(remoteMethod) + ", manager bean method does not throw " + remoteException.getSimpleName());
                }
            }
            catch (NoSuchMethodException nsme) {
                errors.add(RemoteAPIValidator.format(remoteMethod) + ", method not found in the local interface");
            }
            RemoteAPIValidator.validateTypeParameter(remoteMethod, 0, Subject.class, "subject", errors);
            RemoteAPIValidator.validateTypeParameter(remoteMethod, parameterTypes.length - 1, PageControl.class, "pageControl", errors);
        }
        for (Method managerBeanMethod : managerBeanMethods = managerBean.getMethods()) {
            methodName = managerBeanMethod.getName();
            Class returnType = managerBeanMethod.getReturnType();
            if (!returnType.isAssignableFrom(List.class) && !returnType.isAssignableFrom(PageList.class) || methodName.startsWith("find") || finderMethodExceptions.contains(methodName)) continue;
            errors.add(RemoteAPIValidator.format(managerBeanMethod) + ", bean method returning a List must begin with 'find'");
        }
        return errors;
    }

    private static void validateTypeParameter(Method remoteMethod, int parameterIndex, Class<?> expectedParameterType, String namingConvention, List<String> errors) {
        Class<?> parameterType;
        int parameterCount = remoteMethod.getParameterTypes().length;
        if (parameterCount == 0) {
            return;
        }
        if (parameterIndex < 0 || parameterIndex > parameterCount - 1) {
            errors.add(RemoteAPIValidator.format(remoteMethod) + ", parameterIndex was " + parameterIndex + " but only had " + parameterCount + " arguments");
        }
        if (!(parameterType = remoteMethod.getParameterTypes()[parameterIndex]).equals(expectedParameterType)) {
            return;
        }
        Annotation[] parameterAnnotations = remoteMethod.getParameterAnnotations()[parameterIndex];
        WebParam webParam = null;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            if (!(parameterAnnotations[i] instanceof WebParam)) continue;
            webParam = (WebParam)parameterAnnotations[i];
            break;
        }
        if (webParam == null) {
            errors.add(RemoteAPIValidator.format(remoteMethod) + ", missing @WebParam parameter annotation for " + parameterType.getSimpleName());
            return;
        }
        String name = webParam.name();
        if (!name.equals(namingConvention)) {
            errors.add(RemoteAPIValidator.format(remoteMethod) + ", convention should be @WebParam(name = \"" + namingConvention + "\")");
        }
    }

    private static String format(Method method) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getDeclaringClass().getSimpleName()).append('.');
        builder.append(method.getName()).append("(");
        boolean first = true;
        for (Class<?> parameterType : method.getParameterTypes()) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(parameterType.getSimpleName());
        }
        builder.append(")");
        return builder.toString();
    }

    public static void main(String[] args) {
        RemoteAPIValidator.validateAll();
    }

    static {
        finderMethodExceptions.add("translateInstallationSteps");
        finderMethodExceptions.add("getResourceNameOptionItems");
        finderMethodExceptions.add("getResourceLineage");
        finderMethodExceptions.add("getResourceIdLineage");
        finderMethodExceptions.add("deleteResources");
        finderMethodExceptions.add("deleteResource");
        finderMethodExceptions.add("executeQuery");
        finderMethodExceptions.add("executeQueryWithPageControl");
    }
}

