/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective.activator;

import java.util.EnumSet;
import java.util.List;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.perspective.activator.AbstractGlobalActivator;
import org.rhq.enterprise.server.perspective.activator.ActivatorHelper;
import org.rhq.enterprise.server.perspective.activator.ResourceConditionSet;
import org.rhq.enterprise.server.perspective.activator.context.GlobalActivationContext;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InventoryActivator
extends AbstractGlobalActivator {
    static final long serialVersionUID = 1L;
    private List<ResourceConditionSet> resourceConditionSets;

    public InventoryActivator(List<ResourceConditionSet> resourceConditionSets) {
        this.resourceConditionSets = resourceConditionSets;
    }

    @Override
    public boolean isActive(GlobalActivationContext context) {
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        Subject subject = context.getSubject();
        for (ResourceConditionSet rcs : this.resourceConditionSets) {
            PageList<Resource> resources;
            ResourceCriteria criteria = new ResourceCriteria();
            criteria.addFilterPluginName(rcs.getPluginName());
            criteria.addFilterResourceTypeName(rcs.getResourceTypeName());
            EnumSet<Permission> requiredPermissions = rcs.getPermissions();
            if (null != requiredPermissions && !requiredPermissions.isEmpty()) {
                Permission[] arr = requiredPermissions.toArray(new Permission[requiredPermissions.size()]);
                criteria.addRequiredPermissions(arr);
            }
            if (null == (resources = resourceManager.findResourcesByCriteria(context.getSubject(), criteria)) || resources.isEmpty()) continue;
            return ActivatorHelper.areTraitsSatisfied(subject, rcs.getTraitMatchers(), resources, false);
        }
        return false;
    }
}

