/*
 * RHQ Management Platform
 * Copyright (C) 2005-2008 Red Hat, Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.enterprise.gui.legacy.ParamConstants;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/**
 * An Action that retrieves data from the BizApp to facilitate display of the <em>Edit Metric Baseline</em> form.
 */
public class EditMetricBaselineFormPrepareAction extends BaseAction {
    private Log log = LogFactory.getLog(EditMetricBaselineFormPrepareAction.class.getName());

    // ---------------------------------------------------- Public Methods

    /**
     * Prepare the form for editing the baseline for the metric chosen
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        EditMetricBaselineForm editForm = (EditMetricBaselineForm) form;
        Integer scheduleId = editForm.getM();
        Subject subject = RequestUtils.getSubject(request);

        if (scheduleId == null) {
            scheduleId = RequestUtils.getMetricId(request);
        }

        MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();

        MeasurementBaseline metricValue = new MeasurementBaseline();
        MeasurementSchedule schedule = scheduleManager.getScheduleById(subject, scheduleId);

        if ((schedule != null) && (schedule.getBaseline() != null)) {
            metricValue = schedule.getBaseline();
        } else {
            log.info(" the measurement object does not have a baseline set");
        }

        // XXX: temporary settings
        editForm.setFromDate(metricValue.getComputeTime().getTime());
        editForm.setToDate(metricValue.getComputeTime().getTime());
        editForm.setNumOfPts((long) 1);
        editForm.setMean(metricValue.getMean());
        editForm.setMetricName(RequestUtils.getStringParameter(request, ParamConstants.METRIC_NAME_PARAM));
        editForm.setOldMode(RequestUtils.getStringParameter(request, "oldMode"));
        log.debug("in editMetricBaseline form prepare action");
        request.setAttribute("BaselineValue", editForm);
        return null;
    }
}

// EOF
