/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.jaxb.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
class WsConfiguration {
    @XmlTransient
    private Configuration CONFIG = null;
    private int id = -1;
    private String notes = "";
    private long version;
    private long ctime;
    private long mtime;
    public List<Property> properties = new ArrayList<Property>();
    public List<PropertyList> propertyListContainer = new ArrayList<PropertyList>();
    public List<PropertySimple> propertySimpleContainer = new ArrayList<PropertySimple>();
    public List<PropertyMap> propertyMapContainer = new ArrayList<PropertyMap>();
    public Collection<String> names = new ArrayList<String>();

    public WsConfiguration() {
        this.ctime = System.currentTimeMillis();
        this.mtime = System.currentTimeMillis();
        this.notes = "";
    }

    public WsConfiguration(Configuration opaque) {
        this.CONFIG = opaque;
        this.id = opaque.getId();
        this.notes = opaque.getNotes();
        this.version = opaque.getVersion();
        this.ctime = opaque.getCreatedTime();
        this.mtime = opaque.getModifiedTime();
        this.properties = new ArrayList<Property>();
        this.propertyListContainer = new ArrayList<PropertyList>();
        this.propertyMapContainer = new ArrayList<PropertyMap>();
        this.propertySimpleContainer = new ArrayList<PropertySimple>();
        if (opaque.getAllProperties() != null && opaque.getAllProperties().size() > 0) {
            for (String key : opaque.getAllProperties().keySet()) {
                Property property = (Property)opaque.getAllProperties().get(key);
                this.properties.add(property);
                if (property instanceof PropertySimple) {
                    this.propertySimpleContainer.add((PropertySimple)property);
                }
                if (property instanceof PropertyList) {
                    this.propertyListContainer.add((PropertyList)property);
                }
                if (!(property instanceof PropertyMap)) continue;
                this.propertyMapContainer.add((PropertyMap)property);
            }
        }
        this.populatePropertyMaps();
    }

    private void populatePropertyMaps() {
        if (this.properties != null && this.properties.size() > 0) {
            for (Property type : this.properties) {
                this.names.add(type.getName());
                Property property = type;
                if (property instanceof PropertySimple) {
                    this.propertySimpleContainer.add((PropertySimple)type);
                    continue;
                }
                if (property instanceof PropertyList) {
                    this.propertyListContainer.add((PropertyList)type);
                    continue;
                }
                if (!(property instanceof PropertyMap)) continue;
                this.propertyMapContainer.add((PropertyMap)type);
            }
        }
    }
}

