/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class GroupRequest<T>
extends Request {
    private final Map<Address, Rsp<T>> requests;
    int num_valid;
    int num_received;

    public GroupRequest(Message msg, RequestCorrelator corr, Collection<Address> targets, RequestOptions options) {
        super(msg, corr, options);
        int size = targets.size();
        this.requests = new HashMap<Address, Rsp<T>>(size);
        this.setTargets(targets);
    }

    public GroupRequest(Message msg, RequestCorrelator corr, Address target, RequestOptions options) {
        super(msg, corr, options);
        this.requests = new HashMap<Address, Rsp<T>>(1);
        this.setTarget(target);
    }

    public boolean getAnycasting() {
        return this.options.getAnycasting();
    }

    public void setAnycasting(boolean anycasting) {
        this.options.setAnycasting(anycasting);
    }

    @Override
    public void sendRequest() throws Exception {
        this.sendRequest(this.requests.keySet(), this.req_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveResponse(Object response_value, Address sender, boolean is_exception) {
        if (this.done) {
            return;
        }
        Rsp<Object> rsp = this.requests.get(sender);
        if (rsp == null) {
            return;
        }
        RspFilter rsp_filter = this.options.getRspFilter();
        boolean responseReceived = false;
        this.lock.lock();
        try {
            if (!rsp.wasReceived()) {
                if (!rsp.wasSuspected() && !rsp.wasUnreachable()) {
                    ++this.num_received;
                }
                if (responseReceived = rsp_filter == null || rsp_filter.isAcceptable(response_value, sender)) {
                    if (is_exception && response_value instanceof Throwable) {
                        rsp.setException((Throwable)response_value);
                    } else {
                        rsp.setValue(response_value);
                    }
                    ++this.num_valid;
                }
            }
            boolean bl = this.done = this.responsesComplete() || rsp_filter != null && !rsp_filter.needMoreResponses();
            if (responseReceived || this.done) {
                this.completed.signalAll();
            }
            if (this.done && this.corr != null) {
                this.corr.done(this.req_id);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (responseReceived || this.done) {
            this.checkCompletion(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspect(Address suspected_member) {
        if (suspected_member == null) {
            return;
        }
        boolean changed = false;
        Rsp<T> rsp = this.requests.get(suspected_member);
        if (rsp != null && rsp.setSuspected()) {
            changed = true;
            this.lock.lock();
            try {
                if (!rsp.wasReceived() && !rsp.wasUnreachable()) {
                    ++this.num_received;
                }
                this.completed.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        if (changed) {
            this.checkCompletion(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void siteUnreachable(short site) {
        boolean changed = false;
        for (Map.Entry<Address, Rsp<T>> entry : this.requests.entrySet()) {
            SiteAddress addr;
            Address member = entry.getKey();
            if (!(member instanceof SiteAddress) || (addr = (SiteAddress)member).getSite() != site) continue;
            Rsp<T> rsp = entry.getValue();
            if (rsp != null && rsp.setUnreachable()) {
                changed = true;
                this.lock.lock();
                try {
                    if (!rsp.wasReceived() && !rsp.wasSuspected()) {
                        ++this.num_received;
                    }
                    this.completed.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (!changed) continue;
            this.checkCompletion(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChange(View new_view) {
        if (new_view == null || this.requests == null || this.requests.isEmpty()) {
            return;
        }
        List<Address> mbrs = new_view.getMembers();
        if (mbrs == null) {
            return;
        }
        boolean changed = false;
        this.lock.lock();
        try {
            for (Map.Entry<Address, Rsp<T>> entry : this.requests.entrySet()) {
                Rsp<T> rsp;
                Address mbr = entry.getKey();
                if (mbr instanceof SiteAddress || mbrs.contains(mbr) || !(rsp = entry.getValue()).setSuspected()) continue;
                if (!rsp.wasReceived() && !rsp.wasUnreachable()) {
                    ++this.num_received;
                }
                changed = true;
            }
            if (changed) {
                this.completed.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (changed) {
            this.checkCompletion(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transportClosed() {
        boolean changed = false;
        this.lock.lock();
        try {
            for (Map.Entry<Address, Rsp<T>> entry : this.requests.entrySet()) {
                Rsp<T> rsp = entry.getValue();
                if (rsp == null || rsp.wasReceived() || rsp.wasSuspected() || rsp.wasUnreachable()) continue;
                rsp.setException(new IllegalStateException("transport was closed"));
                ++this.num_received;
                changed = true;
            }
            if (changed) {
                this.completed.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (changed) {
            this.checkCompletion(this);
        }
    }

    public RspList<T> getResults() {
        Collection<Rsp<T>> rsps = this.requests.values();
        return new RspList<T>(rsps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RspList<T> get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            this.waitForResults(0L);
        }
        finally {
            this.lock.unlock();
        }
        return this.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RspList<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean ok;
        this.lock.lock();
        try {
            ok = this.waitForResults(unit.toMillis(timeout));
        }
        finally {
            this.lock.unlock();
        }
        if (!ok) {
            throw new TimeoutException();
        }
        return this.getResults();
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder(128);
        ret.append(super.toString());
        if (!this.requests.isEmpty()) {
            ret.append(", entries:\n");
            for (Map.Entry<Address, Rsp<T>> entry : this.requests.entrySet()) {
                Address mbr = entry.getKey();
                Rsp<T> rsp = entry.getValue();
                ret.append(mbr).append(": ").append(rsp).append("\n");
            }
        }
        return ret.toString();
    }

    private void setTarget(Address mbr) {
        this.requests.put(mbr, new Rsp(mbr));
    }

    private void setTargets(Collection<Address> mbrs) {
        for (Address mbr : mbrs) {
            this.requests.put(mbr, new Rsp(mbr));
        }
    }

    private static int determineMajority(int i) {
        return i < 2 ? i : i / 2 + 1;
    }

    private void sendRequest(Collection<Address> targetMembers, long requestId) throws Exception {
        try {
            this.corr.sendRequest(requestId, targetMembers, this.request_msg, this.options.getMode() == ResponseMode.GET_NONE ? null : this, this.options);
        }
        catch (Exception ex) {
            if (this.corr != null) {
                this.corr.done(requestId);
            }
            throw ex;
        }
    }

    @Override
    protected boolean responsesComplete() {
        if (this.done) {
            return true;
        }
        int num_total = this.requests.size();
        switch (this.options.getMode()) {
            case GET_FIRST: {
                return this.num_valid >= 1 || this.num_received >= num_total;
            }
            case GET_ALL: {
                return this.num_valid >= num_total || this.num_received >= num_total;
            }
            case GET_MAJORITY: {
                int majority = GroupRequest.determineMajority(num_total);
                return this.num_valid >= majority || this.num_received >= num_total;
            }
            case GET_NONE: {
                return true;
            }
        }
        if (log.isErrorEnabled()) {
            log.error("rsp_mode " + (Object)((Object)this.options.getMode()) + " unknown !");
        }
        return false;
    }
}

