/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.plugin.session.impl;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionListener;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.CookieUtils;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FMSessionProvider
implements SessionProvider {
    public static final String RANDOM_SECRET = "randomSecret";
    private static final String AUTH_TYPE = "AuthType";
    private static final String PROPERTY_VALUES_SEPARATOR = ":::";
    private static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"fmSessionProvider");
    private static Debug debug = Debug.getInstance((String)"libPlugins");
    private static String cookieName = SystemPropertiesManager.get((String)"com.iplanet.am.cookie.name");
    private static String lbcookieName = null;
    private static String lbcookieValue = null;
    private static boolean urlRewriteEnabled = false;
    private static SecureRandom random = new SecureRandom();
    private static final int SECRET_LENGTH = 20;
    private static Set secretSet = Collections.synchronizedSet(new HashSet(1000));

    public static boolean matchSecret(String secret) {
        return secretSet.remove(secret);
    }

    private static String generateSecret() {
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        return new String(bytes);
    }

    public Object createSession(Map info, HttpServletRequest request, HttpServletResponse response, StringBuffer targetApplication) throws SessionException {
        String realm = (String)info.get("realm");
        if (realm == null || realm.length() == 0) {
            throw new SessionException(bundle.getString("nullRealm"));
        }
        String principalName = (String)info.get("principalName");
        if (principalName == null || principalName.length() == 0) {
            throw new SessionException(bundle.getString("nullPrincipal"));
        }
        String authLevel = (String)info.get("AuthLevel");
        Object oldSession = null;
        try {
            oldSession = this.getSession(request);
            String oldPrincipal = this.getPrincipalName(oldSession);
            oldPrincipal = oldPrincipal.toLowerCase();
            if (!oldPrincipal.equals(principalName.toLowerCase()) && !oldPrincipal.startsWith("id=" + principalName.toLowerCase() + ",")) {
                this.invalidateSession(oldSession, request, response);
                oldSession = null;
            }
        }
        catch (SessionException se) {
            oldSession = null;
        }
        AuthContext ac = null;
        try {
            ac = oldSession != null ? new AuthContext((SSOToken)oldSession, true) : new AuthContext(realm);
            ac.login(AuthContext.IndexType.MODULE_INSTANCE, "Federation");
        }
        catch (AuthLoginException ale) {
            throw new SessionException((Exception)((Object)ale));
        }
        Callback[] callbacks = null;
        while (ac.hasMoreRequirements()) {
            callbacks = ac.getRequirements();
            if (callbacks == null || callbacks.length == 0) continue;
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof NameCallback)) continue;
                NameCallback nc = (NameCallback)callbacks[i];
                if (nc.getPrompt().equals("principalName")) {
                    nc.setName(principalName);
                    continue;
                }
                if (nc.getPrompt().equals(RANDOM_SECRET)) {
                    String randomString = FMSessionProvider.generateSecret();
                    while (secretSet.contains(randomString)) {
                        randomString = FMSessionProvider.generateSecret();
                    }
                    secretSet.add(randomString);
                    nc.setName(randomString);
                    continue;
                }
                if (!nc.getPrompt().equals("AuthLevel")) continue;
                nc.setName(authLevel);
            }
        }
        ac.submitRequirements(callbacks);
        SSOToken ssoToken = null;
        if (ac.getStatus() == AuthContext.Status.SUCCESS) {
            try {
                ssoToken = ac.getSSOToken();
            }
            catch (Exception e) {
                throw new SessionException(e.getMessage());
            }
        } else {
            if (ac.getStatus() == AuthContext.Status.FAILED) {
                int failureCode = SessionException.AUTH_ERROR_NOT_DEFINED;
                AuthLoginException ale = ac.getLoginException();
                String authError = null;
                if (ale != null) {
                    authError = ale.getErrorCode();
                }
                if (authError == null) {
                    failureCode = SessionException.AUTH_ERROR_NOT_DEFINED;
                } else if (authError.equals("104")) {
                    failureCode = SessionException.AUTH_USER_INACTIVE;
                } else if (authError.equals("112")) {
                    failureCode = SessionException.AUTH_USER_LOCKED;
                } else if (authError.equals("101")) {
                    failureCode = SessionException.AUTH_ACCOUNT_EXPIRED;
                }
                SessionException se = null;
                se = ale != null ? new SessionException((Exception)((Object)ale)) : new SessionException(bundle.getString("loginFailed"));
                se.setErrCode(failureCode);
                throw se;
            }
            throw new SessionException(bundle.getString("loginFailed"));
        }
        if (response != null) {
            int n;
            ServiceSchemaManager scm = null;
            try {
                scm = new ServiceSchemaManager("iPlanetAMPlatformService", ssoToken);
            }
            catch (Exception e) {
                throw new SessionException(e);
            }
            ServiceSchema platformSchema = null;
            try {
                platformSchema = scm.getGlobalSchema();
            }
            catch (SMSException se) {
                throw new SessionException((Exception)((Object)se));
            }
            this.setLoadBalancerCookie(response);
            Set cookieDomains = (Set)platformSchema.getAttributeDefaults().get("iplanet-am-platform-cookie-domains");
            String value = ssoToken.getTokenID().toString();
            if (cookieDomains.size() == 0) {
                Cookie cookie = CookieUtils.newCookie((String)cookieName, (String)value, (String)"/");
                response.addCookie(cookie);
            } else {
                Iterator it = cookieDomains.iterator();
                Cookie cookie = null;
                String cookieDomain = null;
                while (it.hasNext()) {
                    cookieDomain = (String)it.next();
                    if (debug.messageEnabled()) {
                        debug.message("cookieName=" + cookieName);
                        debug.message("value=" + value);
                        debug.message("cookieDomain=" + cookieDomain);
                    }
                    cookie = CookieUtils.newCookie((String)cookieName, (String)value, (String)"/", (String)cookieDomain);
                    response.addCookie(cookie);
                }
            }
            if (urlRewriteEnabled && targetApplication != null && (n = targetApplication.length()) > 0) {
                String rewrittenURL = this.rewriteURL(ssoToken, targetApplication.toString());
                targetApplication.delete(0, n);
                targetApplication.append(rewrittenURL);
            }
        }
        try {
            for (String keyName : info.keySet()) {
                if (keyName.equals("AuthLevel")) continue;
                String keyVal = (String)info.get(keyName);
                ssoToken.setProperty(keyName, keyVal);
            }
        }
        catch (SSOException se) {
            throw new SessionException((Exception)((Object)se));
        }
        return ssoToken;
    }

    public void setLoadBalancerCookie(HttpServletResponse response) {
        FSUtils.setlbCookie((HttpServletResponse)response);
    }

    public Object getSession(String sessionID) throws SessionException {
        try {
            SSOToken session = SSOTokenManager.getInstance().createSSOToken(sessionID);
            SSOTokenManager.getInstance().refreshSession(session);
            return session;
        }
        catch (Throwable e) {
            throw new SessionException(e);
        }
    }

    public Object getSession(HttpServletRequest request) throws SessionException {
        try {
            SSOToken session = SSOTokenManager.getInstance().createSSOToken(request);
            SSOTokenManager.getInstance().refreshSession(session);
            return session;
        }
        catch (Throwable e) {
            throw new SessionException(e);
        }
    }

    public void invalidateSession(Object session, HttpServletRequest request, HttpServletResponse response) throws SessionException {
        try {
            SSOTokenManager.getInstance().destroyToken((SSOToken)session);
            if (request != null && response != null) {
                AuthUtils.clearAllCookies((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
        catch (SSOException se) {
            throw new SessionException((Exception)((Object)se));
        }
    }

    public boolean isValid(Object session) throws SessionException {
        try {
            return SSOTokenManager.getInstance().isValidToken((SSOToken)session);
        }
        catch (SSOException se) {
            throw new SessionException((Exception)((Object)se));
        }
    }

    public String getSessionID(Object session) {
        return ((SSOToken)session).getTokenID().toString();
    }

    public String getPrincipalName(Object session) throws SessionException {
        try {
            return ((SSOToken)session).getProperty("sun.am.UniversalIdentifier");
        }
        catch (SSOException se) {
            throw new SessionException((Exception)((Object)se));
        }
    }

    public long getTimeLeft(Object session) throws SessionException {
        try {
            return ((SSOToken)session).getTimeLeft();
        }
        catch (SSOException se) {
            throw new SessionException((Exception)((Object)se));
        }
    }

    public void setProperty(Object session, String name, String[] values) throws SessionException {
        if (name == null || values == null || values.length == 0) {
            return;
        }
        String propValue = null;
        if (values.length == 1) {
            propValue = values[0];
        } else {
            StringBuffer buffer = new StringBuffer(values[0]);
            for (int i = 1; i < values.length; ++i) {
                buffer.append(PROPERTY_VALUES_SEPARATOR).append(values[i]);
            }
            propValue = buffer.toString();
        }
        try {
            ((SSOToken)session).setProperty(name, propValue);
        }
        catch (SSOException se) {
            throw new SessionException((Exception)((Object)se));
        }
    }

    public String[] getProperty(Object session, String name) throws SessionException {
        if (session == null || name == null || name.length() == 0) {
            return null;
        }
        if (name.equals("authMethod")) {
            name = AUTH_TYPE;
        }
        String values = null;
        try {
            values = "SAML2IDPSessionIndex".equals(name) ? ((SSOToken)session).getProperty(name, true) : ((SSOToken)session).getProperty(name);
        }
        catch (SSOException se) {
            throw new SessionException((Exception)((Object)se));
        }
        if (values == null || values.length() == 0) {
            return null;
        }
        if (name.equals(AUTH_TYPE)) {
            String[] retValues = new String[1];
            if (values.equalsIgnoreCase("Cert")) {
                retValues[0] = "urn:ietf:rfc:2246";
            }
            if (values.equalsIgnoreCase("Kerberos")) {
                retValues[0] = "urn:ietf:rfc:1510";
            }
            if (SAMLConstants.passwordAuthMethods.contains(values.toLowerCase())) {
                retValues[0] = "urn:oasis:names:tc:SAML:1.0:am:password";
            }
            retValues[0] = SAMLConstants.tokenAuthMethods.contains(values.toLowerCase()) ? "urn:oasis:names:tc:SAML:1.0:am:HardwareToken" : "urn:com:sun:identity:" + values;
            return retValues;
        }
        return values.split("\\:::");
    }

    public String rewriteURL(Object session, String URL2) throws SessionException {
        if (urlRewriteEnabled) {
            try {
                return ((SSOToken)session).encodeURL(URL2);
            }
            catch (SSOException se) {
                throw new SessionException((Exception)((Object)se));
            }
        }
        return URL2;
    }

    public void addListener(Object session, SessionListener listener) throws SessionException {
        try {
            ((SSOToken)session).addSSOTokenListener((SSOTokenListener)new SSOTokenListenerImpl(session, listener));
        }
        catch (SSOException se) {
            throw new SessionException((Exception)((Object)se));
        }
    }

    static {
        String urlRewriteEnabledStr = SystemPropertiesManager.get((String)"com.sun.identity.cookieRewritingInPath");
        if (urlRewriteEnabledStr != null && urlRewriteEnabledStr.trim().length() != 0 && urlRewriteEnabledStr.trim().toLowerCase().equals("true")) {
            urlRewriteEnabled = true;
        }
    }

    class SSOTokenListenerImpl
    implements SSOTokenListener {
        private Object session = null;
        private SessionListener listener = null;

        public SSOTokenListenerImpl(Object session, SessionListener listener) {
            this.session = session;
            this.listener = listener;
        }

        public void ssoTokenChanged(SSOTokenEvent evt) {
            int eventType = -1;
            try {
                eventType = evt.getType();
            }
            catch (SSOException sSOException) {
                // empty catch block
            }
            if (eventType == 1 || eventType == 2 || eventType == 3) {
                this.listener.sessionInvalidated(this.session);
            }
        }
    }
}

