/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ejb.EJBException;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;

class GeneralInvocationFailureResponseHandler
extends ProtocolMessageHandler {
    private final ChannelAssociation channelAssociation;
    private final FailureType failureType;

    GeneralInvocationFailureResponseHandler(ChannelAssociation channelAssociation, FailureType failureType) {
        this.failureType = failureType;
        this.channelAssociation = channelAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMessage(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            short invocationId = dataInputStream.readShort();
            String failureMessage = dataInputStream.readUTF();
            EJBException exception = new EJBException(failureMessage);
            this.channelAssociation.resultReady(invocationId, new InvocationFailureResultProducer((Exception)exception));
        }
        finally {
            dataInputStream.close();
        }
    }

    private class InvocationFailureResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final Exception invocationFailure;

        InvocationFailureResultProducer(Exception invocationFailure) {
            this.invocationFailure = invocationFailure;
        }

        @Override
        public Object getResult() throws Exception {
            GeneralInvocationFailureResponseHandler.this.glueStackTraces(this.invocationFailure, Thread.currentThread().getStackTrace(), 1, "asynchronous invocation");
            throw this.invocationFailure;
        }

        @Override
        public void discardResult() {
        }
    }

    static enum FailureType {
        NO_SUCH_METHOD,
        SESSION_NOT_ACTIVE,
        EJB_NOT_STATEFUL;

    }
}

