/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.remote;

import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.common.ICachedDirectoryServices;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.sdk.common.MiscUtils;
import com.iplanet.am.sdk.remote.RemoteServicesFactory;
import com.iplanet.am.sdk.remote.RemoteServicesImpl;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.SMSSchema;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class EventListener {
    private static Debug debug = RemoteServicesImpl.getDebug();
    private static SOAPClient client;
    private static Set listeners;
    private static EventListener instance;
    private static final String NOTIFICATION_PROPERTY = "com.sun.identity.idm.remote.notification.enabled";
    private static final String CACHE_POLLING_TIME_PROPERTY = "com.iplanet.am.sdk.remote.pollingTime";
    private static final int DEFAULT_CACHE_POLLING_TIME = 1;
    static final String METHOD = "method";
    static final String ENTITY_NAME = "entityName";
    static final String EVENT_TYPE = "eventType";
    static final String ATTR_NAMES = "attrNames";
    static final String OBJECT_CHANGED = "objectChanged";
    static final String OBJECTS_CHANGED = "objectsChanged";
    static final String PERMISSIONS_CHANGED = "permissionsChanged";
    static final String ALL_OBJECTS_CHANGED = "allObjectsChanged";

    public static synchronized EventListener getInstance() {
        if (instance == null) {
            instance = new EventListener();
        }
        return instance;
    }

    private EventListener() {
        client = new SOAPClient("DirectoryManagerIF");
        String notificationFlag = SystemProperties.get(NOTIFICATION_PROPERTY, "true");
        if (notificationFlag.equalsIgnoreCase("true")) {
            URL url = null;
            try {
                url = WebtopNaming.getNotificationURL();
                client.send("registerNotificationURL", (Object)url.toString(), null, null);
                PLLClient.addNotificationHandler("DirectoryManagerIF", new EventNotificationHandler());
                if (debug.messageEnabled()) {
                    debug.message("EventService: Using notification mechanism for cache updates: " + url.toString());
                }
            }
            catch (Exception e) {
                if (debug.warningEnabled()) {
                    debug.warning("EventService: Registering for notification via URL failed for " + url + e.getMessage() + "\nUsing polling mechanism for updates");
                }
                EventListener.startPollingThreadIfEnabled(this.getCachePollingInterval());
            }
        } else {
            EventListener.startPollingThreadIfEnabled(this.getCachePollingInterval());
        }
    }

    private int getCachePollingInterval() {
        String cachePollingTimeStr = SystemProperties.get(CACHE_POLLING_TIME_PROPERTY);
        int cachePollingInterval = 1;
        if (cachePollingTimeStr != null) {
            try {
                cachePollingInterval = Integer.parseInt(cachePollingTimeStr);
            }
            catch (NumberFormatException nfe) {
                debug.error("EventListener::NotificationRunnable:: Invalid Polling Time: " + cachePollingTimeStr + " Defaulting to " + 1 + " minute");
            }
        }
        return cachePollingInterval;
    }

    private static void startPollingThreadIfEnabled(int cachePollingInterval) {
        if (cachePollingInterval > 0) {
            if (debug.messageEnabled()) {
                debug.message("EventListener: Polling mode enabled. Starting the polling thread..");
            }
            NotificationRunnable nt = new NotificationRunnable(cachePollingInterval);
            SystemTimer.getTimer().schedule((TaskRunnable)nt, new Date(System.currentTimeMillis() / 1000L * 1000L));
        } else if (debug.warningEnabled()) {
            debug.warning("EventListener: Polling mode DISABLED. com.iplanet.am.sdk.remote.pollingTime=" + cachePollingInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SSOToken token, AMObjectListener listener) throws AMEventManagerException {
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException ssoe) {
            throw new AMEventManagerException(ssoe.getMessage(), "902");
        }
        Set set = listeners;
        synchronized (set) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendNotification(String nItem) {
        block35: {
            if (debug.messageEnabled()) {
                debug.message("EventListener::sendNotification: Received notification.");
            }
            StringBuffer sb = new StringBuffer(nItem.length() + 50);
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(nItem);
            try {
                String entityName;
                String method;
                Map attrs = CreateServiceConfig.getAttributeValuePairs(SMSSchema.getXMLDocument(sb.toString(), false).getDocumentElement());
                if (debug.messageEnabled()) {
                    debug.message("EventListener::sendNotification Decoded Event: " + attrs);
                }
                if ((method = EventListener.getAttributeValue(attrs, METHOD)) == null) {
                    EventListener.handleError("invalid method name: " + attrs.get(METHOD));
                }
                if ((entityName = EventListener.getAttributeValue(attrs, ENTITY_NAME)) == null) {
                    EventListener.handleError("invalid entity Name: " + attrs.get(ENTITY_NAME));
                }
                String entryDN = MiscUtils.formatToRFC(entityName);
                IDirectoryServices dsServices = RemoteServicesFactory.getInstance();
                if (method.equalsIgnoreCase(OBJECT_CHANGED)) {
                    int eventType = EventListener.getEventType((Set)attrs.get(EVENT_TYPE));
                    if (RemoteServicesFactory.isCachingEnabled()) {
                        ((ICachedDirectoryServices)dsServices).dirtyCache(entryDN, eventType, false, false, Collections.EMPTY_SET);
                    }
                    Set set = listeners;
                    synchronized (set) {
                        for (AMObjectListener listener : listeners) {
                            listener.objectChanged(entityName, eventType, null);
                        }
                    }
                } else if (method.equalsIgnoreCase(OBJECTS_CHANGED)) {
                    int eventType = EventListener.getEventType((Set)attrs.get(EVENT_TYPE));
                    Set attributes = (Set)attrs.get(attrs.get(ATTR_NAMES));
                    if (RemoteServicesFactory.isCachingEnabled()) {
                        ((ICachedDirectoryServices)dsServices).dirtyCache(entryDN, eventType, true, false, attributes);
                    }
                    Set items = listeners;
                    synchronized (items) {
                        for (AMObjectListener listener : listeners) {
                            listener.objectsChanged(entityName, eventType, attributes, null);
                        }
                    }
                } else if (method.equalsIgnoreCase(PERMISSIONS_CHANGED)) {
                    if (RemoteServicesFactory.isCachingEnabled()) {
                        ((ICachedDirectoryServices)dsServices).dirtyCache(entryDN, 4, false, true, Collections.EMPTY_SET);
                    }
                    Set set = listeners;
                    synchronized (set) {
                        for (AMObjectListener listener : listeners) {
                            listener.permissionsChanged(entityName, null);
                        }
                    }
                } else if (method.equalsIgnoreCase(ALL_OBJECTS_CHANGED)) {
                    if (RemoteServicesFactory.isCachingEnabled()) {
                        ((ICachedDirectoryServices)dsServices).clearCache();
                    }
                    Set set = listeners;
                    synchronized (set) {
                        for (AMObjectListener listener : listeners) {
                            listener.allObjectsChanged();
                        }
                    }
                } else {
                    EventListener.handleError("invalid method name: " + method);
                }
                if (debug.messageEnabled()) {
                    debug.message("EventListener::sendNotification: Sent notification.");
                }
            }
            catch (Exception e) {
                if (!debug.warningEnabled()) break block35;
                debug.warning("EventListener::sendNotification: Unable to send notification: " + nItem, (Throwable)e);
            }
        }
    }

    static void handleError(String msg) throws Exception {
        debug.error("EventListener::sendNotification: " + msg);
        throw new Exception(msg);
    }

    static String getAttributeValue(Map attrs, String attrName) {
        String answer = null;
        Set set = (Set)attrs.get(attrName);
        if (set != null && set.size() == 1) {
            answer = (String)set.iterator().next();
        }
        return answer;
    }

    static int getEventType(Set eventSet) throws Exception {
        if (eventSet == null || eventSet.size() != 1) {
            throw new Exception("EventListener::sendNotification: invalid event type: " + eventSet);
        }
        String eventString = (String)eventSet.iterator().next();
        return Integer.parseInt(eventString);
    }

    static {
        listeners = new HashSet();
        instance = null;
    }

    static class EventNotificationHandler
    implements NotificationHandler {
        EventNotificationHandler() {
        }

        public void process(Vector notifications) {
            for (int i = 0; i < notifications.size(); ++i) {
                Notification notification = (Notification)notifications.elementAt(i);
                String content = notification.getContent();
                if (debug.messageEnabled()) {
                    debug.message("EventListener:IdRepoEventNotificationHandler: received notification: " + content);
                }
                EventListener.sendNotification(content);
            }
        }
    }

    static class NotificationRunnable
    extends GeneralTaskRunnable {
        private int pollingTime;
        private long runPeriod;

        NotificationRunnable(int interval) {
            this.pollingTime = interval;
            this.runPeriod = this.pollingTime * 1000 * 60;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }

        public boolean isEmpty() {
            return true;
        }

        public long getRunPeriod() {
            return this.runPeriod;
        }

        public void run() {
            try {
                Object[] obj = new Object[]{new Integer(this.pollingTime)};
                Set mods = (Set)client.send(EventListener.OBJECTS_CHANGED, obj, null, null);
                if (debug.messageEnabled()) {
                    debug.message("EventListener:NotificationRunnable retrived changes: " + mods);
                }
                Iterator items = mods.iterator();
                while (items.hasNext()) {
                    EventListener.sendNotification((String)items.next());
                }
            }
            catch (NumberFormatException nfe) {
                debug.warning("EventListener::NotificationRunnable:run Number Format Exception for polling Time: " + this.pollingTime, (Throwable)nfe);
            }
            catch (Exception ex) {
                debug.warning("EventListener::NotificationRunnable:run Exception", (Throwable)ex);
            }
        }
    }
}

