/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionEvent;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionNotification;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.share.Notification;
import com.sun.identity.shared.debug.Debug;
import java.util.Hashtable;
import java.util.Vector;

public class SessionNotificationHandler
implements NotificationHandler {
    private Hashtable sessionTable;
    public static SessionNotificationHandler handler = null;
    public static Debug sessionDebug = null;

    public SessionNotificationHandler(Hashtable table) {
        this.sessionTable = table;
    }

    public void process(Vector notifications) {
        for (int i = 0; i < notifications.size(); ++i) {
            Notification not = (Notification)notifications.elementAt(i);
            SessionNotification snot = SessionNotification.parseXML(not.getContent());
            if (snot == null) continue;
            this.processNotification(snot);
        }
    }

    public void processNotification(SessionNotification snot) {
        SessionInfo info = snot.getSessionInfo();
        sessionDebug.message("SESSION NOTIFICATION : " + info.toXMLString());
        SessionID sid = new SessionID(info.sid);
        Session session = null;
        session = (Session)((Object)this.sessionTable.get(sid));
        if (session != null && !info.state.equals("valid")) {
            Session.removeSID(sid);
            return;
        }
        try {
            if (session == null) {
                if (Session.getAllSessionEventListeners().size() == 0) {
                    return;
                }
                session = new Session(sid);
            }
            session.update(info);
        }
        catch (Exception e) {
            sessionDebug.error("SessionNotificationHandler:processNotification : ", (Throwable)e);
            Session.removeSID(sid);
            return;
        }
        SessionEvent evt = new SessionEvent(session, snot.getNotificationType(), snot.getNotificationTime());
        Session.invokeListeners(evt);
    }

    static {
        sessionDebug = Debug.getInstance((String)"amSession");
    }
}

