/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.util.GenericNode;
import com.iplanet.services.util.ParseOutput;
import com.iplanet.services.util.XMLException;
import com.iplanet.services.util.XMLParser;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class ServerGroup
implements ParseOutput {
    String baseDN = null;
    int maxConnPool = -1;
    int minConnPool = -1;
    ArrayList servers = null;
    ArrayList users = null;
    HashMap miscConfig = null;
    private String groupName;

    public void process(XMLParser parser, String name, Vector elems, Hashtable atts, String Pcdata) throws XMLException {
        if (DSConfigMgr.debugger.messageEnabled()) {
            DSConfigMgr.debugger.message("in ServerGroup.process()");
        }
        if (name.equals("ServerGroup")) {
            String minConnPoolStr;
            this.groupName = (String)atts.get("name");
            for (int i = 0; i < elems.size(); ++i) {
                Object obj = elems.elementAt(i);
                if (DSConfigMgr.debugger.messageEnabled()) {
                    DSConfigMgr.debugger.message("Object of type:" + obj.getClass().getName());
                }
                if (obj instanceof Server) {
                    if (this.servers == null) {
                        if (DSConfigMgr.debugger.messageEnabled()) {
                            DSConfigMgr.debugger.message("Initializing servers list.");
                        }
                        this.servers = new ArrayList();
                    }
                    this.servers.add(obj);
                    continue;
                }
                if (obj instanceof LDAPUser) {
                    if (this.users == null) {
                        this.users = new ArrayList();
                    }
                    this.users.add(obj);
                    continue;
                }
                if (!(obj instanceof GenericNode)) continue;
                GenericNode x = (GenericNode)obj;
                if (x._name.equals("BaseDN")) {
                    if (x._pcdata != null && !DN.isDN((String)x._pcdata)) {
                        throw new XMLException(DSConfigMgr.getString("dscfg-invalid_base_dn") + x._pcdata);
                    }
                    this.baseDN = LDAPDN.normalize((String)x._pcdata);
                    continue;
                }
                if (!x._name.equals("MiscConfig")) continue;
                String attrName = (String)x._atts.get("name");
                String attrValue = (String)x._atts.get("value");
                if (name == null || name.length() <= 0) continue;
                if (this.miscConfig == null) {
                    this.miscConfig = new HashMap();
                }
                this.miscConfig.put(attrName, attrValue);
            }
            if (this.servers == null || this.baseDN == null) {
                String errorMsg = null;
                if (this.servers == null) {
                    errorMsg = "No server object found in the server group:" + this.groupName;
                }
                if (this.baseDN == null) {
                    errorMsg = "No base DN string defined in the server group:" + this.groupName;
                }
                throw new XMLException(errorMsg);
            }
            String maxConnPoolStr = System.getProperty("max_conn_pool");
            if (maxConnPoolStr == null) {
                maxConnPoolStr = (String)atts.get("maxConnPool");
            }
            if ((minConnPoolStr = System.getProperty("min_conn_pool")) == null) {
                minConnPoolStr = (String)atts.get("minConnPool");
            }
            try {
                this.maxConnPool = Integer.parseInt(maxConnPoolStr);
            }
            catch (NumberFormatException ex) {
                this.maxConnPool = 10;
            }
            try {
                this.minConnPool = Integer.parseInt(minConnPoolStr);
            }
            catch (NumberFormatException ex) {
                this.minConnPool = 1;
            }
        } else {
            throw new XMLException(DSConfigMgr.getString("dscfg-servergroup_node_expected"));
        }
        parser.getGroupContainer().put(this.groupName, this);
    }

    public ServerInstance getServerInstance(LDAPUser.Type authType) {
        Server serv = null;
        for (int i = 0; !(i >= this.servers.size() || (serv = (Server)this.servers.get(i)) != null && serv.getActiveStatus()); ++i) {
        }
        LDAPUser user = null;
        for (int i = 0; !(i >= this.users.size() || (user = (LDAPUser)this.users.get(i)) != null && user.getAuthType().equals(authType)); ++i) {
        }
        if (serv != null && user != null) {
            return new ServerInstance(this, serv, user);
        }
        return null;
    }

    public String serverGroupName() {
        return this.groupName;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("Server Group Name=");
        buf.append(this.groupName);
        for (i = 0; i < this.users.size(); ++i) {
            buf.append('\n');
            buf.append(' ');
            buf.append(this.users.get(i).toString());
        }
        for (i = 0; i < this.servers.size(); ++i) {
            buf.append('\n');
            buf.append(' ');
            buf.append(this.servers.get(i).toString());
        }
        buf.append("Min Connection Pool=");
        buf.append(this.minConnPool);
        buf.append(" Max Connection Pool=");
        buf.append(this.maxConnPool);
        return buf.toString();
    }

    public Collection getServersList() {
        return this.servers;
    }
}

