/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.AttributeStruct;
import com.sun.identity.common.configuration.ConfigurationListener;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigurationObserver
implements ServiceListener {
    private static ConfigurationObserver instance = new ConfigurationObserver();
    private static int PARENT_LEN = "com-sun-identity-servers".length() + 2;
    private Set migratedServiceNames = new HashSet();
    private Set listeners = new HashSet();
    private static boolean hasRegisteredListeners;

    private ConfigurationObserver() {
        this.createAttributeMapping();
    }

    private void createAttributeMapping() {
        if (SystemProperties.isServerMode() && !ServerConfiguration.isLegacy()) {
            Map attributeMap = SystemProperties.getAttributeMap();
            for (AttributeStruct a : attributeMap.values()) {
                this.migratedServiceNames.add(a.getServiceName());
            }
        }
    }

    private synchronized void registerListeners() {
        if (!hasRegisteredListeners) {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            Iterator i = this.migratedServiceNames.iterator();
            while (i.hasNext()) {
                try {
                    ServiceConfigManager scm = new ServiceConfigManager((String)i.next(), adminToken);
                    scm.addListener(instance);
                }
                catch (SSOException ex) {
                    Debug.getInstance((String)"amSetupServlet").error("ConfigurationObserver.registeringListeners", (Throwable)((Object)ex));
                }
                catch (SMSException ex) {
                    Debug.getInstance((String)"amSetupServlet").error("ConfigurationObserver.registeringListeners", (Throwable)ex);
                }
            }
            hasRegisteredListeners = true;
        }
    }

    public static ConfigurationObserver getInstance() {
        instance.registerListeners();
        return instance;
    }

    public void schemaChanged(String serviceName, String version) {
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        if (serviceName.equals("iPlanetAMPlatformService")) {
            if (serviceComponent.startsWith("/com-sun-identity-servers/")) {
                String serverName = serviceComponent.substring(PARENT_LEN);
                if (serverName.equals("server-default") || serverName.equals(SystemProperties.getServerInstanceName())) {
                    SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    try {
                        Properties newProp = ServerConfiguration.getServerInstance(adminToken, serverName);
                        SystemProperties.initializeProperties(newProp, true, true);
                        this.notifies();
                    }
                    catch (SSOException ex) {
                    }
                    catch (IOException ex) {
                    }
                    catch (SMSException ex) {}
                }
            } else {
                this.notifies();
            }
        } else {
            this.notifies();
        }
    }

    public void addListener(ConfigurationListener l) {
        this.listeners.add(l);
    }

    private void notifies() {
        for (ConfigurationListener l : this.listeners) {
            l.notifyChanges();
        }
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
    }
}

