/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.EntitlementSubject;
import com.sun.identity.entitlement.PrivilegeManager;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class EntitlementSubjectImpl
implements EntitlementSubject {
    private String uuid;
    private String pSubjectName;
    private boolean exclusive;

    public EntitlementSubjectImpl() {
    }

    public EntitlementSubjectImpl(String uuid) {
        this.uuid = uuid;
    }

    public EntitlementSubjectImpl(String uuid, String pSubjectName) {
        this.uuid = uuid;
        this.pSubjectName = pSubjectName;
    }

    public void setState(String state) {
        try {
            JSONObject jo = new JSONObject(state);
            this.uuid = jo.has("uuid") ? jo.optString("uuid") : null;
            this.pSubjectName = jo.has("pSubjectName") ? jo.optString("pSubjectName") : null;
            this.exclusive = jo.has("exclusive") ? Boolean.parseBoolean(jo.optString("exclusive")) : false;
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("EntitlementSubjectImpl.setState", (Throwable)e);
        }
    }

    public String getState() {
        return this.toString();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("uuid", (Object)this.uuid);
        jo.put("pSubjectName", (Object)this.pSubjectName);
        if (this.exclusive) {
            jo.put("exclusive", this.exclusive);
        }
        return jo;
    }

    public String toString() {
        String s = null;
        try {
            s = this.toJSONObject().toString(2);
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("EntitlementSubjectImpl.toString", (Throwable)e);
        }
        return s;
    }

    public void setID(String uuid) {
        this.uuid = uuid;
    }

    public String getID() {
        return this.uuid;
    }

    public void setPSubjectName(String pSubjectName) {
        this.pSubjectName = pSubjectName;
    }

    public String getPSubjectName() {
        return this.pSubjectName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        EntitlementSubjectImpl object = (EntitlementSubjectImpl)obj;
        if (this.uuid == null ? object.getID() != null : !this.uuid.equals(object.getID())) {
            return false;
        }
        if (this.pSubjectName == null ? object.getPSubjectName() != null : !this.pSubjectName.equals(object.getPSubjectName())) {
            return false;
        }
        return this.exclusive == object.exclusive;
    }

    public int hashCode() {
        int code = 0;
        if (this.uuid != null) {
            code += this.uuid.hashCode();
        }
        if (this.pSubjectName != null) {
            code += this.pSubjectName.hashCode();
        }
        code = this.exclusive ? (code += Boolean.TRUE.hashCode()) : (code += Boolean.FALSE.hashCode());
        return code;
    }

    protected boolean hasPrincipal(Subject subject, String uuid) {
        Set<Principal> userPrincipals = subject.getPrincipals();
        for (Principal p : userPrincipals) {
            if (!p.getName().equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean flag) {
        this.exclusive = flag;
    }
}

