/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.Entitlement;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeEvaluator;
import com.sun.identity.entitlement.util.NetworkMonitor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Evaluator {
    private Subject adminSubject;
    private String applicationName = "iPlanetAMWebAgentService";
    public static final int DEFAULT_POLICY_EVAL_THREAD = 10;
    private static final NetworkMonitor HAS_ENTITLEMENT_MONITOR = NetworkMonitor.getInstance("hasEntitltmentMonitor");
    private static final NetworkMonitor EVAL_SINGLE_LEVEL_MONITOR = NetworkMonitor.getInstance("evalSingleLevelMonitor");
    private static final NetworkMonitor EVAL_SUB_TREE_MONITOR = NetworkMonitor.getInstance("evalSubTreeMonitor");

    private Evaluator() throws EntitlementException {
    }

    public Evaluator(Subject subject, String applicationName) throws EntitlementException {
        this.adminSubject = subject;
        this.applicationName = applicationName;
    }

    public Evaluator(Subject subject) throws EntitlementException {
        this.adminSubject = subject;
    }

    public boolean hasEntitlement(String realm, Subject subject, Entitlement e, Map<String, Set<String>> envParameters) throws EntitlementException {
        long start = HAS_ENTITLEMENT_MONITOR.start();
        PrivilegeEvaluator evaluator = new PrivilegeEvaluator();
        boolean result = evaluator.hasEntitlement(realm, this.adminSubject, subject, this.applicationName, e, envParameters);
        HAS_ENTITLEMENT_MONITOR.end(start);
        return result;
    }

    public List<Entitlement> evaluate(String realm, Subject subject, String resourceName, Map<String, Set<String>> environment, boolean recursive) throws EntitlementException {
        long start = recursive ? EVAL_SUB_TREE_MONITOR.start() : EVAL_SINGLE_LEVEL_MONITOR.start();
        PrivilegeEvaluator evaluator = new PrivilegeEvaluator();
        List<Entitlement> results = evaluator.evaluate(realm, this.adminSubject, subject, this.applicationName, resourceName, environment, recursive);
        if (recursive) {
            EVAL_SUB_TREE_MONITOR.end(start);
        } else {
            EVAL_SINGLE_LEVEL_MONITOR.end(start);
        }
        return results;
    }

    public String getApplicationName() {
        return this.applicationName;
    }
}

