/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationType;
import com.sun.identity.entitlement.ApplicationTypeManager;
import com.sun.identity.entitlement.EntitlementCombiner;
import com.sun.identity.entitlement.interfaces.ISaveIndex;
import com.sun.identity.entitlement.interfaces.ISearchIndex;
import com.sun.identity.entitlement.interfaces.ResourceName;
import com.sun.identity.entitlement.opensso.SubjectUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationImpl
extends AuthenticatedCommand {
    public static final String PARAM_APPL_TYPE_NAME = "applicationtype";
    public static final String PARAM_APPL_NAME = "name";
    public static final String PARAM_APPL_NAMES = "names";
    public static final String ATTR_APPLICATIONTYPE = "applicationType";
    public static final String ATTR_ACTIONS = "actions";
    public static final String ATTR_RESOURCES = "resources";
    public static final String ATTR_SUBJECTS = "subjects";
    public static final String ATTR_CONDITIONS = "conditions";
    public static final String ATTR_ENTITLEMENT_COMBINER = "entitlementCombiner";
    public static final String ATTR_SUBJECT_ATTRIBUTE_NAMES = "subjectAttributeNames";
    public static final String ATTR_RESOURCE_COMPARATOR = "resourceComparator";
    public static final String ATTR_SAVE_INDEX = "saveIndexImpl";
    public static final String ATTR_SEARCH_INDEX = "searchIndexImpl";
    private Subject adminSubject;

    @Override
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
    }

    protected static String getString(String key, Map<String, Set<String>> map) {
        Set<String> set = map.get(key);
        return set == null || set.isEmpty() ? null : set.iterator().next();
    }

    protected Subject getAdminSubject() {
        if (this.adminSubject == null) {
            this.adminSubject = SubjectUtils.createSubject(this.getAdminSSOToken());
        }
        return this.adminSubject;
    }

    protected ApplicationType getApplicationType(String name) throws CLIException {
        ApplicationType applType = ApplicationTypeManager.getAppplicationType(this.getAdminSubject(), name);
        if (applType == null) {
            String msg = this.getResourceString("application-type-invalid");
            Object[] param = new Object[]{name};
            throw new CLIException(MessageFormat.format(msg, param), 127);
        }
        return applType;
    }

    protected void setApplicationAttributes(Application appl, Map<String, Set<String>> attributeValues, boolean bCreate) throws CLIException {
        Class searchIndex;
        Class saveIndex;
        Class resourceComparator;
        Set<String> names;
        Class entitlementCombiner;
        Set<String> conditions;
        Set<String> subjects;
        Set<String> resources;
        Map<String, Boolean> actions = this.getActions(attributeValues);
        if (actions != null) {
            appl.setActions(actions);
        }
        if ((resources = attributeValues.get(ATTR_RESOURCES)) == null || resources.isEmpty()) {
            if (bCreate) {
                throw new CLIException(this.getResourceString("resources-required"), 127);
            }
        } else {
            appl.setResources(resources);
        }
        if ((subjects = attributeValues.get(ATTR_SUBJECTS)) == null || subjects.isEmpty()) {
            if (bCreate) {
                throw new CLIException(this.getResourceString("subjects-required"), 127);
            }
        } else {
            appl.setSubjects(subjects);
        }
        if ((conditions = attributeValues.get(ATTR_CONDITIONS)) == null || conditions.isEmpty()) {
            if (bCreate) {
                throw new CLIException(this.getResourceString("conditions-required"), 127);
            }
        } else {
            appl.setConditions(conditions);
        }
        if ((entitlementCombiner = this.getEntitlementCombiner(attributeValues)) == null) {
            if (bCreate) {
                throw new CLIException(this.getResourceString("entitlement-combiner-required"), 127);
            }
        } else {
            appl.setEntitlementCombiner(entitlementCombiner);
        }
        if ((names = attributeValues.get(ATTR_SUBJECT_ATTRIBUTE_NAMES)) != null && !names.isEmpty()) {
            appl.setAttributeNames(names);
        }
        if ((resourceComparator = this.getResourceComparator(attributeValues)) != null) {
            try {
                appl.setResourceComparator(resourceComparator);
            }
            catch (InstantiationException ex) {
                throw new CLIException(ex, 127);
            }
            catch (IllegalAccessException ex) {
                throw new CLIException(ex, 127);
            }
        }
        if ((saveIndex = this.getSaveIndex(attributeValues)) != null) {
            try {
                appl.setSaveIndex(saveIndex);
            }
            catch (InstantiationException ex) {
                throw new CLIException(ex, 127);
            }
            catch (IllegalAccessException ex) {
                throw new CLIException(ex, 127);
            }
        }
        if ((searchIndex = this.getSearchIndex(attributeValues)) != null) {
            try {
                appl.setSearchIndex(searchIndex);
            }
            catch (InstantiationException ex) {
                throw new CLIException(ex, 127);
            }
            catch (IllegalAccessException ex) {
                throw new CLIException(ex, 127);
            }
        }
    }

    private Map<String, Boolean> getActions(Map<String, Set<String>> attributeValues) {
        Set<String> actions = attributeValues.get(ATTR_ACTIONS);
        if (actions == null || actions.isEmpty()) {
            return null;
        }
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        for (String action : actions) {
            int idx = (action = action.trim()).indexOf(61);
            if (idx == -1) {
                results.put(action, true);
                continue;
            }
            String a = action.substring(0, idx);
            String v = action.substring(idx + 1);
            results.put(a, Boolean.parseBoolean(v));
        }
        return results;
    }

    private Class getEntitlementCombiner(Map<String, Set<String>> attributeValues) throws CLIException {
        String comb = ApplicationImpl.getString(ATTR_ENTITLEMENT_COMBINER, attributeValues);
        if (comb == null || comb.trim().length() == 0) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(comb);
            Class<?> superClasses = clazz.getSuperclass();
            boolean found = false;
            while (superClasses != null && !found) {
                if (superClasses.equals(EntitlementCombiner.class)) {
                    found = true;
                    continue;
                }
                superClasses = clazz.getSuperclass();
            }
            if (found) {
                return clazz;
            }
            Object[] params = new Object[]{comb};
            throw new CLIException(MessageFormat.format("entitlement-combiner-does-not-extend-superclass", params), 127);
        }
        catch (ClassNotFoundException ex) {
            Object[] params = new Object[]{comb};
            throw new CLIException(MessageFormat.format("entitlement-combiner-class-not-found", params), 127);
        }
    }

    private Class getResourceComparator(Map<String, Set<String>> attributeValues) throws CLIException {
        String comp = ApplicationImpl.getString(ATTR_RESOURCE_COMPARATOR, attributeValues);
        if (comp == null || comp.trim().length() == 0) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(comp);
            Object obj = clazz.newInstance();
            if (obj instanceof ResourceName) {
                return clazz;
            }
            Object[] params = new Object[]{comp};
            throw new CLIException(MessageFormat.format("resource-comparator-does-not-extend-interface", params), 127);
        }
        catch (InstantiationException ex) {
            throw new CLIException(ex, 127);
        }
        catch (IllegalAccessException ex) {
            throw new CLIException(ex, 127);
        }
        catch (ClassNotFoundException ex) {
            Object[] params = new Object[]{comp};
            throw new CLIException(MessageFormat.format("resource-comparator-class-not-found", params), 127);
        }
    }

    private Class getSaveIndex(Map<String, Set<String>> attributeValues) throws CLIException {
        String saveIndex = ApplicationImpl.getString(ATTR_SAVE_INDEX, attributeValues);
        if (saveIndex == null || saveIndex.trim().length() == 0) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(saveIndex);
            Object obj = clazz.newInstance();
            if (obj instanceof ISaveIndex) {
                return clazz;
            }
            Object[] params = new Object[]{saveIndex};
            throw new CLIException(MessageFormat.format("save-index-does-not-extend-interface", params), 127);
        }
        catch (InstantiationException ex) {
            throw new CLIException(ex, 127);
        }
        catch (IllegalAccessException ex) {
            throw new CLIException(ex, 127);
        }
        catch (ClassNotFoundException ex) {
            Object[] params = new Object[]{saveIndex};
            throw new CLIException(MessageFormat.format("save-index-class-not-found", params), 127);
        }
    }

    private Class getSearchIndex(Map<String, Set<String>> attributeValues) throws CLIException {
        String searchIndex = ApplicationImpl.getString(ATTR_SEARCH_INDEX, attributeValues);
        if (searchIndex == null || searchIndex.trim().length() == 0) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(searchIndex);
            Object obj = clazz.newInstance();
            if (obj instanceof ISearchIndex) {
                return clazz;
            }
            Object[] params = new Object[]{searchIndex};
            throw new CLIException(MessageFormat.format("search-index-does-not-extend-interface", params), 127);
        }
        catch (InstantiationException ex) {
            throw new CLIException(ex, 127);
        }
        catch (IllegalAccessException ex) {
            throw new CLIException(ex, 127);
        }
        catch (ClassNotFoundException ex) {
            Object[] params = new Object[]{searchIndex};
            throw new CLIException(MessageFormat.format("search-index-class-not-found", params), 127);
        }
    }
}

