/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso.cli;

import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationManager;
import com.sun.identity.entitlement.ApplicationType;
import com.sun.identity.entitlement.opensso.cli.ApplicationImpl;
import com.sun.identity.log.Level;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowApplication
extends ApplicationImpl {
    @Override
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        String realm = this.getStringOptionValue("realm");
        String appName = this.getStringOptionValue("name");
        String[] params = new String[]{realm, appName};
        this.writeLog(0, Level.INFO, "ATTEMPT_SHOW_APPLICATION", params);
        Application appl = ApplicationManager.getApplication(this.getAdminSubject(), realm, appName);
        IOutput writer = this.getOutputWriter();
        if (appl == null) {
            Object[] param = new Object[]{appName};
            writer.printlnMessage(MessageFormat.format(this.getResourceString("show-application-not-found"), param));
        } else {
            this.displayAttrs(writer, appl);
        }
        this.writeLog(0, Level.INFO, "SUCCEEDED_SHOW_APPLICATION", params);
    }

    private void displayAttrs(IOutput writer, Application appl) {
        ApplicationType applType = appl.getApplicationType();
        writer.printlnMessage("applicationType=" + applType.getName());
        Map<String, Boolean> actions = appl.getActions();
        if (actions != null && !actions.isEmpty()) {
            for (String k : actions.keySet()) {
                writer.printlnMessage("actions=" + k + "=" + actions.get(k).toString());
            }
        }
        this.displayAttributes(writer, "subjectAttributeNames", appl.getAttributeNames());
        this.displayAttributes(writer, "resources", appl.getResources());
        this.displayAttributes(writer, "conditions", appl.getConditions());
        this.displayAttributes(writer, "subjects", appl.getSubjects());
        this.displayClassName(writer, "entitlementCombiner", appl.getEntitlementCombinerClass());
        this.displayClassName(writer, "resourceComparator", appl.getResourceComparatorClass());
        this.displayClassName(writer, "saveIndexImpl", appl.getSaveIndexClass());
        this.displayClassName(writer, "searchIndexImpl", appl.getSearchIndexClass());
    }

    private void displayClassName(IOutput writer, String attrName, Class clazz) {
        if (clazz != null) {
            writer.printlnMessage(attrName + "=" + clazz.getName());
        }
    }

    private void displayAttributes(IOutput writer, String attrName, Set<String> values) {
        if (values != null && !values.isEmpty()) {
            for (String v : values) {
                writer.printlnMessage(attrName + "=" + v);
            }
        }
    }
}

