/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCrypt;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdServicesFactory;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.common.IdRepoUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class AMIdentity {
    private String univIdWithoutDN;
    private SSOToken token;
    private String name;
    private IdType type;
    private String orgName;
    private Set fullyQualifiedNames;
    private AMHashMap modMap = new AMHashMap(false);
    private AMHashMap binaryModMap = new AMHashMap(true);
    protected String univDN = null;
    private static Debug debug = Debug.getInstance((String)"amIdm");
    public static String COS_PRIORITY = "cospriority";

    public AMIdentity(SSOToken ssotoken) throws SSOException, IdRepoException {
        this(ssotoken, ssotoken.getProperty("sun.am.UniversalIdentifier"));
    }

    public AMIdentity(SSOToken ssotoken, String universalId) throws IdRepoException {
        this.token = ssotoken;
        DN dnObject = null;
        String[] array = null;
        if (universalId != null && universalId.toLowerCase().startsWith("id=") && DN.isDN((String)universalId)) {
            dnObject = new DN(universalId);
            array = dnObject.explodeDN(true);
        }
        if (array == null || array.length < 3) {
            Object[] args = new Object[]{universalId};
            throw new IdRepoException("amIdRepo", "215", args);
        }
        this.univIdWithoutDN = new DN(universalId).toRFCString();
        int index = this.univIdWithoutDN.toLowerCase().indexOf(",amsdkdn=");
        if (index != -1) {
            this.univDN = this.univIdWithoutDN.substring(index + 9);
            this.univIdWithoutDN = this.univIdWithoutDN.substring(0, index);
            dnObject = new DN(this.univIdWithoutDN);
        }
        this.name = LDAPDN.unEscapeValue((String)array[0]);
        this.type = new IdType(array[1]);
        this.orgName = dnObject.getParent().getParent().toRFCString();
    }

    public AMIdentity(SSOToken token, String name, IdType type, String orgName, String amsdkdn) {
        this.name = name;
        this.type = type;
        this.orgName = DNMapper.orgNameToDN(orgName);
        this.token = token;
        if (amsdkdn != null && amsdkdn.length() > 0) {
            this.univDN = new DN(amsdkdn).toRFCString();
        }
        StringBuffer sb = new StringBuffer(100);
        if (name != null && name.indexOf(44) != -1 && DN.isDN((String)name)) {
            name = LDAPDN.explodeDN((String)name, (boolean)true)[0];
        }
        sb.append("id=").append(LDAPDN.escapeValue((String)name)).append(",ou=").append(type.getName()).append(",").append(this.orgName);
        this.univIdWithoutDN = sb.toString();
    }

    public String getName() {
        String sname = this.name;
        if (this.type.equals(IdType.REALM)) {
            String[] array = new DN(this.univIdWithoutDN).explodeDN(true);
            sname = array[2];
        }
        return sname;
    }

    public IdType getType() {
        return this.type;
    }

    public String getRealm() {
        return this.orgName;
    }

    public boolean isActive() throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.isActive(this.token, this.type, this.name, this.orgName, this.univDN);
    }

    public void setActiveStatus(boolean active) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        idServices.setActiveStatus(this.token, this.type, this.name, this.orgName, this.univDN, active);
    }

    public Map getAttributes() throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Map attrs = idServices.getAttributes(this.token, this.type, this.name, this.orgName, this.univDN);
        if (debug.messageEnabled()) {
            debug.message("AMIdentity.getAttributes all: attrs=" + IdRepoUtils.getAttrMapWithoutPasswordAttrs(attrs, null));
        }
        return attrs;
    }

    public Map getAttributes(Set attrNames) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Map attrs = idServices.getAttributes(this.token, this.type, this.name, attrNames, this.orgName, this.univDN, true);
        CaseInsensitiveHashMap caseAttrs = new CaseInsensitiveHashMap(attrs);
        CaseInsensitiveHashMap resultMap = new CaseInsensitiveHashMap();
        for (String attrName : attrNames) {
            if (!caseAttrs.containsKey(attrName)) continue;
            resultMap.put(attrName, caseAttrs.get(attrName));
        }
        if (debug.messageEnabled()) {
            debug.message("AMIdentity.getAttributes 6: attrNames=" + attrNames + ";  resultMap=" + resultMap + "; attrs=" + attrs);
        }
        return resultMap;
    }

    public Map getBinaryAttributes(Set attrNames) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.getAttributes(this.token, this.type, this.name, attrNames, this.orgName, this.univDN, false);
    }

    public Set getAttribute(String attrName) throws IdRepoException, SSOException {
        HashSet<String> attrNames = new HashSet<String>();
        attrNames.add(attrName);
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Map valMap = idServices.getAttributes(this.token, this.type, this.name, attrNames, this.orgName, this.univDN, true);
        return (Set)valMap.get(attrName);
    }

    public void setAttributes(Map attrMap) throws IdRepoException, SSOException {
        this.modMap.copy(attrMap);
    }

    public void changePassword(String oldPassword, String newPassword) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        idServices.changePassword(this.token, this.type, this.name, oldPassword, newPassword, this.orgName, this.getDN());
    }

    public void setBinaryAttributes(Map attrMap) throws IdRepoException, SSOException {
        this.binaryModMap.copy(attrMap);
    }

    public void removeAttributes(Set attrNames) throws IdRepoException, SSOException {
        if (attrNames == null || attrNames.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        boolean agentflg = this.getType().equals(IdType.AGENTONLY);
        if (agentflg) {
            IdServices idServices = IdServicesFactory.getDataStoreServices();
            idServices.removeAttributes(this.token, this.type, this.name, attrNames, this.orgName, null);
            for (String attr : attrNames) {
                this.modMap.remove(attr);
            }
        } else {
            for (String attr : attrNames) {
                this.modMap.put(attr, Collections.EMPTY_SET);
            }
        }
    }

    public void store() throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        if (this.modMap != null && !this.modMap.isEmpty()) {
            idServices.setAttributes(this.token, this.type, this.name, this.modMap, false, this.orgName, this.univDN, true);
            this.modMap.clear();
        }
        if (this.binaryModMap != null && !this.binaryModMap.isEmpty()) {
            idServices.setAttributes(this.token, this.type, this.name, this.binaryModMap, false, this.orgName, this.univDN, false);
            this.binaryModMap.clear();
        }
    }

    public Set getAssignedServices() throws IdRepoException, SSOException {
        Set assigned;
        block4: {
            ServiceManager sm;
            try {
                sm = new ServiceManager(this.token);
            }
            catch (SMSException smse) {
                debug.error("Error while creating Service manager:", (Throwable)smse);
                throw new IdRepoException("amIdRepo", "106", null);
            }
            Map sMap = sm.getServiceNamesAndOCs(this.type.getName());
            IdServices idServices = IdServicesFactory.getDataStoreServices();
            assigned = Collections.EMPTY_SET;
            try {
                assigned = idServices.getAssignedServices(this.token, this.type, this.name, sMap, this.orgName, this.univDN);
            }
            catch (IdRepoException ide) {
                if (ide.getErrorCode().equals("402")) break block4;
                throw ide;
            }
        }
        return assigned;
    }

    public Set getAssignableServices() throws IdRepoException, SSOException {
        ServiceManager sm;
        try {
            sm = new ServiceManager(this.token);
        }
        catch (SMSException smse) {
            throw new IdRepoException("amIdRepo", "106", null);
        }
        Map sMap = sm.getServiceNamesAndOCs(this.type.getName());
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Set assigned = Collections.EMPTY_SET;
        try {
            assigned = idServices.getAssignedServices(this.token, this.type, this.name, sMap, this.orgName, this.univDN);
        }
        catch (IdRepoException ide) {
            if (!ide.getErrorCode().equals("402")) {
                throw ide;
            }
            return assigned;
        }
        Set keys = sMap.keySet();
        keys.removeAll(assigned);
        return keys;
    }

    public void assignService(String serviceName, Map attributes) throws IdRepoException, SSOException {
        SchemaType stype;
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Set OCs = this.getServiceOCs(this.token, serviceName);
        HashMap<String, Set> tMap = new HashMap<String, Set>();
        tMap.put(serviceName, OCs);
        Set assignedServices = idServices.getAssignedServices(this.token, this.type, this.name, tMap, this.orgName, this.univDN);
        if (assignedServices.contains(serviceName)) {
            Object[] args = new Object[]{serviceName, this.type.getName()};
            throw new IdRepoException("amIdRepo", "105", args);
        }
        try {
            ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, this.token);
            ServiceSchema ss = ssm.getSchema(this.type.getName());
            if (ss != null) {
                Set cosPriority = attributes != null ? (Set)attributes.remove(COS_PRIORITY) : null;
                attributes = ss.validateAndInheritDefaults(attributes, this.orgName, true);
                if (cosPriority != null) {
                    attributes.put(COS_PRIORITY, cosPriority);
                }
                attributes = AMCommonUtils.removeEmptyValues(attributes);
                stype = ss.getServiceType();
            } else {
                ss = ssm.getSchema(SchemaType.DYNAMIC);
                if (ss == null) {
                    Object[] args = new Object[]{serviceName};
                    throw new IdRepoException("amIdRepo", "102", args);
                }
                if (attributes == null) {
                    try {
                        attributes = this.getServiceConfig(this.token, serviceName, SchemaType.DYNAMIC);
                    }
                    catch (SMSException smsex) {
                        Object[] args = new Object[]{serviceName, this.type.getName()};
                        throw new IdRepoException("amIdRepo", "451", args);
                    }
                } else {
                    attributes = ss.validateAndInheritDefaults(attributes, this.orgName, true);
                }
                attributes = AMCommonUtils.removeEmptyValues(attributes);
                stype = SchemaType.DYNAMIC;
            }
            attributes = AMCrypt.encryptPasswords(attributes, ss);
        }
        catch (SMSException smse) {
            Object[] args = new Object[]{serviceName};
            throw new IdRepoException("amIdRepo", "101", args);
        }
        attributes.put("objectclass", OCs);
        idServices.assignService(this.token, this.type, this.name, serviceName, stype, attributes, this.orgName, this.univDN);
    }

    public void unassignService(String serviceName) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Set OCs = this.getServiceOCs(this.token, serviceName);
        HashMap<String, Set> tMap = new HashMap<String, Set>();
        tMap.put(serviceName, OCs);
        Set assignedServices = idServices.getAssignedServices(this.token, this.type, this.name, tMap, this.orgName, this.univDN);
        if (!assignedServices.contains(serviceName)) {
            Object[] args = new Object[]{serviceName};
            throw new IdRepoException("amIdRepo", "101", args);
        }
        HashMap<String, Set> attrMap = new HashMap<String, Set>();
        Set objectclasses = this.getAttribute("objectclass");
        if (objectclasses != null && !objectclasses.isEmpty()) {
            Set removeOCs = AMCommonUtils.updateAndGetRemovableOCs(objectclasses, OCs);
            try {
                Set attrNames = new HashSet();
                ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, this.token);
                ServiceSchema uss = ssm.getSchema(this.type.getName());
                if (uss != null) {
                    attrNames = uss.getAttributeSchemaNames();
                }
                for (String a : attrNames) {
                    attrMap.put(a, Collections.EMPTY_SET);
                }
            }
            catch (SMSException smse) {
                // empty catch block
            }
            attrMap.put("objectclass", removeOCs);
        }
        idServices.unassignService(this.token, this.type, this.name, serviceName, attrMap, this.orgName, this.univDN);
    }

    public Map getServiceAttributes(String serviceName) throws IdRepoException, SSOException {
        Set attrNames = this.getServiceAttributesName(serviceName);
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        if (debug.messageEnabled()) {
            debug.message("AMIdentity.getServiceAttributes: attrNames=" + attrNames + ";  orgName=" + this.orgName + ";  univDN=" + this.univDN);
        }
        return idServices.getServiceAttributes(this.token, this.type, this.name, serviceName, attrNames, this.orgName, this.univDN);
    }

    public Map getBinaryServiceAttributes(String serviceName) throws IdRepoException, SSOException {
        Set attrNames = this.getServiceAttributesName(serviceName);
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        if (debug.messageEnabled()) {
            debug.message("AMIdentity.getBinaryServiceAttributes: attrNames=" + attrNames + ";  orgName=" + this.orgName + ";  univDN=" + this.univDN);
        }
        return idServices.getBinaryServiceAttributes(this.token, this.type, this.name, serviceName, attrNames, this.orgName, this.univDN);
    }

    public Map getServiceAttributesAscending(String serviceName) throws IdRepoException, SSOException {
        Set attrNames = this.getServiceAttributesName(serviceName);
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        if (debug.messageEnabled()) {
            debug.message("AMIdentity.getServiceAttributesAscending: attrNames=" + attrNames + ";  orgName=" + this.orgName + ";  univDN=" + this.univDN);
        }
        return idServices.getServiceAttributesAscending(this.token, this.type, this.name, serviceName, attrNames, this.orgName, this.univDN);
    }

    public void modifyService(String serviceName, Map attrMap) throws IdRepoException, SSOException {
        SchemaType stype;
        Object values;
        boolean hasCosPriority;
        IdServices idServices;
        block8: {
            idServices = IdServicesFactory.getDataStoreServices();
            Set OCs = this.getServiceOCs(this.token, serviceName);
            HashMap<String, Set> tMap = new HashMap<String, Set>();
            tMap.put(serviceName, OCs);
            Set assignedServices = idServices.getAssignedServices(this.token, this.type, this.name, tMap, this.orgName, this.univDN);
            if (!assignedServices.contains(serviceName)) {
                Object[] args = new Object[]{serviceName};
                throw new IdRepoException("amIdRepo", "101", args);
            }
            hasCosPriority = new CaseInsensitiveHashSet((Collection)attrMap.keySet()).contains(COS_PRIORITY);
            values = null;
            if (hasCosPriority) {
                attrMap = new CaseInsensitiveHashMap(attrMap);
                values = attrMap.remove(COS_PRIORITY);
            }
            try {
                ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, this.token);
                ServiceSchema ss = ssm.getSchema(this.type.getName());
                if (ss != null) {
                    attrMap = ss.validateAndInheritDefaults(attrMap, false);
                    stype = ss.getServiceType();
                    break block8;
                }
                ss = ssm.getSchema(SchemaType.DYNAMIC);
                if (ss != null) {
                    attrMap = ss.validateAndInheritDefaults(attrMap, false);
                    stype = SchemaType.DYNAMIC;
                    break block8;
                }
                Object[] args = new Object[]{serviceName};
                throw new IdRepoException("amIdRepo", "102", args);
            }
            catch (SMSException smse) {
                Object[] args = new Object[]{serviceName};
                throw new IdRepoException("amIdRepo", "103", args);
            }
        }
        if (hasCosPriority) {
            attrMap.put(COS_PRIORITY, values);
        }
        if (debug.messageEnabled()) {
            debug.message("AMIdentity.modifyService befre idService serviceName=" + serviceName + ";  attrMap=" + attrMap);
        }
        idServices.modifyService(this.token, this.type, this.name, serviceName, stype, attrMap, this.orgName, this.univDN);
    }

    public void removeServiceAttributes(String serviceName, Set attrNames) throws IdRepoException, SSOException {
        HashMap<String, Set> attrMap = new HashMap<String, Set>(attrNames.size() * 2);
        for (String attrName : attrNames) {
            attrMap.put(attrName, Collections.EMPTY_SET);
        }
        this.modifyService(serviceName, attrMap);
    }

    public boolean isMember(AMIdentity identity) throws IdRepoException, SSOException {
        IdRepoException idException;
        boolean ismember;
        block19: {
            String mdn;
            String dn;
            Set members;
            IdServices idServices;
            block18: {
                ismember = false;
                idException = null;
                idServices = IdServicesFactory.getDataStoreServices();
                try {
                    members = idServices.getMemberships(this.token, this.getType(), this.getName(), identity.getType(), this.orgName, this.getDN());
                    if (members != null && members.contains(identity)) {
                        ismember = true;
                    } else if (members != null) {
                        dn = identity.getDN();
                        for (AMIdentity id : members) {
                            if (identity.equals(id)) {
                                ismember = true;
                                break;
                            }
                            if (dn == null || (mdn = id.getDN()) == null || !mdn.equalsIgnoreCase(dn)) continue;
                            ismember = true;
                            break;
                        }
                    }
                    if (ismember || members == null || members.isEmpty()) break block18;
                    String identityDN = identity.getUniversalId();
                    String amsdkdn = identity.getDN();
                    if (amsdkdn != null && identityDN.toLowerCase().indexOf(",amsdkdn=") != -1) {
                        identityDN = identityDN.substring(0, identityDN.indexOf(amsdkdn) - 9);
                    }
                    for (AMIdentity id : members) {
                        int endIdx;
                        String idDN = id.getUniversalId();
                        String mdn2 = id.getDN();
                        if (mdn2 != null && (endIdx = idDN.indexOf(mdn2) - 9) >= 0) {
                            idDN = idDN.substring(0, endIdx);
                        }
                        if (!idDN.equalsIgnoreCase(identityDN)) continue;
                        ismember = true;
                        break;
                    }
                }
                catch (IdRepoException ide) {
                    idException = ide;
                }
            }
            if (!ismember && identity.getType().equals(IdType.GROUP)) {
                try {
                    members = idServices.getMembers(this.token, identity.getType(), identity.getName(), identity.orgName, this.getType(), identity.getDN());
                    if (members != null && members.contains(this)) {
                        ismember = true;
                        break block19;
                    }
                    if (members == null) break block19;
                    dn = this.getDN();
                    for (AMIdentity id : members) {
                        if (this.equals(id)) {
                            ismember = true;
                        } else {
                            if (dn == null || (mdn = id.getDN()) == null || !mdn.equalsIgnoreCase(dn)) continue;
                            ismember = true;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        if (idException != null) {
            throw idException;
        }
        return ismember;
    }

    public void addMember(AMIdentity identity) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        HashSet<String> members = new HashSet<String>();
        members.add(identity.getName());
        idServices.modifyMemberShip(this.token, this.type, this.name, members, identity.getType(), 1, this.orgName);
    }

    public void removeMember(AMIdentity identity) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        HashSet<String> members = new HashSet<String>();
        members.add(identity.getName());
        idServices.modifyMemberShip(this.token, this.type, this.name, members, identity.getType(), 2, this.orgName);
    }

    public void removeMembers(Set identityObjects) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        HashSet<String> members = new HashSet<String>();
        for (AMIdentity identity : identityObjects) {
            members.add(identity.getName());
            idServices.modifyMemberShip(this.token, this.type, this.name, members, identity.getType(), 2, this.orgName);
            members = new HashSet();
        }
    }

    public Set getMembers(IdType mtype) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.getMembers(this.token, this.type, this.name, this.orgName, mtype, this.getDN());
    }

    public Set getMemberships(IdType mtype) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.getMemberships(this.token, this.type, this.name, mtype, this.orgName, this.getDN());
    }

    public boolean isExists() throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.isExists(this.token, this.type, this.name, this.orgName);
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o instanceof AMIdentity) {
            String dn;
            AMIdentity compareTo = (AMIdentity)o;
            if (this.univIdWithoutDN.equalsIgnoreCase(compareTo.univIdWithoutDN)) {
                isEqual = true;
            } else if (this.univDN != null && (dn = compareTo.getDN()) != null && dn.equalsIgnoreCase(this.univDN)) {
                isEqual = true;
            }
            if (!isEqual && !this.type.equals(IdType.REALM) && this.type.equals(compareTo.getType())) {
                Set sfqn = this.getFullyQualifiedNames();
                Set cfqn = compareTo.getFullyQualifiedNames();
                if (sfqn != null && cfqn != null && !sfqn.isEmpty() && !cfqn.isEmpty()) {
                    for (String next : sfqn) {
                        if (next == null || !cfqn.contains(next)) continue;
                        isEqual = true;
                        break;
                    }
                }
            }
        }
        return isEqual;
    }

    public int hashCode() {
        return this.univIdWithoutDN.toLowerCase().hashCode();
    }

    public void setDN(String dn) {
        this.univDN = dn;
    }

    public String getDN() {
        return this.univDN;
    }

    public String getUniversalId() {
        return this.univIdWithoutDN;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("AMIdentity object: ").append(this.univIdWithoutDN);
        if (this.univDN != null) {
            sb.append("AMSDKDN=").append(this.univDN);
        }
        return sb.toString();
    }

    protected Set getFullyQualifiedNames() {
        block5: {
            if (this.fullyQualifiedNames == null) {
                try {
                    IdServices idServices = IdServicesFactory.getDataStoreServices();
                    this.fullyQualifiedNames = idServices.getFullyQualifiedNames(this.token, this.type, this.name, this.orgName);
                }
                catch (IdRepoException ire) {
                    if (debug.messageEnabled()) {
                        debug.message("AMIdentity:getFullyQualifiedNames: got exception: ", (Throwable)ire);
                    }
                }
                catch (SSOException ssoe) {
                    if (!debug.messageEnabled()) break block5;
                    debug.message("AMIdentity:getFullyQualifiedNames: got exception: ", (Throwable)((Object)ssoe));
                }
            }
        }
        return this.fullyQualifiedNames;
    }

    private Set getServiceOCs(SSOToken token, String serviceName) throws SSOException {
        HashSet result = new HashSet();
        try {
            Map attrs;
            Set vals;
            if (this.serviceHasSubSchema(token, serviceName, SchemaType.GLOBAL) && (vals = (Set)(attrs = this.getServiceConfig(token, serviceName, SchemaType.GLOBAL)).get("serviceObjectClasses")) != null) {
                result.addAll(vals);
            }
        }
        catch (SMSException smsex) {
            // empty catch block
        }
        return result;
    }

    private Map getServiceConfig(SSOToken token, String serviceName, SchemaType type) throws SMSException, SSOException {
        Map attrMap = null;
        if (type != SchemaType.POLICY) {
            ServiceSchemaManager scm = new ServiceSchemaManager(serviceName, token);
            ServiceSchema gsc = scm.getSchema(type);
            attrMap = gsc.getAttributeDefaults();
        }
        return attrMap;
    }

    private boolean serviceHasSubSchema(SSOToken token, String serviceName, SchemaType schemaType) throws SMSException, SSOException {
        boolean schemaTypeFlg;
        block3: {
            schemaTypeFlg = false;
            try {
                ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, token);
                Set types = ssm.getSchemaTypes();
                if (debug.messageEnabled()) {
                    debug.message("AMServiceUtils.serviceHasSubSchema() SchemaTypes types for " + serviceName + " are: " + types);
                }
                schemaTypeFlg = types.contains(schemaType);
            }
            catch (ServiceNotFoundException ex) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("AMServiceUtils.serviceHasSubSchema() Service does not exist : " + serviceName);
            }
        }
        return schemaTypeFlg;
    }

    private Set getServiceAttributesName(String serviceName) throws IdRepoException, SSOException {
        Set<String> attrNames;
        block8: {
            attrNames = Collections.EMPTY_SET;
            try {
                attrNames = new HashSet();
                ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, this.token);
                ServiceSchema uss = ssm.getSchema(this.type.getName());
                if (uss != null) {
                    attrNames = uss.getAttributeSchemaNames();
                }
                if (!(this.type.equals(IdType.ROLE) || this.type.equals(IdType.REALM) || this.type.equals(IdType.FILTEREDROLE))) {
                    uss = ssm.getDynamicSchema();
                    if (uss != null) {
                        if (attrNames == Collections.EMPTY_SET) {
                            attrNames = uss.getAttributeSchemaNames();
                        } else {
                            attrNames.addAll(uss.getAttributeSchemaNames());
                        }
                    }
                } else {
                    attrNames.add(COS_PRIORITY);
                }
            }
            catch (SMSException smse) {
                if (!debug.messageEnabled()) break block8;
                debug.message("AMIdentity.getServiceAttributes: Caught SM exception", (Throwable)smse);
            }
        }
        return attrNames;
    }
}

