/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ChoiceValues;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AllowedAgents
extends ChoiceValues {
    private static final String version = "1.0";
    private static final String agentServiceName = "AgentService";
    private static ServiceConfigManager scm = null;
    Debug debug = Debug.getInstance((String)"AuthAgents");

    public Map getChoiceValues() {
        return this.getChoiceValues(Collections.EMPTY_MAP);
    }

    public Map getChoiceValues(Map envParams) {
        HashMap<String, String> answer;
        block8: {
            String orgDN = null;
            SSOToken adminToken = null;
            answer = new HashMap<String, String>(2);
            if (envParams != null) {
                orgDN = (String)envParams.get("organization_name");
            }
            if (orgDN == null || orgDN.length() == 0) {
                orgDN = SMSEntry.getRootSuffix();
            }
            try {
                adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                ServiceConfig oc = this.getOrgConfig(adminToken, orgDN);
                Set agentConfigs = oc.getSubConfigNames();
                if (agentConfigs != null && !agentConfigs.isEmpty()) {
                    for (String agentName : agentConfigs) {
                        String agentType;
                        ServiceConfig aCfg = oc.getSubConfig(agentName);
                        if (aCfg == null || (agentType = aCfg.getSchemaID()).equalsIgnoreCase("SharedAgent")) continue;
                        answer.put(agentName, agentName);
                    }
                }
            }
            catch (SSOException ssoe) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("AllowedAgents.getChoiceValues(): SSOException:" + (Object)((Object)ssoe));
                }
            }
            catch (SMSException smse) {
                if (!this.debug.warningEnabled()) break block8;
                this.debug.warning("AllowedAgents.getChoiceValues(): SMSException:" + smse);
            }
        }
        return answer;
    }

    private ServiceConfig getOrgConfig(SSOToken token, String realmName) {
        ServiceConfig orgConfigCache;
        block6: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AllowedAgents.getOrgConfig() called. ");
            }
            orgConfigCache = null;
            try {
                if (scm == null) {
                    scm = new ServiceConfigManager(token, agentServiceName, version);
                }
                orgConfigCache = scm.getOrganizationConfig(realmName, null);
            }
            catch (SMSException smse) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("AllowedAgents.getOrgConfig(): Unable to get organization config due to " + smse);
                }
            }
            catch (SSOException ssoe) {
                if (!this.debug.warningEnabled()) break block6;
                this.debug.warning("AllowedAgents.getOrgConfig(): Unable to get organization config due to " + (Object)((Object)ssoe));
            }
        }
        return orgConfigCache;
    }
}

