/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.sun.identity.setup.AMSetupServlet;
import com.sun.identity.shared.debug.Debug;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

public class LDIFTemplates {
    private static List templates = new ArrayList();

    private LDIFTemplates() {
    }

    public static void copy(String dir, ServletContext servletCtx) {
        for (String templ : templates) {
            String content = LDIFTemplates.getContent(templ, servletCtx);
            String newFile = dir + "/ldif/" + templ;
            File file = new File(newFile);
            file.getParentFile().mkdirs();
            try {
                AMSetupServlet.writeToFile(newFile, content);
            }
            catch (IOException e) {
                Debug.getInstance((String)"amSetupServlet").error("LDIFTemplates.copy", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContent(String templateName, ServletContext servletCtx) {
        InputStreamReader fin = null;
        StringBuffer sbuf = new StringBuffer();
        try {
            int len;
            fin = new InputStreamReader(AMSetupServlet.getResourceAsStream(servletCtx, "/WEB-INF/template/ldif/" + templateName));
            char[] cbuf = new char[1024];
            while ((len = fin.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, len);
            }
        }
        catch (IOException e) {
            Debug.getInstance((String)"amSetupServlet").error("LDIFTemplates.getContent", (Throwable)e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {}
            }
        }
        return sbuf.toString();
    }

    static {
        templates.add("ad/ad_config_schema.ldif");
        templates.add("ad/ad_user_schema.ldif");
        templates.add("opends/opends_config_schema.ldif");
        templates.add("opends/opends_user_schema.ldif");
        templates.add("opends/opends_embinit.ldif");
        templates.add("opends/opends_userinit.ldif");
        templates.add("opends/opends_user_index.ldif");
        templates.add("opends/opends_plugin.ldif");
        templates.add("opends/opends_remove_user_schema.ldif");
        templates.add("sunds/sunds_config_schema.ldif");
        templates.add("sunds/sunds_config_index.ldif");
        templates.add("sunds/sunds_user_index.ldif");
        templates.add("sunds/sunds_user_schema.ldif");
        templates.add("sunds/sunds_plugin.ldif");
        templates.add("sunds/sunds_userinit.ldif");
        templates.add("sunds/amsdk_plugin/amsdk_init_template.ldif");
        templates.add("sunds/amsdk_plugin/amsdk_sunone_schema2.ldif");
        templates.add("tivoli/tivoli_user_schema.ldif");
    }
}

